
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:


Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University). All
Rights Reserved. This program is distributed under the W3C's Software
Intellectual Property License. This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.
See W3C License http://www.w3.org/Consortium/Legal/ for more details.

*/

package org.w3c.domts.level1.core;

import org.w3c.dom.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.domts.*;
import javax.xml.parsers.*;
import java.util.*;



/**
* 
    The "cloneNode(deep)" method returns a copy of the node
    and the subtree under it if deep=true.
    
    Retrieve the second employee and invoke the
    "cloneNode(deep)" method with deep=true.   The
    method should clone this node and the subtree under it.
    The NodeName of each child in the returned node is 
    checked to insure the entire subtree under the second
    employee was cloned.

* @author NIST
* @author Mary Brady
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-3A0ED0A4">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-3A0ED0A4</a>
*/
public class nodeclonenodetrue extends DOMTestCase {

   public nodeclonenodetrue(DOMTestDocumentBuilderFactory factory) 
 {
      super(factory);

   }

   public void runTest() throws java.lang.Throwable {
      Document doc;
      NodeList elementList;
      Node employeeNode;
      Node clonedNode;
      NodeList clonedList;
      Node clonedChild;
      String clonedChildName;
      List result = new ArrayList();
      
      List expectedWhitespace = new ArrayList();
      expectedWhitespace.add("#text");
      expectedWhitespace.add("employeeId");
      expectedWhitespace.add("#text");
      expectedWhitespace.add("name");
      expectedWhitespace.add("#text");
      expectedWhitespace.add("position");
      expectedWhitespace.add("#text");
      expectedWhitespace.add("salary");
      expectedWhitespace.add("#text");
      expectedWhitespace.add("gender");
      expectedWhitespace.add("#text");
      expectedWhitespace.add("address");
      expectedWhitespace.add("#text");
      
      List expectedNoWhitespace = new ArrayList();
      expectedNoWhitespace.add("employeeId");
      expectedNoWhitespace.add("name");
      expectedNoWhitespace.add("position");
      expectedNoWhitespace.add("salary");
      expectedNoWhitespace.add("gender");
      expectedNoWhitespace.add("address");
      
      doc = load("staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      clonedNode = employeeNode.cloneNode(true);
      clonedList = clonedNode.getChildNodes();
      for(int _index = 0; _index < clonedList.getLength();_index++) {
      clonedChild = ( Node ) clonedList.item(_index);
	   clonedChildName = clonedChild.getNodeName();
      result.add(clonedChildName);
      
	}
      
	if(
	isIgnoringElementContentWhitespace()
	) {
	assertEquals("nowhitespace",expectedNoWhitespace,result);
      
	}
	
		else {
			assertEquals("whitespace",expectedWhitespace,result);
      
		}
	
   }
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level1/core/nodeclonenodetrue";
   }
   public static void main(String[] args) {
        DOMTestCase.doMain(nodeclonenodetrue.class,args);
   }
}
