
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:


Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University). All
Rights Reserved. This program is distributed under the W3C's Software
Intellectual Property License. This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.
See W3C License http://www.w3.org/Consortium/Legal/ for more details.

*/

package org.w3c.domts.level1.core;

import org.w3c.dom.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.domts.*;
import javax.xml.parsers.*;
import java.util.*;



/**
* 
    The "appendChild(newChild)" method raises a 
    HIERARCHY_REQUEST_ERR DOMException if the node to 
    append is one of this node's ancestors.
    
    Retrieve the second employee and attempt to append 
    an ancestor node(root node) to it.
    An attempt to make such an addition should raise the 
    desired exception.

* @author NIST
* @author Mary Brady
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='HIERARCHY_REQUEST_ERR'])">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='HIERARCHY_REQUEST_ERR'])</a>
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107</a>
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-184E7107')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='HIERARCHY_REQUEST_ERR'])">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-184E7107')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='HIERARCHY_REQUEST_ERR'])</a>
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107</a>
*/
public class nodeappendchildnodeancestor extends DOMTestCase {

   public nodeappendchildnodeancestor(DOMTestDocumentBuilderFactory factory) 
 {
      super(factory);

   }

   public void runTest() throws java.lang.Throwable {
      Document doc;
      Node newChild;
      NodeList elementList;
      Node employeeNode;
      NodeList childList;
      Node oldChild;
      Node appendedChild;
      doc = load("staff");
      newChild = doc.getDocumentElement();
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      
	{
		boolean success = false;
		try {
			appendedChild = employeeNode.appendChild(newChild);
      
		}
		catch(DOMException ex) {
			success = (ex.code == DOMException.HIERARCHY_REQUEST_ERR);
		}
		assertTrue("nodeAppendChildNodeAncestorAssert1",success);
	}

   }
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level1/core/nodeappendchildnodeancestor";
   }
   public static void main(String[] args) {
        DOMTestCase.doMain(nodeappendchildnodeancestor.class,args);
   }
}
