
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:


Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University). All
Rights Reserved. This program is distributed under the W3C's Software
Intellectual Property License. This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.
See W3C License http://www.w3.org/Consortium/Legal/ for more details.

*/

package org.w3c.domts.level1.core;

import org.w3c.dom.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.domts.*;
import javax.xml.parsers.*;
import java.util.*;



/**
* 
    The "createElement(tagName)" method creates an Element 
   of the type specified.  In addition, if there are known attributes
   with default values, Attr nodes representing them are automatically
   created and attached to the element.
   Retrieve the entire DOM document and invoke its 
   "createElement(tagName)" method with tagName="address".
   The method should create an instance of an Element node
   whose tagName is "address".  The tagName "address" has an 
   attribute with default values, therefore the newly created element
   will have them.  

* @author NIST
* @author Mary Brady
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-2141741547">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-2141741547</a>
*/
public class documentcreateelementdefaultattr extends DOMTestCase {

   public documentcreateelementdefaultattr(DOMTestDocumentBuilderFactory factory) 
 {
      super(factory);

   }

   public void runTest() throws java.lang.Throwable {
      Document doc;
      Element newElement;
      NamedNodeMap defaultAttr;
      Node child;
      String name;
      String value;
      doc = load("staff");
      newElement = doc.createElement("address");
      defaultAttr = newElement.getAttributes();
      child = defaultAttr.item(0);
      name = child.getNodeName();
      assertEquals("attrName","street",name);
      value = child.getNodeValue();
      assertEquals("attrValue","Yes",value);
      assertSize("attrCount",1,defaultAttr);
      
   }
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level1/core/documentcreateelementdefaultattr";
   }
   public static void main(String[] args) {
        DOMTestCase.doMain(documentcreateelementdefaultattr.class,args);
   }
}
