
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:


Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University). All
Rights Reserved. This program is distributed under the W3C's Software
Intellectual Property License. This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.
See W3C License http://www.w3.org/Consortium/Legal/ for more details.

*/

package org.w3c.domts.level1.core;

import org.w3c.dom.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.domts.*;
import javax.xml.parsers.*;
import java.util.*;



/**
* 
    The "setValue()" method for an attribute causes the 
  DOMException NO_MODIFICATION_ALLOWED_ERR to be raised
  if the node is readonly.
  Obtain the children of the THIRD "gender" element.  The elements
  content is an entity reference.  Get the "domestic" attribute
  from the entity reference and execute the "setValue()" method.
  This causes a NO_MODIFICATION_ALLOWED_ERR DOMException to be thrown.

* @author NIST
* @author Mary Brady
* @see <a href="http://www.w3.org/TR/2000/WD-DOM-Level-1-20000929/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='NO_MODIFICATION_ALLOWED_ERR'])">http://www.w3.org/TR/2000/WD-DOM-Level-1-20000929/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='NO_MODIFICATION_ALLOWED_ERR'])</a>
* @see <a href="http://www.w3.org/TR/2000/WD-DOM-Level-1-20000929/level-one-core#ID-221662474">http://www.w3.org/TR/2000/WD-DOM-Level-1-20000929/level-one-core#ID-221662474</a>
* @see <a href="http://www.w3.org/TR/2000/WD-DOM-Level-1-20000929/level-one-core#xpointer(id('ID-221662474')/setraises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NO_MODIFICATION_ALLOWED_ERR'])">http://www.w3.org/TR/2000/WD-DOM-Level-1-20000929/level-one-core#xpointer(id('ID-221662474')/setraises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NO_MODIFICATION_ALLOWED_ERR'])</a>
* @see <a href="http://www.w3.org/DOM/updates/REC-DOM-Level-1-19981001-errata.html">http://www.w3.org/DOM/updates/REC-DOM-Level-1-19981001-errata.html</a>
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-221662474">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-221662474</a>
*/
public class attrsetvaluenomodificationallowederr extends DOMTestCase {

   public attrsetvaluenomodificationallowederr(DOMTestDocumentBuilderFactory factory) 
 throws DOMTestIncompatibleException {

      DocumentBuilderSetting[] settings = new DocumentBuilderSetting[] {
DocumentBuilderSetting.notExpandEntityReferences
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

   }

   public void runTest() throws java.lang.Throwable {
      Document doc;
      NodeList genderList;
      Node gender;
      NodeList genList;
      Node gen;
      NodeList gList;
      Node g;
      NamedNodeMap attrList;
      Attr attrNode;
      doc = load("staff");
      genderList = doc.getElementsByTagName("gender");
      gender = genderList.item(2);
      genList = gender.getChildNodes();
      gen = genList.item(0);
      gList = gen.getChildNodes();
      g = gList.item(0);
      attrList = g.getAttributes();
      attrNode = (Attr)attrList.getNamedItem("domestic");
      
	{
		boolean success = false;
		try {
			attrNode.setValue("newvalue");
      
		}
		catch(DOMException ex) {
			success = (ex.code == DOMException.NO_MODIFICATION_ALLOWED_ERR);
		}
		assertTrue("setValue_throws_NO_MODIFICATION",success);
	}

	{
		boolean success = false;
		try {
			attrNode.setNodeValue("newvalue2");
      
		}
		catch(DOMException ex) {
			success = (ex.code == DOMException.NO_MODIFICATION_ALLOWED_ERR);
		}
		assertTrue("setNodeValue_throws_NO_MODIFICATION",success);
	}

   }
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level1/core/attrsetvaluenomodificationallowederr";
   }
   public static void main(String[] args) {
        DOMTestCase.doMain(attrsetvaluenomodificationallowederr.class,args);
   }
}
