/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.domts;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestFramework;

public class JUnitTestCaseAdapter
extends TestCase
implements DOMTestFramework {
    private DOMTestCase test;

    public JUnitTestCaseAdapter(DOMTestCase test) {
        super(test.getTargetURI());
        test.setFramework(this);
        this.test = test;
    }

    protected void runTest() throws Throwable {
        this.test.runTest();
    }

    public boolean hasFeature(DocumentBuilder docBuilder, String feature, String version) {
        return docBuilder.getDOMImplementation().hasFeature(feature, version);
    }

    public void wait(int millisecond) {
    }

    public void assertTrue(DOMTestCase test, String assertID, boolean actual) {
        Assert.assertTrue(assertID, actual);
    }

    public void assertFalse(DOMTestCase test, String assertID, boolean actual) {
        if (actual) {
            Assert.assertEquals(assertID, String.valueOf(false), String.valueOf(actual));
        }
    }

    public void assertNull(DOMTestCase test, String assertID, Object actual) {
        Assert.assertNull(assertID, actual);
    }

    public void assertNotNull(DOMTestCase test, String assertID, Object actual) {
        Assert.assertNotNull(assertID, actual);
    }

    public void assertSame(DOMTestCase test, String assertID, Object expected, Object actual) {
        boolean same;
        boolean bl = same = expected == actual;
        if (!same) {
            if (expected == null || actual == null || !(expected instanceof Node) || !(actual instanceof Node)) {
                Assert.assertEquals(assertID, expected, actual);
            } else {
                Assert.assertEquals(assertID, expected, actual);
            }
        }
    }

    public void assertInstanceOf(DOMTestCase test, String assertID, Object obj, Class cls) {
        Assert.assertTrue(assertID, cls.isInstance(obj));
    }

    public void assertSize(DOMTestCase test, String assertID, int expectedSize, NodeList collection) {
        Assert.assertEquals(assertID, expectedSize, collection.getLength());
    }

    public void assertSize(DOMTestCase test, String assertID, int expectedSize, NamedNodeMap collection) {
        Assert.assertEquals(assertID, expectedSize, collection.getLength());
    }

    public void assertSize(DOMTestCase test, String assertID, int expectedSize, Collection collection) {
        Assert.assertEquals(assertID, expectedSize, collection.size());
    }

    public void assertEqualsIgnoreCase(DOMTestCase test, String assertID, String expected, String actual) {
        Assert.assertTrue(assertID, expected.equalsIgnoreCase(actual));
    }

    public void assertEqualsIgnoreCase(DOMTestCase test, String assertID, Collection expected, Collection actual) {
        boolean equals;
        int size = expected.size();
        Assert.assertNotNull(assertID, expected);
        Assert.assertNotNull(assertID, actual);
        Assert.assertEquals(assertID, size, actual.size());
        boolean bl = equals = expected != null && actual != null && size == actual.size();
        if (equals) {
            ArrayList expectedArray = new ArrayList(expected);
            Iterator actualIter = actual.iterator();
            while (actualIter.hasNext() && equals) {
                String actualString = (String)actualIter.next();
                Iterator expectedIter = expectedArray.iterator();
                equals = false;
                while (expectedIter.hasNext() && !equals) {
                    String expectedString = (String)expectedIter.next();
                    if (!actualString.equalsIgnoreCase(expectedString)) continue;
                    equals = true;
                    expectedArray.remove(expectedString);
                }
            }
        }
        Assert.assertTrue(assertID, equals);
    }

    public void assertEqualsIgnoreCase(DOMTestCase test, String assertID, List expected, List actual) {
        boolean equals;
        int size = expected.size();
        Assert.assertNotNull(assertID, expected);
        Assert.assertNotNull(assertID, actual);
        Assert.assertEquals(assertID, size, actual.size());
        boolean bl = equals = expected != null && actual != null && size == actual.size();
        if (equals) {
            int i = 0;
            while (i < size) {
                String actualString;
                String expectedString = (String)expected.get(i);
                if (!expectedString.equalsIgnoreCase(actualString = (String)actual.get(i))) {
                    Assert.assertEquals(assertID, expectedString, actualString);
                    break;
                }
                ++i;
            }
        }
    }

    public void assertEquals(DOMTestCase test, String assertID, String expected, String actual) {
        Assert.assertEquals(assertID, expected, actual);
    }

    public void assertEquals(DOMTestCase test, String assertID, int expected, int actual) {
        Assert.assertEquals(assertID, expected, actual);
    }

    public void assertEquals(DOMTestCase test, String assertID, double expected, double actual) {
        if (expected != actual) {
            Assert.assertEquals(assertID, String.valueOf(expected), String.valueOf(actual));
        }
    }

    public void assertEquals(DOMTestCase test, String assertID, Collection expected, Collection actual) {
        boolean equals;
        int size = expected.size();
        Assert.assertNotNull(assertID, expected);
        Assert.assertNotNull(assertID, actual);
        Assert.assertEquals(assertID, size, actual.size());
        boolean bl = equals = expected != null && actual != null && size == actual.size();
        if (equals) {
            ArrayList expectedArray = new ArrayList(expected);
            Iterator actualIter = actual.iterator();
            while (actualIter.hasNext() && equals) {
                Object actualObj = actualIter.next();
                Iterator expectedIter = expectedArray.iterator();
                equals = false;
                while (expectedIter.hasNext() && !equals) {
                    Object expectedObj = expectedIter.next();
                    if (expectedObj != actualObj && !expectedObj.equals(actualObj)) continue;
                    equals = true;
                    expectedArray.remove(expectedObj);
                }
            }
        }
        Assert.assertTrue(assertID, equals);
    }

    public void assertNotEqualsIgnoreCase(DOMTestCase test, String assertID, String expected, String actual) {
        if (expected.equalsIgnoreCase(actual)) {
            Assert.assertTrue(assertID, !expected.equalsIgnoreCase(actual));
        }
    }

    public void assertNotEquals(DOMTestCase test, String assertID, String expected, String actual) {
        Assert.assertTrue(assertID, !expected.equals(actual));
    }

    public void assertNotEquals(DOMTestCase test, String assertID, int expected, int actual) {
        Assert.assertTrue(assertID, expected != actual);
    }

    public void assertNotEquals(DOMTestCase test, String assertID, double expected, double actual) {
        if (expected == actual) {
            Assert.assertTrue(assertID, expected != actual);
        }
    }

    public void assertURIEquals(DOMTestCase test, String assertID, String scheme, String path, String host, String file, String query, String fragment, Boolean isAbsolute, String actual) throws MalformedURLException {
        Assert.assertNotNull(assertID, actual);
        String uri = actual;
        int lastPound = actual.lastIndexOf("#");
        String actualFragment = "";
        if (lastPound != -1) {
            uri = actual.substring(0, lastPound);
            actualFragment = actual.substring(lastPound + 1);
        }
        if (fragment != null) {
            Assert.assertEquals(assertID, fragment, actualFragment);
        }
        int lastQuestion = uri.lastIndexOf("?");
        String actualQuery = "";
        if (lastQuestion != -1) {
            uri = actual.substring(0, lastQuestion);
            actualQuery = actual.substring(lastQuestion + 1);
        }
        if (query != null) {
            Assert.assertEquals(assertID, query, actualQuery);
        }
        int firstColon = uri.indexOf(":");
        int firstSlash = uri.indexOf("/");
        String actualPath = uri;
        String actualScheme = "";
        if (firstColon != -1 && firstColon < firstSlash) {
            actualScheme = uri.substring(0, firstColon);
            actualPath = uri.substring(firstColon + 1);
        }
        if (scheme != null) {
            Assert.assertEquals(assertID, scheme, actualScheme);
        }
        if (path != null) {
            Assert.assertEquals(assertID, path, actualPath);
        }
        if (host != null) {
            String actualHost = "";
            if (actualPath.startsWith("//")) {
                int termSlash = actualPath.indexOf("/", 2);
                actualHost = actualPath.substring(0, termSlash);
            }
            Assert.assertEquals(assertID, host, actualHost);
        }
        if (file != null) {
            String actualFile = actualPath;
            int finalSlash = actualPath.lastIndexOf("/");
            if (finalSlash != -1) {
                actualFile = actualPath.substring(finalSlash + 1);
            }
            Assert.assertEquals(assertID, file, actualFile);
        }
        if (isAbsolute != null) {
            Assert.assertEquals(assertID, isAbsolute, actualPath.startsWith("/"));
        }
    }

    public boolean same(Object expected, Object actual) {
        boolean equals;
        boolean bl = equals = expected == actual;
        if (equals || expected == null || !(expected instanceof Node) || actual == null || actual instanceof Node) {
            // empty if block
        }
        return equals;
    }

    public boolean equalsIgnoreCase(String expected, String actual) {
        return expected.equalsIgnoreCase(actual);
    }

    public boolean equalsIgnoreCase(Collection expected, Collection actual) {
        boolean equals;
        int size = expected.size();
        boolean bl = equals = expected != null && actual != null && size == actual.size();
        if (equals) {
            ArrayList expectedArray = new ArrayList(expected);
            Iterator actualIter = actual.iterator();
            while (actualIter.hasNext() && equals) {
                String actualString = (String)actualIter.next();
                Iterator expectedIter = expectedArray.iterator();
                equals = false;
                while (expectedIter.hasNext() && !equals) {
                    String expectedString = (String)expectedIter.next();
                    if (!actualString.equalsIgnoreCase(expectedString)) continue;
                    equals = true;
                    expectedArray.remove(expectedString);
                }
            }
        }
        return equals;
    }

    public boolean equalsIgnoreCase(List expected, List actual) {
        boolean equals;
        int size = expected.size();
        boolean bl = equals = expected != null && actual != null && size == actual.size();
        if (equals) {
            int i = 0;
            while (i < size) {
                String actualString;
                String expectedString = (String)expected.get(i);
                if (!expectedString.equalsIgnoreCase(actualString = (String)actual.get(i))) {
                    equals = false;
                    break;
                }
                ++i;
            }
        }
        return equals;
    }

    public boolean equals(String expected, String actual) {
        return expected.equals(actual);
    }

    public boolean equals(int expected, int actual) {
        return expected == actual;
    }

    public boolean equals(double expected, double actual) {
        return expected == actual;
    }

    public boolean equals(Collection expected, Collection actual) {
        boolean equals;
        int size = expected.size();
        boolean bl = equals = expected != null && actual != null && size == actual.size();
        if (equals) {
            ArrayList expectedArray = new ArrayList(expected);
            Iterator actualIter = actual.iterator();
            while (actualIter.hasNext() && equals) {
                Object actualObj = actualIter.next();
                Iterator expectedIter = expectedArray.iterator();
                equals = false;
                while (expectedIter.hasNext() && !equals) {
                    Object expectedObj = expectedIter.next();
                    if (expectedObj == actualObj || !expectedObj.equals(actualObj)) continue;
                    equals = true;
                    expectedArray.remove(expectedObj);
                }
            }
        }
        return equals;
    }

    public boolean equals(List expected, List actual) {
        boolean equals;
        int size = expected.size();
        boolean bl = equals = expected != null && actual != null && size == actual.size();
        if (equals) {
            int i = 0;
            while (i < size) {
                Object actualObj;
                Object expectedObj = expected.get(i);
                if (!expectedObj.equals(actualObj = actual.get(i))) {
                    equals = false;
                    break;
                }
                ++i;
            }
        }
        return equals;
    }

    public int size(Collection collection) {
        return collection.size();
    }

    public int size(NamedNodeMap collection) {
        return collection.getLength();
    }

    public int size(NodeList collection) {
        return collection.getLength();
    }
}

