<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" 
  xmlns:lta="http://www.w3.org/2008/05/lta/"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">  
  <xsl:output indent="yes" method="xml"  xml:space="default"/>
  <xsl:template match="/"><!-- Templates in mode  cleanUp1 needed to clean up Java output.-->
    <xsl:variable name="cleanUp1">
      <xsl:copy>
        <xsl:apply-templates select="node()" mode="cleanUp1"/>
      </xsl:copy>
    </xsl:variable>
    <xsl:apply-templates select="$cleanUp1" mode="cleanUp2"/>
    <!-- Templates in mode cleanUp1 needed for renaming etc. -->
  </xsl:template>
  <xsl:template match="node() | @*"  mode="cleanUp1">
    <xsl:copy>
      <xsl:apply-templates select="node() | @*" mode="cleanUp1"/>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="text()
    [preceding-sibling::lta:comment] | text()[preceding-sibling::lta:desc] | 
    lta:unit[preceding-sibling::lta:filedate][1]"  mode="cleanUp1"/>
  <xsl:template match="lta:comment | lta:desc"  mode="cleanUp1">
    <xsl:copy>
      <xsl:value-of select="."/>
      <xsl:for-each select="following-sibling::text()">
        <xsl:value-of select="replace(normalize-space(.),'\n','')"/>
      </xsl:for-each>
    </xsl:copy>
  </xsl:template>
  <xsl:template mode="cleanUp2" match="@* | node()">
    <xsl:copy>
      <xsl:apply-templates select="node() | @*" mode="cleanUp2"/>
    </xsl:copy>
  </xsl:template>
  <xsl:template mode="cleanUp2" match="lta:unit[lta:type[.='language']]">
    <xsl:element name="lta:language">
      <xsl:apply-templates select="node() | @*" mode="cleanUp2"/>     
    </xsl:element>
  </xsl:template>
  <xsl:template mode="cleanUp2" match="lta:unit[lta:type[.='script']]">
    <xsl:element name="lta:script">
      <xsl:apply-templates select="node() | @*" mode="cleanUp2"/>     
    </xsl:element>
  </xsl:template>
  <xsl:template mode="cleanUp2" match="lta:unit[lta:type[.='region']]">
    <xsl:element name="lta:region">
      <xsl:apply-templates select="node() | @*" mode="cleanUp2"/>     
    </xsl:element>
  </xsl:template>
  <xsl:template mode="cleanUp2" match="lta:unit[lta:type[.='variant']]">
    <xsl:element name="lta:variant">
      <xsl:apply-templates select="node() | @*" mode="cleanUp2"/>     
    </xsl:element>
  </xsl:template>
  <xsl:template mode="cleanUp2" match="lta:unit[lta:type[.='grandfathered']]">
    <xsl:element name="lta:grandfathered">
      <xsl:apply-templates select="node() | @*" mode="cleanUp2"/>     
    </xsl:element>
  </xsl:template>
  <xsl:template mode="cleanUp2" match="lta:unit[lta:type[.='redundant']]">
    <xsl:element name="lta:redundant">
      <xsl:apply-templates select="node() | @*" mode="cleanUp2"/>     
    </xsl:element>
  </xsl:template>
</xsl:stylesheet>