import java.net.*;
import java.util.regex.*;
import java.io.*;

public class Lsr2xml {

    private static Pattern delim = Pattern.compile("^%%.*");
    private static        Pattern type = Pattern.compile("^(Type: )(.+)$");
    private static        Pattern subtag = Pattern.compile("^(Subtag: )(.+)$");
    private static        Pattern tag = Pattern.compile("^(Tag: )(.+)$");
    private static        Pattern description = Pattern.compile("^(Description: )(.+)$");
    private static        Pattern added = Pattern.compile("^(Added: )(.+)$");
    private static        Pattern suppressScript = Pattern.compile("^(Suppress-Script: )(.+)$");
    private static        Pattern preferredValue = Pattern.compile("^(Preferred-Value: )(.+)$");
    private static        Pattern deprecated = Pattern.compile("^(Deprecated: )(.+)$");
    private static        Pattern prefix = Pattern.compile("^(Prefix: )(.+)$");
    private static        Pattern comments = Pattern.compile("^(Comments: )(.+)$");
    private static       Pattern fileDate = Pattern.compile("^(File-Date: )(.+)$");
    private static  BufferedReader get;

    static void checkLine (String line, int linenum) throws IOException {
	String newline;
	linenum++;
	Matcher mdel = delim.matcher(line);
	Matcher mt = type.matcher(line);
	Matcher ms = subtag.matcher(line);
	Matcher mtag = tag.matcher(line);
	Matcher md = description.matcher(line);
	Matcher ma = added.matcher(line);
	Matcher ss = suppressScript.matcher(line);
	Matcher mpv = preferredValue.matcher(line);
	Matcher mdep = deprecated.matcher(line);
	Matcher mpre = prefix.matcher(line);
	Matcher mcom = comments.matcher(line);
	Matcher mfd = fileDate.matcher(line);

	if (mdel.matches()) {
	    System.out.println (
				"</lta:unit>\n<lta:unit>");
	}
	else if (mt.matches()) {
	    System.out.println (
				"<lta:type>" + mt.group(2) + "</lta:type>");
	} else if (ms.matches()) {
	    System.out.println (
				"<lta:subtag>" + ms.group(2) + "</lta:subtag>");
	}
	else if (mtag.matches()) {
	    System.out.println (
				"<lta:tag>" + mtag.group(2) + "</lta:tag>");
	}
	else if (md.matches()) {
	    System.out.println (
				"<lta:desc>" + md.group(2) + "</lta:desc>");
	}
	else if (ma.matches()) {
	    System.out.println (
				"<lta:added>" + ma.group(2) + "</lta:added>");
	}
	else if (ss.matches()) {
	    System.out.println (
				"<lta:suppressScript>" + ss.group(2) + "</lta:suppressScript>");
	}
	else if (mpv.matches()) {
	    System.out.println (
				"<lta:preferredValue>" + mpv.group(2) + "</lta:preferredValue>");
	}
	else if (mdep.matches()) {
	    System.out.println (
				"<lta:deprecated>" + mdep.group(2) + "</lta:deprecated>");
	}
	else if (mpre.matches()) {
	    System.out.println (
				"<lta:deprecated>" + mpre.group(2) + "</lta:deprecated>");
	}
	else if (mcom.matches()) {
	    System.out.println (
				"<lta:comment>" + mcom.group(2) + "</lta:comment>");
	}
	else if (mfd.matches()) {
	    System.out.println (
				"<lta:filedate>" + mfd.group(2) + "</lta:filedate>\n<lta:unit>");
	}
	else System.out.println(line);	  
    }

    public static void main (String [] args) throws Exception, IOException {  
	String line;
	int linenum = 1;
	System.out.println("<lta:lsr xmlns:lta='http://www.w3.org/2008/05/lta/'>");
	try {
            URL lsr = new URL("http://www.iana.org/assignments/language-subtag-registry");
	    BufferedReader get = new BufferedReader(new InputStreamReader(lsr.openStream()));
	    while ((line = get.readLine()) != null)
		{
		    checkLine(line,linenum);
		}

	    System.out.println("</lta:unit>\n</lta:lsr>");
	}
	catch (FileNotFoundException e)
	    {}
    }
}