/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.specgenerator;

import java.io.File;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tools.markup.dom.DOMUtil;
import org.w3c.tools.markup.xpath.XPathFactory;
import org.w3c.tools.markup.xpath.XPathProcessor;
import org.w3c.tools.specgenerator.NodeLink;
import org.w3c.tools.specgenerator.SpecDTD;

public class Util {
    static XPathProcessor proc = XPathFactory.getDefaultProcessor();
    protected static ArrayList _navigation = new ArrayList(10);
    protected static Hashtable _fileNames = new Hashtable();
    protected static Hashtable _anchors = new Hashtable();
    protected static Hashtable _defs = new Hashtable();
    protected static Hashtable _bibs = new Hashtable();
    protected static Hashtable _defrefs = new Hashtable();
    protected static Hashtable _bibrefs = new Hashtable();
    protected static Hashtable _javaTypes = new Hashtable();
    protected static Hashtable _ecmaTypes = new Hashtable();
    static Object IS_NORMATIVE = new Object();
    static Object IS_INFORMATIVE = new Object();
    static boolean objectIndex = false;
    static boolean index = false;
    public static String padstr;

    public static void init(Document document) {
        int n;
        int n2;
        int n3;
        Object object;
        Object object2;
        Object object3;
        int n4;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        System.out.println("Initializing the application...");
        Element element = document.getDocumentElement();
        String string = null;
        boolean bl = false;
        if (element.hasAttribute("w3c-doctype")) {
            string = element.getAttribute("w3c-doctype");
            string = string.equals("rec") ? "REC" : (string.equals("pr") ? "PR" : (string.equals("cr") ? "CR" : (string.equals("wd") ? "WD" : (string.equals("note") ? "NOTE" : null))));
        } else {
            object7 = proc.getNode(document, "/spec/header/w3c-doctype", document);
            string = Util.getAllText((Node)object7, null);
            if (string != null) {
                string = string.indexOf("Proposed") != -1 ? "PR" : (string.indexOf("Candidate") != -1 ? "CR" : (string.indexOf("Recommendation") != -1 ? "REC" : (string.indexOf("Working") != -1 ? "WD" : (string.indexOf("Note") != -1 ? "NOTE" : null))));
            }
        }
        if (string != null) {
            object7 = Util.getAllText(document, "/spec/@role");
            if ("editors-copy".equals(object7)) {
                System.out.println(" Generating a W3C Members only document.");
            } else if (!"public".equals(object7)) {
                System.err.println("[WARNING] No role attribute. assuming role is \"editors-copy\".");
                document.getDocumentElement().setAttribute("role", "editors-copy");
            }
            _fileNames.put("-Status-", string);
        }
        object7 = proc.selectNodes(document, "//processing-instruction()", document);
        int n5 = 0;
        while (n5 < object7.getLength()) {
            object6 = object7.item(n5);
            object5 = object6.getNodeName();
            object4 = object6.getNodeValue();
            int n6 = ((String)object4).indexOf(32);
            if ("command-options".equals(object5)) {
                Util.parseOptions(((String)object4).trim());
            } else if ("GENERATE-DEFINITION-INDEX".equals(object5)) {
                index = true;
            } else if ("GENERATE-OBJECT-INDEX".equals(object5)) {
                objectIndex = true;
            }
            ++n5;
        }
        if (Util.getFileName("-TocFile-") == null) {
            _fileNames.put("-TocFile-", Util.getFileName("-OverviewFile-"));
        }
        if (!SpecDTD.diffs) {
            object6 = proc.selectNodes(document, "//*[@diff='del']", document);
            int n7 = 0;
            while (n7 < object6.getLength()) {
                object4 = object6.item(n7);
                object4.getParentNode().removeChild((Node)object4);
                ++n7;
            }
        }
        object6 = proc.getNode(document, "/spec/header", document);
        object5 = proc.selectNodes((Node)object6, ".//bibref", (Node)object6);
        int n8 = 0;
        while (n8 < object5.getLength()) {
            Element element2 = (Element)object5.item(n8);
            Util.setBiblinkStatus(element2);
            ++n8;
        }
        NodeList nodeList = proc.selectNodes(document, "/spec/*/div1", document);
        _navigation.add(new NodeLink(document, Util.getFileName("-OverviewFile-"), "overview"));
        int n9 = 0;
        while (n9 < nodeList.getLength()) {
            Object object8;
            Node node;
            int n10;
            Object object9;
            Object object10;
            Object object11;
            String string2;
            Object object12;
            Object object13;
            Object object14;
            n4 = 1;
            object3 = (Element)nodeList.item(n9);
            object2 = SpecDTD.getSuitableFileName((Element)object3);
            object = (String)object2 + ".html";
            object5 = proc.selectNodes((Node)object3, ".//interface", (Node)object3);
            int n11 = 0;
            while (n11 < object5.getLength()) {
                Element element3 = (Element)object5.item(n11);
                object14 = element3.getAttribute("name");
                _anchors.put(object14, new NodeLink(element3, (String)object14, (String)object + "#" + element3.getAttribute("id")));
                object13 = element3.getFirstChild();
                while (object13 != null) {
                    if (object13.getNodeType() == 1) {
                        object12 = (Element)object13;
                        string2 = object13.getNodeName();
                        if ("attribute".equals(string2) || "method".equals(string2) || "constant".equals(string2)) {
                            object11 = object12.getAttribute("name");
                            _anchors.put((String)object14 + '.' + (String)object11, new NodeLink((Node)object12, (String)object11, (String)object + "#" + object12.getAttribute("id")));
                        } else if ("group".equals(string2)) {
                            object11 = object13.getFirstChild();
                            while (object11 != null) {
                                if (object11.getNodeType() == 1) {
                                    object10 = (Element)object11;
                                    if ("constant".equals(object11.getNodeName())) {
                                        object9 = object10.getAttribute("name");
                                        _anchors.put((String)object14 + '.' + (String)object9, new NodeLink((Node)object10, (String)object9, (String)object + "#" + object10.getAttribute("id")));
                                    }
                                }
                                object11 = object11.getNextSibling();
                            }
                        }
                    }
                    object13 = object13.getNextSibling();
                }
                ++n11;
            }
            object5 = proc.selectNodes((Node)object3, ".//definitions/exception", (Node)object3);
            int n12 = 0;
            while (n12 < object5.getLength()) {
                object14 = (Element)object5.item(n12);
                object13 = object14.getAttribute("name");
                _anchors.put(object13, new NodeLink((Node)object14, (String)object13, (String)object + "#" + object14.getAttribute("id")));
                ++n12;
            }
            object5 = proc.selectNodes((Node)object3, ".//definitions/group/constant", (Node)object3);
            n3 = 0;
            while (n3 < object5.getLength()) {
                object13 = (Element)object5.item(n3);
                object12 = object13.getAttribute("name");
                _anchors.put(object12, new NodeLink((Node)object13, (String)object12, (String)object + "#" + object13.getAttribute("id")));
                ++n3;
            }
            object5 = proc.selectNodes((Node)object3, ".//typedef", (Node)object3);
            n2 = 0;
            while (n2 < object5.getLength()) {
                object12 = (Element)object5.item(n2);
                string2 = object12.getAttribute("name");
                _anchors.put(string2, new NodeLink((Node)object12, string2, (String)object + "#" + object12.getAttribute("id")));
                ++n2;
            }
            n = "glossary".equals(object3.getAttribute("role")) ? 1 : 0;
            if (n != 0) {
                object5 = proc.selectNodes((Node)object3, ".//label[@referenced]", (Node)object3);
                n10 = 0;
                while (n10 < object5.getLength()) {
                    object11 = (Element)object5.item(n10);
                    Util.trackGlossaryReference((Element)object11, (String)object);
                    ++n10;
                }
            } else {
                object5 = proc.selectNodes((Node)object3, ".//termref", (Node)object3);
                n10 = 0;
                while (n10 < object5.getLength()) {
                    object11 = (Element)object5.item(n10);
                    object10 = object11.getAttribute("def");
                    _defrefs.put(object10, object);
                    object9 = object11.getOwnerDocument().getElementById((String)object10);
                    Util.markLabelAsReferenced((Element)object9);
                    ++n10;
                }
            }
            object5 = proc.selectNodes((Node)object3, ".//label", (Node)object3);
            n10 = 0;
            while (n10 < object5.getLength()) {
                object11 = (Element)object5.item(n10);
                if (object11.hasAttribute("id")) {
                    object10 = object11.getAttribute("id");
                    if (n == 0 || Util.hasDefref((String)object10) || SpecDTD.allGlossary) {
                        _defs.put(object10, new NodeLink((Node)object11, Util.getAllText((Node)object11, null), (String)object + "#" + (String)object10));
                        if (n != 0) {
                            object11.setAttribute("glossary", "true");
                        }
                    } else if (n != 0) {
                        object9 = object11.getParentNode();
                        node = object9.getParentNode();
                        object9.getParentNode().removeChild((Node)object9);
                        if (!proc.match(node, "*[child::gitem]", node)) {
                            System.out.println("[WARNING] glossary is not used and section is therefore removed.");
                            object8 = Util.findAncestor(node, "div3");
                            if (object8 == null) {
                                object8 = Util.findAncestor(node, "div2");
                            }
                            if (object8 == null) {
                                object8 = Util.findAncestor(node, "div1");
                                n4 = 0;
                            }
                            object8.getParentNode().removeChild((Node)object8);
                        }
                    }
                }
                ++n10;
            }
            object5 = proc.selectNodes((Node)object3, ".//termdef", (Node)object3);
            int n13 = 0;
            while (n13 < object5.getLength()) {
                object10 = (Element)object5.item(n13);
                object9 = object10.getAttribute("id");
                _defs.put(object9, new NodeLink((Node)object10, object10.getAttribute("term"), (String)object + "#" + (String)object9));
                ++n13;
            }
            object5 = proc.selectNodes((Node)object3, ".//bibref", (Node)object3);
            int n14 = 0;
            while (n14 < object5.getLength()) {
                object9 = (Element)object5.item(n14);
                Util.setBiblinkStatus((Element)object9);
                ++n14;
            }
            object5 = proc.selectNodes((Node)object3, ".//bibl", (Node)object3);
            int n15 = 0;
            while (n15 < object5.getLength()) {
                node = (Element)object5.item(n15);
                object8 = node.getAttribute("id");
                Object object15 = Util.getBiblinkStatus((String)object8);
                if (object15 != null || SpecDTD.allReference) {
                    _bibs.put(object8, new NodeLink(node, node.getAttribute("key"), (String)object + "#" + (String)object8));
                    if (object15 == IS_NORMATIVE) {
                        node.setAttribute("specrole", "normative");
                    } else {
                        bl = true;
                    }
                } else {
                    Node node2 = node.getParentNode();
                    node2.removeChild(node);
                    if (!proc.match(node2, "*[child::bibl]", node2)) {
                        NodeList nodeList2;
                        System.out.println("[WARNING] references are not used.");
                        Node node3 = Util.findAncestor(node2, "div3");
                        if (node3 == null && (node3 = Util.findAncestor(node2, "div2")) != null && (nodeList2 = proc.selectNodes(node3.getParentNode(), "*[child::div2]", node3)).getLength() == 1) {
                            node3 = null;
                        }
                        if (node3 == null) {
                            node3 = Util.findAncestor(node2, "div1");
                            n4 = 0;
                        }
                        node3.getParentNode().removeChild(node3);
                    }
                }
                ++n15;
            }
            if (n4 != 0) {
                _navigation.add(new NodeLink((Node)object3, (String)object2, Util.getAllText((Node)object3, "head")));
            }
            ++n9;
        }
        nodeList = proc.selectNodes(document, "/spec/*/inform-div1", document);
        n4 = 0;
        while (n4 < nodeList.getLength()) {
            object3 = nodeList.item(n4);
            object2 = SpecDTD.getSuitableFileName((Element)object3);
            _navigation.add(new NodeLink((Node)object3, (String)object2, Util.getAllText((Node)object3, "head")));
            ++n4;
        }
        object3 = proc.selectNodes(document, "/spec/back/div1//blist", document);
        if (bl) {
            if (object3.getLength() == 1) {
                object2 = (Element)object3.item(0);
                object = object2.getParentNode();
                Element element4 = document.createElement("blist");
                Element element5 = document.createElement("blist");
                n3 = object2.getChildNodes().getLength();
                n2 = 0;
                n = 0;
                while (n < n3) {
                    Node node = object2.getChildNodes().item(n2);
                    if (node.getNodeType() == 1) {
                        if (((Element)node).hasAttribute("specrole")) {
                            element4.appendChild(node);
                        } else {
                            element5.appendChild(node);
                        }
                    } else {
                        ++n2;
                    }
                    ++n;
                }
                DocumentFragment documentFragment = document.createDocumentFragment();
                if (element4.hasChildNodes()) {
                    documentFragment.appendChild(document.createElement("div2"));
                    ((Element)documentFragment.getLastChild()).setAttribute("id", "References-Normative");
                    documentFragment.getLastChild().appendChild(document.createElement("head"));
                    documentFragment.getLastChild().getLastChild().appendChild(document.createTextNode("Normative references"));
                    documentFragment.getLastChild().appendChild(element4);
                }
                if (element5.hasChildNodes()) {
                    documentFragment.appendChild(document.createElement("div2"));
                    ((Element)documentFragment.getLastChild()).setAttribute("id", "References-Informative");
                    documentFragment.getLastChild().appendChild(document.createElement("head"));
                    documentFragment.getLastChild().getLastChild().appendChild(document.createTextNode("Informative references"));
                    documentFragment.getLastChild().appendChild(element5);
                }
                if ("div1".equals(object.getNodeName())) {
                    System.err.println(" Replaced blist to reorder references");
                    object.replaceChild(documentFragment, (Node)object2);
                } else {
                    System.err.println(" Replaced " + object.getNodeName() + " to reorder references");
                    object.getParentNode().replaceChild(documentFragment, (Node)object);
                }
            } else {
                bl = false;
            }
        } else if (object3.getLength() == 1) {
            object2 = object3.item(0);
            object = object2.getParentNode();
            Element element6 = document.createElement("p");
            object.insertBefore(element6, (Node)object2);
            element6.appendChild(document.createTextNode("The references listed in this section are normatives."));
        }
        if (!bl) {
            System.err.println("[WARNING] No automatic generation of normative/informative references.");
        }
        System.out.println("Initialize done.");
    }

    public static boolean markLabelAsReferenced(Element element) {
        if (element == null) {
            System.err.println("[WARNING] Cannot find referenced term ");
            return true;
        }
        if (element.hasAttribute("referenced")) {
            return true;
        }
        element.setAttribute("referenced", "true");
        return false;
    }

    public static void trackGlossaryReference(Element element, String string) {
        Node node = element.getParentNode();
        NodeList nodeList = proc.selectNodes(node, ".//termref", node);
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2 = (Element)nodeList.item(n);
            String string2 = element2.getAttribute("def");
            _defrefs.put(string2, string);
            Element element3 = element2.getOwnerDocument().getElementById(string2);
            if (!Util.markLabelAsReferenced(element3)) {
                Util.trackGlossaryReference(element3, string);
            }
            ++n;
        }
    }

    public static Node findAncestor(Node node, String string) {
        while (node != null && node.getNodeType() != 9) {
            if (string.equals(node.getNodeName())) {
                return node;
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static NodeLink getFirstItem() {
        return (NodeLink)_navigation.get(0);
    }

    public static NodeLink getRelatedItem(String string, String string2) {
        int n = 0;
        while (n < _navigation.size()) {
            NodeLink nodeLink = (NodeLink)_navigation.get(n);
            if (nodeLink.getKey().equals(string)) break;
            ++n;
        }
        if (string2.equals("previous") ? --n >= 0 : string2.equals("next") && ++n < _navigation.size()) {
            return (NodeLink)_navigation.get(n);
        }
        return null;
    }

    public static NodeLink getURL(String string) {
        NodeLink nodeLink = (NodeLink)_anchors.get(string);
        return nodeLink;
    }

    public static NodeLink getBibref(String string) {
        return (NodeLink)_bibs.get(string);
    }

    static Object getBiblinkStatus(String string) {
        return _bibrefs.get(string);
    }

    static void setBiblinkStatus(Element element) {
        String string = element.getAttribute("ref");
        String string2 = element.getAttribute("role");
        if ("normative".equals(string2)) {
            _bibrefs.put(string, IS_NORMATIVE);
        } else if ("informative".equals(string2)) {
            if (_bibrefs.get(string) != IS_NORMATIVE) {
                _bibrefs.put(string, IS_INFORMATIVE);
            }
        } else {
            _bibrefs.put(string, IS_NORMATIVE);
        }
    }

    public static NodeLink getTermDef(String string) {
        return (NodeLink)_defs.get(string);
    }

    public static boolean hasDefref(String string) {
        return _defrefs.get(string) != null;
    }

    public static void generateHtmlHead(Document document, PrintWriter printWriter, String string, String string2, String string3, NodeLink nodeLink, NodeLink nodeLink2, boolean bl, boolean bl2) {
        String string4 = Util.getAllText(document, "/spec/@role");
        String string5 = Util.getAllText(document, "/spec/header/publoc/loc");
        printWriter.println("<!DOCTYPE html PUBLIC\n  \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n  \"http://www.w3.org/TR/html4/loose.dtd\">");
        printWriter.println("<!--");
        try {
            printWriter.println(" Generated: " + new Date() + " " + InetAddress.getLocalHost().getHostName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        printWriter.println(" -->");
        printWriter.println("<html lang='en-US'>");
        printWriter.println("<head>");
        printWriter.println("  <title>" + string + "</title>");
        printWriter.println("  <link rel='stylesheet' type='text/css' href='./spec.css'>");
        String string6 = SpecDTD.online ? Util.getFileName("-W3CStyleSheets-") : "";
        string6 = Util.getFileName("-W3CStyleSheet-") != null ? Util.getFileName("-W3CStyleSheet-") : ("editors-copy".equals(string4) ? Util.getFileName("-W3CMOStyleSheet-") : (Util.getFileName("-Status-") != null ? string6 + "W3C-" + Util.getFileName("-Status-") : string6 + "base"));
        if (!SpecDTD.online) {
            string6 = string6 + ".css";
        }
        printWriter.println("  <link rel='stylesheet' type='text/css' href='" + string6 + "'>");
        if (SpecDTD.diffs) {
            printWriter.println("  <style type='text/css'>");
            printWriter.println("   .diff-add  { background-color: yellow }");
            printWriter.println("   .diff-del  { text-decoration: line-through }");
            printWriter.println("   .diff-chg  { background-color: lime }");
            printWriter.println("  </style>");
        }
        if (nodeLink2 != null) {
            printWriter.println("  <link rel='next' href='" + nodeLink2.getKey() + ".html'>");
        }
        if (Util.getFileName("-TocFile-") != null) {
            printWriter.println("  <link rel='contents' href='" + Util.getFileName("-TocFile-") + ".html#contents'>");
        }
        if (Util.getFileName("Copyright-Notice") != null) {
            printWriter.println("  <link rel='copyright' href='" + Util.getFileName("Copyright-Notice") + ".html'>");
        }
        if (document.getElementById("glossary") != null) {
            printWriter.println("  <link rel='glossary' href='glossary.html'>");
        }
        if (Util.getFileName("-OverviewFile-") != null) {
            printWriter.println("  <link rel='Start' href='" + Util.getFileName("-OverviewFile-") + ".html'>");
        }
        if (bl2 && Util.getFileName("-IndexFile-") != null) {
            printWriter.println("  <link rel='index' href='" + Util.getFileName("-IndexFile-") + ".html'>");
        }
        if (bl && Util.getFileName("-ObjectIndexFile-") != null) {
            printWriter.println("  <link rel='object-index' href='" + Util.getFileName("-ObjectIndexFile-") + ".html'>");
        }
        printWriter.println("  <link rel='author' href='mailto:www-dom@w3.org'>");
        printWriter.println("  <link rel='help' href='http://www.w3.org/DOM/'>");
        if (nodeLink != null) {
            printWriter.println("  <link rel='prev' href='" + nodeLink.getKey() + ".html'>");
        } else {
            Node node = proc.getNode(document, "/spec/header/publoc", document);
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                Element element;
                String string7;
                if (node2.getNodeType() == 1 && (string7 = (element = (Element)node2).getAttribute("role")) != null && !string7.equals("")) {
                    String string8 = null;
                    if ("plain".equals(string7)) {
                        string8 = "text/plain";
                    } else if ("postscript".equals(string7)) {
                        string8 = "application/postscript";
                    } else if ("zip".equals(string7)) {
                        string8 = "application/zip";
                    } else if ("pdf".equals(string7)) {
                        string8 = "application/pdf";
                    } else if ("html".equals(string7)) {
                        string8 = "text/html";
                    } else {
                        System.err.println("Unknown role " + string7 + " for publoc/loc element");
                    }
                    if (string8 != null) {
                        printWriter.println("  <link rel='alternate' href='" + element.getAttribute("href") + "' title='" + Util.getAllText(element, null) + "' type='" + string8 + "'>");
                    }
                }
                node2 = node2.getNextSibling();
            }
        }
        printWriter.println("</head>");
        printWriter.println("<body>");
        Util.generateNavigationBar(document, printWriter, "top", nodeLink, nodeLink2, bl, bl2);
        if (string2 != null) {
            printWriter.println("<div class='noprint' style='text-align: right'>");
            printWriter.println("<p style='font-family: monospace;font-size:small'>" + string3 + "</p>");
            printWriter.println("</div>");
        }
    }

    public static void generateNavigationBar(Document document, PrintWriter printWriter, String string, NodeLink nodeLink, NodeLink nodeLink2, boolean bl, boolean bl2) {
        boolean bl3 = "bottom".equals(string);
        printWriter.println("<div class='navbar' align='center'>");
        if (bl3) {
            printWriter.println("<map id='navbar-bottom' name='navbar-bottom' title='Navigation Bar'><hr title='Navigation area separator'><p>");
        } else {
            printWriter.println("<map id='navbar-top' name='navbar-top' title='Navigation Bar'><p>");
        }
        boolean bl4 = false;
        if (nodeLink != null) {
            printWriter.print("[<a title='" + nodeLink.getLink() + "' ");
            if (!bl3) {
                printWriter.print("accesskey='p' ");
            }
            printWriter.println("href='" + nodeLink.getKey() + ".html'><strong><u>p</u></strong>revious</a>]");
            bl4 = true;
        }
        if (nodeLink2 != null) {
            if (bl4) {
                printWriter.print(" &nbsp; ");
            }
            printWriter.print("[<a title='" + nodeLink2.getLink() + "' ");
            if (!bl3) {
                printWriter.print("accesskey='n' ");
            }
            printWriter.print("href='" + nodeLink2.getKey() + ".html'><strong><u>n</u></strong>ext</a>]");
            bl4 = true;
        }
        if (Util.getFileName("-TocFile-") != null) {
            if (bl4) {
                printWriter.print(" &nbsp; ");
            }
            printWriter.print("[<a title='Table of Contents' ");
            if (!bl3) {
                printWriter.print("accesskey='c' ");
            }
            printWriter.print("href='" + Util.getFileName("-TocFile-") + ".html#contents'><strong><u>c</u></strong>ontents</a>]");
            bl4 = true;
        }
        if (bl && Util.getFileName("-ObjectIndexFile-") != null) {
            if (bl4) {
                printWriter.print(" &nbsp; ");
            }
            printWriter.println("[<a title='Objects index' ");
            if (!bl3) {
                printWriter.print("accesskey='o' ");
            }
            printWriter.print("href='" + Util.getFileName("-ObjectIndexFile-") + ".html'><strong><u>o</u></strong>bjects</a>]");
        }
        if (bl2 && Util.getFileName("-IndexFile-") != null) {
            if (bl4) {
                printWriter.print(" &nbsp; ");
            }
            printWriter.println("[<a title='Index' ");
            if (!bl3) {
                printWriter.print("accesskey='i' ");
            }
            printWriter.print("href='" + Util.getFileName("-IndexFile-") + ".html'><strong><u>i</u></strong>ndex</a>]");
        }
        printWriter.println("</p>");
        if ("top".equals(string)) {
            printWriter.println("<hr title='Navigation area separator'>");
        }
        printWriter.println("</map></div>");
    }

    public static void generateHtmlTail(Document document, PrintWriter printWriter, NodeLink nodeLink, NodeLink nodeLink2, boolean bl, boolean bl2) {
        Util.generateNavigationBar(document, printWriter, "bottom", nodeLink, nodeLink2, bl, bl2);
        printWriter.println("</body>");
        printWriter.println("</html>");
    }

    public static int getElementPosition(Node node) {
        int n = 1;
        String string = node.getNodeName();
        Node node2 = node.getParentNode().getFirstChild();
        while (node2 != null && !node2.equals(node)) {
            if (node2.getNodeType() == 1 && node2.getNodeName().equals(string)) {
                ++n;
            }
            node2 = node2.getNextSibling();
        }
        return n;
    }

    public static String makeHierarchyIndicator(Node node, String[] stringArray, String string) {
        int n = 0;
        String string2 = "";
        int n2 = 1;
        if (string != null) {
            node = proc.getNode(node, string, node);
        }
        if (stringArray != null && stringArray.length != 0) {
            n2 += stringArray.length;
            int n3 = 0;
            do {
                n = Util.getElementPosition(node);
                string2 = n + "." + string2;
                node = proc.getNode(node, "ancestor::" + stringArray[n3], node);
            } while (++n3 < stringArray.length);
        }
        string2 = Util.getElementPosition(node) + "." + string2;
        return string2.substring(0, string2.length() - 1);
    }

    public static String makeAppendixIndicator(Node node, String[] stringArray, String string) {
        int n;
        int n2 = 0;
        String string2 = "";
        int n3 = 1;
        if (string != null) {
            node = proc.getNode(node, string, node);
        }
        if (stringArray != null && stringArray.length != 0) {
            n3 += stringArray.length;
            n = 0;
            do {
                n2 = Util.getElementPosition(node);
                string2 = n2 + "." + string2;
                node = proc.getNode(node, "ancestor::" + stringArray[n], node);
            } while (++n < stringArray.length);
        }
        n = "-ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(Util.getElementPosition(node));
        string2 = (char)n + "." + string2;
        return string2.substring(0, string2.length() - 1);
    }

    public static String getFileName(String string) {
        String string2 = (String)_fileNames.get(string);
        return string2;
    }

    public static String getPubYear(Node node) {
        return Util.getAllText(node, "/spec/header/pubdate/year");
    }

    public static String getAllText(Node node, String string) {
        if (node == null) {
            return "";
        }
        if (string == null) {
            return DOMUtil.getContent(node);
        }
        if ((node = proc.getNode(node, string, node)) == null) {
            return "";
        }
        return DOMUtil.getContent(node);
    }

    public static String getPubDate(Document document) {
        StringBuffer stringBuffer = new StringBuffer();
        Node node = proc.getNode(document, "/spec/header/pubdate", document);
        if (node == null) {
            return null;
        }
        stringBuffer.append(DOMUtil.getContent(proc.getNode(node, "day", node)));
        stringBuffer.append(' ');
        stringBuffer.append(DOMUtil.getContent(proc.getNode(node, "month", node)));
        stringBuffer.append(' ');
        stringBuffer.append(DOMUtil.getContent(proc.getNode(node, "year", node)));
        return stringBuffer.toString();
    }

    public static String getEscapedContent(CharacterData characterData) {
        return Util.getEscapedContent(characterData.getData());
    }

    public static String getEscapedContent(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '<': {
                    stringBuffer.append('&');
                    stringBuffer.append('l');
                    stringBuffer.append('t');
                    stringBuffer.append(';');
                    break;
                }
                case '>': {
                    stringBuffer.append('&');
                    stringBuffer.append('g');
                    stringBuffer.append('t');
                    stringBuffer.append(';');
                    break;
                }
                case '&': {
                    stringBuffer.append('&');
                    stringBuffer.append('a');
                    stringBuffer.append('m');
                    stringBuffer.append('p');
                    stringBuffer.append(';');
                    break;
                }
                case '\r': {
                    break;
                }
                default: {
                    char c2 = c;
                    if (c2 > '\u007f') {
                        stringBuffer.append("&#x");
                        stringBuffer.append(Integer.toHexString(c2));
                        stringBuffer.append(';');
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean isPreviousElement(Node node, String string) {
        Node node2 = node.getPreviousSibling();
        while (node2 != null) {
            switch (node2.getNodeType()) {
                case 3: {
                    break;
                }
                case 1: {
                    if (node2.getNodeName().equals(string)) {
                        return true;
                    }
                }
                default: {
                    return false;
                }
            }
            node2 = node2.getPreviousSibling();
        }
        return false;
    }

    public static boolean isNextElement(Node node, String string) {
        Node node2 = node.getNextSibling();
        while (node2 != null) {
            switch (node2.getNodeType()) {
                case 3: {
                    break;
                }
                case 1: {
                    if (node2.getNodeName().equals(string)) {
                        return true;
                    }
                }
                default: {
                    return false;
                }
            }
            node2 = node2.getNextSibling();
        }
        return false;
    }

    public static String getClosestAncestorId(Element element) {
        while (element != null && !element.hasAttribute("id")) {
            Node node = element.getParentNode();
            element = node.getNodeType() == 1 ? (Element)node : null;
        }
        if (element == null) {
            return null;
        }
        return element.getAttribute("id");
    }

    public static String padString(String string, int n) {
        if (string.length() >= n) {
            return string;
        }
        return string + padstr.substring(0, n - string.length());
    }

    public static String getW3CCopyright(Node node) {
        return "/*\n * Copyright (c) " + Util.getPubYear(node) + " World Wide Web Consortium,\n" + " *\n" + " * (Massachusetts Institute of Technology, European Research Consortium for\n" + " * Informatics and Mathematics, Keio University). All Rights Reserved. This\n" + " * work is distributed under the W3C(r) Software License [1] in the hope that\n" + " * it will be useful, but WITHOUT ANY WARRANTY; without even the implied\n" + " * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n" + " *\n" + " * [1] http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231\n" + " */\n";
    }

    public static String getJavaTypeBinding(String string) {
        String string2 = (String)_javaTypes.get(string);
        return string2;
    }

    public static String getECMAScriptTypeBinding(String string) {
        return (String)_ecmaTypes.get(string);
    }

    public static boolean createDirectory(String string) {
        File file = new File(string);
        if (!file.exists() && !file.mkdir()) {
            char c = File.separatorChar;
            int n = string.lastIndexOf(c);
            if (n <= 0) {
                return false;
            }
            if (!Util.createDirectory(string.substring(0, n))) {
                return false;
            }
            return file.mkdir();
        }
        return true;
    }

    public static void help() {
        System.out.println("Usage: java org.w3c.tools.specgenerator.Main [options]* <XML files>");
        System.out.println("Options are");
        System.out.println("\t--bindings         : generate the language bindings in separate files");
        System.out.println("\t--strip-references : generate only the references used in the document");
        System.out.println("\t--strip-glossary   : generate only the glossary entries used in the document");
        System.out.println("\t--version          : Return the version number of this program");
        System.out.println("\t--offline          : Generate an offline version");
        System.out.println("\t--diff             : Generate diff informations");
        System.out.println("\t--directory        : Generate in a specified directory");
        System.out.println("\t--help             : Return this help");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int parseOptions(String[] stringArray) throws IllegalArgumentException {
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String string;
            String string2;
            String string3 = stringArray[n];
            if ("--bindings".equals(string3)) {
                SpecDTD.binding = true;
            } else if ("--monolithic".equals(string3)) {
                SpecDTD.monolithic = true;
            } else if ("--strip-references".equals(string3)) {
                SpecDTD.allReference = false;
            } else if ("--strip-glossary".equals(string3)) {
                SpecDTD.allGlossary = false;
            } else if ("--offline".equals(string3)) {
                SpecDTD.online = false;
            } else if ("--diff".equals(string3)) {
                SpecDTD.diffs = true;
            } else if ("--map".equals(string3)) {
                if (++n + 1 >= n2) throw new IllegalArgumentException("--map requires two arguments");
                string2 = stringArray[n++];
                string = stringArray[n];
                if (string.endsWith(".html")) {
                    string = string.substring(0, string.length() - 5);
                }
                _fileNames.put(string2, string);
            } else {
                if (!"--map-type".equals(string3)) return n;
                if (++n + 2 >= n2) throw new IllegalArgumentException("--map-type requires three arguments");
                string2 = stringArray[n++];
                string = stringArray[n++];
                String string4 = null;
                if (string.startsWith("\"")) {
                    string = string.substring(1);
                    do {
                        string = string + ' ';
                        if (n != n2) continue;
                        throw new IllegalArgumentException("--map-type");
                    } while (!(string = string + stringArray[n++]).endsWith("\""));
                    string = string.substring(0, string.length() - 1);
                }
                if ((string4 = stringArray[n]).startsWith("\"")) {
                    string4 = string4.substring(1);
                    do {
                        string4 = string4 + ' ';
                        if (n != n2) continue;
                        throw new IllegalArgumentException("--map-type");
                    } while (!(string4 = string4 + stringArray[++n]).endsWith("\""));
                    string4 = string4.substring(0, string4.length() - 1);
                }
                if ("java".equalsIgnoreCase(string2)) {
                    _javaTypes.put(string, string4);
                } else if ("ecmascript".equalsIgnoreCase(string2)) {
                    _ecmaTypes.put(string, string4);
                } else {
                    System.err.println("[WARNING] unknown language " + string2 + " in --map-type");
                }
            }
            ++n;
        }
        return n;
    }

    public static int parseOptions(String string) throws IllegalArgumentException {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[128];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (((String)object).startsWith("\"")) {
                while (!((String)object).endsWith("\"") && stringTokenizer.hasMoreTokens()) {
                    object = (String)object + ' ' + stringTokenizer.nextToken();
                }
                if (!((String)object).endsWith("\"")) {
                    System.err.println("ERROR: invalid option in");
                    System.err.println("  " + (String)object);
                    return -1;
                }
                object = ((String)object).substring(1, ((String)object).length() - 1);
            }
            stringArray[n++] = object;
        }
        object = new String[n];
        System.arraycopy(stringArray, 0, object, 0, n);
        return Util.parseOptions((String[])object);
    }

    static void displayList(NodeList nodeList) {
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            switch (node.getNodeType()) {
                case 1: {
                    System.err.println("[debug] element " + node.getNodeName() + " key " + ((Element)node).getAttribute("key") + " role " + ((Element)node).getAttribute("specrole"));
                    break;
                }
                case 8: {
                    System.err.println("[debug] comment");
                    break;
                }
                default: {
                    System.err.println("[debug] node is " + node.getNodeType());
                }
            }
            ++n;
        }
    }

    static {
        _fileNames.put("-W3CIcons-", "http://www.w3.org/Icons/");
        _fileNames.put("-W3CStyleSheets-", "http://www.w3.org/StyleSheets/TR/");
        _fileNames.put("-W3CMOStyleSheet-", "http://www.w3.org/StyleSheets/TR/W3C-MO");
        _fileNames.put("-OverviewFile-", "Overview");
        _fileNames.put("-IndexFile-", "index");
        _fileNames.put("-ObjectIndexFile-", "object-index");
        padstr = "                                                                                                        ";
    }
}

