/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.specgenerator;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tools.markup.dom.DOMUtil;
import org.w3c.tools.markup.xpath.XPathFactory;
import org.w3c.tools.markup.xpath.XPathProcessor;
import org.w3c.tools.specgenerator.Entry;
import org.w3c.tools.specgenerator.NodeLink;
import org.w3c.tools.specgenerator.StringIgnoreCaseComparator;
import org.w3c.tools.specgenerator.Util;

public class SpecDTD {
    public static boolean monolithic = false;
    public static boolean binding = false;
    public static boolean allReference = true;
    public static boolean allGlossary = true;
    public static boolean online = true;
    public static boolean diffs = false;
    static XPathProcessor proc = XPathFactory.getDefaultProcessor();

    public static String getSpecTitle(Document document) {
        return DOMUtil.getContent(proc.getNode(document, "/spec/header/title", document));
    }

    public static String getSuitableFileNameFor(Element element, String string) {
        String string2 = null;
        if (element == null) {
            return null;
        }
        if (string != null) {
            element = (Element)proc.getNode(element, string, element);
        }
        if (element.hasAttribute("id")) {
            string2 = Util.getFileName(element.getAttribute("id"));
        }
        if (string2 == null) {
            string2 = Util.getAllText(element, "head");
            string2 = string2.trim().toLowerCase();
            StringBuffer stringBuffer = new StringBuffer(string2);
            StringBuffer stringBuffer2 = new StringBuffer(16);
            int n = 0;
            boolean bl = false;
            while (n != stringBuffer.length()) {
                char c = stringBuffer.charAt(n);
                switch (c) {
                    case '(': 
                    case ')': {
                        if (bl) {
                            bl = false;
                            stringBuffer2.append('-');
                        }
                        stringBuffer2.append(' ');
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        bl = true;
                        break;
                    }
                    default: {
                        if (bl) {
                            bl = false;
                            stringBuffer2.append('-');
                        }
                        stringBuffer2.append(c);
                    }
                }
                ++n;
            }
            string2 = stringBuffer2.toString();
        }
        return string2;
    }

    public static String getSuitableFileName(Element element) {
        return SpecDTD.getSuitableFileNameFor(element, null);
    }

    protected static void getTitleContent(StringBuffer stringBuffer, Node node) {
        if (node != null) {
            switch (node.getNodeType()) {
                case 1: {
                    if (!"head".equals(node.getNodeName())) {
                        stringBuffer.append("<" + node.getNodeName() + ">");
                    }
                    Node node2 = node.getFirstChild();
                    while (node2 != null) {
                        SpecDTD.getTitleContent(stringBuffer, node2);
                        node2 = node2.getNextSibling();
                    }
                    if ("head".equals(node.getNodeName())) break;
                    stringBuffer.append("</" + node.getNodeName() + ">");
                    break;
                }
                case 5: 
                case 6: 
                case 9: 
                case 11: {
                    Node node3 = node.getFirstChild();
                    while (node3 != null) {
                        SpecDTD.getTitleContent(stringBuffer, node3);
                        node3 = node3.getNextSibling();
                    }
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    stringBuffer.append(node.getNodeValue());
                    break;
                }
                case 7: 
                case 8: 
                case 10: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown DOM node type: " + node.getNodeType());
                }
            }
        }
    }

    protected static String getTitleContent(Node node, String string) {
        Node node2 = proc.getNode(node, string, node);
        StringBuffer stringBuffer = new StringBuffer(32);
        SpecDTD.getTitleContent(stringBuffer, node2);
        return stringBuffer.toString();
    }

    public static void generateExpandedToc(Node node, PrintWriter printWriter, boolean bl) {
        Object object;
        int n;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        printWriter.println("<ul class='toc'>");
        NodeList nodeList = proc.selectNodes(node, "/spec/front/div1", node);
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n2);
            String string = SpecDTD.getTitleContent(element, "head");
            object6 = SpecDTD.getSuitableFileName(element) + ".html";
            if (monolithic) {
                object6 = '#' + element.getAttribute("id");
            }
            printWriter.println("<li class='tocline2'><a class='tocxref' href='" + (String)object6 + "'>" + string + "</a>");
            if (monolithic) {
                object6 = null;
            }
            if ((object5 = proc.selectNodes(element, "div2", element)).getLength() > 0) {
                printWriter.println("<ul class='toc'>");
            }
            int n3 = 0;
            while (n3 < object5.getLength()) {
                object4 = (Element)object5.item(n3);
                object3 = object4.getAttribute("id");
                string = SpecDTD.getTitleContent((Node)object4, "head");
                printWriter.println("<li class='tocline3'><a class='tocxref' href='" + (String)object6 + '#' + (String)object3 + "'>" + string + "</a>");
                object2 = proc.selectNodes((Node)object4, "div3", (Node)object4);
                if (object2.getLength() > 0) {
                    printWriter.println("<ul class='toc'>");
                }
                n = 0;
                while (n < object2.getLength()) {
                    object = (Element)object2.item(n);
                    object3 = object.getAttribute("id");
                    string = SpecDTD.getTitleContent((Node)object, "head");
                    printWriter.println("<li class='tocline4'><a class='tocxref' href='" + (String)object6 + '#' + (String)object3 + "'>" + string + "</a>");
                    ++n;
                }
                if (object2.getLength() > 0) {
                    printWriter.println("</ul>");
                }
                printWriter.println("</li>");
                ++n3;
            }
            if (object5.getLength() > 0) {
                printWriter.println("</ul>");
            }
            printWriter.println("</li>");
            ++n2;
        }
        printWriter.println("</ul>");
        int n4 = 1;
        printWriter.println("<ul class='toc'>");
        nodeList = proc.selectNodes(node, "/spec/body/div1", node);
        if (nodeList.getLength() <= 1) {
            bl = false;
        }
        int n5 = 0;
        while (n5 < nodeList.getLength()) {
            object6 = (Element)nodeList.item(n5);
            object5 = SpecDTD.getTitleContent((Node)object6, "head");
            object5 = !bl ? n4 + " " + (String)object5 : "Chapter " + n4 + ": " + (String)object5;
            String string = SpecDTD.getSuitableFileName((Element)object6) + ".html";
            if (monolithic) {
                string = '#' + object6.getAttribute("id");
            }
            printWriter.println("<li class='tocline2'><a class='tocxref' href='" + string + "'>" + (String)object5 + "</a>");
            if (monolithic) {
                string = null;
            }
            object4 = proc.selectNodes((Node)object6, "div2", (Node)object6);
            object3 = proc.selectNodes((Node)object6, "definitions", (Node)object6);
            if (object4.getLength() + object3.getLength() > 0) {
                SpecDTD.generateDiv1Toc((Node)object6, printWriter, string, "" + n4, false);
            }
            printWriter.println("</li>");
            ++n4;
            ++n5;
        }
        printWriter.println("</ul>");
        n4 = 0;
        object6 = null;
        nodeList = proc.selectNodes(node, "/spec/back/div1", node);
        if (nodeList.getLength() > 0) {
            printWriter.println("<ul class='toc'>");
        }
        int n6 = 0;
        while (n6 < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n6);
            object4 = SpecDTD.getTitleContent(element, "head");
            object3 = element.getAttribute("role");
            if (!("index".equals(object3) || "note".equals(object3) || "references".equals(object3) || "glossary".equals(object3) || "acknowledgments".equals(object3) || "object-index".equals(object3))) {
                object6 = "" + "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(n4);
                object4 = "Appendix " + (String)object6 + ": " + (String)object4;
            } else {
                object6 = null;
            }
            object2 = SpecDTD.getSuitableFileName(element) + ".html";
            if (monolithic) {
                object2 = '#' + element.getAttribute("id");
            }
            printWriter.println("<li class='tocline2'><a class='tocxref' href='" + (String)object2 + "'>" + (String)object4 + "</a>");
            if (monolithic) {
                object2 = null;
            }
            n = 1;
            object = proc.selectNodes(element, "div2", element);
            if (object.getLength() > 0) {
                printWriter.println("<ul class='toc'>");
            }
            int n7 = 0;
            while (n7 < object.getLength()) {
                Element element2 = (Element)object.item(n7);
                String string = element2.getAttribute("id");
                object4 = SpecDTD.getTitleContent(element2, "head");
                object4 = object6 != null ? (String)object6 + '.' + n + ' ' + (String)object4 : n + " " + (String)object4;
                printWriter.println("<li class='tocline3'><a class='tocxref' href='" + (String)object2 + '#' + string + "'>" + (String)object4 + "</a>");
                int n8 = 1;
                NodeList nodeList2 = proc.selectNodes(element2, "div3", element2);
                if (nodeList2.getLength() > 0) {
                    printWriter.println("<ul class='toc'>");
                }
                int n9 = 0;
                while (n9 < nodeList2.getLength()) {
                    Element element3 = (Element)nodeList2.item(n9);
                    string = element3.getAttribute("id");
                    object4 = SpecDTD.getTitleContent(element3, "head");
                    object4 = object6 != null ? (String)object6 + '.' + n + '.' + n8 + ' ' + (String)object4 : n + 46 + n8 + 32 + (String)object4;
                    printWriter.println("<li class='tocline4'><a class='tocxref' href='" + (String)object2 + '#' + string + "'>" + (String)object4 + "</a>");
                    ++n8;
                    ++n9;
                }
                if (nodeList2.getLength() > 0) {
                    printWriter.println("</ul>");
                }
                printWriter.println("</li>");
                ++n;
                ++n7;
            }
            if (object.getLength() > 0) {
                printWriter.println("</ul>");
            }
            printWriter.println("</li>");
            ++n4;
            ++n6;
        }
        if (n4 != 0) {
            printWriter.println("</ul>\n");
        }
    }

    public static void listDefinitions(Node node, PrintWriter printWriter, int n, boolean bl) {
        if (node.getFirstChild() != null && bl) {
            printWriter.print("<li class='tocline" + n + "'>");
        }
        node = node.getFirstChild();
        do {
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String string = element.getAttribute("id");
            String string2 = element.getAttribute("name");
            if (!element.hasAttribute("id")) {
                System.err.println("[ERROR] definition \"" + string2 + "\" has no ID");
            }
            if (bl) {
                bl = false;
            } else {
                printWriter.print(",\n");
            }
            printWriter.print("<a href='#" + string + "'>" + string2 + "</a>");
        } while ((node = node.getNextSibling()) != null);
    }

    public static void generateDiv2Toc(Node node, PrintWriter printWriter, String string, String string2, int n, boolean bl) {
        printWriter.println("<ul class='toc'>");
        int n2 = 1;
        boolean bl2 = true;
        node = node.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                Object object;
                Element element = (Element)node;
                if (element.getNodeName().equals("div3")) {
                    object = element.getAttribute("id");
                    String string3 = Util.getAllText(element, "head");
                    string3 = string2 + "." + n + '.' + n2 + ' ' + string3;
                    if (!element.hasAttribute("id")) {
                        System.err.println("[ERROR] div3 \"" + string3 + "\" has no ID");
                    }
                    if (!bl2) {
                        printWriter.println("");
                        bl2 = true;
                    }
                    printWriter.println("<li class='tocline4'><a class='tocxref' href='" + string + '#' + (String)object + "'>" + string3 + "</a>");
                    NodeList nodeList = proc.selectNodes(element, "definitions", element);
                    if (bl && nodeList.getLength() > 0) {
                        printWriter.println("<ul>");
                        boolean bl3 = true;
                        NodeList nodeList2 = proc.selectNodes(node, ".//definitions", node);
                        int n3 = 0;
                        while (n3 < nodeList2.getLength()) {
                            SpecDTD.listDefinitions(nodeList2.item(n3), printWriter, 5, bl3);
                            bl3 = false;
                            ++n3;
                        }
                        printWriter.println("</ul>");
                    }
                    ++n2;
                } else if (element.getNodeName().equals("definitions")) {
                    object = proc.selectNodes(element, "*", element);
                    if (bl && object.getLength() > 0) {
                        SpecDTD.listDefinitions(element, printWriter, 4, bl2);
                        bl2 = false;
                    }
                }
            }
            node = node.getNextSibling();
        }
        printWriter.print("</ul>");
    }

    public static void generateDiv1Toc(Node node, PrintWriter printWriter, String string, String string2, boolean bl) {
        printWriter.println("<ul class='toc'>");
        int n = 1;
        node = node.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                if (element.getNodeName().equals("div2")) {
                    String string3 = element.getAttribute("id");
                    String string4 = Util.getAllText(element, "head");
                    string4 = string2 + "." + n + ' ' + string4;
                    if (!element.hasAttribute("id")) {
                        System.err.println("[ERROR] div2 \"" + string4 + "\" has no ID");
                    }
                    printWriter.println("<li class='tocline3'><a class='tocxref' href='" + string + '#' + string3 + "'>" + string4 + "</a>");
                    NodeList nodeList = proc.selectNodes(element, "div3", element);
                    int n2 = 0;
                    if (bl) {
                        NodeList nodeList2 = proc.selectNodes(element, "definitions", element);
                        n2 = nodeList2.getLength();
                    }
                    if (nodeList.getLength() + n2 > 0) {
                        SpecDTD.generateDiv2Toc(node, printWriter, string, string2, n, bl);
                    }
                    printWriter.println("</li>");
                    ++n;
                } else if (element.getNodeName().equals("definitions") && bl) {
                    SpecDTD.listDefinitions(element, printWriter, 3, true);
                }
            }
            node = node.getNextSibling();
        }
        printWriter.println("</ul>");
    }

    public static void generateMiniToc(Node node, PrintWriter printWriter, String string) {
        printWriter.println("<div class='noprint'>");
        printWriter.println("<h2 id='table-of-contents'>Table of contents</h2>");
        SpecDTD.generateDiv1Toc(node, printWriter, "", string, true);
        printWriter.println("</div>");
    }

    public static void generateObjectIndex(Node node, PrintWriter printWriter) {
        int n = 0;
        NodeList nodeList = proc.selectNodes(node, "/spec/body/div1", node);
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            Object object;
            Element element = (Element)nodeList.item(n2);
            String string = SpecDTD.getSuitableFileName(element) + ".html";
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            NodeList nodeList2 = proc.selectNodes(element, ".//definitions/*", element);
            int n3 = 0;
            while (n3 < nodeList2.getLength()) {
                object = (Element)nodeList2.item(n3);
                treeMap.put(object.getAttribute("name"), object);
                ++n3;
            }
            if (!treeMap.isEmpty()) {
                object = Util.getAllText(element, "head");
                printWriter.println("<h3 id='title-object-" + ++n + "'>" + (String)object + "</h3>");
                printWriter.println("<table border='0'>");
                Iterator iterator = treeMap.keySet().iterator();
                int n4 = 0;
                while (iterator.hasNext()) {
                    String string2;
                    Element element2;
                    if (n4 % 3 == 0) {
                        printWriter.println("<tr>");
                    }
                    if (!(element2 = (Element)treeMap.get(string2 = (String)iterator.next())).hasAttribute("id")) {
                        System.err.println("[ERROR] object \"" + string2 + "\" has no ID");
                    }
                    printWriter.println("   <td><a class='toc-link' href='" + string + '#' + element2.getAttribute("id") + "'>" + string2 + "</a>&nbsp;&nbsp;&nbsp;</td>");
                    ++n4;
                }
                printWriter.println("</table>");
            }
            ++n2;
        }
    }

    public static void generateDefinitionIndex(Node node, PrintWriter printWriter) {
        Object object;
        Object object2;
        int n;
        Object object3;
        Object object4;
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(new StringIgnoreCaseComparator());
        NodeList nodeList = proc.selectNodes(node, "/spec/front/div1", node);
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            Entry entry;
            Object object5;
            Object object6;
            String string;
            Object object7;
            Object object8;
            Element element = (Element)nodeList.item(n2);
            object4 = SpecDTD.getSuitableFileName(element) + ".html";
            if (monolithic) {
                object4 = "";
            }
            object3 = proc.selectNodes(element, ".//bibref", element);
            int n3 = 0;
            while (n3 < object3.getLength()) {
                object8 = (Element)object3.item(n3);
                String string2 = object8.getAttribute("ref");
                object7 = Util.getBibref(string2);
                if (object7 != null) {
                    string = ((NodeLink)object7).getKey();
                    object6 = Util.getClosestAncestorId((Element)object8);
                    object5 = new Entry('R', (Node)object8, (String)object4, (String)object6);
                    entry = (Entry)treeMap.get(string);
                    if (entry == null) {
                        treeMap.put(string, object5);
                    } else {
                        entry.append((Entry)object5);
                    }
                } else {
                    System.err.println("[ERROR] unknown bibref " + string2 + " removed!");
                }
                ++n3;
            }
            object8 = proc.selectNodes(element, ".//termref", element);
            n = 0;
            while (n < object8.getLength()) {
                object7 = (Element)object8.item(n);
                string = object7.getAttribute("def");
                object6 = Util.getTermDef(string);
                if (object6 != null) {
                    object5 = Util.getClosestAncestorId((Element)object7);
                    entry = new Entry('T', (Node)object7, (String)object4, (String)object5);
                    object2 = (Entry)treeMap.get(((NodeLink)object6).getKey());
                    if (object2 == null) {
                        treeMap.put(((NodeLink)object6).getKey(), entry);
                    } else {
                        ((Entry)object2).append(entry);
                    }
                } else {
                    System.err.println("[ERROR] unknown termref " + string + " removed!");
                }
                ++n;
            }
            ++n2;
        }
        nodeList = proc.selectNodes(node, "/spec/body/div1", node);
        int n4 = 0;
        while (n4 < nodeList.getLength()) {
            Entry entry;
            Object object9;
            String string;
            Object object10;
            Object object11;
            Object object12;
            Object object13;
            object4 = (Element)nodeList.item(n4);
            object3 = SpecDTD.getSuitableFileName((Element)object4) + ".html";
            if (monolithic) {
                object3 = "";
            }
            NodeList nodeList2 = proc.selectNodes((Node)object4, ".//typedef", (Node)object4);
            int n5 = 0;
            while (n5 < nodeList2.getLength()) {
                Element element = (Element)nodeList2.item(n5);
                String string3 = element.getAttribute("name");
                String string4 = element.getAttribute("id");
                Entry entry2 = new Entry('T', element, (String)object3, string4);
                Entry entry3 = (Entry)treeMap.get(string3);
                if (entry3 == null) {
                    treeMap.put(string3, entry2);
                } else {
                    entry3.append(entry2);
                }
                ++n5;
            }
            nodeList2 = proc.selectNodes((Node)object4, ".//interface", (Node)object4);
            n = 0;
            while (n < nodeList2.getLength()) {
                Element element = (Element)nodeList2.item(n);
                String string5 = element.getAttribute("name");
                String string6 = element.getAttribute("id");
                Entry entry4 = new Entry('I', element, (String)object3, string6);
                Entry entry5 = (Entry)treeMap.get(string5);
                if (entry5 == null) {
                    treeMap.put(string5, entry4);
                } else {
                    entry5.append(entry4);
                }
                ++n;
            }
            nodeList2 = proc.selectNodes((Node)object4, ".//method", (Node)object4);
            int n6 = 0;
            while (n6 < nodeList2.getLength()) {
                Element element = (Element)nodeList2.item(n6);
                String string7 = element.getAttribute("name");
                String string8 = Util.getClosestAncestorId(element);
                Entry entry6 = new Entry('M', element, (String)object3, string8);
                object2 = (Entry)treeMap.get(string7);
                if (object2 == null) {
                    treeMap.put(string7, entry6);
                } else {
                    ((Entry)object2).append(entry6);
                }
                ++n6;
            }
            nodeList2 = proc.selectNodes((Node)object4, ".//attribute", (Node)object4);
            int n7 = 0;
            while (n7 < nodeList2.getLength()) {
                Element element = (Element)nodeList2.item(n7);
                String string9 = element.getAttribute("name");
                String string10 = Util.getClosestAncestorId(element);
                object2 = new Entry('A', element, (String)object3, string10);
                object13 = (Entry)treeMap.get(string9);
                if (object13 == null) {
                    treeMap.put(string9, object2);
                } else {
                    ((Entry)object13).append((Entry)object2);
                }
                ++n7;
            }
            nodeList2 = proc.selectNodes((Node)object4, ".//constant", (Node)object4);
            int n8 = 0;
            while (n8 < nodeList2.getLength()) {
                Element element = (Element)nodeList2.item(n8);
                String string11 = element.getAttribute("name");
                object2 = Util.getClosestAncestorId(element);
                object13 = new Entry('C', element, (String)object3, (String)object2);
                object12 = (Entry)treeMap.get(string11);
                if (object12 == null) {
                    treeMap.put(string11, object13);
                } else {
                    ((Entry)object12).append((Entry)object13);
                }
                ++n8;
            }
            nodeList2 = proc.selectNodes((Node)object4, ".//exception", (Node)object4);
            int n9 = 0;
            while (n9 < nodeList2.getLength()) {
                Element element = (Element)nodeList2.item(n9);
                if ("definitions".equals(element.getParentNode().getNodeName())) {
                    object2 = element.getAttribute("name");
                    object13 = Util.getClosestAncestorId(element);
                    object12 = new Entry('E', element, (String)object3, (String)object13);
                    object = (Entry)treeMap.get(object2);
                    if (object == null) {
                        treeMap.put(object2, object12);
                    } else {
                        ((Entry)object).append((Entry)object12);
                    }
                }
                ++n9;
            }
            nodeList2 = proc.selectNodes((Node)object4, ".//termdef", (Node)object4);
            int n10 = 0;
            while (n10 < nodeList2.getLength()) {
                object2 = (Element)nodeList2.item(n10);
                object13 = Util.getClosestAncestorId((Element)object2);
                object12 = object2.getAttribute("term");
                object = new Entry('T', (Node)object2, (String)object3, (String)object13);
                object11 = (Entry)treeMap.get(object12);
                if (object11 == null) {
                    treeMap.put(object12, object);
                } else {
                    ((Entry)object11).append((Entry)object);
                }
                ++n10;
            }
            object2 = proc.selectNodes((Node)object4, ".//bibref", (Node)object4);
            int n11 = 0;
            while (n11 < object2.getLength()) {
                object12 = (Element)object2.item(n11);
                object = object12.getAttribute("ref");
                object11 = Util.getBibref((String)object);
                if (object11 != null) {
                    object10 = ((NodeLink)object11).getKey();
                    string = Util.getClosestAncestorId((Element)object12);
                    object9 = new Entry('R', (Node)object12, (String)object3, string);
                    entry = (Entry)treeMap.get(object10);
                    if (entry == null) {
                        treeMap.put(object10, object9);
                    } else {
                        entry.append((Entry)object9);
                    }
                } else {
                    System.err.println("[ERROR] unknown bibref " + (String)object + " removed!");
                }
                ++n11;
            }
            nodeList2 = proc.selectNodes((Node)object4, ".//termref", (Node)object4);
            int n12 = 0;
            while (n12 < nodeList2.getLength()) {
                object = (Element)nodeList2.item(n12);
                object11 = object.getAttribute("def");
                object10 = Util.getTermDef((String)object11);
                if (object10 != null) {
                    string = Util.getClosestAncestorId((Element)object);
                    object9 = new Entry('T', (Node)object, (String)object3, string);
                    entry = (Entry)treeMap.get(((NodeLink)object10).getKey());
                    if (entry == null) {
                        treeMap.put(((NodeLink)object10).getKey(), object9);
                    } else {
                        entry.append((Entry)object9);
                    }
                } else {
                    System.err.println("[ERROR] unknown termref " + (String)object11 + " removed!");
                }
                ++n12;
            }
            object = proc.selectNodes((Node)object4, ".//label", (Node)object4);
            int n13 = 0;
            while (n13 < object.getLength()) {
                object10 = (Element)object.item(n13);
                if (object10.hasAttribute("id")) {
                    string = object10.getAttribute("id");
                    object9 = Util.getAllText((Node)object10, null);
                    entry = new Entry('L', (Node)object10, (String)object3, string);
                    Entry entry7 = (Entry)treeMap.get(object9);
                    if (entry7 == null) {
                        treeMap.put(object9, entry);
                    } else {
                        entry7.append(entry);
                    }
                }
                ++n13;
            }
            ++n4;
        }
        object4 = (Element)proc.getNode(node, "/spec/back/div1[@role='glossary']", node);
        if (object4 != null) {
            object3 = SpecDTD.getSuitableFileName((Element)object4) + ".html";
            if (monolithic) {
                object3 = "";
            }
            NodeList nodeList3 = proc.selectNodes((Node)object4, ".//label", (Node)object4);
            int n14 = 0;
            while (n14 < nodeList3.getLength()) {
                Element element = (Element)nodeList3.item(n14);
                String string = element.getAttribute("id");
                String string12 = Util.getAllText(element, null);
                Entry entry = new Entry('L', element, (String)object3, string);
                Entry entry8 = (Entry)treeMap.get(string12);
                if (entry8 == null) {
                    treeMap.put(string12, entry);
                } else {
                    entry8.append(entry);
                }
                ++n14;
            }
            NodeList nodeList4 = proc.selectNodes((Node)object4, ".//bibref", (Node)object4);
            int n15 = 0;
            while (n15 < nodeList4.getLength()) {
                Element element = (Element)nodeList4.item(n15);
                String string = element.getAttribute("ref");
                NodeLink nodeLink = Util.getBibref(string);
                if (nodeLink != null) {
                    String string13 = nodeLink.getKey();
                    Node node2 = proc.getNode(element, "ancestor::gitem/label", element);
                    object2 = ((Element)node2).getAttribute("id");
                    Entry entry = new Entry('R', element, (String)object3, (String)object2);
                    object = (Entry)treeMap.get(string13);
                    if (object == null) {
                        treeMap.put(string13, entry);
                    } else {
                        ((Entry)object).append(entry);
                    }
                } else {
                    System.err.println("[ERROR] unknown bibref " + string + " removed!");
                }
                ++n15;
            }
        }
        if ((object4 = (Element)proc.getNode(node, "/spec/back/div1[@role='references']", node)) != null) {
            object3 = SpecDTD.getSuitableFileName((Element)object4) + ".html";
            if (monolithic) {
                object3 = "";
            }
            NodeList nodeList5 = proc.selectNodes((Node)object4, ".//bibl", (Node)object4);
            int n16 = 0;
            while (n16 < nodeList5.getLength()) {
                Element element = (Element)nodeList5.item(n16);
                String string = element.getAttribute("id");
                String string14 = element.getAttribute("key");
                Entry entry = new Entry('B', element, (String)object3, string);
                Entry entry9 = (Entry)treeMap.get(string14);
                if (entry9 == null) {
                    treeMap.put(string14, entry);
                } else {
                    entry9.append(entry);
                }
                ++n16;
            }
        }
        int n17 = 0;
        char c = '\u0000';
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            char c2;
            String string = (String)iterator.next();
            Entry entry = (Entry)treeMap.get(string);
            if (n17 == 0) {
                printWriter.println("<table summary='the table contains all keywords used in this document'>");
            }
            if ((c2 = Character.toLowerCase(string.charAt(0))) != c) {
                if (c != '\u0000') {
                    n17 = 0;
                    printWriter.println("<tr><td>&#160;");
                }
                c = c2;
            }
            if (n17 % 3 == 0) {
                printWriter.println("<tr>");
            }
            printWriter.print("<td width='30%'>");
            int n18 = 1;
            HashSet<String> hashSet = new HashSet<String>();
            while (entry != null) {
                if (n18 == 1) {
                    printWriter.print("<a class='noxref' href='" + entry.getFileName() + '#' + entry.getId() + "'>" + string + "</a>");
                    if (entry.getNext() != null) {
                        printWriter.print(" <a class='index-inst' href='" + entry.getFileName() + '#' + entry.getId() + "'>" + n18 + "</a>");
                    }
                    hashSet.add(entry.getId());
                    ++n18;
                } else if (!hashSet.contains(entry.getId())) {
                    printWriter.print(",\n<a class='index-inst' href='" + entry.getFileName() + '#' + entry.getId() + "'>" + n18 + "</a>");
                    hashSet.add(entry.getId());
                    ++n18;
                }
                entry = entry.getNext();
            }
            printWriter.println("</td>");
            ++n17;
        }
        if (n17 != 0) {
            printWriter.println("</table>");
        }
    }
}

