/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.specgenerator;

import java.io.File;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.tools.specgenerator.Back;
import org.w3c.tools.specgenerator.Body;
import org.w3c.tools.specgenerator.CoverPage;
import org.w3c.tools.specgenerator.Front;
import org.w3c.tools.specgenerator.SpecDTD;
import org.w3c.tools.specgenerator.Util;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Main
implements ErrorHandler {
    public static String version = "Spec Generator v2.0";

    public void warning(SAXParseException sAXParseException) {
        System.err.println("[WARNING] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) {
        System.err.println("[ERROR] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.err.println("[FATAL ERROR] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        throw sAXParseException;
    }

    public void doJob(String string, String string2) throws Exception {
        String string3 = string == null ? "html" : string + File.separatorChar + "html";
        System.out.println("Loading " + string2 + " ...");
        DOMParser dOMParser = new DOMParser();
        dOMParser.setFeature("http://xml.org/sax/features/namespaces", false);
        dOMParser.setFeature("http://xml.org/sax/features/validation", true);
        dOMParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        dOMParser.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", false);
        dOMParser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", false);
        dOMParser.setErrorHandler((ErrorHandler)this);
        try {
            dOMParser.parse(string2);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                sAXException.getException().printStackTrace();
            }
            return;
        }
        Document document = dOMParser.getDocument();
        System.out.println("Loading done.");
        DOMImplementation dOMImplementation = document.getImplementation();
        if (!dOMImplementation.hasFeature("XML", "2.0")) {
            System.err.println("You need, at least, a DOM Level 2 implementation. Sorry.");
            return;
        }
        Util.init(document);
        File file = new File(string3);
        if (!file.exists() && !Util.createDirectory(file.getAbsolutePath())) {
            System.err.println("[ERROR] Directory " + file.getAbsolutePath() + " not created.");
        }
        if (!SpecDTD.monolithic) {
            CoverPage coverPage = new CoverPage();
            coverPage.generateToFile(document, string3);
            Front front = new Front();
            front.generateToDirectory(document, string3);
            Body body2 = new Body();
            body2.generateToDirectory(document, string3);
            Back back = new Back();
            back.generateToDirectory(document, string3);
        } else {
            Main.monolithic(string, document);
        }
    }

    public static void monolithic(String string, Document document) throws Exception {
        System.err.println("Monolithic not yet implemented");
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        try {
            n = Util.parseOptions(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Util.help();
            return;
        }
        if (n >= stringArray.length) {
            Util.help();
            return;
        }
        String string = null;
        String string2 = stringArray[n];
        if ("--version".equals(string2)) {
            System.out.println(version);
            return;
        }
        if ("--help".equals(string2)) {
            Util.help();
            return;
        }
        if ("--directory".equals(string2) && ++n + 1 < stringArray.length) {
            string = stringArray[n++];
        }
        if (n != stringArray.length - 1) {
            Util.help();
            return;
        }
        new Main().doJob(string, stringArray[n]);
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(File.separatorChar);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }
}

