/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.specgenerator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.tools.markup.dom.DOMDispatcher;
import org.w3c.tools.markup.dom.DOMDispatcherImpl;
import org.w3c.tools.markup.dom.DOMNodeHandlerBase;
import org.w3c.tools.markup.dom.DOMUtil;
import org.w3c.tools.markup.xpath.XPathFactory;
import org.w3c.tools.markup.xpath.XPathProcessor;
import org.w3c.tools.specgenerator.NodeLink;
import org.w3c.tools.specgenerator.SpecDTD;
import org.w3c.tools.specgenerator.Util;

public class CoverPage {
    PrintWriter out;
    XPathProcessor proc = XPathFactory.getDefaultProcessor();
    DOMDispatcher dispatcher = new DOMDispatcherImpl();
    boolean inAltLocs = false;

    public void generateToFile(Document document, String string) throws IOException {
        String string2 = string != null ? string + File.separatorChar + Util.getFileName("-OverviewFile-") + ".html" : Util.getFileName("-OverviewFile-") + ".html";
        System.out.println("Generating " + Util.getFileName("-OverviewFile-") + "...");
        Object object = new File(string);
        if (!((File)object).exists() && !((File)object).mkdir()) {
            System.err.println("[ERROR] Directory " + ((File)object).getAbsolutePath() + " not created.");
            return;
        }
        this.out = new PrintWriter(new FileWriter(string2));
        object = SpecDTD.getSpecTitle(document);
        NodeLink nodeLink = Util.getRelatedItem(Util.getFileName("-OverviewFile-"), "next");
        Util.generateHtmlHead(document, this.out, (String)object, null, null, null, nodeLink, Util.objectIndex, Util.index);
        Node node = this.proc.getNode(document, "/spec/header", document);
        this.dispatcher.addHandler(new Abstract());
        this.dispatcher.addHandler(new affiliationAuthor());
        this.dispatcher.addHandler(new affiliationMember());
        this.dispatcher.addHandler(new chair());
        this.dispatcher.addHandler(new editor());
        this.dispatcher.addHandler(new author());
        this.dispatcher.addHandler(new authorGeneral());
        this.dispatcher.addHandler(new authlist());
        this.dispatcher.addHandler(new email());
        this.dispatcher.addHandler(new code());
        this.dispatcher.addHandler(new day());
        this.dispatcher.addHandler(new emphImportant());
        this.dispatcher.addHandler(new emph());
        this.dispatcher.addHandler(new item());
        this.dispatcher.addHandler(new publoc());
        this.dispatcher.addHandler(new altlocs());
        this.dispatcher.addHandler(new latestloc());
        this.dispatcher.addHandler(new prevlocs());
        this.dispatcher.addHandler(new locPrevlocs());
        this.dispatcher.addHandler(new locLatestloc());
        this.dispatcher.addHandler(new loc());
        this.dispatcher.addHandler(new month());
        this.dispatcher.addHandler(new nameAuthor());
        this.dispatcher.addHandler(new nameMember());
        this.dispatcher.addHandler(new noteEditorial());
        this.dispatcher.addHandler(new noteComment());
        this.dispatcher.addHandler(new noteReminder());
        this.dispatcher.addHandler(new note());
        this.dispatcher.addHandler(new ednote());
        this.dispatcher.addHandler(new notice());
        this.dispatcher.addHandler(new olist());
        this.dispatcher.addHandler(new pErrata());
        this.dispatcher.addHandler(new pLanguages());
        this.dispatcher.addHandler(new langusage());
        this.dispatcher.addHandler(new revisiondesc());
        this.dispatcher.addHandler(new pQuote());
        this.dispatcher.addHandler(new pDiff());
        this.dispatcher.addHandler(new pItem());
        this.dispatcher.addHandler(new pNote());
        this.dispatcher.addHandler(new pNotice());
        this.dispatcher.addHandler(new pList());
        this.dispatcher.addHandler(new pImportant());
        this.dispatcher.addHandler(new p());
        this.dispatcher.addHandler(new phraseDiff());
        this.dispatcher.addHandler(new pubdate());
        this.dispatcher.addHandler(new roleMember());
        this.dispatcher.addHandler(new sourcedesc());
        this.dispatcher.addHandler(new status());
        this.dispatcher.addHandler(new structuredesc());
        this.dispatcher.addHandler(new title());
        this.dispatcher.addHandler(new ulist());
        this.dispatcher.addHandler(new version());
        this.dispatcher.addHandler(new w3cDesignation());
        this.dispatcher.addHandler(new w3cDoctype());
        this.dispatcher.addHandler(new pi1());
        this.dispatcher.addHandler(new pi2());
        this.dispatcher.addHandler(new pi3());
        this.dispatcher.addHandler(new bibref());
        this.dispatcher.addHandler(new TextHandler());
        this.dispatcher.process(node, this.out);
        Util.generateHtmlTail(document, this.out, null, nodeLink, Util.objectIndex, Util.index);
        this.out.flush();
        this.out.close();
    }

    public static void generateSimpleToc(Document document, PrintWriter printWriter, boolean bl) {
        String string;
        String string2;
        XPathProcessor xPathProcessor = XPathFactory.getDefaultProcessor();
        printWriter.println("<h2 id='table-of-contents'><a name='contents'>Table of contents</a></h2>");
        printWriter.println("<ul class='toc'>");
        NodeList nodeList = xPathProcessor.selectNodes(document, "/spec/front/div1", document);
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            string2 = Util.getAllText(element, "head");
            string = SpecDTD.getSuitableFileName(element) + ".html";
            if (SpecDTD.monolithic) {
                string = "#" + element.getAttribute("id");
            }
            printWriter.println("<li class='tocline2'><a class='tocxref' href='" + string + "'>" + string2 + "</a></li>");
            ++n;
        }
        printWriter.println("</ul>");
        int n2 = 1;
        printWriter.println("<ul class='toc'>");
        nodeList = xPathProcessor.selectNodes(document, "/spec/body/div1", document);
        if (nodeList.getLength() <= 1) {
            bl = false;
        }
        int n3 = 0;
        while (n3 < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n3);
            string2 = Util.getAllText(element, "head");
            string2 = bl ? "Chapter " + n2 + ": " + string2 : n2 + ". " + string2;
            string = SpecDTD.getSuitableFileName(element) + ".html";
            if (SpecDTD.monolithic) {
                string = "#" + element.getAttribute("id");
            }
            printWriter.println("<li class='tocline2'><a class='tocxref' href='" + string + "'>" + string2 + "</a></li>");
            ++n2;
            ++n3;
        }
        printWriter.println("</ul>");
        n2 = 0;
        nodeList = xPathProcessor.selectNodes(document, "/spec/back/div1", document);
        if (nodeList.getLength() != 0) {
            printWriter.println("<ul class='toc'>");
        }
        int n4 = 0;
        while (n4 < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n4);
            string2 = Util.getAllText(element, "head");
            String string3 = element.getAttribute("role");
            if (!(string3.equals("index") || string3.equals("note") || string3.equals("references") || string3.equals("glossary") || string3.equals("acknowledgments") || string3.equals("object-index"))) {
                char c = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(n2);
                string2 = "Appendix " + c + ": " + string2;
            }
            string = SpecDTD.getSuitableFileName(element) + ".html";
            if (SpecDTD.monolithic) {
                string = "#" + element.getAttribute("id");
            }
            printWriter.println("<li class='tocline2'><a class='tocxref' href='" + string + "'>" + string2 + "</a></li>");
            ++n2;
            ++n4;
        }
        if (n2 != 0) {
            printWriter.println("</ul>\n");
        }
    }

    class bibref
    extends DOMNodeHandlerBase {
        bibref() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            String string = ((Element)node).getAttribute("ref");
            NodeLink nodeLink = Util.getBibref(string);
            if (nodeLink != null) {
                CoverPage.this.out.print("[<a class='noxref' href='" + nodeLink.getLink() + "'>" + nodeLink.getKey() + "</a>]");
            } else {
                System.err.println("[ERROR] unknown bibref " + string + " removed!");
            }
            return true;
        }
    }

    class TextHandler
    extends DOMNodeHandlerBase {
        TextHandler() {
        }

        public String getMatchPattern() {
            return "text()";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            CoverPage.this.out.print(Util.getEscapedContent((CharacterData)node));
            return false;
        }
    }

    class pi3
    extends DOMNodeHandlerBase {
        pi3() {
        }

        public String getMatchPattern() {
            return "processing-instruction('GENERATE-EXPANDED-TOC')";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
            if ("NOCHAPTERS".equals(processingInstruction.getData().trim())) {
                SpecDTD.generateExpandedToc(node, CoverPage.this.out, false);
            } else {
                SpecDTD.generateExpandedToc(node, CoverPage.this.out, true);
            }
            return false;
        }
    }

    class pi2
    extends DOMNodeHandlerBase {
        pi2() {
        }

        public String getMatchPattern() {
            return "processing-instruction('GENERATE-MINI-TOC')";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            boolean bl = SpecDTD.monolithic;
            SpecDTD.monolithic = true;
            SpecDTD.generateMiniToc(node.getParentNode(), CoverPage.this.out, "0");
            SpecDTD.monolithic = bl;
            return false;
        }
    }

    class pi1
    extends DOMNodeHandlerBase {
        pi1() {
        }

        public String getMatchPattern() {
            return "processing-instruction('GENERATE-TOC')";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            CoverPage.generateSimpleToc(node.getOwnerDocument(), CoverPage.this.out, true);
            return false;
        }
    }

    class w3cDoctype
    extends DOMNodeHandlerBase {
        w3cDoctype() {
        }

        public String getMatchPattern() {
            return "w3c-doctype";
        }

        public String prefix() {
            return "  <h2 id='W3C-doctype'>";
        }

        public String suffix() {
            return " ";
        }
    }

    class w3cDesignation
    extends DOMNodeHandlerBase {
        w3cDesignation() {
        }

        public String getMatchPattern() {
            return "w3c-designation";
        }

        public String prefix() {
            return "<!-- ";
        }

        public String suffix() {
            return " -->";
        }
    }

    class version
    extends DOMNodeHandlerBase {
        version() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            String string = DOMUtil.getContent(node);
            if (string.length() != 0) {
                CoverPage.this.out.print("  <h2 id='version'>Version ");
            }
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            String string = DOMUtil.getContent(node);
            if (string.length() != 0) {
                CoverPage.this.out.println("</h2>");
            }
        }
    }

    class ulist
    extends DOMNodeHandlerBase {
        ulist() {
        }

        public String prefix() {
            return "<ul>\n";
        }

        public String suffix() {
            return "</ul>\n";
        }
    }

    class title
    extends DOMNodeHandlerBase {
        title() {
        }

        public String prefix() {
            if (!SpecDTD.online) {
                return "\n<div class='head'>\n<p><a href='http://www.w3.org/'>\n<img height='48' width='72'\n alt='W3C' src='./images/w3c_home.gif'></a></p>\n  <h1 id='title'>";
            }
            return "\n<div class='head'>\n<p><a href='http://www.w3.org/'>\n<img height='48' width='72'\n alt='W3C' src='" + Util.getFileName("-W3CIcons-") + "w3c_home'></a></p>\n  <h1 id='title'>";
        }

        public String suffix() {
            return "</h1>\n";
        }
    }

    class structuredesc
    extends DOMNodeHandlerBase {
        structuredesc() {
        }

        public String prefix() {
            return "<h2 id='structure'>Structure</h2>\n<div class='structure'>";
        }

        public String suffix() {
            return "</div>";
        }
    }

    class status
    extends DOMNodeHandlerBase {
        status() {
        }

        public String prefix() {
            return "<h2 id='status'>Status of this document</h2>\n<div class='status'>\n";
        }

        public String suffix() {
            return "</div>\n";
        }
    }

    class sourcedesc
    extends DOMNodeHandlerBase {
        sourcedesc() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            return false;
        }
    }

    class roleMember
    extends DOMNodeHandlerBase {
        roleMember() {
        }

        public String getMatchPattern() {
            return "member/role";
        }

        public String prefix() {
            return "<i>";
        }

        public String suffix() {
            return "</i>";
        }
    }

    class pubdate
    extends DOMNodeHandlerBase {
        pubdate() {
        }

        public String suffix() {
            return "</h2>\n";
        }
    }

    class phraseDiff
    extends DOMNodeHandlerBase {
        phraseDiff() {
        }

        public String getMatchPattern() {
            return "phrase[@diff]";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            CoverPage.this.out.print("<span class='diff-" + ((Element)node).getAttribute("diff") + "'>");
            return true;
        }

        public String suffix() {
            return "</span>";
        }
    }

    class p
    extends DOMNodeHandlerBase {
        p() {
        }

        public String prefix() {
            return "<p>";
        }

        public String suffix() {
            return "</p>";
        }
    }

    class pImportant
    extends DOMNodeHandlerBase {
        pImportant() {
        }

        public String getMatchPattern() {
            return "p[@role='important']";
        }

        public String prefix() {
            return "<p><b>";
        }

        public String suffix() {
            return "</b></p>";
        }
    }

    class pList
    extends DOMNodeHandlerBase {
        pList() {
        }

        public String getMatchPattern() {
            return "p[descendant::olist or descendant::ulist]";
        }

        public String prefix() {
            return "<p>";
        }
    }

    class pNotice
    extends DOMNodeHandlerBase {
        pNotice() {
        }

        public String getMatchPattern() {
            return "notice/p";
        }
    }

    class pNote
    extends DOMNodeHandlerBase {
        pNote() {
        }

        public String getMatchPattern() {
            return "note/p";
        }
    }

    class pItem
    extends DOMNodeHandlerBase {
        pItem() {
        }

        public String getMatchPattern() {
            return "item/p";
        }
    }

    class pDiff
    extends DOMNodeHandlerBase {
        pDiff() {
        }

        public String getMatchPattern() {
            return "p[@diff]";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            CoverPage.this.out.print("<p class='diff-" + ((Element)node).getAttribute("diff") + "'>");
            return true;
        }

        public String suffix() {
            return "</p>";
        }
    }

    class pQuote
    extends DOMNodeHandlerBase {
        pQuote() {
        }

        public String getMatchPattern() {
            return "p[@role='block']";
        }

        public String prefix() {
            return "<blockquote>";
        }

        public String suffix() {
            return "</blockquote>";
        }
    }

    class pLanguages
    extends DOMNodeHandlerBase {
        pLanguages() {
        }

        public String getMatchPattern() {
            return "status//p[@role='languages']";
        }

        public String prefix() {
            return "<h3 id='languages'>Available Languages</h3>\n<p>";
        }
    }

    class pErrata
    extends DOMNodeHandlerBase {
        pErrata() {
        }

        public String getMatchPattern() {
            return "status//p[@role='errata']";
        }

        public String prefix() {
            return "<h3 id='errata'>Errata</h3>\n<p>";
        }
    }

    class olist
    extends DOMNodeHandlerBase {
        olist() {
        }

        public String prefix() {
            return "<ol>\n";
        }

        public String suffix() {
            return "</ol>\n";
        }
    }

    class notice
    extends DOMNodeHandlerBase {
        notice() {
        }

        public String prefix() {
            return "<div align='center'><i><b>Note:</b> ";
        }

        public String suffix() {
            return "</i></div>\n";
        }
    }

    class ednote
    extends DOMNodeHandlerBase {
        ednote() {
        }

        public String prefix() {
            return "<div style='color: red'>(<i><b>ED: </b>";
        }

        public String suffix() {
            return ")</i></div><br>\n";
        }
    }

    class note
    extends DOMNodeHandlerBase {
        note() {
        }

        public String prefix() {
            return "<p><b>Note:</b>";
        }
    }

    class noteReminder
    extends DOMNodeHandlerBase {
        noteReminder() {
        }

        public String getMatchPattern() {
            return "note[@role='reminder']";
        }

        public String prefix() {
            return "<div style='color: red'>(<i><b>ED: </b>";
        }

        public String suffix() {
            return ")</i></div><br>\n";
        }
    }

    class noteComment
    extends DOMNodeHandlerBase {
        noteComment() {
        }

        public String getMatchPattern() {
            return "note[@role='comment']";
        }

        public String prefix() {
            return "<div style='color: green'>(<i><b>ED: </b>";
        }

        public String suffix() {
            return ")</i></div><br>\n";
        }
    }

    class noteEditorial
    extends DOMNodeHandlerBase {
        noteEditorial() {
        }

        public String getMatchPattern() {
            return "note[@role='editorial']";
        }

        public String prefix() {
            return "<div style='color: red'>(<i><b>ED: </b>";
        }

        public String suffix() {
            return ")</i></div><br>\n";
        }
    }

    class email
    extends DOMNodeHandlerBase {
        email() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            return false;
        }
    }

    class nameMember
    extends DOMNodeHandlerBase {
        nameMember() {
        }

        public String getMatchPattern() {
            return "member/name";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            CoverPage.this.out.println(", ");
        }
    }

    class nameAuthor
    extends DOMNodeHandlerBase {
        nameAuthor() {
        }

        public String getMatchPattern() {
            return "author/name";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            CoverPage.this.out.println(", ");
        }
    }

    class month
    extends DOMNodeHandlerBase {
        month() {
        }

        public String suffix() {
            return " ";
        }
    }

    class loc
    extends DOMNodeHandlerBase {
        loc() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            String string = ((Element)node).getAttribute("href");
            CoverPage.this.out.print("<a href='" + string + "'>");
            return true;
        }

        public String suffix() {
            return "</a>";
        }
    }

    class locLatestloc
    extends DOMNodeHandlerBase {
        locLatestloc() {
        }

        public String getMatchPattern() {
            return "latestloc/loc";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            String string = ((Element)node).getAttribute("href");
            CoverPage.this.out.print("<dd><a href='" + string + "'>");
            return true;
        }

        public String suffix() {
            return "</a></dd>\n";
        }
    }

    class locPrevlocs
    extends DOMNodeHandlerBase {
        int count = 0;

        locPrevlocs() {
        }

        public String getMatchPattern() {
            return "prevlocs/loc";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            if (this.count != 0) {
                System.err.println("[WARNING] No more than one previous version is allowed now.");
            }
            ++this.count;
            String string = ((Element)node).getAttribute("href");
            CoverPage.this.out.print("<dd><a href='" + string + "'>");
            return true;
        }

        public String suffix() {
            return "</a></dd>\n";
        }
    }

    class prevlocs
    extends DOMNodeHandlerBase {
        prevlocs() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            NodeList nodeList = CoverPage.this.proc.selectNodes(node, "./loc", node);
            if (nodeList.getLength() > 0) {
                CoverPage.this.out.println("<dt>Previous version:</dt>\n");
                return true;
            }
            return false;
        }

        public void endNode(Node node, Hashtable hashtable) {
            if (!CoverPage.this.proc.match(node, "*[following-sibling::latestloc]", node)) {
                CoverPage.this.out.println("</dl>");
            }
        }
    }

    class latestloc
    extends DOMNodeHandlerBase {
        latestloc() {
        }

        public String prefix() {
            return "<dt>Latest version:</dt>\n";
        }

        public void endNode(Node node, Hashtable hashtable) {
            if (!CoverPage.this.proc.match(node, "*[following-sibling::prevlocs]", node)) {
                CoverPage.this.out.println("</dl>");
            }
        }
    }

    class altlocs
    extends DOMNodeHandlerBase {
        altlocs() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            if (CoverPage.this.inAltLocs) {
                CoverPage.this.out.print("<p>This document is also available in these non-normative formats: ");
                NodeList nodeList = CoverPage.this.proc.selectNodes(node, "./loc", node);
                Element element = (Element)nodeList.item(0);
                int n = 0;
                do {
                    if (nodeList.item(n + 1) == null) {
                        CoverPage.this.out.print(", and ");
                    } else if (n >= 1) {
                        CoverPage.this.out.print(", ");
                    }
                    CoverPage.this.out.print("<a href='" + element.getAttribute("href") + "'>");
                    Node node2 = element.getFirstChild();
                    do {
                        if (node2.getNodeType() == 3) {
                            CoverPage.this.out.print(node2.getNodeValue());
                            continue;
                        }
                        System.err.println("Invalid node in <loc>? " + node2.getNodeType());
                    } while ((node2 = node2.getNextSibling()) != null);
                    CoverPage.this.out.print("</a>");
                } while ((element = (Element)nodeList.item(++n)) != null);
                CoverPage.this.out.println(".</p>");
            }
            return false;
        }
    }

    class publoc
    extends DOMNodeHandlerBase {
        publoc() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            CoverPage.this.out.print("<dl><dt>This version:</dt>\n");
            Node node2 = node.getFirstChild();
            while (node2 != null && node2.getNodeType() != 1) {
                node2 = node2.getNextSibling();
            }
            CoverPage.this.out.print("<dd>");
            CoverPage.this.out.print("<a href='" + ((Element)node2).getAttribute("href") + "'>");
            Node node3 = node2.getFirstChild();
            do {
                if (node3.getNodeType() == 3) {
                    CoverPage.this.out.print(node3.getNodeValue());
                    continue;
                }
                System.err.println("Invalid node in <loc>? " + node3.getNodeType());
            } while ((node3 = node3.getNextSibling()) != null);
            CoverPage.this.out.print("</a></dd>");
            return false;
        }
    }

    class revisiondesc
    extends DOMNodeHandlerBase {
        revisiondesc() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            return false;
        }
    }

    class langusage
    extends DOMNodeHandlerBase {
        langusage() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            return false;
        }
    }

    class item
    extends DOMNodeHandlerBase {
        item() {
        }

        public String prefix() {
            return "<li>";
        }

        public String suffix() {
            return "</li>";
        }
    }

    class emph
    extends DOMNodeHandlerBase {
        emph() {
        }

        public String prefix() {
            return "<em>";
        }

        public String suffix() {
            return "</em>";
        }
    }

    class emphImportant
    extends DOMNodeHandlerBase {
        emphImportant() {
        }

        public String getMatchPattern() {
            return "emph[@role='important']";
        }

        public String prefix() {
            return "<b>";
        }

        public String suffix() {
            return "</b>";
        }
    }

    class day
    extends DOMNodeHandlerBase {
        day() {
        }

        public String suffix() {
            return " ";
        }
    }

    class code
    extends DOMNodeHandlerBase {
        code() {
        }

        public String prefix() {
            return "<code>";
        }

        public String suffix() {
            return "</code>";
        }
    }

    class authlist
    extends DOMNodeHandlerBase {
        authlist() {
        }

        public String prefix() {
            return "<dl>";
        }

        public void endNode(Node node, Hashtable hashtable) {
            Element element;
            CoverPage.this.out.println("</dl>\n");
            Element element2 = (Element)CoverPage.this.proc.getNode(node.getOwnerDocument(), "/spec/header/status/p/loc[@role='errata']", node.getOwnerDocument());
            if (element2 != null) {
                CoverPage.this.out.print("<p class='errata'>Please refer to the <a href='");
                CoverPage.this.out.print(element2.getAttribute("href") + "'>errata</a>");
                CoverPage.this.out.print(" for this document, which may include some normative corrections.</p>");
            }
            if ((element = (Element)CoverPage.this.proc.getNode(node, "../altlocs", node)) != null) {
                CoverPage.this.inAltLocs = true;
                CoverPage.this.dispatcher.process(element, CoverPage.this.out);
                CoverPage.this.inAltLocs = false;
            }
            if ((element2 = (Element)CoverPage.this.proc.getNode(node.getOwnerDocument(), "/spec/header/status/p/loc[@role='translation']", node.getOwnerDocument())) != null) {
                CoverPage.this.out.print("<p class='translation'>See also <a href='");
                CoverPage.this.out.print(element2.getAttribute("href") + "'>translations</a>");
                CoverPage.this.out.print(" of this document.</p>");
            }
            CoverPage.this.out.print("<p class='copyright'><a href='http://www.w3.org/Consortium/Legal/ipr-notice#Copyright'> Copyright</a> &copy;" + Util.getPubYear(node) + " <a href='http://www.w3.org/'><abbr title='World Wide Web Consortium'>W3C</abbr></a><sup>&reg;</sup> (<a " + "href='http://www.lcs.mit.edu/'><abbr title='Massachusetts Institute of Technology'>MIT</abbr></a>, <a " + "href='http://www.ercim.org/'><abbr title='European Research Consortium for Informatics and Mathematics" + "'>ERCIM</abbr></a>, <a href='http://www.keio.ac.jp/'>Keio</a>), All Rights Reserved. W3C <a " + "href='http://www.w3.org/Consortium/Legal/ipr-notice#Legal_Disclaimer'>liability</a>, <a " + "href='http://www.w3.org/Consortium/Legal/ipr-notice#W3C_Trademarks'>trademark</a>, <a " + "href='http://www.w3.org/Consortium/Legal/copyright-documents'>document use</a> and <a " + "href='http://www.w3.org/Consortium/Legal/copyright-software'>software licensing</a> rules apply.</p>\n");
        }
    }

    class affiliationMember
    extends DOMNodeHandlerBase {
        affiliationMember() {
        }

        public String getMatchPattern() {
            return "member/affiliation";
        }

        public String suffix() {
            return ",";
        }
    }

    class affiliationAuthor
    extends DOMNodeHandlerBase {
        affiliationAuthor() {
        }

        public String getMatchPattern() {
            return "author/affiliation";
        }

        public String prefix() {
            return "<i>";
        }

        public String suffix() {
            return "</i>";
        }
    }

    class authorGeneral
    extends DOMNodeHandlerBase {
        authorGeneral() {
        }

        public String getMatchPattern() {
            return "author";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            if (!CoverPage.this.proc.match(node, "*[preceding-sibling::*]", node)) {
                CoverPage.this.out.print("<dt>Principal Contributors\n</dt>");
            }
            return true;
        }

        public String prefix() {
            return "<dd>";
        }

        public String suffix() {
            return "</dd>\n";
        }
    }

    class author
    extends DOMNodeHandlerBase {
        author() {
        }

        public String getMatchPattern() {
            return "author[@role='author']";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            if (!CoverPage.this.proc.match(node, "*[preceding-sibling::*[@role='author']]", node)) {
                CoverPage.this.out.print("<dt>Principal Contributors\n</dt>");
            }
            return true;
        }

        public String prefix() {
            return "<dd>";
        }

        public String suffix() {
            return "</dd>\n";
        }
    }

    class editor
    extends DOMNodeHandlerBase {
        editor() {
        }

        public String getMatchPattern() {
            return "author[@role='editor']";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            if (!CoverPage.this.proc.match(node, "*[preceding-sibling::*[@role='editor']]", node)) {
                NodeList nodeList = CoverPage.this.proc.selectNodes(node, "../*[@role='editor']", node);
                if (nodeList.getLength() > 1) {
                    CoverPage.this.out.print("<dt>Editors:\n</dt>");
                } else {
                    CoverPage.this.out.print("<dt>Editor:\n</dt>");
                }
            }
            return true;
        }

        public String prefix() {
            return "<dd>";
        }

        public String suffix() {
            return "</dd>\n";
        }
    }

    class chair
    extends DOMNodeHandlerBase {
        chair() {
        }

        public String getMatchPattern() {
            return "author[@role='chair']";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            if (!CoverPage.this.proc.match(node, "*[preceding-sibling::*[@role='chair']]", node)) {
                CoverPage.this.out.print("<dt>Chair:\n</dt>");
            }
            return true;
        }

        public String prefix() {
            return "<dd>";
        }

        public String suffix() {
            return "</dd>\n";
        }
    }

    class Abstract
    extends DOMNodeHandlerBase {
        Abstract() {
        }

        public String getMatchPattern() {
            return "abstract";
        }

        public String prefix() {
            return "</div>\n<hr title='separator from header'>\n<h2 id='abstract'>Abstract</h2>\n<div class='abstract'>\n";
        }

        public String suffix() {
            return "</div>\n";
        }
    }
}

