/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.specgenerator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tools.markup.dom.DOMDispatcher;
import org.w3c.tools.markup.dom.DOMDispatcherImpl;
import org.w3c.tools.markup.dom.DOMNodeHandler;
import org.w3c.tools.markup.dom.DOMNodeHandlerBase;
import org.w3c.tools.markup.xpath.XPathFactory;
import org.w3c.tools.markup.xpath.XPathProcessor;
import org.w3c.tools.specgenerator.ECMA;
import org.w3c.tools.specgenerator.IDL;
import org.w3c.tools.specgenerator.Java;
import org.w3c.tools.specgenerator.NodeLink;
import org.w3c.tools.specgenerator.SpecDTD;
import org.w3c.tools.specgenerator.Util;

public class Body {
    XPathProcessor proc = XPathFactory.getDefaultProcessor();
    String destDir;
    PrintWriter out;
    HashSet linkedtypes = new HashSet();
    DOMDispatcher dispatcher;

    public Body() {
    }

    public Body(String string) {
        this.destDir = string;
    }

    public void generateToDirectory(Document document, String string) throws IOException {
        System.out.println("Generating body...");
        this.destDir = string;
        String string2 = Util.getAllText(document, "/spec/header/w3c-designation");
        string2 = string2.trim();
        NodeList nodeList = this.proc.selectNodes(document, "/spec/body/div1", document);
        DOMDispatcherImpl dOMDispatcherImpl = new DOMDispatcherImpl();
        DOMNodeHandler[] dOMNodeHandlerArray = this.getHandlers(this.out, dOMDispatcherImpl);
        int n = 0;
        while (n < dOMNodeHandlerArray.length) {
            dOMDispatcherImpl.addHandler(dOMNodeHandlerArray[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n2);
            String string3 = SpecDTD.getSuitableFileName(element);
            System.out.println(" Generating " + string3 + "...");
            String string4 = Util.getAllText(element, "head");
            NodeLink nodeLink = Util.getRelatedItem(string3, "previous");
            NodeLink nodeLink2 = Util.getRelatedItem(string3, "next");
            string3 = string3 + ".html";
            this.out = new PrintWriter(new FileWriter(string + System.getProperty("file.separator") + string3));
            Util.generateHtmlHead(document, this.out, string4, string2, Util.getPubDate(document), nodeLink, nodeLink2, Util.objectIndex, Util.index);
            dOMDispatcherImpl.process(element, this.out);
            Util.generateHtmlTail(document, this.out, nodeLink, nodeLink2, Util.objectIndex, Util.index);
            this.out.flush();
            this.out.close();
            ++n2;
        }
    }

    public DOMNodeHandler[] getHandlers(PrintWriter printWriter, DOMDispatcher dOMDispatcher) {
        this.out = printWriter;
        this.dispatcher = dOMDispatcher;
        return new DOMNodeHandler[]{new AffAuthor(), new AffMember(), new definitions(), new attribute(), new authlistChair(), new authlistEditor(), new authlistAuthor(), new authlist(), new body(), new sourceCode(), new code(), new typename(), new constantGroup(), new constant(), new gItemdef(), new descr1(), new descr2(), new descr3(), new descr4(), new div1(), new div2(), new div3(), new div4(), new egCode(), new eg(), new emphRole(), new emph(), new i(), new b(), new sub(), new sup(), new u(), new enumerator(), new enum(), new ExceptionDefinition(), new glist(), new graphic(), new group(), new headDiv1(), new headDiv2(), new headDiv3(), new headDiv4(), new table(), new _interface(), new issue(), new resolution(), new item(), new label(), new loc(), new member(), new method(), new nameAuthor(), new nameMember(), new noteEditorial(), new noteComment(), new ednote(), new noteReminder(), new note(), new notice(), new orglist(), new pQuote(), new pDiff(), new pItem(), new pDef(), new pNote(), new pNotice(), new pIssue(), new pResolution(), new pInterface(), new pException(), new pReturn(), new pExceptionInterface(), new pConstant(), new pAttribute(), new pMethod(), new pParam(), new pOlist(), new pUlist(), new pDefinitions(), new pImportant(), new pTable(), new pDiv1(), new p(), new phraseDiff(), new parameters(), new param(), new quote(), new titleref(), new raises(), new setraises(), new getraises(), new returns(), new roleMember(), new specref(), new xspecref(), new status(), new th(), new td(), new term(), new xtermdef(), new termref(), new termdef(), new tr(), new typedef(), new olist(), new ulist(), new TextHandler(), new piIDL(), new piJava(), new piECMA(), new piExpandedToc(), new piMiniToc(), new piObjectIndex(), new piDefinitionIndex(), new blist(), new bibl(), new bibref()};
    }

    class bibref
    extends DOMNodeHandlerBase {
        bibref() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            String string = ((Element)node).getAttribute("ref");
            String string2 = ((Element)node).getAttribute("role");
            NodeLink nodeLink = Util.getBibref(string);
            String string3 = "normative";
            if ("normative".equals(string2)) {
                string3 = "normative";
            } else if ("informative".equals(string2)) {
                string3 = "informative";
            }
            if (nodeLink != null) {
                Body.this.out.print("[<a class='noxref " + string3 + "' href='" + nodeLink.getLink() + "'>" + nodeLink.getKey() + "</a>]");
            } else {
                System.err.println("[ERROR] unknown bibref " + string + " -> removed!");
            }
            return true;
        }
    }

    class bibl
    extends DOMNodeHandlerBase {
        String hasDiff = null;

        bibl() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            if (element.hasAttribute("diff")) {
                this.hasDiff = element.getAttribute("diff");
            }
            String string = element.getAttribute("key");
            Element element2 = null;
            if (node.getPreviousSibling() != null && node.getPreviousSibling().getNodeType() == 1) {
                element2 = (Element)node.getPreviousSibling();
            }
            if (element2 == null || !element2.getAttribute("key").equals(string)) {
                Body.this.out.print("<dt><b>[<a name='" + element.getAttribute("id") + "'>");
                if (this.hasDiff != null) {
                    Body.this.out.print("<span class='diff-" + this.hasDiff + "'>");
                }
                Body.this.out.print(string);
                if (this.hasDiff != null) {
                    Body.this.out.print("</span>");
                }
                Body.this.out.print("</a>]</b></dt>");
            }
            if (this.hasDiff != null) {
                Body.this.out.print("<dd><div class='diff-" + this.hasDiff + "'>");
            } else {
                Body.this.out.print("<dd>");
            }
            return true;
        }

        public String suffix() {
            if (this.hasDiff != null) {
                this.hasDiff = null;
                return "</div></dd>";
            }
            return "</dd>\n";
        }
    }

    class blist
    extends DOMNodeHandlerBase {
        blist() {
        }

        public String prefix() {
            return "<dl>";
        }

        public String suffix() {
            return "</dl>";
        }
    }

    class piDefinitionIndex
    extends DOMNodeHandlerBase {
        piDefinitionIndex() {
        }

        public String getMatchPattern() {
            return "processing-instruction('GENERATE-DEFINITION-INDEX')";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            SpecDTD.generateDefinitionIndex(node, Body.this.out);
            return false;
        }
    }

    class piObjectIndex
    extends DOMNodeHandlerBase {
        piObjectIndex() {
        }

        public String getMatchPattern() {
            return "processing-instruction('GENERATE-OBJECT-INDEX')";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            SpecDTD.generateObjectIndex(node, Body.this.out);
            return false;
        }
    }

    class piMiniToc
    extends DOMNodeHandlerBase {
        piMiniToc() {
        }

        public String getMatchPattern() {
            return "processing-instruction('GENERATE-MINI-TOC')";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node.getParentNode();
            Element element2 = (Element)element.getParentNode();
            String string = element.getAttribute("role");
            int n = Util.getElementPosition(node.getParentNode());
            String string2 = element2.getNodeName().equals("back") && !"index".equals(string) && !"note".equals(string) && !"references".equals(string) && !"glossary".equals(string) && !"acknowledgments".equals(string) && !"object-index".equals(string) ? "" + "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(n - 1) : "" + n;
            SpecDTD.generateMiniToc(node.getParentNode(), Body.this.out, string2);
            return false;
        }
    }

    class piExpandedToc
    extends DOMNodeHandlerBase {
        piExpandedToc() {
        }

        public String getMatchPattern() {
            return "processing-instruction('GENERATE-EXPANDED-TOC')";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            if ("NOCHAPTERS".equals(node.getNodeValue().trim())) {
                SpecDTD.generateExpandedToc(node, Body.this.out, false);
            } else {
                SpecDTD.generateExpandedToc(node, Body.this.out, true);
            }
            return false;
        }
    }

    class piECMA
    extends DOMNodeHandlerBase {
        ECMA ecma = new ECMA();

        piECMA() {
        }

        public String getMatchPattern() {
            return "processing-instruction('GENERATE-ECMA')";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            String string;
            String string2 = node.getNodeValue().trim();
            int n = string2.indexOf(32);
            if (n == -1) {
                string = string2;
                string2 = "";
            } else {
                string = string2.substring(0, n);
                string2 = string2.substring(n + 1).trim();
            }
            Element element = node.getOwnerDocument().getElementById(string);
            if (element == null) {
                System.err.println("[ERROR] " + string + " not found");
            } else {
                Body.this.out.println("<div class='ecma-block'>\n");
                Body.this.out.println("<dl>\n");
                NodeList nodeList = Body.this.proc.selectNodes(element, ".//definitions/*", element);
                int n2 = 0;
                while (n2 < nodeList.getLength()) {
                    this.ecma.generateAt(nodeList.item(n2), Body.this.out);
                    ++n2;
                }
                Body.this.out.println("\n</dl>");
                Body.this.out.println("\n</div> <!-- ecma-block -->");
            }
            return false;
        }
    }

    class piJava
    extends DOMNodeHandlerBase {
        Java java = new Java();

        piJava() {
        }

        public String getMatchPattern() {
            return "processing-instruction('GENERATE-JAVA')";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            String string;
            String string2 = node.getNodeValue().trim();
            int n = string2.indexOf(32);
            if (n == -1) {
                string = string2;
                string2 = "";
            } else {
                string = string2.substring(0, n);
                string2 = string2.substring(n + 1).trim();
            }
            Element element = node.getOwnerDocument().getElementById(string);
            if (element == null) {
                System.err.println("[ERROR] " + string + " not found");
            } else {
                this.java.generateJavaSourceFile(element, Body.this.out, string2, Body.this.destDir);
            }
            return false;
        }
    }

    class piIDL
    extends DOMNodeHandlerBase {
        IDL idl = new IDL();

        piIDL() {
        }

        public String getMatchPattern() {
            return "processing-instruction('GENERATE-IDL')";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            String string;
            String string2 = node.getNodeValue().trim();
            int n = string2.indexOf(32);
            if (n == -1) {
                string = string2;
                string2 = "";
            } else {
                string = string2.substring(0, n);
                string2 = string2.substring(n + 1).trim();
            }
            Element element = node.getOwnerDocument().getElementById(string);
            if (element == null) {
                System.err.println("[ERROR] " + string + " not found");
            } else {
                this.idl.generateIDLModule(element, Body.this.out, string2, Body.this.destDir);
            }
            return false;
        }
    }

    class TextHandler
    extends DOMNodeHandlerBase {
        TextHandler() {
        }

        public String getMatchPattern() {
            return "text()";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Body.this.out.print(Util.getEscapedContent((CharacterData)node));
            return false;
        }
    }

    class olist
    extends DOMNodeHandlerBase {
        olist() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            if (element.hasAttribute("diff")) {
                Body.this.out.println("<ol class='diff-" + element.getAttribute("diff") + "'>");
            } else {
                Body.this.out.println("<ol>");
            }
            return true;
        }

        public String suffix() {
            return "</ol>\n";
        }
    }

    class ulist
    extends DOMNodeHandlerBase {
        ulist() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            if (element.hasAttribute("diff")) {
                Body.this.out.println("<ul class='diff-" + element.getAttribute("diff") + "'>");
            } else {
                Body.this.out.println("<ul>");
            }
            return true;
        }

        public String suffix() {
            return "</ul>\n";
        }
    }

    class typedef
    extends DOMNodeHandlerBase {
        typedef() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            Body.this.out.print("<dt><b>Type Definition <i>");
            Body.this.out.print("<a name='" + element.getAttribute("id") + "'>");
            Body.this.out.print(element.getAttribute("name") + "</a></i></b></dt>");
            Body.this.out.println("<dd>");
            return true;
        }

        public String suffix() {
            return "</dd>";
        }
    }

    class tr
    extends DOMNodeHandlerBase {
        tr() {
        }

        public String prefix() {
            return "<tr>\n";
        }

        public String suffix() {
            return "</tr>\n";
        }
    }

    class termdef
    extends DOMNodeHandlerBase {
        termdef() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Body.this.out.print("<a name='" + ((Element)node).getAttribute("id") + "'></a>");
            return true;
        }
    }

    class termref
    extends DOMNodeHandlerBase {
        NodeLink savedurl;

        termref() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            String string = element.getAttribute("def");
            this.savedurl = Util.getTermDef(string);
            if (this.savedurl != null) {
                if (node.getPreviousSibling() == null || "termdef".equals(node.getNodeName()) && string.equals(((Element)node.getPreviousSibling()).getAttribute("def"))) {
                    Body.this.out.print("<a class='noxref' href='" + this.savedurl.getLink() + "'>");
                } else {
                    Body.this.out.print("<a href='" + this.savedurl.getLink() + "'>");
                }
            } else {
                System.err.println("[ERROR] unknown term " + string + "!");
            }
            if (element.hasAttribute("glossary")) {
                Body.this.out.print("<em>");
            }
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            if (((Element)node).hasAttribute("glossary")) {
                Body.this.out.print("</em>");
            }
            if (this.savedurl != null) {
                Body.this.out.print("</a>");
            }
        }
    }

    class xtermdef
    extends DOMNodeHandlerBase {
        xtermdef() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Body.this.out.print("<a href='" + ((Element)node).getAttribute("href") + "'>");
            return true;
        }

        public String prefix() {
            return "<i>";
        }

        public String suffix() {
            return "</i></a>";
        }
    }

    class term
    extends DOMNodeHandlerBase {
        term() {
        }

        public String prefix() {
            return "<i>";
        }

        public String suffix() {
            return "</i>";
        }
    }

    class td
    extends DOMNodeHandlerBase {
        td() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            boolean bl = false;
            Element element = (Element)node;
            Body.this.out.print("<td");
            if (!Body.this.proc.match(node.getParentNode(), "*[preceding-sibling::tr]", node)) {
                Body.this.out.print(" bgcolor='#cfcfcf'");
                bl = true;
            }
            if (element.hasAttribute("valign")) {
                Body.this.out.print(" valign='" + element.getAttribute("valign") + "'");
            } else if (!bl) {
                Body.this.out.print(" valign='top'");
            }
            if (element.hasAttribute("align")) {
                Body.this.out.print(" align='" + element.getAttribute("align") + "'");
            }
            if (element.hasAttribute("rowspan")) {
                Body.this.out.print(" rowspan='" + element.getAttribute("rowspan") + "'");
            }
            if (element.hasAttribute("colspan")) {
                Body.this.out.print(" colspan='" + element.getAttribute("colspan") + "'");
            }
            if (bl) {
                Body.this.out.print("><b>");
            } else {
                Body.this.out.println('>');
            }
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            if (!Body.this.proc.match(node.getParentNode(), "*[preceding-sibling::tr]", node)) {
                Body.this.out.print("</b></td>");
            } else {
                Body.this.out.print("</td>");
            }
        }
    }

    class th
    extends DOMNodeHandlerBase {
        th() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            Body.this.out.print("<th");
            if (element.hasAttribute("valign")) {
                Body.this.out.print(" valign='" + element.getAttribute("valign") + "'");
            }
            if (element.hasAttribute("align")) {
                Body.this.out.print(" align='" + element.getAttribute("align") + "'");
            }
            if (element.hasAttribute("rowspan")) {
                Body.this.out.print(" rowspan='" + element.getAttribute("rowspan") + "'");
            }
            if (element.hasAttribute("colspan")) {
                Body.this.out.print(" colspan='" + element.getAttribute("colspan") + "'");
            }
            Body.this.out.println('>');
            return true;
        }

        public String suffix() {
            return "</th>";
        }
    }

    class status
    extends DOMNodeHandlerBase {
        status() {
        }

        public String prefix() {
            return "<h2 id='status'>Status</h2>\n<div class='status'>\n";
        }

        public String suffix() {
            return "</div>\n";
        }
    }

    class xspecref
    extends DOMNodeHandlerBase {
        xspecref() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            String string = element.getAttribute("href");
            String string2 = element.getAttribute("role");
            String string3 = "normative";
            if ("normative".equals(string2)) {
                string3 = "normative";
            } else if ("informative".equals(string2)) {
                string3 = "informative";
            } else if (!"".equals(string2)) {
                System.err.println("[ERROR] unknow role " + string2 + " on xspecref");
            }
            Body.this.out.print("<a class='" + string3 + "' href='" + string + "'>");
            return true;
        }

        public String prefix() {
            return "<em>";
        }

        public String suffix() {
            return "</em></a>";
        }
    }

    class specref
    extends DOMNodeHandlerBase {
        specref() {
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public boolean startNode(Node var1_1, Hashtable var2_2) {
            block3: {
                var3_3 = "";
                var4_4 = (Element)var1_1;
                var5_5 = var4_4.getAttribute("ref");
                var6_6 = var4_4.getOwnerDocument().getElementById(var5_5);
                if (var6_6 == null) {
                    System.err.println("No element with id " + var5_5);
                    return false;
                }
                var7_7 = 6;
                var8_8 = Body.this.proc.getNode(var6_6, "ancestor-or-self::div1", var6_6);
                var9_9 /* !! */  = null;
                var10_10 = SpecDTD.getSuitableFileName((Element)var8_8);
                if (var10_10 != null) {
                    var10_10 = var10_10 + ".html";
                }
                if (var6_6.getNodeName() == null || !var6_6.getNodeName().startsWith("div") || var6_6.getNodeName().length() != 4) ** GOTO lbl19
                var9_9 /* !! */  = var6_6;
                break block3;
lbl-1000:
                // 1 sources

                {
                    var9_9 /* !! */  = Body.this.proc.getNode(var6_6, "ancestor-or-self::div" + var7_7, var6_6);
                    --var7_7;
lbl19:
                    // 2 sources

                    ** while (var9_9 /* !! */  == null && var7_7 != 1)
                }
            }
            var3_3 = var9_9 /* !! */  != null ? SpecDTD.getTitleContent(var9_9 /* !! */ , "head") : SpecDTD.getTitleContent(var8_8, "head");
            var3_3 = var3_3.trim();
            Body.this.out.print("<a href='" + var10_10 + "#" + var5_5 + "'>" + var3_3 + "</a>");
            return false;
        }
    }

    class roleMember
    extends DOMNodeHandlerBase {
        roleMember() {
        }

        public String getMatchPattern() {
            return "member/role";
        }

        public String prefix() {
            return ", <i>";
        }

        public String suffix() {
            return "</i>";
        }
    }

    class returns
    extends DOMNodeHandlerBase {
        returns() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            String string = element.getAttribute("type");
            if (!"void".equals(string)) {
                Body.this.out.println("\n<div class='return'>");
                Body.this.out.println("<b>Return Value</b>");
                Body.this.out.println("<div class='returntable'>");
                Body.this.out.print("<table  summary='Layout table: the first cell contains\n the type of the return value, the second contains a short description'\n border='0'><tr><td valign='top'><p>");
                NodeLink nodeLink = Util.getURL(string);
                Body.this.linkedtypes.add(string);
                if (nodeLink != null) {
                    Body.this.out.print("<a href='" + nodeLink.getLink() + "'>");
                }
                Body.this.out.print("<code>" + string + "</code>");
                if (nodeLink != null) {
                    Body.this.out.print("</a>");
                }
                Body.this.out.println("</p></td><td>");
            }
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            if (!"void".equals(((Element)node).getAttribute("type"))) {
                Body.this.linkedtypes.clear();
                Body.this.out.println("</td></tr></table>\n</div></div> <!-- return -->");
            }
        }
    }

    class getraises
    extends DOMNodeHandlerBase {
        int size;

        getraises() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            this.size = Body.this.proc.selectNodes(node, "exception", node).getLength();
            if (this.size > 0) {
                Body.this.out.println("\n<div class='exceptions'>");
                Body.this.out.println("<b>Exceptions on retrieval</b>");
                Body.this.out.println("<div class='exceptiontable'>");
                Body.this.out.println("<table  summary='Layout table: the first cell contains\n the type of the exception, the second contains\nthe specific error code and a short description'\nborder='0'>");
            }
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            if (this.size > 0) {
                Body.this.out.println("</table>");
                Body.this.out.println("</div></div> <!-- exceptions -->");
            }
        }
    }

    class setraises
    extends DOMNodeHandlerBase {
        int size;

        setraises() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            this.size = Body.this.proc.selectNodes(node, "exception", node).getLength();
            if (this.size > 0) {
                Body.this.out.println("\n<div class='exceptions'>");
                Body.this.out.println("<b>Exceptions on setting</b>");
                Body.this.out.println("<div class='exceptiontable'>");
                Body.this.out.println("<table  summary='Layout table: the first cell contains\n the type of the exception, the second contains\nthe specific error code and a short description'\nborder='0'>");
            }
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            if (this.size > 0) {
                Body.this.out.println("</table>");
                Body.this.out.println("</div></div> <!-- exceptions -->");
            }
        }
    }

    class raises
    extends DOMNodeHandlerBase {
        int size;

        raises() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            this.size = Body.this.proc.selectNodes(node, "exception", node).getLength();
            if (this.size > 0) {
                Body.this.out.println("\n<div class='exceptions'>");
                Body.this.out.println("<b>Exceptions</b>");
                Body.this.out.println("<div class='exceptiontable'>");
                Body.this.out.println("<table  summary='Layout table: the first cell contains\n the type of the exception, the second contains\nthe specific error code and a short description'\nborder='0'>");
            }
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            if (this.size > 0) {
                Body.this.out.println("</table>");
                Body.this.out.println("</div></div> <!-- exceptions -->");
            }
        }
    }

    class titleref
    extends DOMNodeHandlerBase {
        boolean hasHref = false;

        titleref() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node.getParentNode();
            String string = element.getAttribute("href");
            if (!"".equals(string)) {
                this.hasHref = true;
                Body.this.out.print("<cite><a href='");
                Body.this.out.print(string);
                Body.this.out.print("'>");
            } else {
                Body.this.out.println("<cite>");
            }
            return true;
        }

        public String suffix() {
            if (this.hasHref) {
                this.hasHref = false;
                return "</a></cite>";
            }
            return "</cite>";
        }
    }

    class quote
    extends DOMNodeHandlerBase {
        quote() {
        }

        public String prefix() {
            return "<cite>\"";
        }

        public String suffix() {
            return "\"</cite>";
        }
    }

    class param
    extends DOMNodeHandlerBase {
        param() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            String string;
            Element element = (Element)node;
            Body.this.out.print("<dt>");
            String string2 = element.getAttribute("type");
            NodeLink nodeLink = Util.getURL(string2);
            if (Body.this.linkedtypes.contains(string2)) {
                string = " class='noxref'";
            } else {
                string = "";
                Body.this.linkedtypes.add(string2);
            }
            Body.this.out.println("<code class='parameter-name'>" + element.getAttribute("name") + "</code> of type ");
            if (nodeLink != null) {
                Body.this.out.print("<a" + string + " href='" + nodeLink.getLink() + "'>");
            }
            Body.this.out.print("<code>" + string2 + "</code>");
            if (nodeLink != null) {
                Body.this.out.print("</a>");
            }
            Body.this.out.println("</dt><dd>");
            return true;
        }

        public String suffix() {
            return "</dd>\n";
        }
    }

    class parameters
    extends DOMNodeHandlerBase {
        parameters() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Body.this.linkedtypes.clear();
            if (Body.this.proc.match(node, "*[child::param]", node)) {
                Body.this.out.println("<div class='parameters'>");
                Body.this.out.println("<b>Parameters</b>");
                Body.this.out.println("<div class='paramtable'>");
                Body.this.out.println("<dl>");
            }
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            if (Body.this.proc.match(node, "*[child::param]", node)) {
                Body.this.out.println("</dl>");
                Body.this.out.println("</div></div> <!-- parameters -->");
            }
        }
    }

    class phraseDiff
    extends DOMNodeHandlerBase {
        phraseDiff() {
        }

        public String getMatchPattern() {
            return "phrase[@diff]";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Body.this.out.print("<span class='diff-" + ((Element)node).getAttribute("diff") + "'>");
            return true;
        }

        public String suffix() {
            return "</span>";
        }
    }

    class p
    extends DOMNodeHandlerBase {
        p() {
        }

        public String prefix() {
            return "<p>";
        }
    }

    class pDiv1
    extends DOMNodeHandlerBase {
        pDiv1() {
        }

        public String getMatchPattern() {
            return "div1/p";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            if (Body.this.proc.match(node, "*[preceding-sibling::p]", node)) {
                Body.this.out.print("<p>");
            } else {
                Body.this.out.print("<p class='first'>");
            }
            return true;
        }

        public String suffix() {
            return "</p>";
        }
    }

    class pImportant
    extends DOMNodeHandlerBase {
        pImportant() {
        }

        public String getMatchPattern() {
            return "p[@role='important']";
        }

        public String prefix() {
            return "<p><b>";
        }

        public String suffix() {
            return "</b></p>";
        }
    }

    class pDefinitions
    extends DOMNodeHandlerBase {
        pDefinitions() {
        }

        public String getMatchPattern() {
            return "p[preceding-sibling::definitions]";
        }

        public String prefix() {
            return "<p>";
        }

        public String suffix() {
            return "</p>";
        }
    }

    class pUlist
    extends DOMNodeHandlerBase {
        pUlist() {
        }

        public String getMatchPattern() {
            return "p[descendant::ulist]";
        }

        public String prefix() {
            return "<p>";
        }
    }

    class pOlist
    extends DOMNodeHandlerBase {
        pOlist() {
        }

        public String getMatchPattern() {
            return "p[descendant::olist]";
        }

        public String prefix() {
            return "<p>";
        }
    }

    class pParam
    extends DOMNodeHandlerBase {
        pParam() {
        }

        public String getMatchPattern() {
            return "param/descr/p";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            if (Body.this.proc.match(node, "*[preceding-sibling::*]", node)) {
                Body.this.out.println("<br>");
            }
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            if (!Body.this.proc.match(node, "*[following-sibling::*]", node)) {
                Body.this.out.println("<br>");
            }
        }
    }

    class pMethod
    extends DOMNodeHandlerBase {
        pMethod() {
        }

        public String getMatchPattern() {
            return "method/descr/p";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            if (Body.this.proc.match(node, "*[preceding-sibling::*]", node)) {
                Body.this.out.println("<br>");
            }
            return true;
        }
    }

    class pAttribute
    extends DOMNodeHandlerBase {
        pAttribute() {
        }

        public String getMatchPattern() {
            return "attribute/descr/p";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            if (Body.this.proc.match(node, "*[preceding-sibling::*]", node)) {
                Body.this.out.println("<br>");
            }
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            if (!Body.this.proc.match(node, "*[following-sibling::*]", node)) {
                Body.this.out.println("<br>");
            }
        }
    }

    class pConstant
    extends DOMNodeHandlerBase {
        pConstant() {
        }

        public String getMatchPattern() {
            return "constant/descr/p";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            if (Body.this.proc.match(node, "*[preceding-sibling::*]", node)) {
                Body.this.out.println("<br>");
            }
            return true;
        }
    }

    class pExceptionInterface
    extends DOMNodeHandlerBase {
        pExceptionInterface() {
        }

        public String getMatchPattern() {
            return "interface//exception/descr/p";
        }

        public String prefix() {
            return "<p>";
        }
    }

    class pReturn
    extends DOMNodeHandlerBase {
        pReturn() {
        }

        public String getMatchPattern() {
            return "returns/descr/p";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            if (!((Element)node.getParentNode().getParentNode()).getAttribute("type").equals("void") && Body.this.proc.match(node, "*[preceding-sibling::*]", node)) {
                Body.this.out.println("<br>");
            } else {
                Body.this.out.println("<p>");
            }
            return true;
        }
    }

    class pException
    extends DOMNodeHandlerBase {
        pException() {
        }

        public String getMatchPattern() {
            return "definitions/exception/p";
        }

        public String prefix() {
            return "<dd>";
        }

        public String suffix() {
            return "</dd>";
        }
    }

    class pInterface
    extends DOMNodeHandlerBase {
        pInterface() {
        }

        public String getMatchPattern() {
            return "interface/p";
        }

        public String prefix() {
            return "<dd><p>";
        }

        public String suffix() {
            return "</dd>";
        }
    }

    class pIssue
    extends DOMNodeHandlerBase {
        pIssue() {
        }

        public String getMatchPattern() {
            return "issue/p";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            if (Body.this.proc.match(node, "*[preceding-sibling::*]", node)) {
                Body.this.out.println("<br>");
            }
            return true;
        }
    }

    class pNotice
    extends DOMNodeHandlerBase {
        pNotice() {
        }

        public String getMatchPattern() {
            return "notice/p";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            if (Body.this.proc.match(node, "*[preceding-sibling::*]", node)) {
                Body.this.out.println("<br>");
            }
            return true;
        }
    }

    class pNote
    extends DOMNodeHandlerBase {
        pNote() {
        }

        public String getMatchPattern() {
            return "note/p";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            if (Body.this.proc.match(node, "*[preceding-sibling::*]", node)) {
                Body.this.out.println("<br>");
            }
            return true;
        }
    }

    class pDef
    extends DOMNodeHandlerBase {
        pDef() {
        }

        public String getMatchPattern() {
            return "gitem/def/p";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            if (Body.this.proc.match(node, "*[preceding-sibling::p]", node) && !Body.this.proc.match(node, "*[preceding-sibling::p[@role='important']]", node)) {
                Body.this.out.println("<br>");
            }
            return true;
        }
    }

    class pResolution
    extends DOMNodeHandlerBase {
        pResolution() {
        }

        public String getMatchPattern() {
            return "resolution/p";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            if (Body.this.proc.match(node, "*[preceding-sibling::*]", node)) {
                Body.this.out.println("<br>");
            }
            return true;
        }
    }

    class pItem
    extends DOMNodeHandlerBase {
        pItem() {
        }

        public String getMatchPattern() {
            return "item/p";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            if (Body.this.proc.match(node, "*[preceding-sibling::*]", node)) {
                Body.this.out.println("<br>");
            }
            return true;
        }
    }

    class pDiff
    extends DOMNodeHandlerBase {
        pDiff() {
        }

        public String getMatchPattern() {
            return "p[@diff]";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Body.this.out.print("<p class='diff-" + ((Element)node).getAttribute("diff") + "'>");
            return true;
        }

        public String suffix() {
            return "</p>";
        }
    }

    class pQuote
    extends DOMNodeHandlerBase {
        pQuote() {
        }

        public String getMatchPattern() {
            return "p[@role='quote']";
        }

        public String prefix() {
            return "<blockquote>";
        }

        public String suffix() {
            return "</blockquote>";
        }
    }

    class pTable
    extends DOMNodeHandlerBase {
        pTable() {
        }

        public String getMatchPattern() {
            return "p[following-sibling::table]";
        }

        public String prefix() {
            return "<p>";
        }

        public String suffix() {
            return "</p>";
        }
    }

    class orglist
    extends DOMNodeHandlerBase {
        orglist() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Body.this.out.println("<dl>");
            Element element = (Element)node;
            if (element.hasAttribute("role")) {
                String string = element.getAttribute("role");
                if ("editors".equals(string)) {
                    NodeList nodeList = Body.this.proc.selectNodes(node, "./member", node);
                    if (nodeList.getLength() > 1) {
                        Body.this.out.print("<dt><i>Editors</i>:\n</dt>");
                    } else {
                        Body.this.out.print("<dt><i>Editor</i>:\n</dt>");
                    }
                } else {
                    string = string.substring(0, 1).toUpperCase() + string.substring(1);
                    Body.this.out.println("<dt><i>" + string + "</i></dt>");
                }
            }
            return true;
        }

        public String suffix() {
            return "</dl>\n";
        }
    }

    class notice
    extends DOMNodeHandlerBase {
        notice() {
        }

        public String prefix() {
            return "<div style='text-align:center'><i><b>Note: </b></i>";
        }

        public String suffix() {
            return "</div>\n";
        }
    }

    class note
    extends DOMNodeHandlerBase {
        note() {
        }

        public String prefix() {
            return "<p><b>Note:</b> ";
        }

        public void endNode(Node node, Hashtable hashtable) {
            if (!node.getLastChild().getNodeName().equals("eg")) {
                Body.this.out.println("</p>");
            }
        }
    }

    class noteReminder
    extends DOMNodeHandlerBase {
        noteReminder() {
        }

        public String getMatchPattern() {
            return "note[@role='reminder']";
        }

        public String prefix() {
            return "<div style='color: red'>(<i><b>ED: </b></i>";
        }

        public String suffix() {
            return ")</div>\n";
        }
    }

    class ednote
    extends DOMNodeHandlerBase {
        ednote() {
        }

        public String prefix() {
            return "<div style='color: red'>(<i><b>ED: </b></i>";
        }

        public String suffix() {
            return ")</div>\n";
        }
    }

    class noteComment
    extends DOMNodeHandlerBase {
        noteComment() {
        }

        public String getMatchPattern() {
            return "note[@role='comment']";
        }

        public String prefix() {
            return "<div style='color: green'>(<i><b>ED: </b></i>";
        }

        public String suffix() {
            return ")</div>\n";
        }
    }

    class noteEditorial
    extends DOMNodeHandlerBase {
        noteEditorial() {
        }

        public String getMatchPattern() {
            return "note[@role='editorial']";
        }

        public String prefix() {
            return "<div style='color: red'>(<i><b>ED: </b></i>";
        }

        public String suffix() {
            return ")</div>\n";
        }
    }

    class nameMember
    extends DOMNodeHandlerBase {
        String email;

        nameMember() {
        }

        public String getMatchPattern() {
            return "member/name";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            this.email = Util.getAllText(Body.this.proc.getNode(node.getParentNode(), "email/@href", node), null);
            if (!"".equals(this.email)) {
                Body.this.out.print("<a href='" + this.email + "'>");
            }
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            if (!"".equals(this.email)) {
                Body.this.out.print("</a>");
            }
            this.email = null;
        }
    }

    class nameAuthor
    extends DOMNodeHandlerBase {
        String email;

        nameAuthor() {
        }

        public String getMatchPattern() {
            return "author/name";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            this.email = Util.getAllText(Body.this.proc.getNode(node.getParentNode(), "email/@href", node), null);
            if (!"".equals(this.email)) {
                Body.this.out.print("<a href='" + this.email + "'>");
            }
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            if (!"".equals(this.email)) {
                Body.this.out.print("</a>");
            }
            this.email = null;
        }
    }

    class method
    extends DOMNodeHandlerBase {
        method() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            String string = element.getAttribute("role");
            String string2 = element.getAttribute("name");
            Body.this.out.print("\n<dt><code class='method-name'>");
            if (element.hasAttribute("id")) {
                Body.this.out.print("<a name='" + element.getAttribute("id") + "'>");
                Body.this.out.print(string2 + "</a></code>");
            } else {
                Body.this.out.print(string2 + "</a></code>");
                System.err.println("[ERROR] No id for " + string2);
            }
            boolean bl = element.hasAttribute("since");
            if (bl) {
                Body.this.out.print(" introduced in <b class='since'>" + element.getAttribute("since") + "</b>");
            }
            if (element.hasAttribute("version")) {
                if (bl) {
                    Body.this.out.println(",");
                }
                Body.this.out.print(" modified in <b class='version'>" + element.getAttribute("version") + "</b>");
            }
            if ("java-only".equals(string) || "ecmascript-only".equals(string)) {
                Body.this.out.print("<br />Depending on the language binding in use, this method may not be available.");
            }
            Body.this.out.println("</dt>");
            Body.this.out.println("<dd>");
            Body.this.out.println("<div class='method'>");
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            if (Body.this.proc.selectNodes(node, "parameters/param", node).getLength() == 0) {
                Body.this.out.println("<div><b>No Parameters</b></div>");
            }
            if ("void".equals(Body.this.proc.getNode(node, "returns/@type", node).getNodeValue())) {
                Body.this.out.println("<div><b>No Return Value</b></div>");
            }
            if (Body.this.proc.selectNodes(node, "raises/exception", node).getLength() == 0) {
                Body.this.out.println("<div><b>No Exceptions</b></div>");
            }
            Body.this.out.println("</div> <!-- method -->");
            Body.this.out.println("</dd>");
        }
    }

    class member
    extends DOMNodeHandlerBase {
        member() {
        }

        public String prefix() {
            return "<dd>";
        }

        public String suffix() {
            return "</dd>\n";
        }
    }

    class loc
    extends DOMNodeHandlerBase {
        loc() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            String string = element.getAttribute("href");
            String string2 = element.getAttribute("role");
            String string3 = "normative";
            if ("normative".equals(string2)) {
                string3 = "normative";
            } else if ("informative".equals(string2)) {
                string3 = "informative";
            } else if (!"".equals(string2)) {
                System.err.println("[ERROR] unknow role " + string2 + " on xspecref");
            }
            Body.this.out.print("<a class='" + string3 + "' href='" + string + "'>");
            return true;
        }

        public String suffix() {
            return "</a>";
        }
    }

    class label
    extends DOMNodeHandlerBase {
        boolean id;

        label() {
        }

        public String getMatchPattern() {
            return "gitem/label";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            Body.this.out.print("<dt>");
            if (element.hasAttribute("glossary")) {
                Body.this.out.print("<b>");
            }
            if (this.id = element.hasAttribute("id")) {
                Body.this.out.print("<a name='" + element.getAttribute("id") + "'>");
            }
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            if (this.id) {
                Body.this.out.print("</a>");
            }
            if (((Element)node).hasAttribute("glossary")) {
                Body.this.out.print("</b>");
            }
            Body.this.out.println("</dt>");
        }
    }

    class item
    extends DOMNodeHandlerBase {
        item() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            if (element.hasAttribute("diff")) {
                Body.this.out.println("<li class='diff-" + element.getAttribute("diff") + "'>");
            } else {
                Body.this.out.println("<li>");
            }
            return true;
        }

        public String suffix() {
            return "</li>\n";
        }
    }

    class resolution
    extends DOMNodeHandlerBase {
        resolution() {
        }

        public String prefix() {
            return "<br><b>Resolution:</b> ";
        }
    }

    class issue
    extends DOMNodeHandlerBase {
        issue() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            String string;
            Element element = (Element)node;
            String string2 = element.getAttribute("id");
            String string3 = null;
            if (element.hasAttribute("status")) {
                string3 = element.getAttribute("status");
            }
            if (!Util.isPreviousElement(node, "issue")) {
                Body.this.out.println("<dl>");
            }
            Body.this.out.print("<dt style=\"color: ");
            if (Body.this.proc.match(node, "*[descendant::resolution]", node) || "closed".equals(string3)) {
                if (string3 == null) {
                    System.err.println("[WARNING] suggest adding status='closed' for issue " + string2);
                }
                string = "green";
            } else {
                string = "red";
            }
            Body.this.out.println(string + "\"><a name=\"" + string2 + "\" id=\"" + string2 + "\"> Issue " + string2 + ":</a></dt>\n<dd>");
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            Body.this.out.println("</dd>");
            if (!Util.isNextElement(node, "issue")) {
                Body.this.out.println("</dl>");
            }
        }
    }

    class _interface
    extends DOMNodeHandlerBase {
        TreeMap methods = new TreeMap();
        TreeMap attributes = new TreeMap();

        _interface() {
        }

        public String getMatchPattern() {
            return "interface";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            String string;
            Iterator iterator;
            Element element = (Element)node;
            this.methods.clear();
            this.attributes.clear();
            Body.this.out.print("\n<dt><b>Interface <i>");
            Body.this.out.print("<a name='" + element.getAttribute("id") + "'>");
            Body.this.out.print(element.getAttribute("name") + "</a></i></b>");
            boolean bl = element.hasAttribute("since");
            if (bl) {
                Body.this.out.print(" (introduced in <b class='since'>" + element.getAttribute("since") + "</b>)");
            }
            if (element.hasAttribute("version")) {
                if (bl) {
                    Body.this.out.println(',');
                }
                Body.this.out.print(" (modified in <b class='version'>" + element.getAttribute("version") + "</b>)");
            }
            Body.this.out.println("</dt>");
            Body.this.out.println("<dd>");
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (node2.getNodeType() == 1) {
                    if (node2.getNodeName().equals("attribute")) {
                        this.attributes.put(((Element)node2).getAttribute("name"), node2);
                    } else if (node2.getNodeName().equals("method")) {
                        this.methods.put(((Element)node2).getAttribute("name"), node2);
                    } else {
                        Body.this.dispatcher.process(node2, Body.this.out);
                    }
                }
                node2 = node2.getNextSibling();
            }
            if (!this.attributes.isEmpty()) {
                Body.this.out.println("\n<dt><b>Attributes</b></dt>");
                Body.this.out.println("<dd><dl>");
                iterator = this.attributes.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    Body.this.dispatcher.process((Node)this.attributes.get(string), Body.this.out);
                }
                Body.this.out.println("</dl></dd>");
            }
            if (!this.methods.isEmpty()) {
                Body.this.out.println("\n<dt><b>Methods</b></dt>");
                Body.this.out.println("<dd><dl>");
                iterator = this.methods.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    Body.this.dispatcher.process((Node)this.methods.get(string), Body.this.out);
                }
                Body.this.out.println("</dl></dd>");
            }
            if (node.getParentNode().getNodeName().equals("definitions")) {
                Body.this.out.println("</dl></dd>");
            }
            return false;
        }
    }

    class table
    extends DOMNodeHandlerBase {
        table() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            if (element.hasAttribute("border")) {
                Body.this.out.print("<table border='" + element.getAttribute("border") + "'");
            } else {
                Body.this.out.print("<table border='1'");
            }
            if (element.hasAttribute("summary")) {
                Body.this.out.print(" summary='" + element.getAttribute("summary") + "'");
            } else {
                System.err.println("[ERROR] missing summary attribute in a table!");
            }
            if (element.hasAttribute("cellpadding")) {
                Body.this.out.println(" cellpadding='" + element.getAttribute("cellpadding") + "'");
            }
            if (element.hasAttribute("cellspacing")) {
                Body.this.out.println(" cellspacing='" + element.getAttribute("cellspacing") + "'>");
            } else {
                Body.this.out.println('>');
            }
            return true;
        }

        public String suffix() {
            return "</table>\n";
        }
    }

    class headDiv4
    extends DOMNodeHandlerBase {
        String[] table = new String[]{"div3", "div2", "div1"};

        headDiv4() {
        }

        public String getMatchPattern() {
            return "div4/head";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node.getParentNode();
            String string = Util.makeHierarchyIndicator(element, this.table, null);
            String string2 = element.hasAttribute("id") ? element.getAttribute("id") : "s-" + string;
            Body.this.out.println("<h4 id='" + string2 + "-h4' class='div4'>" + string + ' ');
            return true;
        }

        public String suffix() {
            return "</h4>";
        }
    }

    class headDiv3
    extends DOMNodeHandlerBase {
        String[] table = new String[]{"div2", "div1"};

        headDiv3() {
        }

        public String getMatchPattern() {
            return "div3/head";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node.getParentNode();
            String string = Util.makeHierarchyIndicator(element, this.table, null);
            String string2 = element.hasAttribute("id") ? element.getAttribute("id") : "s-" + string;
            Body.this.out.println("<h3 id='" + string2 + "-h3' class='div3'>" + string + ' ');
            return true;
        }

        public String suffix() {
            return "</h3>";
        }
    }

    class headDiv2
    extends DOMNodeHandlerBase {
        String[] table = new String[]{"div1"};

        headDiv2() {
        }

        public String getMatchPattern() {
            return "div2/head";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node.getParentNode();
            String string = Util.makeHierarchyIndicator(element, this.table, null);
            String string2 = element.hasAttribute("id") ? element.getAttribute("id") : "s-" + string;
            Body.this.out.println("<h2 id='" + string2 + "-h2' class='div2'>" + string + ' ');
            return true;
        }

        public String suffix() {
            return "</h2>";
        }
    }

    class headDiv1
    extends DOMNodeHandlerBase {
        headDiv1() {
        }

        public String getMatchPattern() {
            return "div1/head";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node.getParentNode();
            String string = Util.makeHierarchyIndicator(element, null, null);
            String string2 = element.hasAttribute("id") ? element.getAttribute("id") : "s-" + string;
            Body.this.out.println("<h1 id='" + string2 + "-h1' class='div1'>" + string + ". ");
            return true;
        }

        public String suffix() {
            return "</h1>";
        }
    }

    class group
    extends DOMNodeHandlerBase {
        TreeMap constants = new TreeMap();
        TreeMap attributes = new TreeMap();
        TreeMap methods = new TreeMap();

        group() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            String string;
            Iterator iterator;
            Element element = (Element)node;
            if (node.getParentNode().getNodeName().equals("definitions")) {
                this.constants.clear();
            }
            Body.this.out.println("<dt><b>Definition group <i><a name='" + element.getAttribute("id") + "'>" + element.getAttribute("name") + "</a></i></b></dt>");
            Body.this.out.print("<dd>");
            this.constants.clear();
            this.attributes.clear();
            this.methods.clear();
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (node2.getNodeType() == 1) {
                    if (node2.getNodeName().equals("attribute")) {
                        this.attributes.put(((Element)node2).getAttribute("name"), node2);
                    } else if (node2.getNodeName().equals("method")) {
                        this.methods.put(((Element)node2).getAttribute("name"), node2);
                    } else if (node2.getNodeName().equals("constant")) {
                        this.constants.put(((Element)node2).getAttribute("name"), node2);
                    } else {
                        Body.this.dispatcher.process(node2, Body.this.out);
                    }
                }
                node2 = node2.getNextSibling();
            }
            if (!this.constants.isEmpty()) {
                Body.this.out.println("<dl>");
                Body.this.out.println("<dt><b>Defined Constants</b></dt>");
                Body.this.out.println("<dd><dl>");
                iterator = this.constants.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    Body.this.dispatcher.process((Node)this.constants.get(string), Body.this.out);
                }
                Body.this.out.println("</dl>");
                Body.this.out.println("</dd></dl>");
            }
            Body.this.out.println("</dd>");
            if (node.getParentNode().getNodeName().equals("definitions")) {
                if (!this.attributes.isEmpty()) {
                    Body.this.out.println("\n<dt><b>Attributes</b></dt>");
                    Body.this.out.println("<dd><dl>");
                    iterator = this.attributes.keySet().iterator();
                    while (iterator.hasNext()) {
                        string = (String)iterator.next();
                        Body.this.dispatcher.process((Node)this.attributes.get(string), Body.this.out);
                    }
                    Body.this.out.println("</dl></dd>");
                }
                if (!this.methods.isEmpty()) {
                    Body.this.out.println("\n<dt><b>Methods</b></dt>");
                    Body.this.out.println("<dd><dl>");
                    iterator = this.methods.keySet().iterator();
                    while (iterator.hasNext()) {
                        string = (String)iterator.next();
                        Body.this.dispatcher.process((Node)this.methods.get(string), Body.this.out);
                    }
                    Body.this.out.println("</dl></dd>");
                }
            }
            if (Body.this.proc.match(node, "*[preceding-sibling::exception]", node)) {
                Body.this.out.println("</dl></dd>");
            }
            return false;
        }
    }

    class graphic
    extends DOMNodeHandlerBase {
        graphic() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            String string = element.getAttribute("alt");
            String string2 = element.getAttribute("source");
            Body.this.out.println("<div class='figure' style='text-align: center'>");
            if (element.hasAttribute("id")) {
                Body.this.out.println("<a name='" + element.getAttribute("id") + "'></a>");
            }
            Body.this.out.println("<img src='" + string2 + "' alt='" + string + "'>");
            Body.this.out.println("<p style='text-align:left'><i>Figure: " + string);
            String string3 = string2.substring(0, string2.length() - 4) + ".svg";
            Body.this.out.println("</i> [<a href='" + string3 + "'>SVG 1.0 version</a>]");
            Body.this.out.println("</p>\n</div>\n");
            return true;
        }
    }

    class glist
    extends DOMNodeHandlerBase {
        glist() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            if (element.hasAttribute("role")) {
                Body.this.out.println("<div class='" + element.getAttribute("role") + "'>");
            }
            Body.this.out.println("<dl>");
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            Body.this.out.println("</dl>");
            if (element.hasAttribute("role")) {
                Body.this.out.println("</div>");
            }
        }
    }

    class ExceptionDefinition
    extends DOMNodeHandlerBase {
        ExceptionDefinition() {
        }

        public String getMatchPattern() {
            return "definitions/exception";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            Body.this.out.print("<dt><b>Exception <i>");
            Body.this.out.print("<a name='" + element.getAttribute("id") + "'>");
            Body.this.out.print(element.getAttribute("name") + "</a></i></b>");
            boolean bl = element.hasAttribute("since");
            if (bl) {
                Body.this.out.print(" introduced in <b class='version'>" + element.getAttribute("since") + "</b>");
            }
            if (element.hasAttribute("version")) {
                if (bl) {
                    Body.this.out.println(',');
                }
                Body.this.out.print(" modified in <b class='version'>" + element.getAttribute("version") + "</b>");
            }
            Body.this.out.println("</dt>");
            Body.this.out.println("<dd>");
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            if (!Body.this.proc.match(node, "*[following-sibling::group]", node)) {
                Body.this.out.println("</dl></dd>");
            }
        }
    }

    class enum
    extends DOMNodeHandlerBase {
        enum() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            Body.this.out.print("<dl><dt><b>Enumeration <i>");
            Body.this.out.print("<a name='" + element.getAttribute("id") + "'>");
            Body.this.out.println(element.getAttribute("name") + "</a></i></b></dt><dd>");
            return true;
        }

        public String suffix() {
            return "</dd></dl>";
        }
    }

    class enumerator
    extends DOMNodeHandlerBase {
        enumerator() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            if (!Body.this.proc.match(node, "*[preceding-sibling::enumerator]", node)) {
                Body.this.out.println("<br>\n<table  width='80%' cellpadding=5 border=0>\n<tr><td bgcolor='#cfcfcf' colspan=2>\n<b>Enumerator Values</b></td></tr></table>\n<table width='80%' border='1' cellpadding='5'>\n");
            }
            Body.this.out.print("<tr><td width='30%'>" + ((Element)node).getAttribute("name") + "</td><td>");
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            Body.this.out.println("</td></tr>");
            if (!Body.this.proc.match(node, "*[following-sibling::enumerator]", node)) {
                Body.this.out.println("</table>");
            }
        }
    }

    class u
    extends DOMNodeHandlerBase {
        u() {
        }

        public String prefix() {
            return "<u>";
        }

        public String suffix() {
            return "</u>";
        }
    }

    class sup
    extends DOMNodeHandlerBase {
        sup() {
        }

        public String prefix() {
            return "<sup>";
        }

        public String suffix() {
            return "</sup>";
        }
    }

    class sub
    extends DOMNodeHandlerBase {
        sub() {
        }

        public String prefix() {
            return "<sub>";
        }

        public String suffix() {
            return "</sub>";
        }
    }

    class b
    extends DOMNodeHandlerBase {
        b() {
        }

        public String prefix() {
            return "<b>";
        }

        public String suffix() {
            return "</b>";
        }
    }

    class i
    extends DOMNodeHandlerBase {
        i() {
        }

        public String prefix() {
            return "<i>";
        }

        public String suffix() {
            return "</i>";
        }
    }

    class emph
    extends DOMNodeHandlerBase {
        emph() {
        }

        public String prefix() {
            return "<em>";
        }

        public String suffix() {
            return "</em>";
        }
    }

    class emphRole
    extends DOMNodeHandlerBase {
        emphRole() {
        }

        public String getMatchPattern() {
            return "emph[@role='important']";
        }

        public String prefix() {
            return "<b>";
        }

        public String suffix() {
            return "</b>";
        }
    }

    class eg
    extends DOMNodeHandlerBase {
        eg() {
        }

        public String prefix() {
            return "<div class='eg'>\n<pre>";
        }

        public String suffix() {
            return "</pre>\n</div>";
        }
    }

    class egCode
    extends DOMNodeHandlerBase {
        egCode() {
        }

        public String getMatchPattern() {
            return "eg[@role='code']";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            if (node.getPreviousSibling() == null || Body.this.proc.match(node.getPreviousSibling(), "div2/p", node)) {
                Body.this.out.println("</p>");
            }
            Body.this.out.print("<div class='code-block'>\n<pre>");
            return true;
        }

        public String suffix() {
            return "</pre>\n</div>";
        }
    }

    class div4
    extends DOMNodeHandlerBase {
        String[] table = new String[]{"div3", "div2", "div1"};
        String id;

        div4() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            this.id = element.getAttribute("id");
            if (!element.hasAttribute("id")) {
                this.id = "s-" + Util.makeHierarchyIndicator(node, this.table, null);
            }
            Body.this.out.println("\n<div class='div4'><a name='" + this.id + "'></a>");
            return true;
        }

        public String suffix() {
            return "</div> <!-- div4 " + this.id + " -->";
        }
    }

    class div3
    extends DOMNodeHandlerBase {
        String[] table = new String[]{"div2", "div1"};
        String id;

        div3() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            this.id = element.getAttribute("id");
            if (!element.hasAttribute("id")) {
                this.id = "s-" + Util.makeHierarchyIndicator(node, this.table, null);
            }
            Body.this.out.println("\n<div class='div3'><a name='" + this.id + "'></a>");
            return true;
        }

        public String suffix() {
            return "</div> <!-- div3 " + this.id + " -->";
        }
    }

    class div2
    extends DOMNodeHandlerBase {
        String[] table = new String[]{"div1"};
        String id;

        div2() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            this.id = element.getAttribute("id");
            if (!element.hasAttribute("id")) {
                this.id = "s-" + Util.makeHierarchyIndicator(node, this.table, null);
            }
            Body.this.out.println("\n<div class='div2'><a name='" + this.id + "'></a>");
            return true;
        }

        public String suffix() {
            return "</div> <!-- div2 " + this.id + " -->";
        }
    }

    class div1
    extends DOMNodeHandlerBase {
        String id;

        div1() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            this.id = element.getAttribute("id");
            if (!element.hasAttribute("id")) {
                this.id = "s-" + Util.makeHierarchyIndicator(node, null, null);
            }
            Body.this.out.println("\n<div class='div1'><a name='" + this.id + "'></a>");
            return true;
        }

        public String suffix() {
            return "</div> <!-- div1 " + this.id + " -->";
        }
    }

    class descr4
    extends DOMNodeHandlerBase {
        IDL idl = new IDL();

        descr4() {
        }

        public String getMatchPattern() {
            return "typedef/descr";
        }

        public void endNode(Node node, Hashtable hashtable) {
            if (!Body.this.proc.match(node, "*[ancestor::interface]", node)) {
                Body.this.out.println("\n<dl>");
                Body.this.out.println("<dt><br><b>IDL Definition</b></dt>");
                Body.this.out.println("<dd>");
                Body.this.out.print("<div class='idl-code'>\n<pre>");
                this.idl.generateAt(node.getParentNode(), Body.this.out);
                Body.this.out.println("</pre>\n</div><br>");
                Body.this.out.println("</dd></dl>");
            }
        }
    }

    class descr3
    extends DOMNodeHandlerBase {
        IDL idl = new IDL();

        descr3() {
        }

        public String getMatchPattern() {
            return "interface/descr";
        }

        public void endNode(Node node, Hashtable hashtable) {
            Body.this.out.println("\n<dl>");
            Body.this.out.println("<dt><br><b>IDL Definition</b></dt>");
            Body.this.out.println("<dd>");
            Body.this.out.print("<div class='idl-code'>\n<pre>");
            this.idl.generateAt(node.getParentNode(), Body.this.out);
            Body.this.out.println("</pre>\n</div><br>");
            Body.this.out.println("</dd>");
        }
    }

    class descr2
    extends DOMNodeHandlerBase {
        IDL idl = new IDL();

        descr2() {
        }

        public String getMatchPattern() {
            return "definitions/exception/descr";
        }

        public void endNode(Node node, Hashtable hashtable) {
            Body.this.out.println("\n<dl>");
            Body.this.out.println("<dt><br><b>IDL Definition</b></dt>");
            Body.this.out.println("<dd>");
            Body.this.out.print("<div class='idl-code'>\n<pre>");
            this.idl.generateAt(node.getParentNode(), Body.this.out);
            Body.this.out.println("</pre>\n</div><br>");
            Body.this.out.println("</dd>");
        }
    }

    class descr1
    extends DOMNodeHandlerBase {
        descr1() {
        }

        public String getMatchPattern() {
            return "interface//exception/descr";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            String string = ((Element)node.getParentNode()).getAttribute("name");
            NodeLink nodeLink = Util.getURL(string);
            Body.this.out.print("<tr><td valign='top'><p>");
            if (nodeLink != null) {
                Body.this.out.print("<a href='" + nodeLink.getLink() + "'>");
            }
            Body.this.out.print("<code>" + string + "</code>");
            if (nodeLink != null) {
                Body.this.out.print("</a>");
            }
            Body.this.out.println("</p></td><td>");
            return true;
        }

        public String suffix() {
            return "</td></tr>\n";
        }
    }

    class gItemdef
    extends DOMNodeHandlerBase {
        gItemdef() {
        }

        public String getMatchPattern() {
            return "gitem/def";
        }

        public String prefix() {
            return "<dd>";
        }

        public String suffix() {
            return "</dd>";
        }
    }

    class constant
    extends DOMNodeHandlerBase {
        constant() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            String string = element.getAttribute("id");
            if ("".equals(string)) {
                System.err.println("[ERROR] no id attribute for constant " + element.getAttribute("name"));
            }
            Body.this.out.print("<dt><b>Constant <i><a name='");
            Body.this.out.print(string);
            Body.this.out.print("'>");
            Body.this.out.print(element.getAttribute("name"));
            Body.this.out.println("</a></i></b></dt><dd>");
            return true;
        }

        public String suffix() {
            return "</dd>";
        }
    }

    class constantGroup
    extends DOMNodeHandlerBase {
        constantGroup() {
        }

        public String getMatchPattern() {
            return "group/constant";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            String string = element.getAttribute("name");
            String string2 = element.getAttribute("id");
            if ("".equals(string2)) {
                System.err.println("[ERROR] no id attribute for constant " + element.getAttribute("name"));
            }
            Body.this.out.print("<dt><a name='");
            Body.this.out.print(string2);
            Body.this.out.print("'><code class='constant-name'>");
            Body.this.out.print(string);
            Body.this.out.print("</code></a>");
            if (element.hasAttribute("since") || element.hasAttribute("version")) {
                if (element.hasAttribute("since")) {
                    Body.this.out.print(", introduced in <b class='version'>");
                    Body.this.out.print(element.getAttribute("since"));
                    Body.this.out.print("</b>.");
                }
                if (element.hasAttribute("version")) {
                    if (element.hasAttribute("since")) {
                        Body.this.out.print(" ");
                    }
                    Body.this.out.print(",\tmodified in <b class='version'>");
                    Body.this.out.print(element.getAttribute("version"));
                    Body.this.out.print("</b>.");
                }
            }
            Body.this.out.println("</dt><dd>");
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            Body.this.out.println("</dd>");
        }
    }

    class typename
    extends DOMNodeHandlerBase {
        typename() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            return false;
        }
    }

    class code
    extends DOMNodeHandlerBase {
        NodeLink savedurl;

        code() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            String string = null;
            Element element = (Element)Body.this.proc.getNode(node, "ancestor::interface", node);
            if (element != null) {
                string = element.getAttribute("name");
            }
            String string2 = Util.getAllText(node, null);
            this.savedurl = null;
            if (!string2.equals(string)) {
                int n;
                this.savedurl = Util.getURL(string2);
                if (this.savedurl == null && (n = string2.lastIndexOf(115)) != -1 && n == string2.length() - 1 && !(string2 = string2.substring(0, n)).equals(string)) {
                    this.savedurl = Util.getURL(string2);
                }
                if (this.savedurl == null && (n = string2.indexOf(")")) != -1 && n == string2.length() - 1 && (n = string2.indexOf("(")) != -1 && !(string2 = string2.substring(0, n)).equals(string)) {
                    this.savedurl = Util.getURL(string2);
                }
                n = 0;
                if (this.savedurl != null) {
                    if ((Body.this.proc.match(node, "*[ancestor::parameters]", node) || Body.this.proc.match(node, "*[ancestor::returns]", node)) && Body.this.linkedtypes.contains(string2)) {
                        n = 1;
                    } else {
                        NodeList nodeList = Body.this.proc.selectNodes(node, "preceding-sibling::code", node);
                        int n2 = 0;
                        while (n2 < nodeList.getLength()) {
                            Node node2 = nodeList.item(n2);
                            String string3 = Util.getAllText(node2, null);
                            if (string3.equals(string2)) {
                                n = 1;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (n != 0) {
                        Body.this.out.print("<a class='noxref' href='");
                        Body.this.out.print(this.savedurl.getLink());
                        Body.this.out.print("'>");
                    } else {
                        Body.this.out.print("<a href='" + this.savedurl.getLink() + "'>");
                    }
                }
            }
            Body.this.out.print("<code>");
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            Body.this.out.print("</code>");
            if (this.savedurl != null) {
                Body.this.out.print("</a>");
            }
        }
    }

    class TextHandlerSourceCode
    extends DOMNodeHandlerBase {
        PrintWriter out;

        TextHandlerSourceCode(PrintWriter printWriter) {
            this.out = printWriter;
        }

        public String getMatchPattern() {
            return "text()";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            this.out.print(((CharacterData)node).getData());
            return false;
        }
    }

    class sourceCode
    extends DOMNodeHandlerBase {
        IDL idl = new IDL();

        sourceCode() {
        }

        public String getMatchPattern() {
            return "source-code[@type='text/java']";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            String string = ((Element)node).getAttribute("name");
            String string2 = ((Element)node).getAttribute("package");
            Body.this.out.println("<h3 id='" + string + "'>" + string2.replace('.', '/') + '/' + string + ".java:</h3>");
            Body.this.out.print("<div class='java-code'>\n<pre>");
            this.generateToFile(node, string2.replace('.', File.separatorChar), string);
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            Body.this.out.println("</pre>\n</div>");
        }

        public void generateToFile(Node node, String string, String string2) {
            PrintWriter printWriter;
            String string3 = Body.this.destDir + File.separatorChar + ".." + File.separatorChar + "java" + File.separatorChar + string;
            if (!Util.createDirectory(string3)) {
                System.err.println("[ERROR] Directory " + string3 + " not created.");
                return;
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string3 + File.separatorChar + string2 + ".java"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
            printWriter.println(Util.getW3CCopyright(node));
            Node node2 = node.getFirstChild();
            DOMDispatcherImpl dOMDispatcherImpl = new DOMDispatcherImpl();
            dOMDispatcherImpl.addHandler(new TextHandlerSourceCode(printWriter));
            while (node2 != null) {
                dOMDispatcherImpl.process(node2, Body.this.out);
                node2 = node2.getNextSibling();
            }
            printWriter.flush();
            printWriter.close();
        }
    }

    class body
    extends DOMNodeHandlerBase {
        body() {
        }

        public String prefix() {
            return "<br><hr>";
        }
    }

    class authlist
    extends DOMNodeHandlerBase {
        authlist() {
        }

        public String prefix() {
            return "<dl>";
        }

        public String suffix() {
            return "</dl>";
        }
    }

    class authlistAuthor
    extends DOMNodeHandlerBase {
        authlistAuthor() {
        }

        public String getMatchPattern() {
            return "authlist[@role='author']";
        }

        public String prefix() {
            return "<dt>Principal Contributors</dt>\n";
        }

        public String suffix() {
            return "</dl>\n";
        }
    }

    class authlistEditor
    extends DOMNodeHandlerBase {
        authlistEditor() {
        }

        public String getMatchPattern() {
            return "authlist[@role='editor']";
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            NodeList nodeList = Body.this.proc.selectNodes(node, "./*[@role='editor']", node);
            if (nodeList.getLength() > 1) {
                Body.this.out.print("<dt>Editors:\n</dt>");
            } else {
                Body.this.out.print("<dt>Editor:\n</dt>");
            }
            return true;
        }
    }

    class authlistChair
    extends DOMNodeHandlerBase {
        authlistChair() {
        }

        public String getMatchPattern() {
            return "authlist[@role='chair']";
        }

        public String prefix() {
            return "<dt>WG Chair</dt>\n";
        }
    }

    class attribute
    extends DOMNodeHandlerBase {
        attribute() {
        }

        public boolean startNode(Node node, Hashtable hashtable) {
            Element element = (Element)node;
            String string = element.getAttribute("role");
            String string2 = element.getAttribute("name");
            Body.this.out.print("\n<dt><code class='attribute-name'>");
            if (element.hasAttribute("id")) {
                Body.this.out.print("<a name='");
                Body.this.out.print(element.getAttribute("id"));
                Body.this.out.print("'>");
                Body.this.out.print(string2);
                Body.this.out.print("</a></code> of type ");
            } else {
                Body.this.out.print(string2);
                Body.this.out.print("</code> of type ");
                System.err.print("[ERROR] No id for ");
                System.err.print(string2);
                System.err.print("in descendant of id ");
                System.err.println(Util.getAllText(element, "ancestor[@id]/@id"));
            }
            String string3 = element.getAttribute("type");
            NodeLink nodeLink = Util.getURL(string3);
            if (nodeLink != null) {
                Body.this.out.print("<a href='" + nodeLink.getLink() + "'>");
            }
            Body.this.out.print("<code>" + string3 + "</code>");
            if (nodeLink != null) {
                Body.this.out.print("</a>");
            }
            if ("yes".equals(element.getAttribute("readonly"))) {
                Body.this.out.print(", readonly");
            }
            if (element.hasAttribute("since")) {
                Body.this.out.print(", introduced in <b class='version'>");
                Body.this.out.print(element.getAttribute("since"));
                Body.this.out.print("</b>");
            }
            if (element.hasAttribute("version")) {
                Body.this.out.print(", modified in <b class='version'>");
                Body.this.out.print(element.getAttribute("version"));
                Body.this.out.print("</b>");
            }
            if ("java-only".equals(string) || "ecmascript-only".equals(string)) {
                Body.this.out.print("<br />Depending on the language binding in use, this attribute may not be available.");
            }
            Body.this.out.println("</dt>");
            Body.this.out.print("<dd>");
            return true;
        }

        public void endNode(Node node, Hashtable hashtable) {
            Body.this.out.print("\n</dd>");
        }
    }

    class definitions
    extends DOMNodeHandlerBase {
        definitions() {
        }

        public String prefix() {
            return "\n<dl>";
        }

        public String suffix() {
            return "</dl>\n";
        }
    }

    class AffMember
    extends DOMNodeHandlerBase {
        AffMember() {
        }

        public String getMatchPattern() {
            return "member/affiliation";
        }

        public String prefix() {
            return ", ";
        }
    }

    class AffAuthor
    extends DOMNodeHandlerBase {
        AffAuthor() {
        }

        public String getMatchPattern() {
            return "author/affiliation";
        }

        public String prefix() {
            return ", <i>";
        }

        public String suffix() {
            return "</i><br>";
        }
    }
}

