/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.markup.dom;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMUtil {
    public static Element getChild(Element element, String string) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeName().equals(string) && node.getNodeType() == 1) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static Element getChild(Element element, String string, String string2) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (string2.equals(node.getLocalName()) && (string == null && node.getNamespaceURI() == null || string != null && string.equals(node.getNamespaceURI()))) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static String getContent(StringBuffer stringBuffer, Node node) {
        DOMUtil.getContent(stringBuffer, node, true);
        return stringBuffer.toString();
    }

    protected static void getContent(StringBuffer stringBuffer, Node node, boolean bl) {
        if (node != null) {
            switch (node.getNodeType()) {
                case 1: 
                case 5: 
                case 6: 
                case 9: 
                case 11: {
                    Node node2 = node.getFirstChild();
                    while (node2 != null) {
                        DOMUtil.getContent(stringBuffer, node2, false);
                        node2 = node2.getNextSibling();
                    }
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    stringBuffer.append(node.getNodeValue());
                    break;
                }
                case 7: 
                case 8: {
                    if (!bl) break;
                    stringBuffer.append(node.getNodeValue());
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown DOM node type: " + node.getNodeType());
                }
                case 10: 
            }
        }
    }

    public static String getContent(Node node) {
        return DOMUtil.getContent(new StringBuffer(), node);
    }

    public static String lookupNamespaceURI(Element element, String string) {
        return DOMUtil.lookupXmlnsAttr(element, "xmlns:" + string);
    }

    protected static String lookupXmlnsAttr(Element element, String string) {
        while (element != null) {
            if (element.hasAttribute(string)) {
                return element.getAttribute(string);
            }
            Node node = element.getParentNode();
            element = node != null && node.getNodeType() == 1 ? (Element)node : null;
        }
        return null;
    }

    public static boolean removeChild(Element element, String string) {
        Element element2 = DOMUtil.getChild(element, string);
        if (element2 != null) {
            element2.getParentNode().removeChild(element2);
            return true;
        }
        return false;
    }

    public static boolean removeChild(Element element, String string, String string2) {
        Element element2 = DOMUtil.getChild(element, string, string2);
        if (element2 != null) {
            element2.getParentNode().removeChild(element2);
            return true;
        }
        return false;
    }

    public static boolean removeChildren(Element element, String string) {
        boolean bl = false;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeName().equals(string) && node.getNodeType() == 1) {
                node.getParentNode().removeChild(node);
                bl = true;
            }
            node = node.getNextSibling();
        }
        return bl;
    }

    public static boolean removeChildren(Element element, String string, String string2) {
        boolean bl = false;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeName().equals(string2) && (string == null && node.getNamespaceURI() == null || string != null && string.equals(node.getNamespaceURI()))) {
                node.getParentNode().removeChild(node);
                bl = true;
            }
            node = node.getNextSibling();
        }
        return bl;
    }

    public static boolean removeChildren(Node node) {
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return false;
        }
        do {
            node.removeChild(node2);
        } while ((node2 = node2.getNextSibling()) != null);
        return true;
    }

    public static void setContent(Node node, String string) {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                DOMUtil.removeChildren(node);
                Text text = node.getOwnerDocument().createTextNode(string);
                node.appendChild(text);
                return;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                node.setNodeValue(string);
                return;
            }
        }
        throw new RuntimeException("Unknown DOM node type: " + node.getNodeType());
    }
}

