/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.AVT;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.transformer.CountersTable;
import org.apache.xalan.transformer.DecimalToRoman;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.NodeVector;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.StringBufferPool;
import org.apache.xml.utils.res.XResourceBundle;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.xml.sax.SAXException;

public class ElemNumber
extends ElemTemplateElement {
    private XPath m_countMatchPattern = null;
    private XPath m_fromMatchPattern = null;
    private int m_level = 1;
    private XPath m_valueExpr = null;
    private AVT m_format_avt = null;
    private AVT m_lang_avt = null;
    private AVT m_lettervalue_avt = null;
    private AVT m_groupingSeparator_avt = null;
    private AVT m_groupingSize_avt = null;
    private static final DecimalToRoman[] m_romanConvertTable = new DecimalToRoman[]{new DecimalToRoman(1000L, "M", 900L, "CM"), new DecimalToRoman(500L, "D", 400L, "CD"), new DecimalToRoman(100L, "C", 90L, "XC"), new DecimalToRoman(50L, "L", 40L, "XL"), new DecimalToRoman(10L, "X", 9L, "IX"), new DecimalToRoman(5L, "V", 4L, "IV"), new DecimalToRoman(1L, "I", 1L, "I")};
    private static char[] m_alphaCountTable = null;

    public ElemTemplateElement appendChild(ElemTemplateElement elemTemplateElement) {
        this.error(4, new Object[]{elemTemplateElement.getNodeName(), this.getNodeName()});
        return null;
    }

    public void compose(StylesheetRoot stylesheetRoot) throws TransformerException {
        super.compose(stylesheetRoot);
        StylesheetRoot.ComposeState composeState = stylesheetRoot.getComposeState();
        Vector vector = composeState.getVariableNames();
        if (this.m_countMatchPattern != null) {
            this.m_countMatchPattern.fixupVariables(vector, composeState.getGlobalsSize());
        }
        if (this.m_format_avt != null) {
            this.m_format_avt.fixupVariables(vector, composeState.getGlobalsSize());
        }
        if (this.m_fromMatchPattern != null) {
            this.m_fromMatchPattern.fixupVariables(vector, composeState.getGlobalsSize());
        }
        if (this.m_groupingSeparator_avt != null) {
            this.m_groupingSeparator_avt.fixupVariables(vector, composeState.getGlobalsSize());
        }
        if (this.m_groupingSize_avt != null) {
            this.m_groupingSize_avt.fixupVariables(vector, composeState.getGlobalsSize());
        }
        if (this.m_lang_avt != null) {
            this.m_lang_avt.fixupVariables(vector, composeState.getGlobalsSize());
        }
        if (this.m_lettervalue_avt != null) {
            this.m_lettervalue_avt.fixupVariables(vector, composeState.getGlobalsSize());
        }
        if (this.m_valueExpr != null) {
            this.m_valueExpr.fixupVariables(vector, composeState.getGlobalsSize());
        }
    }

    public void execute(TransformerImpl transformerImpl) throws TransformerException {
        if (TransformerImpl.S_DEBUG) {
            transformerImpl.getTraceManager().fireTraceEvent(this);
        }
        int n = transformerImpl.getXPathContext().getCurrentNode();
        String string = this.getCountString(transformerImpl, n);
        try {
            transformerImpl.getResultTreeHandler().characters(string.toCharArray(), 0, string.length());
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    int findAncestor(XPathContext xPathContext, XPath xPath, XPath xPath2, int n, ElemNumber elemNumber) throws TransformerException {
        DTM dTM = xPathContext.getDTM(n);
        while (n != -1) {
            if (xPath != null && xPath.getMatchScore(xPathContext, n) != Double.NEGATIVE_INFINITY || xPath2 != null && xPath2.getMatchScore(xPathContext, n) != Double.NEGATIVE_INFINITY) break;
            n = dTM.getParent(n);
        }
        return n;
    }

    private int findPrecedingOrAncestorOrSelf(XPathContext xPathContext, XPath xPath, XPath xPath2, int n, ElemNumber elemNumber) throws TransformerException {
        DTM dTM = xPathContext.getDTM(n);
        while (n != -1) {
            if (xPath != null && xPath.getMatchScore(xPathContext, n) != Double.NEGATIVE_INFINITY) {
                n = -1;
                break;
            }
            if (xPath2 != null && xPath2.getMatchScore(xPathContext, n) != Double.NEGATIVE_INFINITY) break;
            int n2 = dTM.getPreviousSibling(n);
            if (n2 == -1) {
                n = dTM.getParent(n);
                continue;
            }
            n = dTM.getLastChild(n2);
            if (n != -1) continue;
            n = n2;
        }
        return n;
    }

    String formatNumberList(TransformerImpl transformerImpl, int[] nArray, int n) throws TransformerException {
        String string;
        FastStringBuffer fastStringBuffer = StringBufferPool.get();
        try {
            String string2;
            String string3;
            int n2 = nArray.length;
            int n3 = 1;
            char c = '1';
            String string4 = null;
            String string5 = null;
            String string6 = ".";
            boolean bl = true;
            String string7 = string3 = this.m_format_avt != null ? this.m_format_avt.evaluate(transformerImpl.getXPathContext(), n, this) : null;
            if (string3 == null) {
                string3 = "1";
            }
            NumberFormatStringTokenizer numberFormatStringTokenizer = new NumberFormatStringTokenizer(string3);
            int n4 = 0;
            while (n4 < n2) {
                if (numberFormatStringTokenizer.hasMoreTokens()) {
                    string2 = numberFormatStringTokenizer.nextToken();
                    if (Character.isLetterOrDigit(string2.charAt(string2.length() - 1))) {
                        n3 = string2.length();
                        c = string2.charAt(n3 - 1);
                    } else if (numberFormatStringTokenizer.isLetterOrDigitAhead()) {
                        string5 = string2;
                        while (numberFormatStringTokenizer.nextIsSep()) {
                            string2 = numberFormatStringTokenizer.nextToken();
                            string5 = String.valueOf(string5) + string2;
                        }
                        if (!bl) {
                            string6 = string5;
                        }
                        string2 = numberFormatStringTokenizer.nextToken();
                        n3 = string2.length();
                        c = string2.charAt(n3 - 1);
                    } else {
                        string4 = string2;
                        while (numberFormatStringTokenizer.hasMoreTokens()) {
                            string2 = numberFormatStringTokenizer.nextToken();
                            string4 = String.valueOf(string4) + string2;
                        }
                    }
                }
                if (string5 != null && bl) {
                    fastStringBuffer.append(string5);
                } else if (string6 != null && !bl) {
                    fastStringBuffer.append(string6);
                }
                this.getFormattedNumber(transformerImpl, n, c, n3, nArray[n4], fastStringBuffer);
                bl = false;
                ++n4;
            }
            while (numberFormatStringTokenizer.isLetterOrDigitAhead()) {
                numberFormatStringTokenizer.nextToken();
            }
            if (string4 != null) {
                fastStringBuffer.append(string4);
            }
            while (numberFormatStringTokenizer.hasMoreTokens()) {
                string2 = numberFormatStringTokenizer.nextToken();
                fastStringBuffer.append(string2);
            }
            string = fastStringBuffer.toString();
        }
        finally {
            Object var7_17 = null;
            StringBufferPool.free((FastStringBuffer)fastStringBuffer);
        }
        return string;
    }

    public XPath getCount() {
        return this.m_countMatchPattern;
    }

    XPath getCountMatchPattern(XPathContext xPathContext, int n) throws TransformerException {
        XPath xPath = this.m_countMatchPattern;
        DTM dTM = xPathContext.getDTM(n);
        if (xPath == null) {
            switch (dTM.getNodeType(n)) {
                case 1: {
                    xPath = new XPath(dTM.getNodeName(n), (SourceLocator)this, (PrefixResolver)this, 1, xPathContext.getErrorListener());
                    break;
                }
                case 2: {
                    xPath = new XPath("@" + dTM.getNodeName(n), (SourceLocator)this, (PrefixResolver)this, 1, xPathContext.getErrorListener());
                    break;
                }
                case 3: 
                case 4: {
                    xPath = new XPath("text()", (SourceLocator)this, (PrefixResolver)this, 1, xPathContext.getErrorListener());
                    break;
                }
                case 8: {
                    xPath = new XPath("comment()", (SourceLocator)this, (PrefixResolver)this, 1, xPathContext.getErrorListener());
                    break;
                }
                case 9: {
                    xPath = new XPath("/", (SourceLocator)this, (PrefixResolver)this, 1, xPathContext.getErrorListener());
                    break;
                }
                case 7: {
                    xPath = new XPath("pi(" + dTM.getNodeName(n) + ")", (SourceLocator)this, (PrefixResolver)this, 1, xPathContext.getErrorListener());
                    break;
                }
                default: {
                    xPath = null;
                }
            }
        }
        return xPath;
    }

    String getCountString(TransformerImpl transformerImpl, int n) throws TransformerException {
        int[] nArray = null;
        XPathContext xPathContext = transformerImpl.getXPathContext();
        CountersTable countersTable = transformerImpl.getCountersTable();
        if (this.m_valueExpr != null) {
            XObject xObject = this.m_valueExpr.execute(xPathContext, n, (PrefixResolver)this);
            int n2 = (int)Math.floor(xObject.num() + 0.5);
            nArray = new int[]{n2};
        } else if (this.m_level == 3) {
            nArray = new int[]{countersTable.countNode(xPathContext, this, n)};
        } else {
            NodeVector nodeVector = this.getMatchingAncestors(xPathContext, n, this.m_level == 1);
            int n3 = nodeVector.size() - 1;
            if (n3 >= 0) {
                nArray = new int[n3 + 1];
                int n4 = n3;
                while (n4 >= 0) {
                    int n5 = nodeVector.elementAt(n4);
                    nArray[n3 - n4] = countersTable.countNode(xPathContext, this, n5);
                    --n4;
                }
            }
        }
        return nArray != null ? this.formatNumberList(transformerImpl, nArray, n) : "";
    }

    public AVT getFormat() {
        return this.m_format_avt;
    }

    private void getFormattedNumber(TransformerImpl transformerImpl, int n, char c, int n2, int n3, FastStringBuffer fastStringBuffer) throws TransformerException {
        DecimalFormat decimalFormat = this.getNumberFormatter(transformerImpl, n);
        String string = decimalFormat.format(0L);
        String string2 = this.m_lettervalue_avt != null ? this.m_lettervalue_avt.evaluate(transformerImpl.getXPathContext(), n, this) : null;
        switch (c) {
            case 'A': {
                if (m_alphaCountTable == null) {
                    XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle((String)"org.apache.xml.utils.res.XResources", (Locale)this.getLocale(transformerImpl, n));
                    char[] cArray = (char[])xResourceBundle.getObject("alphabet");
                    m_alphaCountTable = cArray;
                }
                this.int2alphaCount(n3, m_alphaCountTable, fastStringBuffer);
                break;
            }
            case 'a': {
                FastStringBuffer fastStringBuffer2;
                if (m_alphaCountTable == null) {
                    fastStringBuffer2 = XResourceBundle.loadResourceBundle((String)"org.apache.xml.utils.res.XResources", (Locale)this.getLocale(transformerImpl, n));
                    char[] cArray = (char[])fastStringBuffer2.getObject("alphabet");
                    m_alphaCountTable = cArray;
                }
                fastStringBuffer2 = StringBufferPool.get();
                try {
                    this.int2alphaCount(n3, m_alphaCountTable, fastStringBuffer2);
                    fastStringBuffer.append(fastStringBuffer2.toString().toLowerCase(this.getLocale(transformerImpl, n)));
                    break;
                }
                finally {
                    Object var12_27 = null;
                    StringBufferPool.free((FastStringBuffer)fastStringBuffer2);
                }
            }
            case 'I': {
                fastStringBuffer.append(this.long2roman(n3, true));
                break;
            }
            case 'i': {
                fastStringBuffer.append(this.long2roman(n3, true).toLowerCase(this.getLocale(transformerImpl, n)));
                break;
            }
            case '\u3042': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle((String)"org.apache.xml.utils.res.XResources", (Locale)new Locale("ja", "JP", "HA"));
                if (string2 != null && string2.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(n3, xResourceBundle));
                    break;
                }
                fastStringBuffer.append(this.int2singlealphaCount(n3, (char[])xResourceBundle.getObject("alphabet")));
                break;
            }
            case '\u3044': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle((String)"org.apache.xml.utils.res.XResources", (Locale)new Locale("ja", "JP", "HI"));
                if (string2 != null && string2.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(n3, xResourceBundle));
                    break;
                }
                fastStringBuffer.append(this.int2singlealphaCount(n3, (char[])xResourceBundle.getObject("alphabet")));
                break;
            }
            case '\u30a2': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle((String)"org.apache.xml.utils.res.XResources", (Locale)new Locale("ja", "JP", "A"));
                if (string2 != null && string2.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(n3, xResourceBundle));
                    break;
                }
                fastStringBuffer.append(this.int2singlealphaCount(n3, (char[])xResourceBundle.getObject("alphabet")));
                break;
            }
            case '\u30a4': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle((String)"org.apache.xml.utils.res.XResources", (Locale)new Locale("ja", "JP", "I"));
                if (string2 != null && string2.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(n3, xResourceBundle));
                    break;
                }
                fastStringBuffer.append(this.int2singlealphaCount(n3, (char[])xResourceBundle.getObject("alphabet")));
                break;
            }
            case '\u4e00': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle((String)"org.apache.xml.utils.res.XResources", (Locale)new Locale("zh", "CN"));
                if (string2 != null && string2.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(n3, xResourceBundle));
                    break;
                }
                this.int2alphaCount(n3, (char[])xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u58f9': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle((String)"org.apache.xml.utils.res.XResources", (Locale)new Locale("zh", "TW"));
                if (string2 != null && string2.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(n3, xResourceBundle));
                    break;
                }
                this.int2alphaCount(n3, (char[])xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u0e51': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle((String)"org.apache.xml.utils.res.XResources", (Locale)new Locale("th", ""));
                if (string2 != null && string2.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(n3, xResourceBundle));
                    break;
                }
                this.int2alphaCount(n3, (char[])xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u05d0': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle((String)"org.apache.xml.utils.res.XResources", (Locale)new Locale("he", ""));
                if (string2 != null && string2.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(n3, xResourceBundle));
                    break;
                }
                this.int2alphaCount(n3, (char[])xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u10d0': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle((String)"org.apache.xml.utils.res.XResources", (Locale)new Locale("ka", ""));
                if (string2 != null && string2.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(n3, xResourceBundle));
                    break;
                }
                this.int2alphaCount(n3, (char[])xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u03b1': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle((String)"org.apache.xml.utils.res.XResources", (Locale)new Locale("el", ""));
                if (string2 != null && string2.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(n3, xResourceBundle));
                    break;
                }
                this.int2alphaCount(n3, (char[])xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u0430': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle((String)"org.apache.xml.utils.res.XResources", (Locale)new Locale("cy", ""));
                if (string2 != null && string2.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(n3, xResourceBundle));
                    break;
                }
                this.int2alphaCount(n3, (char[])xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            default: {
                String string3 = decimalFormat.format(n3);
                int n4 = n2 - string3.length();
                int n5 = 0;
                while (n5 < n4) {
                    fastStringBuffer.append(string);
                    ++n5;
                }
                fastStringBuffer.append(string3);
            }
        }
    }

    public XPath getFrom() {
        return this.m_fromMatchPattern;
    }

    public AVT getGroupingSeparator() {
        return this.m_groupingSeparator_avt;
    }

    public AVT getGroupingSize() {
        return this.m_groupingSize_avt;
    }

    public AVT getLang() {
        return this.m_lang_avt;
    }

    public AVT getLetterValue() {
        return this.m_lettervalue_avt;
    }

    public int getLevel() {
        return this.m_level;
    }

    Locale getLocale(TransformerImpl transformerImpl, int n) throws TransformerException {
        Locale locale = null;
        if (this.m_lang_avt != null) {
            XPathContext xPathContext = transformerImpl.getXPathContext();
            String string = this.m_lang_avt.evaluate(xPathContext, n, this);
            if (string != null && (locale = new Locale(string.toUpperCase(), "")) == null) {
                transformerImpl.getMsgMgr().warn(this, null, xPathContext.getDTM(n).getNode(n), 5, new Object[]{string});
                locale = Locale.getDefault();
            }
        } else {
            locale = Locale.getDefault();
        }
        return locale;
    }

    NodeVector getMatchingAncestors(XPathContext xPathContext, int n, boolean bl) throws TransformerException {
        NodeSetDTM nodeSetDTM = new NodeSetDTM(xPathContext.getDTMManager());
        XPath xPath = this.getCountMatchPattern(xPathContext, n);
        DTM dTM = xPathContext.getDTM(n);
        while (n != -1) {
            if (this.m_fromMatchPattern != null && this.m_fromMatchPattern.getMatchScore(xPathContext, n) != Double.NEGATIVE_INFINITY && !bl) break;
            if (xPath == null) {
                System.out.println("Programmers error! countMatchPattern should never be null!");
            }
            if (xPath.getMatchScore(xPathContext, n) != Double.NEGATIVE_INFINITY) {
                nodeSetDTM.addElement(n);
                if (bl) break;
            }
            n = dTM.getParent(n);
        }
        return nodeSetDTM;
    }

    public String getNodeName() {
        return "number";
    }

    private DecimalFormat getNumberFormatter(TransformerImpl transformerImpl, int n) throws TransformerException {
        DecimalFormat decimalFormat;
        block2: {
            String string;
            Locale locale = (Locale)this.getLocale(transformerImpl, n).clone();
            decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            String string2 = this.m_groupingSeparator_avt != null ? this.m_groupingSeparator_avt.evaluate(transformerImpl.getXPathContext(), n, this) : null;
            String string3 = string = this.m_groupingSize_avt != null ? this.m_groupingSize_avt.evaluate(transformerImpl.getXPathContext(), n, this) : null;
            if (string2 == null || string == null) break block2;
            try {
                decimalFormat.setGroupingSize(Integer.valueOf(string));
                decimalFormat.getDecimalFormatSymbols().setGroupingSeparator(string2.charAt(0));
                ((NumberFormat)decimalFormat).setGroupingUsed(true);
            }
            catch (NumberFormatException numberFormatException) {
                ((NumberFormat)decimalFormat).setGroupingUsed(false);
            }
        }
        return decimalFormat;
    }

    /*
     * Unable to fully structure code
     */
    public int getPreviousNode(XPathContext var1_1, int var2_2) throws TransformerException {
        block7: {
            var3_3 = this.getCountMatchPattern(var1_1, var2_2);
            var4_4 = var1_1.getDTM(var2_2);
            if (this.m_level != 3) ** GOTO lbl-1000
            var5_5 = this.m_fromMatchPattern;
            while (var2_2 != -1) {
                var6_6 = var4_4.getPreviousSibling(var2_2);
                if (var6_6 == -1) {
                    var6_6 = var4_4.getParent(var2_2);
                    if (var6_6 != -1 && (var5_5 != null && var5_5.getMatchScore(var1_1, var6_6) != -Infinity || var4_4.getNodeType(var6_6) == 9)) {
                        var2_2 = -1;
                        break block7;
                    }
                } else {
                    var7_7 = var6_6;
                    while (var7_7 != -1) {
                        var7_7 = var4_4.getLastChild(var6_6);
                        if (var7_7 == -1) continue;
                        var6_6 = var7_7;
                    }
                }
                if ((var2_2 = var6_6) == -1 || var3_3 != null && var3_3.getMatchScore(var1_1, var2_2) == -Infinity) {
                    continue;
                }
                break block7;
            }
            break block7;
            while ((var2_2 = var4_4.getPreviousSibling(var2_2)) == -1 || var3_3 != null && var3_3.getMatchScore(var1_1, var2_2) == -Infinity) lbl-1000:
            // 2 sources

            {
                if (var2_2 != -1) continue;
            }
        }
        return var2_2;
    }

    public int getTargetNode(XPathContext xPathContext, int n) throws TransformerException {
        int n2 = -1;
        XPath xPath = this.getCountMatchPattern(xPathContext, n);
        n2 = this.m_level == 3 ? this.findPrecedingOrAncestorOrSelf(xPathContext, this.m_fromMatchPattern, xPath, n, this) : this.findAncestor(xPathContext, this.m_fromMatchPattern, xPath, n, this);
        return n2;
    }

    public XPath getValue() {
        return this.m_valueExpr;
    }

    public int getXSLToken() {
        return 35;
    }

    String getZeroString() {
        return "0";
    }

    protected void int2alphaCount(int n, char[] cArray, FastStringBuffer fastStringBuffer) {
        int n2 = cArray.length;
        char[] cArray2 = new char[cArray.length];
        int n3 = 0;
        while (n3 < cArray.length - 1) {
            cArray2[n3 + 1] = cArray[n3];
            ++n3;
        }
        cArray2[0] = cArray[n3];
        char[] cArray3 = new char[100];
        int n4 = cArray3.length - 1;
        int n5 = 1;
        int n6 = 0;
        while ((n5 = (n + (n6 = n5 == 0 || n6 != 0 && n5 == n2 - 1 ? n2 - 1 : 0)) % n2) != 0 || (n /= n2) != 0) {
            cArray3[n4--] = cArray2[n5];
            if (n > 0) continue;
        }
        fastStringBuffer.append(cArray3, n4 + 1, cArray3.length - n4 - 1);
    }

    protected String int2singlealphaCount(int n, char[] cArray) {
        int n2 = cArray.length;
        if (n > n2) {
            return this.getZeroString();
        }
        return new Character(cArray[n - 1]).toString();
    }

    protected String long2roman(long l, boolean bl) {
        if (l <= 0L) {
            return this.getZeroString();
        }
        String string = "";
        int n = 0;
        if (l <= 3999L) {
            while (true) {
                if (l >= ElemNumber.m_romanConvertTable[n].m_postValue) {
                    string = String.valueOf(string) + ElemNumber.m_romanConvertTable[n].m_postLetter;
                    l -= ElemNumber.m_romanConvertTable[n].m_postValue;
                    continue;
                }
                if (bl && l >= ElemNumber.m_romanConvertTable[n].m_preValue) {
                    string = String.valueOf(string) + ElemNumber.m_romanConvertTable[n].m_preLetter;
                    l -= ElemNumber.m_romanConvertTable[n].m_preValue;
                }
                ++n;
                if (l <= 0L) break;
            }
        } else {
            string = "#error";
        }
        return string;
    }

    public void setCount(XPath xPath) {
        this.m_countMatchPattern = xPath;
    }

    public void setFormat(AVT aVT) {
        this.m_format_avt = aVT;
    }

    public void setFrom(XPath xPath) {
        this.m_fromMatchPattern = xPath;
    }

    public void setGroupingSeparator(AVT aVT) {
        this.m_groupingSeparator_avt = aVT;
    }

    public void setGroupingSize(AVT aVT) {
        this.m_groupingSize_avt = aVT;
    }

    public void setLang(AVT aVT) {
        this.m_lang_avt = aVT;
    }

    public void setLetterValue(AVT aVT) {
        this.m_lettervalue_avt = aVT;
    }

    public void setLevel(int n) {
        this.m_level = n;
    }

    public void setValue(XPath xPath) {
        this.m_valueExpr = xPath;
    }

    protected String tradAlphaCount(int n, XResourceBundle xResourceBundle) {
        int n2;
        char[] cArray;
        char[] cArray2 = null;
        int n3 = 1;
        char[] cArray3 = new char[100];
        int n4 = 0;
        int[] nArray = (int[])xResourceBundle.getObject("numberGroups");
        String[] stringArray = (String[])xResourceBundle.getObject("tables");
        String string = xResourceBundle.getString("numbering");
        if (string.equals("multiplicative-additive")) {
            String string2 = xResourceBundle.getString("multiplierOrder");
            int[] nArray2 = (int[])xResourceBundle.getObject("multiplier");
            cArray = (char[])xResourceBundle.getObject("zero");
            n2 = 0;
            while (n2 < nArray2.length && n < nArray2[n2]) {
                ++n2;
            }
            while (n2 < nArray2.length) {
                if (n < nArray2[n2]) {
                    if (cArray.length == 0) {
                        ++n2;
                    } else {
                        if (cArray3[n4 - 1] != cArray[0]) {
                            cArray3[n4++] = cArray[0];
                        }
                        ++n2;
                    }
                } else if (n >= nArray2[n2]) {
                    int n5 = n / nArray2[n2];
                    n %= nArray2[n2];
                    for (int j = 0; j < nArray.length; ++j) {
                        n3 = 1;
                        if (n5 / nArray[j] <= 0) {
                            continue;
                        }
                        char[] cArray4 = (char[])xResourceBundle.getObject(stringArray[j]);
                        cArray2 = new char[cArray4.length + 1];
                        int n6 = 0;
                        while (n6 < cArray4.length) {
                            cArray2[n6 + 1] = cArray4[n6];
                            ++n6;
                        }
                        cArray2[0] = cArray4[n6 - 1];
                        n3 = n5 / nArray[j];
                        if (n3 == 0 && n5 == 0) break;
                        char c = ((char[])xResourceBundle.getObject("multiplierChar"))[n2];
                        if (n3 < cArray2.length) {
                            if (string2.equals("precedes")) {
                                cArray3[n4++] = c;
                                cArray3[n4++] = cArray2[n3];
                                break;
                            }
                            if (n3 != 1 || n2 != nArray2.length - 1) {
                                cArray3[n4++] = cArray2[n3];
                            }
                            cArray3[n4++] = c;
                            break;
                        }
                        return "#error";
                    }
                    ++n2;
                }
                if (n2 < nArray2.length) continue;
            }
        }
        int n7 = 0;
        while (n7 < nArray.length) {
            if (n / nArray[n7] <= 0) {
                ++n7;
                continue;
            }
            cArray = (char[])xResourceBundle.getObject(stringArray[n7]);
            cArray2 = new char[cArray.length + 1];
            n2 = 0;
            while (n2 < cArray.length) {
                cArray2[n2 + 1] = cArray[n2];
                ++n2;
            }
            cArray2[0] = cArray[n2 - 1];
            n3 = n / nArray[n7];
            if (n3 == 0 && (n %= nArray[n7]) == 0) break;
            if (n3 >= cArray2.length) {
                return "#error";
            }
            cArray3[n4++] = cArray2[n3];
            ++n7;
        }
        return new String(cArray3, 0, n4);
    }

    class NumberFormatStringTokenizer {
        private int currentPosition;
        private int maxPosition;
        private String str;

        public NumberFormatStringTokenizer(String string) {
            this.str = string;
            this.maxPosition = string.length();
        }

        public int countTokens() {
            int n = 0;
            int n2 = this.currentPosition;
            while (n2 < this.maxPosition) {
                int n3 = n2;
                while (n2 < this.maxPosition && Character.isLetterOrDigit(this.str.charAt(n2))) {
                    ++n2;
                }
                if (n3 == n2 && !Character.isLetterOrDigit(this.str.charAt(n2))) {
                    ++n2;
                }
                ++n;
            }
            return n;
        }

        public boolean hasMoreTokens() {
            return this.currentPosition < this.maxPosition;
        }

        public boolean isLetterOrDigitAhead() {
            int n = this.currentPosition;
            while (n < this.maxPosition) {
                if (Character.isLetterOrDigit(this.str.charAt(n))) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public boolean nextIsSep() {
            return !Character.isLetterOrDigit(this.str.charAt(this.currentPosition));
        }

        public String nextToken() {
            if (this.currentPosition >= this.maxPosition) {
                throw new NoSuchElementException();
            }
            int n = this.currentPosition;
            while (this.currentPosition < this.maxPosition && Character.isLetterOrDigit(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
            if (n == this.currentPosition && !Character.isLetterOrDigit(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
            return this.str.substring(n, this.currentPosition);
        }

        public void reset() {
            this.currentPosition = 0;
        }
    }
}

