/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.serialize;

import java.io.IOException;
import java.util.Properties;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.serialize.CharInfo;
import org.apache.xalan.serialize.ElemDesc;
import org.apache.xalan.serialize.Encodings;
import org.apache.xalan.serialize.SerializerToXML;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.Trie;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SerializerToHTML
extends SerializerToXML {
    protected BoolStack m_isRawStack = new BoolStack();
    private boolean m_inBlockElem = false;
    protected static CharInfo m_htmlcharInfo = new CharInfo(CharInfo.HTML_ENTITIES_RESOURCE);
    static Trie m_elementFlags = new Trie();
    private static ElemDesc m_dummy;
    private boolean m_specialEscapeURLs = true;
    private boolean m_omitMetaTag = false;
    private String m_currentElementName = null;

    static {
        m_elementFlags.put("BASEFONT", (Object)new ElemDesc(2));
        m_elementFlags.put("FRAME", (Object)new ElemDesc(10));
        m_elementFlags.put("FRAMESET", (Object)new ElemDesc(8));
        m_elementFlags.put("NOFRAMES", (Object)new ElemDesc(8));
        m_elementFlags.put("ISINDEX", (Object)new ElemDesc(10));
        m_elementFlags.put("APPLET", (Object)new ElemDesc(0x200000));
        m_elementFlags.put("CENTER", (Object)new ElemDesc(8));
        m_elementFlags.put("DIR", (Object)new ElemDesc(8));
        m_elementFlags.put("MENU", (Object)new ElemDesc(8));
        m_elementFlags.put("TT", (Object)new ElemDesc(4096));
        m_elementFlags.put("I", (Object)new ElemDesc(4096));
        m_elementFlags.put("B", (Object)new ElemDesc(4096));
        m_elementFlags.put("BIG", (Object)new ElemDesc(4096));
        m_elementFlags.put("SMALL", (Object)new ElemDesc(4096));
        m_elementFlags.put("EM", (Object)new ElemDesc(8192));
        m_elementFlags.put("STRONG", (Object)new ElemDesc(8192));
        m_elementFlags.put("DFN", (Object)new ElemDesc(8192));
        m_elementFlags.put("CODE", (Object)new ElemDesc(8192));
        m_elementFlags.put("SAMP", (Object)new ElemDesc(8192));
        m_elementFlags.put("KBD", (Object)new ElemDesc(8192));
        m_elementFlags.put("VAR", (Object)new ElemDesc(8192));
        m_elementFlags.put("CITE", (Object)new ElemDesc(8192));
        m_elementFlags.put("ABBR", (Object)new ElemDesc(8192));
        m_elementFlags.put("ACRONYM", (Object)new ElemDesc(8192));
        m_elementFlags.put("SUP", (Object)new ElemDesc(98304));
        m_elementFlags.put("SUB", (Object)new ElemDesc(98304));
        m_elementFlags.put("SPAN", (Object)new ElemDesc(98304));
        m_elementFlags.put("BDO", (Object)new ElemDesc(98304));
        m_elementFlags.put("BR", (Object)new ElemDesc(98314));
        m_elementFlags.put("BODY", (Object)new ElemDesc(8));
        m_elementFlags.put("ADDRESS", (Object)new ElemDesc(56));
        m_elementFlags.put("DIV", (Object)new ElemDesc(56));
        m_elementFlags.put("A", (Object)new ElemDesc(32768));
        m_elementFlags.put("MAP", (Object)new ElemDesc(98312));
        m_elementFlags.put("AREA", (Object)new ElemDesc(10));
        m_elementFlags.put("LINK", (Object)new ElemDesc(131082));
        m_elementFlags.put("IMG", (Object)new ElemDesc(2195458));
        m_elementFlags.put("OBJECT", (Object)new ElemDesc(2326528));
        m_elementFlags.put("PARAM", (Object)new ElemDesc(2));
        m_elementFlags.put("HR", (Object)new ElemDesc(58));
        m_elementFlags.put("P", (Object)new ElemDesc(56));
        m_elementFlags.put("H1", (Object)new ElemDesc(262152));
        m_elementFlags.put("H2", (Object)new ElemDesc(262152));
        m_elementFlags.put("H3", (Object)new ElemDesc(262152));
        m_elementFlags.put("H4", (Object)new ElemDesc(262152));
        m_elementFlags.put("H5", (Object)new ElemDesc(262152));
        m_elementFlags.put("H6", (Object)new ElemDesc(262152));
        m_elementFlags.put("PRE", (Object)new ElemDesc(0x100008));
        m_elementFlags.put("Q", (Object)new ElemDesc(98304));
        m_elementFlags.put("BLOCKQUOTE", (Object)new ElemDesc(56));
        m_elementFlags.put("INS", (Object)new ElemDesc(0));
        m_elementFlags.put("DEL", (Object)new ElemDesc(0));
        m_elementFlags.put("DL", (Object)new ElemDesc(56));
        m_elementFlags.put("DT", (Object)new ElemDesc(8));
        m_elementFlags.put("DD", (Object)new ElemDesc(8));
        m_elementFlags.put("OL", (Object)new ElemDesc(524296));
        m_elementFlags.put("UL", (Object)new ElemDesc(524296));
        m_elementFlags.put("LI", (Object)new ElemDesc(8));
        m_elementFlags.put("FORM", (Object)new ElemDesc(8));
        m_elementFlags.put("LABEL", (Object)new ElemDesc(16384));
        m_elementFlags.put("INPUT", (Object)new ElemDesc(18434));
        m_elementFlags.put("SELECT", (Object)new ElemDesc(18432));
        m_elementFlags.put("OPTGROUP", (Object)new ElemDesc(0));
        m_elementFlags.put("OPTION", (Object)new ElemDesc(0));
        m_elementFlags.put("TEXTAREA", (Object)new ElemDesc(18432));
        m_elementFlags.put("FIELDSET", (Object)new ElemDesc(24));
        m_elementFlags.put("LEGEND", (Object)new ElemDesc(0));
        m_elementFlags.put("BUTTON", (Object)new ElemDesc(18432));
        m_elementFlags.put("TABLE", (Object)new ElemDesc(56));
        m_elementFlags.put("CAPTION", (Object)new ElemDesc(8));
        m_elementFlags.put("THEAD", (Object)new ElemDesc(8));
        m_elementFlags.put("TFOOT", (Object)new ElemDesc(8));
        m_elementFlags.put("TBODY", (Object)new ElemDesc(8));
        m_elementFlags.put("COLGROUP", (Object)new ElemDesc(8));
        m_elementFlags.put("COL", (Object)new ElemDesc(10));
        m_elementFlags.put("TR", (Object)new ElemDesc(8));
        m_elementFlags.put("TH", (Object)new ElemDesc(0));
        m_elementFlags.put("TD", (Object)new ElemDesc(0));
        m_elementFlags.put("HEAD", (Object)new ElemDesc(0x400008));
        m_elementFlags.put("TITLE", (Object)new ElemDesc(8));
        m_elementFlags.put("BASE", (Object)new ElemDesc(10));
        m_elementFlags.put("META", (Object)new ElemDesc(131082));
        m_elementFlags.put("STYLE", (Object)new ElemDesc(131336));
        m_elementFlags.put("SCRIPT", (Object)new ElemDesc(229632));
        m_elementFlags.put("NOSCRIPT", (Object)new ElemDesc(56));
        m_elementFlags.put("HTML", (Object)new ElemDesc(8));
        m_elementFlags.put("FONT", (Object)new ElemDesc(4096));
        m_elementFlags.put("S", (Object)new ElemDesc(4096));
        m_elementFlags.put("STRIKE", (Object)new ElemDesc(4096));
        m_elementFlags.put("U", (Object)new ElemDesc(4096));
        m_elementFlags.put("NOBR", (Object)new ElemDesc(4096));
        m_elementFlags.put("IFRAME", (Object)new ElemDesc(56));
        m_elementFlags.put("LAYER", (Object)new ElemDesc(56));
        m_elementFlags.put("ILAYER", (Object)new ElemDesc(56));
        ElemDesc elemDesc = (ElemDesc)m_elementFlags.get("AREA");
        elemDesc.setAttr("HREF", 2);
        elemDesc.setAttr("NOHREF", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("BASE");
        elemDesc.setAttr("HREF", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("BLOCKQUOTE");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("Q");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("INS");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("DEL");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("A");
        elemDesc.setAttr("HREF", 2);
        elemDesc.setAttr("NAME", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("LINK");
        elemDesc.setAttr("HREF", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("INPUT");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("CHECKED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("ISMAP", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("SELECT");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("MULTIPLE", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OPTGROUP");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OPTION");
        elemDesc.setAttr("SELECTED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("TEXTAREA");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("BUTTON");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("SCRIPT");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("FOR", 2);
        elemDesc.setAttr("DEFER", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("IMG");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("ISMAP", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OBJECT");
        elemDesc.setAttr("CLASSID", 2);
        elemDesc.setAttr("CODEBASE", 2);
        elemDesc.setAttr("DATA", 2);
        elemDesc.setAttr("ARCHIVE", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("DECLARE", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("FORM");
        elemDesc.setAttr("ACTION", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("HEAD");
        elemDesc.setAttr("PROFILE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("FRAME");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("IFRAME");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("LAYER");
        elemDesc.setAttr("SRC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("ILAYER");
        elemDesc.setAttr("SRC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("DIV");
        elemDesc.setAttr("SRC", 2);
        m_dummy = new ElemDesc(8);
    }

    public SerializerToHTML() {
        this.m_charInfo = m_htmlcharInfo;
    }

    public void cdata(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_currentElementName != null && (this.m_currentElementName.equalsIgnoreCase("SCRIPT") || this.m_currentElementName.equalsIgnoreCase("STYLE"))) {
            try {
                this.writeParentTagEnd();
                this.m_ispreserve = true;
                if (this.shouldIndent()) {
                    this.indent(this.m_currentIndent);
                }
                this.writeNormalizedChars(cArray, n, n2, true);
            }
            catch (IOException iOException) {
                throw new SAXException(XSLMessages.createXPATHMessage(66, null), iOException);
            }
        } else {
            super.cdata(cArray, n, n2);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_isRawStack.peekOrFalse()) {
            try {
                this.writeParentTagEnd();
                this.m_ispreserve = true;
                if (this.shouldIndent()) {
                    this.indent(this.m_currentIndent);
                }
                this.writeNormalizedChars(cArray, n, n2, false);
                return;
            }
            catch (IOException iOException) {
                throw new SAXException(XSLMessages.createXPATHMessage(66, null), iOException);
            }
        }
        super.characters(cArray, n, n2);
    }

    private int copyEntityIntoBuf(String string, int n) throws SAXException {
        int n2 = string.length();
        this.accum('&');
        int n3 = 0;
        while (n3 < n2) {
            this.accum(string.charAt(n3));
            ++n3;
        }
        this.accum(';');
        return n;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string != null && string.length() > 0) {
            super.endElement(string, string2, string3);
            return;
        }
        this.m_currentIndent -= this.m_indentAmount;
        boolean bl = this.childNodesWereAdded();
        this.m_isRawStack.pop();
        ElemDesc elemDesc = this.getElemDesc(string3);
        boolean bl2 = elemDesc.is(8);
        boolean bl3 = false;
        if (this.m_ispreserve) {
            this.m_ispreserve = false;
        } else if (this.m_doIndent && (!this.m_inBlockElem || bl2)) {
            this.m_startNewLine = true;
            bl3 = true;
        }
        this.m_inBlockElem = bl2 ^ true;
        if (bl) {
            if (bl3) {
                this.indent(this.m_currentIndent);
            }
            this.accum("</");
            this.accum(string3);
            this.accum('>');
            this.m_currentElementName = string3;
        } else if (!elemDesc.is(2)) {
            this.accum('>');
            this.accum('<');
            this.accum('/');
            this.accum(string3);
            this.accum('>');
        } else {
            this.accum('>');
        }
        if (elemDesc.is(0x200000)) {
            this.m_ispreserve = true;
        }
        if (bl && !this.m_preserves.isEmpty()) {
            this.m_preserves.pop();
        }
        this.m_isprevtext = false;
        this.m_cdataSectionStates.pop();
    }

    public void entityReference(String string) throws SAXException {
        this.accum("&");
        this.accum(string);
        this.accum(";");
    }

    ElemDesc getElemDesc(String string) {
        Object object;
        if (string != null && (object = m_elementFlags.get(string)) != null) {
            return (ElemDesc)object;
        }
        return m_dummy;
    }

    public boolean getOmitMetaTag() {
        return this.m_omitMetaTag;
    }

    public boolean getSpecialEscapeURLs() {
        return this.m_specialEscapeURLs;
    }

    private boolean isASCIIDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isHHSign(String string) {
        boolean bl = true;
        try {
            char c = (char)Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    private String makeHHString(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    protected void processAttribute(String string, ElemDesc elemDesc, String string2) throws SAXException {
        this.accum(' ');
        if ((string2.length() == 0 || string2.equalsIgnoreCase(string)) && elemDesc.isAttrFlagSet(string, 4)) {
            this.accum(string);
        } else {
            this.accum(string);
            this.accum('=');
            this.accum('\"');
            if (elemDesc.isAttrFlagSet(string, 2)) {
                this.writeAttrURI(string2, this.m_specialEscapeURLs);
            } else {
                this.writeAttrString(string2, this.m_encoding);
            }
            this.accum('\"');
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (string.equals("javax.xml.transform.disable-output-escaping")) {
            this.startNonEscaping();
        } else if (string.equals("javax.xml.transform.enable-output-escaping")) {
            this.endNonEscaping();
        } else {
            this.writeParentTagEnd();
            if (this.shouldIndent()) {
                this.indent(this.m_currentIndent);
            }
            this.accum("<?" + string);
            if (string2.length() > 0 && !Character.isSpaceChar(string2.charAt(0))) {
                this.accum(" ");
            }
            this.accum(String.valueOf(string2) + ">");
            if (this.m_elemStack.isEmpty()) {
                this.outputLineSep();
            }
            this.m_startNewLine = true;
        }
    }

    public void setOmitMetaTag(boolean bl) {
        this.m_omitMetaTag = bl;
    }

    public void setOutputFormat(Properties properties) {
        this.m_specialEscapeURLs = OutputProperties.getBooleanProperty(OutputProperties.S_USE_URL_ESCAPING, properties);
        this.m_omitMetaTag = OutputProperties.getBooleanProperty(OutputProperties.S_OMIT_META_TAG, properties);
        super.setOutputFormat(properties);
    }

    public void setSpecialEscapeURLs(boolean bl) {
        this.m_specialEscapeURLs = bl;
    }

    public void startDocument() throws SAXException {
        this.m_needToOutputDocTypeDecl = true;
        this.m_startNewLine = false;
        this.m_shouldNotWriteXMLHeader = true;
        if (this.m_needToOutputDocTypeDecl && (this.m_doctypeSystem != null || this.m_doctypePublic != null)) {
            this.accum("<!DOCTYPE HTML");
            if (this.m_doctypePublic != null) {
                this.accum(" PUBLIC \"");
                this.accum(this.m_doctypePublic);
                this.accum("\"");
            }
            if (this.m_doctypeSystem != null) {
                if (this.m_doctypePublic == null) {
                    this.accum(" SYSTEM \"");
                } else {
                    this.accum(" \"");
                }
                this.accum(this.m_doctypeSystem);
                this.accum("\"");
            }
            this.accum(">");
            this.outputLineSep();
        }
        this.m_needToOutputDocTypeDecl = false;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string != null && string.length() > 0) {
            super.startElement(string, string2, string3, attributes);
            return;
        }
        boolean bl = this.m_doIndent;
        this.writeParentTagEnd();
        this.pushState(string, string2, this.m_cdataSectionNames, this.m_cdataSectionStates);
        ElemDesc elemDesc = this.getElemDesc(string3);
        boolean bl2 = elemDesc.is(8);
        boolean bl3 = elemDesc.is(0x400000);
        if (this.m_ispreserve) {
            this.m_ispreserve = false;
        } else if (this.m_doIndent && this.m_currentElementName != null && (!this.m_inBlockElem || bl2)) {
            this.m_startNewLine = true;
            this.indent(this.m_currentIndent);
        }
        this.m_inBlockElem = bl2 ^ true;
        this.m_isRawStack.push(elemDesc.is(256));
        this.m_currentElementName = string3;
        this.accum('<');
        this.accum(string3);
        int n = attributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            this.processAttribute(attributes.getQName(n2), elemDesc, attributes.getValue(n2));
            ++n2;
        }
        this.openElementForChildren();
        this.m_currentIndent += this.m_indentAmount;
        this.m_isprevtext = false;
        this.m_doIndent = bl;
        if (bl3) {
            this.writeParentTagEnd();
            if (!this.m_omitMetaTag) {
                if (this.m_doIndent) {
                    this.indent(this.m_currentIndent);
                }
                this.accum("<META http-equiv=\"Content-Type\" content=\"text/html; charset=");
                String string4 = Encodings.getMimeEncoding(this.m_encoding);
                this.accum(string4);
                this.accum('\"');
                this.accum('>');
            }
        }
    }

    public void writeAttrString(String string, String string2) throws SAXException {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c < this.m_maxCharacter && !this.m_charInfo.isSpecial(c)) {
                this.accum(c);
            } else if (c == '<' || c == '>') {
                this.accum(c);
            } else if (c == '&' && n2 + 1 < n && cArray[n2 + 1] == '{') {
                this.accum(c);
            } else {
                int n3 = this.accumDefaultEntity(c, n2, cArray, n, false);
                if (n2 != n3) {
                    n2 = n3 - 1;
                } else {
                    String string3;
                    if (SerializerToXML.isUTF16Surrogate(c)) {
                        try {
                            n2 = this.writeUTF16Surrogate(c, cArray, n2, n);
                        }
                        catch (IOException iOException) {
                            throw new SAXException(iOException);
                        }
                    }
                    if ((string3 = this.m_charInfo.getEntityNameForChar(c)) != null) {
                        this.accum('&');
                        this.accum(string3);
                        this.accum(';');
                    } else if (c < this.m_maxCharacter) {
                        this.accum(c);
                    } else if (c < this.m_maxCharacter) {
                        this.accum(c);
                    } else {
                        this.accum("&#");
                        this.accum(Integer.toString(c));
                        this.accum(';');
                    }
                }
            }
            ++n2;
        }
    }

    public void writeAttrURI(String string, boolean bl) throws SAXException {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c < '!' || c > '~') {
                if (bl) {
                    int n3;
                    int n4;
                    int n5;
                    if (c <= '\u007f') {
                        this.accum('%');
                        this.accum(this.makeHHString(c));
                    } else if (c <= '\u07ff') {
                        n5 = c >> 6 | 0xC0;
                        n4 = c & 0x3F | 0x80;
                        this.accum('%');
                        this.accum(this.makeHHString(n5));
                        this.accum('%');
                        this.accum(this.makeHHString(n4));
                    } else if (SerializerToXML.isUTF16Surrogate(c)) {
                        n5 = c & 0x3FF;
                        n4 = (n5 & 0x3C0) >> 6;
                        n3 = n4 + 1;
                        int n6 = (n5 & 0x3C) >> 2;
                        int n7 = (n5 & 3) << 4 & 0x30;
                        c = cArray[++n2];
                        int n8 = c & 0x3FF;
                        int n9 = n8 & 0x3F;
                        int n10 = 0xF0 | n3 >> 2;
                        int n11 = 0x80 | (n3 & 3) << 4 & 0x30 | n6;
                        int n12 = 0x80 | (n7 |= (n8 & 0x3C0) >> 6);
                        int n13 = 0x80 | n9;
                        this.accum('%');
                        this.accum(this.makeHHString(n10));
                        this.accum('%');
                        this.accum(this.makeHHString(n11));
                        this.accum('%');
                        this.accum(this.makeHHString(n12));
                        this.accum('%');
                        this.accum(this.makeHHString(n13));
                    } else {
                        n5 = c >> 12 | 0xE0;
                        n4 = (c & 0xFC0) >> 6 | 0x80;
                        n3 = c & 0x3F | 0x80;
                        this.accum('%');
                        this.accum(this.makeHHString(n5));
                        this.accum('%');
                        this.accum(this.makeHHString(n4));
                        this.accum('%');
                        this.accum(this.makeHHString(n3));
                    }
                } else if (c < this.m_maxCharacter) {
                    this.accum(c);
                } else {
                    this.accum("&#");
                    this.accum(Integer.toString(c));
                    this.accum(';');
                }
            } else if (c == '%') {
                if (n2 + 2 < n && this.isHHSign(new String(cArray, n2 + 1, 2))) {
                    this.accum(c);
                } else if (bl) {
                    this.accum('%');
                    this.accum(this.makeHHString(c));
                } else {
                    this.accum(c);
                }
            } else if (c == '\"') {
                if (bl) {
                    this.accum("%22");
                } else {
                    this.accum("&quot;");
                }
            } else {
                this.accum(c);
            }
            ++n2;
        }
    }
}

