<?xml version="1.0"?>
<!-- 

    Copyright (C) 2006 W3C (R) (MIT ERCIM Keio), All Rights Reserved.
    W3C liability, trademark and document use rules apply.

    http://www.w3.org/Consortium/Legal/ipr-notice
    http://www.w3.org/Consortium/Legal/copyright-documents

    $Header: /w3ccvs/WWW/2002/ws/databinding/edcopy/patterns/examples2wsdlxsd.xsl,v 1.3 2007/04/19 11:17:25 pdowney Exp $

    generate XSD from multiple examples

-->

<xsl:stylesheet xmlns:xs="http://www.w3.org/2001/XMLSchema" 
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:p="http://www.w3.org/2002/ws/databinding/patterns/6/09/"
    xmlns:ex="http://www.w3.org/2002/ws/databinding/examples/6/09/"
    xmlns:def="http://www.w3.org/2002/ws/databinding/examples/6/09/"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="1.0">
   <xsl:output method="xml" indent="yes" encoding="UTF-8"/>
   <xsl:param name="status" select="'all'"/>
   <xsl:param name="exclude" select="''"/>
   <xsl:param name="include" select="''"/>

   <xsl:template match="/">
      <xsl:param name="name" select="''"/>
      <xsl:param name="ns" select="'ex:'"/>
      <xsl:param name="tns"><xsl:value-of select="/ex:examples/@targetNamespace"/></xsl:param>
      <xsl:comment>

    Copyright (C) 2006 W3C (R) (MIT ERCIM Keio), All Rights Reserved.
    W3C liability, trademark and document use rules apply.

    http://www.w3.org/Consortium/Legal/ipr-notice
    http://www.w3.org/Consortium/Legal/copyright-documents

    Generated from: <xsl:value-of select="//ex:version"/>

</xsl:comment>


      <xsl:comment>

	    excludes: <xsl:value-of select="$exclude"/>

	    includes: <xsl:value-of select="$include"/>

      </xsl:comment>
	<xs:schema targetNamespace="{$tns}" elementFormDefault="qualified"
	    xmlns="http://schemas.xmlsoap.org/wsdl/"
	    xmlns:wsdl="http://schemas.xmlsoap.org/wsdl/"
	    xmlns:soap="http://schemas.xmlsoap.org/wsdl/soap/">
               <xsl:for-each select="//ex:example">
                  <xsl:variable name="m">:<xsl:value-of select="./@xml:id"/>:</xsl:variable>
                  <xsl:if test="not(contains($exclude,$m))">
		    <xsl:if test="$include = '' or contains($include,$m)">
                     <xsl:copy-of select="./ex:typedef/*"/>
                     <xs:element name="echo{./@xml:id}">
                        <xs:complexType>
                           <xs:sequence>
                              <xs:element ref="{./@element}"/>
                           </xs:sequence>
                        </xs:complexType>
                     </xs:element>
                   </xsl:if>
                  </xsl:if>
               </xsl:for-each>
            </xs:schema>
   </xsl:template>
</xsl:stylesheet>
