default collation = "http://mycollations"

<bib>
 {
  for $b in document("http://www.bn.com")/bib/book
  where $b/publisher = "Addison-Wesley" and $b/@year > 1991
  return
    <book year="{ $b/@year }">
     { $b/title }
    </book>
 }
</bib>

;

<bib>
    <book year="1994">
        <title>TCP/IP Illustrated</title>
    </book>
    <book year="1992">
        <title>Advanced Programming in the Unix environment</title>
    </book>
</bib>

;

<results>
  {
    for $b in document("http://www.bn.com")/bib/book,
        $t in $b/title,
        $a in $b/author
    return
        <result>
            { $t }    
            { $a }
        </result>
  }
</results>

;

<results>
  {
    for $b in document("http://www.bn.com")/bib/book
    return
        <result>
            { $b/title }
            {
                for $a in $b/author
                return $a
            }
        </result>
  }
</results>

;

<results>
  {
    for $a in distinct-values(document("http://www.bn.com")//author)
    return
        <result>
            { $a }
            {
                for $b in document("http://www.bn.com")/bib/book[value-equals(author,$a)]
                return $b/title
            }
        </result>
  }
</results>

;

<books-with-prices>
  {
    for $b in document("www.bn.com/bib.xml")//book,
        $a in document("www.amazon.com/reviews.xml")//entry
    where $b/title = $a/title
    return
        <book-with-prices>
            { $b/title }
            <price-amazon>{ $a/price/text() }</price-amazon>
            <price-bn>{ $b/price/text() }</price-bn>
        </book-with-prices>
  }
</books-with-prices>

;

<bib>
  {
    for $b in document("www.bn.com/bib.xml")//book
    where count($b/author) > 0
    return
        <book>
            { $b/title }
            {
                for $a in $b/author[position()<=2]  
                return $a
            }
            {
                if (count($b/author) > 2)
                then <et-al/>
                else ()
            }
        </book>
  }
</bib>

;

<bib>
  {
    for $b in document("www.bn.com/bib.xml")//book[publisher = "Addison-Wesley" and @year > "1991"] 
 order by (title)
    return
        <book>
            { $b/@year }
            { $b/title }
        </book>
  }
</bib>

;

<bib>
  {
    for $b in document("www.bn.com/bib.xml")//book[publisher = "Addison-Wesley" and @year > "1991"] 
 order by stable (title)
    return
        <book>
            { $b/@year }
            { $b/title }
        </book>
  }
</bib>

;

for $b in document("www.bn.com/bib.xml")//book,
    $e in $b/*[contains(string(.), "Suciu")]
where ends_with(name($e), "or")
return
    <book>
        { $b/title }
        { $e }
    </book>
  
;

<results>
  {
    for $t in document("books.xml")//chapter/title union document("books.xml")//section/title
    where contains($t/text(), "XML")
    return $t
  }
</results>

;

<results>
  {
    let $doc := document("prices.xml")
    for $t in distinct-values($doc/book/title)
    let $p := $doc/book[title = $t]/price
    return
      <minprice title="{ $t/text() }">
         { 
           min($p) 
         }
      </minprice>
  }
</results>

;

<bib>
    {
        for $b in document("www.bn.com/bib.xml")//book[author]
        return
            <book>
                { $b/title }
                { $b/author }
            </book>
    }
    {
        for $b in document("www.bn.com/bib.xml")//book[editor]
        return
            <reference>
                { $b/title }
                <org>{ $b/editor/affiliation/text() }</org>
            </reference>
    }
</bib>

;

<bib>
  {
    for $book1 in document("www.bn.com/bib.xml")//book,
        $book2 in document("www.bn.com/bib.xml")//book
    where $book1/title/text() > $book2/title/text() 
    and bags-are-equal($book1/author, $book2/author) 
    return
        <book-pair>
            { $book1/title }
            { $book2/title }
        </book-pair>
  }
</bib>

;


<toc>
  {
    let $b := document("book1.xml")
    return
        filter($b//section | $b//section/title | $b//section/title/text())
  }
</toc>

;

<figlist>
  {
    for $f in document("book1.xml")//figure
    return
        <figure>
            { $f/@* }
            { $f/title }
        </figure>
  }
</figlist>

;

<section_count>{ count(document("book1.xml")//section) }</section_count>, 
<figure_count>{  count(document("book1.xml")//figure ) }</figure_count>

;

<section_count>7</section_count>,
<figure_count>3</figure_count>

;

<top_section_count>
 { 
   count(document("book1.xml")/book/section) 
 }
</top_section_count>

;

<top_section_count>2</top_section_count>

;

<section_list>
  {
    for $s in document("book1.xml")//section
    let $f := $s/figure
    return
        <section title="{ $s/title/text() } figcount={ count($f) }"/>
  }
</section_list>

;

define function section_summary($s as element) as element
{
    <section>
        { $s/@* }
        { $s/title }
        <figcount>{ count($s/figure) }</figcount>
        {
            for $ss in $s/section
            return section_summary($ss)
        }
    </section>
}

<toc>
  {
    for $s in document("book1.xmll")//section
    return section_summary($s)
  }
</toc>

;

for $s in document("report1.xml")//section[section.title = "Procedure"]
return ($s//incision)[2]/instrument

;

for $s in document("report1.xml")//section[section.title = "Procedure"]
return ($s//instrument)[position()<=2]

;

<result>
  {
    for $i in document("items.xml")//item_tuple
    where $i/start_date <= date()
      and $i/end_date >= date() 
      and contains($i/description, "Bicycle")
    order by (itemno)
    return
        <item_tuple>
            { $i/itemno }
            { $i/description }
        </item_tuple>
  }
</result>

;

<result>
  {
    for $i in document("items.xml")//item_tuple
    let $b := document("bids.xml")//bid_tuple[itemno = $i/itemno]
    where contains($i/description, "Bicycle")
    order by(itemno)
    return
        <item_tuple>
            { $i/itemno }
            { $i/description }
            <high_bid>{ max($b/bid) }</high_bid>
        </item_tuple>
  }
</result>

;

<result>
  {
    for $u in document("users.xml")//user_tuple
    for $i in document("items.xml")//item_tuple
    where $u/rating > "C" 
       and $i/reserve_price > 1000 
       and $i/offered_by = $u/userid
    return
        <warning>
            { $u/name }
            { $u/rating }
            { $i/description }
            { $i/reserve_price }
        </warning>
  }
</result>

;

<result>
  {
    for $i in document("items.xml")//item_tuple
    where not(some $b in document("bids.xml")//bid_tuple 
                        satisfies $b/itemno = $i/itemno)
    return
        <no_bid_item>
            { $i/itemno }
            { $i/description }
        </no_bid_item>
  }
</result>

;

<result>
  {
    for $seller in document("users.xml")//user_tuple,
        $buyer in  document("users.xml")//user_tuple,
        $item in  document("items.xml")//item_tuple,
        $highbid in  document("bids.xml")//bid_tuple
    where $seller/name = "Tom Jones" 
      and $seller/userid = $item/offered_by 
      and contains($item/description, "Bicycle") 
      and $item/itemno = $highbid/itemno 
      and $highbid/userid = $buyer/userid 
      and $highbid/bid = max(document("bids.xml")//bid_tuple [itemno = $item/itemno]/bid)
    order by(itemno)
    return
        <jones_bike>
            { $item/itemno }
            { $item/description }
            <high_bid>{ $highbid/bid }</high_bid>
            <high_bidder>{ $buyer/name }</high_bidder>
        </jones_bike>
  }
</result>

;

<result>
  {
    for $seller in unordered(document("users.xml")//user_tuple),
        $buyer in  unordered(document("users.xml")//user_tuple),
        $item in  unordered(document("items.xml")//item_tuple),
        $highbid in  unordered(document("bids.xml")//bid_tuple)
    where $seller/name = "Tom Jones" 
      and $seller/userid = $item/offered_by 
      and contains($item/description, "Bicycle") 
      and $item/itemno = $highbid/itemno 
      and $highbid/userid = $buyer/userid 
      and $highbid/bid = max(document("bids.xml")//bid_tuple [itemno = $item/itemno]/bid)
    order by (itemno)
    return
        <jones_bike>
            { $item/itemno }
            { $item/description }
            <high_bid>{ $highbid/bid }</high_bid>
            <high_bidder>{ $buyer/name }</high_bidder>
        </jones_bike>
  }
</result>

;

<result>
  {
    for $item in document("items.xml")//item_tuple
    let $b := document("bids.xml")//bid_tuple[itemno = $item/itemno]
    where $item/reserve_price * 2 < max($b/bid)
    return
        <successful_item>
            { $item/itemno }
            { $item/description }
            { $item/reserve_price }
            <high_bid>{ max($b/bid) }</high_bid>
        </successful_item>
 }
</result>

;

let $allbikes := document("items.xml")//item_tuple[contains(description, "Bicycle") or contains(description, "Tricycle")]
let $bikebids := document("bids.xml")//bid_tuple[itemno = $allbikes/itemno]
return
    <high_bid>
      { 
        max($bikebids/bid) 
      }
    </high_bid>
;

let $item := document("items.xml")//item_tuple
  [end_date >= date("1999-03-01") and end_date <= date("1999-03-31")]
return
    <item_count>
      { 
        count($item) 
      }
    </item_count>

;

<result>
  {
    let $end_dates := document("items.xml")//item_tuple/end_date
    for $m in distinct-values(month($end_dates))
    let $item := document("items.xml")
        //item_tuple[year(end_date) = 1999 and month(end_date) = $m]
    order by(month)
    return
        <monthly_result>
            <month>{ $m }</month>
            <item_count>{ count($item) }</item_count>
        </monthly_result>
  }
</result>

;

<result>
  {
    for $highbid in document("bids.xml")//bid_tuple,
        $user in document("users.xml")//user_tuple
    where $user/userid = $highbid/userid 
      and $highbid/bid = max(document("bids.xml")//bid_tuple[itemno = $highbid/itemno]/bid)
    order by(itemno)
    return
        <high_bid>
            { $highbid/itemno }
            { $highbid/bid }
            <bidder>{ $user/name/text() }</bidder>
        </high_bid>
  }
</result>

;

let $highbid := max(document("bids.xml")//bid_tuple/bid)
return
    <result>
      {
        for $item in document("items.xml")//item_tuple,
            $b in document("bids.xml")//bid_tuple[itemno = $item/itemno]
        where $b/bid = $highbid
        return
            <expensive_item>
                { $item/itemno }
                { $item/description }
                <high_bid>{ $highbid }</high_bid>
            </expensive_item>
      }
    </result>

;

define function bid_summary ()
{
    for $i in distinct-values(document("bids.xml")//itemno)
    let $b := document("bids.xml")//bid_tuple[itemno = $i]
    return
        <bid_count>
            { $i }
            <nbids>{ count($b) }</nbids>
        </bid_count>
}

<result>
 {
    let $bid_counts := bid_summary(),
        $maxbids := max($bid_counts/nbids),
        $maxitemnos := $bid_counts[nbids=$max_bids]
    for $item in document("items.xml")//item_tuple,
        $bc in $bid_counts
    where $bc/nbids = $maxbids and $item/itemno = $bc/itemno
    return
        <popular_item>
            { $item/itemno }
            { $item/description }
            <bid_count>{ $bc/nbids/text() }</bid_count>
        </popular_item>
 }
</result>

;

<result>
  {
    for $uid in distinct-values(document("bids.xml")//userid),
        $u in document("users.xml")//user_tuple[userid = $uid]
    let $b := document("bids.xml")//bid_tuple[userid = $uid]
    order by(userid)
    return
        <bidder>
            { $u/userid }
            { $u/name }
            <bidcount>{ count($b) }</bidcount>
            <avgbid>{ avg($b/bid) }</avgbid>
        </bidder>
  }
</result>

;

<result>
  {
    for $i in distinct-values(document("bids.xml")//itemno)
    let $b := document("bids.xml")//bid_tuple[itemno = $i]
    where count($b) >= 3
    order by avgbid descending
    return
        <popular_item>
            { $i }
            <avgbid>{ avg($b/bid) }</avgbid>
        </popular_item>
  }
</result>

;

<result>
  {
    for $u in document("users.xml")//user_tuple
    let $b := document("bids.xml")//bid_tuple[userid = $u/userid and bid >= 100]
    where count($b) > 1
    return
        <big_spender>{ $u/name/text() }</big_spender>
  }
</result>

;

<result>
  {
    for $u in document("users.xml")//user_tuple
    let $b := document("bids.xml")//bid_tuple[userid = $u/userid]
    order by(userid)
    return
        <user>
            { $u/userid }
            { $u/name }
            {
                if (empty($b))
                then <status>inactive</status>
                else <status>active</status>
            }
        </user>
  }
</result>

;

<frequent_bidder>
  {
    for $u in document("users.xml")//user_tuple
    where 
      every $item in document("items.xml")//item_tuple satisfies 
        some $b in document("bids.xml")//bid_tuple satisfies 
          ($item/itemno = $b/itemno and $u/userid = $b/userid)
    return
        $u/name
  }
</frequent_bidder>

;


<result>
  {
    for $u in document("users.xml")//user_tuple
    order by(name)
    return
        <user>
            { $u/name }
            {
                for $b in distinct-values(document("bids.xml")//bid_tuple[userid = $u/userid]/itemno),
                    $i in document("items.xml")//item_tuple[itemno = $b]
                    order by description/text()
                return
                    <bid_on_item>{ $i/description/text() }</bid_on_item>
            }
        </user>
  }
</result>

;

<result>
  { 
    //report//para 
  }
</result>

;

<result>
  { 
    //intro/para 
  }
</result>

;

<result>
  {
    for $c in //chapter
    where empty($c/intro)
    return $c/section/intro/para
  }
</result>

;

<result>
  { 
    (((//chapter)[2]//section)[3]//para)[2] 
  }
</result>

;

<result>
  { 
    //para[@security = "c"] 
  }
</result>

;

<result>
  {
    for $s in //section/@shorttitle
    return <stitle>{ $s }</stitle>
  }
</result>

;

<result>
  {
    for $i in //intro/para[1]
    return
        <first_letter>{ substring(string($i), 1, 1) }</first_letter> 
  }
</result>

;

<result>
  { 
    //section[contains(string(.//title), "is SGML")] 
  }
</result>

;

<result>
  { 
    //section[contains(.//title/text(), "is SGML")] 
  }
</result>

;

<result>
  {
    for $id in document("input.xml")//xref/@xrefid
    return //topic[@topicid = $id]
  }
</result>

;

//news_item/title[contains(./text(), "Foobar Corporation")]

;

let $foobar_partners := //company[name = "Foobar Corporation"]//partner
for $item in //news_item
where 
  some $t in $item//title satisfies 
    (contains($t/text(), "Foobar Corporation") 
    and some $partner in $foobar_partners satisfies 
      contains($t/text(), $partner/text())) 
  or some $par in $item//par satisfies 
   (contains($par/text(), "Foobar Corporation") 
     and some $partner in $foobar_partners satisfies 
       contains($par/text(), $partner/text()))
return
    <news_item>
        { $item/title }
        { $item/date }
    </news_item>

;

let $foobar_partners := //company[name = "Foobar Corporation"]//partner,
    $foobar_competitors := //company[name = "Foobar Corporation"]//competitor
for $item in //news_item
where some $partner in $foobar_partners satisfies 
  contains_in_same_sentence(string($item/content), "Foobar Corporation", $partner/text()) 
      and not(some $competitor in $foobar_competitors satisfies 
                   contains(string($item/content), $competitor/text()))
return
    $item/title

;


for $item in //news_item,
    $c in //company
let $partners := $c//partner
where contains(string($item), $c/name/text()) 
  and some $p in $partners satisfies 
    contains(string($item), $p/text()) and $item/news_agent != $c/name
return
    $item

;

for $item in //news_item
where contains(string($item/content), "Gorilla Corporation")
return
    <item_summary>
        { $item/title/text() }.
        { $item/date/text() }.
        { string(($item//par)[1]) }
    </item_summary>

;

let $companies := distinct-values(//company/name/text() 
       union //company//partner/text() 
       union //company//competitor/text())
for $item in //news_item,
    $item_title in $item/title,
    $item_para in $item//par,
    $c1 in $companies,
    $c2 in $companies
where $c1 != $c2 
  and contains_stems_in_same_sentence($item_title/text(), $c1, $c2, "acquire") 
   or contains_stems_in_same_sentence($item_para/text(), $c1, $c2, "acquire")
return
    distinct-values($item)

;

<Q1>
  {
    for $n in distinct-values(get-namespace-uri(//*))
    return
        <ns>{$n}</ns>
  }
</Q1>
;

declare namespace music = "http://www.example.org/music/records"

<Q2>
  { 
    //music:title 
  }
</Q2>

;

declare namespace dt = "http://www.w3.org/1999/XMLSchema-datatypes"

<Q3>
  { 
    //*[@dt:*] 
  }
</Q3>

;

declare namespace xlink = "http://www.w3.org/1999/xlink"

<Q4>
  {
    for $hr in //@xlink:href
    return <ns>{ $hr }</ns>
  }
</Q4>
;

declare namespace music = "http://www.example.org/music/records"

<Q5>
  { 
     //music:record[music:remark/@xml:lang = "de"]
  }
</Q5>

;


declare namespace ma = "http://www.example.com/AuctionWatch"
declare namespace anyzone = "http://www.example.com/auctioneers#anyzone"

<Q6>
  { 
    //ma:Auction[@anyzone:ID]/ma:Schedule/ma:Close 
  }
</Q6>

;

declare namespace ma = "http://www.example.com/AuctionWatch"

<Q7>
  {
    for $a in //ma:Auction
    let $seller_id := $a/ma:Trading_Partners/ma:Seller/*:ID,
        $buyer_id := $a/ma:Trading_Partners/ma:High_Bidder/*:ID
    where namespace_uri($seller_id) = namespace_uri($buyer_id)
    return
        $a/ma:AuctionHomepage
  }
</Q7>

;

declare namespace ma = "http://www.example.com/AuctionWatch"

<Q8>
  {
    (for $s in //ma:Trading_Partners/ma:Seller
     where $s/*:NegativeComments = 0
     return $s)
  union 
    (for $b in //ma:Trading_Partners/ma:High_Bidder
     where $b/*:NegativeComments = 0
     return $b)
  }
</Q8>

;

define function one_level ($p as element) as element
{
    <part partid="{ $p/@partid }" 
          name="{ $p/@name }" >
        {
            for $s in document("data/parts-data.xml")//part
            where $s/@partof = $p/@partid
            return one_level($s)
        }
    </part>
}

<parttree>
  {
    for $p in document("data/parts-data.xml")//part[empty(@partof)]
    return one_level($p)
  }
</parttree>

;

<result>
  {
    for $m in document("census.xml")//person[name = "Martha"]
    return shallow($m/@spouse->person)
  }
</result>

;

define function children($p as element) 
{
    shallow($p/person) union shallow($p/@spouse->person/person)
}

<result>
  {
    for $j in document("census.xml")//person[name = "Joe"]
    return children($j)
  }
</result>

;

<result>
  {
    for $p in document("census.xml")//person,
        $s in $p/@spouse->person
    where $p/person/job = "Athlete" or $s/person/job = "Athlete"
    return shallow($p)
  }
</result>

;

<result>
  {
    for $p in document("census.xml")//person,
        $c in $p/person
    where $p/job = $c/job or //person/job[$p/@spouse] = $c/job
    return shallow($c)
  }
</result>

;

<result>
    {
        for $p in document("census.xml")//person,
            $c in $p/person[job = $p/job]
        return
            <match parent="{ $p/name }" child="{ $c/name }" job="{ $c/job }" />
    }
    {
        for $p in document("census.xml")//person,
            $c in $p/@spouse->person/person[job = $p/job]
        return
            <match parent="{ $p/name }" child="{ $c/name }" job="{ $c/job }" />
    }
</result>

;

<result>
  {
    for $b in document("census.xml")//person[name = "Bill"],
        $c in $b/person | $b/@spouse->person/person,
        $g in $c/person | $c/@spouse->person/person
    return shallow($g)
  }
</result>

;

<result>
  {
    for $b in document("census.xml")//person,
        $c in $b/person | $b/@spouse->person/person,
        $g in $c/person | $c/@spouse->person/person
    return
        <grandparent name="{ $b/name }" grandchild="{ $g/name }"/>
  }
</result>

;

<result>
  {
    for $s in document("census.xml")//person[name = "Dave"]/@spouse->person,
        $sp in $s/.. | $s/../@spouse->person
    return
        shallow($sp)
  }
</result>

;

<result>
  {
    for $p in document("census.xml")//person
    where empty(children($p))
    return shallow($p)
  }
</result>

;

<result>
  {
    for $p in document("census.xml")//person[person]
    where empty($p/@spouse->person)
    return shallow($p)
  }
</result>

;

define function descrip ($e as element) as element
{
    let $kids := $e/* union $e/@spouse->person/*
    let $mstatus :=  if ($e[@spouse]) then "Yes" else "No"
    return
        <person married="{ $mstatus }" nkids="{ count($kids) }">{ $e/@name/text() }</person>
}

define function descendants ($e as element)
{
    if (empty($e/* union $e/@spouse->person/*))
    then $e
    else $e union descendants($e/* union $e/@spouse->person/*)
}

for $x in descrip(descendants(//person[name = "Joe"])) 
order by @nkids descending 
return $x

;

define function code($a as element of type ipo:Address) as string
   {
   typeswitch ($a)
      case element of type ipo:USAddress 
           return (treat as ipo:USAddress ($a))/zip/data()
      case element of type ipo:UKAddress 
           return (treat as ipo:UKAddress ($a))/postcode/data()
      default return "none"
   }

;

import schema "ipo.xsd"
default collation = "http://mycollations"
declare namespace ipo="http://www.example.com/IPO"
						
count( 
  input()//ipo:shipTo[. instance of element of type ipo:UKAddress]
)

;

import schema "ipo.xsd"
import schema "zips.xsd"
declare namespace ipo="http://www.example.com/IPO"

define function zip-ok($a as element of type ipo:USAddress)
  as xs:boolean
{
  let $zip :=
     for $i in document("zips.xml")/zips/row
     where $i/city = $a/city
       and $i/state = $a/state
       and $i/zip = $a/zip
     return $i
  return exists( $zip )
}

;

import schema "ipo.xsd"
import schema "postals.xsd"
declare namespace ipo="http://www.example.com/IPO"

define function postal-ok($a as element of type ipo:UKAddress)
  as xs:boolean
{
  let $pc :=
     for $i in document("zips.xml")/zips/row
     where $i/city = $a/city
       and $i/postcode = $a/postcode
     return $i
  return exists( $pc )
} 

;

import schema "ipo.xsd"
declare namespace ipo="http://www.example.com/IPO"

define function address-ok( $a as element of type ipo:Address)
 as xs:boolean
{
  typeswitch ($a)
      case $b as element of type ipo:USAddress
           return zip-ok($b/shipTo)         
      case $b as element of type ipo:UKAddress
           return postal-ok($b)
      default return false()
}

for $p in collection("ipo")//ipo:purchaseOrder
where not( address-ok($p/shipTo) and address-ok($p/billTo))
return $p

;

import schema "ipo.xsd"
declare namespace ipo="http://www.example.com/IPO"

define function names-match( $s as element ipo:shipTo, $b as element ipo:billTo )
  as boolean
 {
     $s/name = $b/name
 }
 
 for $p in input()//ipo:purchaseOrder
 where not( names-match( $p/ipo:shipTo, $p/ipo:billTo ) )
 return $p

;

import schema "ipo.xsd"
declare namespace ipo="http://www.example.com/IPO"

for $p in input()//ipo:purchaseOrder,
      $s in $i/ipo:shipTo
where not( $s instance of element of type ipo:USAddress) 
     and exists( $p//ipo:USPrice )
return $p

;

import schema "ipo.xsd"
declare namespace ipo="http://www.example.com/IPO"

define function comment-text($c as element ipo:comment)
  as xs:string
{
	string( $c )
}

for $p in input()//ipo:purchaseOrder
where $p/ipo:shipTo/ipo:name="Helen Zoe"
    and $p/ipo:orderDate = date("1999-12-01")
return comment-text( $p//ipo:shipComment )

;

for $p in input()//ipo:purchaseOrder
where $p/ipo:shipTo/ipo:name="Helen Zoe"
  and $p/ipo:orderDate = date("1999-12-01")
return comment-text( $p//ipo:customerComment )

;

import schema "ipo.xsd"
declare namespace ipo="http://www.example.com/IPO"

for $p in input()//ipo:purchaseOrder
where $p/ipo:shipTo/ipo:name="Helen Zoe"
  and $p/ipo:orderDate = date("1999-12-01")
return ($p//ipo:customerComment  | $p//ipo:shipComment  | $p//ipo:comment )

;

import schema "ipo.xsd"
declare namespace ipo="http://www.example.com/IPO"

define function comments-for-element( $e as element)
  as ipo:comment*
{
  let $c := $e/(ipo:customerComment  | $p//ipo:shipComment | ipo:comment)
  return $c
}

;

import schema "ipo.xsd"
declare namespace ipo="http://www.example.com/IPO"

define function deadbeat( $b as element billTo of type USAddress)
  as xs:boolean
{
   $b/ipo:name = document("www.usa-deadbeats.com/current")/deadbeats/row/name
}

;

import schema "ipo.xsd"
declare namespace ipo="http://www.example.com/IPO"

define function total-price( $i as element ipo:item* )
  as xs:decimal
{
  let $subtotals := for $s in $i return $s/quantity * $s/ipo:USPrice
  return sum( $subtotals )
}

;

import schema "ipo.xsd"
declare namespace ipo="http://www.example.com/IPO"

for $p in input()//ipo:purchaseOrder
where $p/ipo:shipTo/ipo:name="Helen Zoe"
   and $p/ipo:orderDate = date("1999-12-01")
return total-price($p)

;

define function  one() as integer
{1}

one()

;

define function identity( $x as element*) 
	as element* {$x} 

identity(<a/>)

;

define function identity($x as element+) 
	as element+ {$x} 

identity(<a/>)

;

define function identity($x as element?) 
	as element? {$x} 

identity(<a/>)

;

text {a/b/c[23]}, 
element foo {yada}, 
element {@foo} {yada}, 
attribute foo {yada}, 
attribute {@foo} {yada}, 
text {a/b/c[23]}

;
amp,
ancestor,
ancestor-or-self,
and,
apos,
as,
ascending,
at,
atomic,
attribute,
by,
case,
cast,
child,
collation,
collation,
comment,
context,
declare,
default,
define,
descendant,
descendant-or-self,
descending,
div,
document,
element,
else,
empty,
eq,
every,
except,
following,
following-sibling,
for,
function,
ge,
greatest,
gt,
gt,
id,
idiv,
if,
import,
in,
instance,
intersect,
is,
isnot,
item,
key,
le,
least,
let,
lt,
mod,
namespace,
ne,
none,
of,
or,
order,
parent,
preceding,
preceding-sibling,
preserve,
processing-instruction,
quot,
result,
return,
returns,
satisfies,
schema,
self,
some,
stable,
strip,
text,
then,
to,
treat,
type,
typeswitch,
union,
unordered,
untyped,
validate,
value,
where,
xmlspace
;
foo castable as xsd:integer
;
foo castable as xsd:integer?
;
deep-equal(/,foo)
;
amp(),
ancestor(),
ancestor-or-self(),
and(),
apos(),
as(),
ascending(),
at(),
atomic(),
attribute(),
by(),
case(),
cast(),
child(),
collation(),
collation(),
comment(),
context(),
declare(),
default(),
define(),
descendant(),
descendant-or-self(),
descending(),
div(),
document(),
element(),
else(),
empty(),
eq(),
every(),
except(),
following(),
following-sibling(),
for(),
function(),
ge(),
greatest(),
gt(),
gt(),
idiv(),
import(),
in(),
instance(),
intersect(),
is(),
isnot(),
item(),
key(),
le(),
least(),
let(),
lt(),
mod(),
namespace(),
ne(),
none(),
of(),
or(),
order(),
parent(),
preceding(),
preceding-sibling(),
preserve(),
processing-instruction(),
quot(),
result(),
return(),
returns(),
satisfies(),
schema(),
self(),
some(),
stable(),
strip(),
text(),
then(),
to(),
treat(),
type(),
union(),
unordered(),
untyped(),
validate(),
value(),
where(),
xmlspace()
;