<?xml version="1.0" encoding="utf-8"?>

<!--
 * Copyright (c) 2002 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0" xmlns:g="http://www.w3.org/2001/03/XPath/grammar">
  <xsl:param name="spec1" select="'xpath'"/>
  <xsl:param name="spec2" select="'xquery'"/>
  
  <xsl:template match="@*|node()">
    <xsl:variable name="s1" select="normalize-space($spec1)"/>
    <xsl:variable name="s2" select="normalize-space($spec2)"/>
    <xsl:if test="self::node()[not(@if) or contains(@if, $s1) or contains(@if, $s2)]
                  [not(@sub-spec='xslt-patterns')]">
      <xsl:if test="not(self::g:level) or self::g:level
                    [not(@if) or (contains(@if, $s1) or contains(@if, $s2))]
                    [*[not(@if) or (contains(@if, $s1) or contains(@if, $s2))]]">
        <xsl:copy>
          <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>        
      </xsl:if>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
