<?xml version="1.0" encoding="UTF-8"?>

<!--
 * Copyright (c) 2002 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
-->

<!-- XSLT stylesheet for formatting a grammar into BNF documentation. -->
<!DOCTYPE xsl:stylesheet [
<!ENTITY nbsp   "&#160;">
]>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:g="http://www.w3.org/2001/03/XPath/grammar">
  <xsl:output method="html"/>
  <xsl:param name="spec" select="'xquery'"/>
  
  <xsl:key name="ref" match="g:token[not(@if) or contains(@if,$spec)]  |
                             g:production[not(@if) or contains(@if,$spec)]  |
                             g:exprProduction[not(@if) or contains(@if,$spec)]" use="@name"/>
  
  <xsl:strip-space elements="*"/>
  
  <!-- workaround for Xalan bug. -->
  <xsl:preserve-space elements="g:char"/>
  
  <xsl:template match="g:grammar">
    <html>
      <head>
        <style type="text/css">
          <xsl:apply-templates select="." mode="css"/>
        </style>
      </head>
      <h1><xsl:value-of select="$spec"/>-bnf</h1>
      <h2 class="pathx1">Xpath1 in Orange</h2>
      <h2 class="core">Core in Yellow</h2>
      <h2 class="xquery">XQuery in Red</h2>
      <h2 class="xpath">Xpath2 in Green</h2>
      <h2 class="shared">Shared in Black</h2>
      
      <xsl:variable name="non-terminals" 
        select="g:start[not(@if) or contains(@if,$spec) or $spec='all'] | 
                g:production[not(@if) or contains(@if,$spec) or $spec='all']  |
                g:exprProduction[not(@if) or contains(@if,$spec) or $spec='all'] |
                g:exprProduction[not(@if) or contains(@if,$spec) or $spec='all']/g:level[not(@if) 
                or contains(@if,$spec) or $spec='all']/*[not(@if) or contains(@if,$spec) or $spec='all']"/>
      <h2>NON-TERMINALS</h2>
      <table>
        <xsl:for-each select="$non-terminals">
          <xsl:variable name="name" select="@name"/>
          <xsl:variable name="position" select="position()"/>
          
          <xsl:apply-templates select="." mode="g:tableCells">
            <xsl:with-param name="name" select="$name"/>
            <xsl:with-param name="position" select="$position"/>
          </xsl:apply-templates>
        </xsl:for-each>
      </table>
      <xsl:variable name="non-terminal-count" select="count($non-terminals)"/>
      <br/>
      <h2><a name="id-terminals">TERMINALS</a></h2>
      <table>
        <xsl:for-each select="g:token[not(@if) or contains(@if,$spec) or $spec='all']">
          <xsl:variable name="name" select="@name"/>
          <xsl:variable name="position" select="position()"/>
          
          <xsl:apply-templates select="." mode="g:tableCells">
            <xsl:with-param name="name" select="$name"/>
            <xsl:with-param name="position" select="$position+$non-terminal-count"/>
          </xsl:apply-templates>
        </xsl:for-each>
      </table>
      <h2>TRANSITION STATES</h2>
      <xsl:variable name="token-list" select="g:lexical-state-transitions[not(@if) or contains(@if,$spec) or $spec='all']/g:transition"/>
      <table border="1">
        <tr valign="baseline">
          <th>tokens</th>
          <th>recognize state</th>
          <th>next state</th>
          <th>action</th>
        </tr>
        <xsl:for-each select="$token-list">
          <xsl:apply-templates select="." mode="g:tableCells"/>
        </xsl:for-each>
      </table>
    </html>
  </xsl:template>
  
  <xsl:template match="g:transition" mode="g:tableCells">
    <tr valign="baseline">
      <xsl:call-template name="color-coding-attrs-ancestor"/>
      <td>
        <xsl:value-of select="@refs"/>
      </td>
      <td>
        <xsl:value-of select="@recognize"/>
      </td>
      <td>
        <xsl:value-of select="@nextState"/>
      </td>
      <td>
        <xsl:value-of select="@action"/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="g:grammar" mode="css">
    <xsl:text>.pathx1 { color: orange }</xsl:text>
    <xsl:text>&#10;</xsl:text>
    <xsl:text>.core { color: yellow }</xsl:text>
    <xsl:text>&#10;</xsl:text>
    <xsl:text>.xquery { color: red }</xsl:text>
    <xsl:text>&#10;</xsl:text>
    <xsl:text>.xpath { color: green }</xsl:text>
    <xsl:text>&#10;</xsl:text>
    <xsl:text>.shared { color: black }</xsl:text>
    <xsl:text>&#10;</xsl:text>
  </xsl:template>

  <xsl:template name="color-coding-attrs">
    <xsl:if test="$spec='all'">
      <xsl:choose>
        <xsl:when test="@if and contains(@if, 'xpath') and contains(@if, 'xquery') and contains(@if, 'pathx1')">
          <xsl:attribute name="class">
            <xsl:value-of select="'shared'"/>
          </xsl:attribute>
        </xsl:when>
        <xsl:when test="@if">
          <xsl:attribute name="class">
            <xsl:value-of select="@if"/>
          </xsl:attribute>          
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="class">
            <xsl:value-of select="'shared'"/>
          </xsl:attribute>          
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>   
  </xsl:template>

  <xsl:template name="color-coding-attrs-ancestor">
    <xsl:if test="ancestor-or-self::*/@if and $spec='all'">
      <xsl:attribute name="class">
        <xsl:value-of select="ancestor-or-self::*[@if][1]/@if"/>
      </xsl:attribute>
    </xsl:if>   
  </xsl:template>
	
  <xsl:template match="g:start" mode="g:tableCells">
    <xsl:param name="name"/>
    <xsl:param name="position"/>
    <tr valign="baseline">
      <td>
        <xsl:number value="$position" format="[1]&nbsp;&nbsp;&nbsp;"/>
      </td>
      <td>
        <xsl:value-of select="$spec"/>
      </td>
      <td>&nbsp;&nbsp;&nbsp;::=&nbsp;&nbsp;&nbsp;</td>
      <td>
        <a href="#prod-{$name}">
          <xsl:value-of select="@name"/>
        </a>
      </td>
    </tr>
  </xsl:template>
  
  <xsl:template match="*" mode="g:tableCells">
    <xsl:param name="name"/>
    <xsl:param name="position"/>
    <tr valign="baseline">
      <xsl:call-template name="color-coding-attrs"/>
      <td>
        <a name="prod-{$name}"/>
        <xsl:number value="$position" format="[1]&nbsp;&nbsp;&nbsp;"/>
      </td>
      <td>
        <xsl:if test="self::g:token">&lt;</xsl:if>
        <xsl:value-of select="$name"/>
        <xsl:if test="self::g:token">&gt;</xsl:if>
      </td>
      <td>&nbsp;&nbsp;&nbsp;::=&nbsp;&nbsp;&nbsp;</td>
      <td>
        <xsl:apply-templates select="."/>
      </td>
    </tr>
  </xsl:template>
  
  <xsl:template match="*">
    <xsl:apply-templates select="*[not(@if) or contains(@if,$spec) or $spec='all']"/>
  </xsl:template>
  
  <xsl:template match="g:string">
    <xsl:if test="not(@if) or contains(@if,$spec) or $spec='all'">
      <xsl:choose>
        <xsl:when test=".='&quot;' or .=&quot;'&quot;">
          <xsl:text>[</xsl:text>
          <xsl:value-of select="."/>
          <xsl:text>]</xsl:text>
        </xsl:when>
        <xsl:when test="contains(.,'&quot;')">
          <xsl:text>'</xsl:text>
          <xsl:value-of select="."/>
          <xsl:text>'</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>"</xsl:text>
          <xsl:value-of select="."/>
          <xsl:text>"</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="g:complement">
    <xsl:if test="not(@if) or contains(@if,$spec) or $spec='all'">
      <xsl:text>[^</xsl:text>
      <xsl:apply-templates select="g:charClass/*[not(@if) or contains(@if,$spec) or $spec='all']"/>
      <xsl:text>]</xsl:text>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="g:charClass">
    <xsl:if test="not(@if) or contains(@if,$spec) or $spec='all'">
      <xsl:text>[</xsl:text>
      <xsl:apply-templates select="*[not(@if) or contains(@if,$spec) or $spec='all']"/>
      <xsl:text>]</xsl:text>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="g:charCode">
    <xsl:if test="not(@if) or contains(@if,$spec) or $spec='all'">
      <xsl:text>&amp;#x</xsl:text>
      <xsl:value-of select="@value"/>
      <xsl:text>;</xsl:text>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="g:char">
    <xsl:if test="not(@if) or contains(@if,$spec) or $spec='all'">
      <xsl:value-of select="."/>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="g:charRange">
    <xsl:if test="not(@if) or contains(@if,$spec) or $spec='all'">
      <xsl:value-of select="@minChar"/>
      <xsl:text>-</xsl:text>
      <xsl:value-of select="@maxChar"/>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="g:charCodeRange">
    <xsl:if test="not(@if) or contains(@if,$spec) or $spec='all'">
      <xsl:text>&amp;#x</xsl:text>
      <xsl:value-of select="@minValue"/>
      <xsl:text>;-&amp;#x</xsl:text>
      <xsl:value-of select="@maxValue"/>
      <xsl:text>;</xsl:text>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="g:production|g:token|g:primary">
    <xsl:if test="not(@if) or contains(@if,$spec) or $spec='all'">
      <xsl:call-template name="g:group">
        <xsl:with-param name="conn-cur" select="$conn-top"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="*" mode="rest"/>
  
  <xsl:template match="g:exprProduction">
    <xsl:if test="not(@if) or contains(@if,$spec) or $spec='all'">
      <xsl:for-each select="g:level[not(@if) or contains(@if,$spec) or $spec='all']/*[not(@if) or contains(@if,$spec) or $spec='all']">
        <xsl:if test="position()!=1">
          <br/>
          <xsl:text>|&nbsp;&nbsp;</xsl:text>
        </xsl:if>
        <xsl:variable name="name" select="@name"/>
        <a href="#prod-{$name}">
          <xsl:call-template name="color-coding-attrs"/>
          <xsl:value-of select="$name"/>
        </a>
      </xsl:for-each>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="g:binary">
    <xsl:if test="not(@if) or contains(@if,$spec) or $spec='all'">
      <xsl:variable name="name" select="@name"/>
      <xsl:variable name="levels" select="../../g:level[*[not(@if) or contains(@if,$spec) or $spec='all']]"/>
      <xsl:for-each select="$levels">
        <xsl:if test="*[not(@if) or contains(@if,$spec) or $spec='all']/@name=$name">
          <xsl:variable name="position" select="position()"/>
          <xsl:variable name="nextProd" select="$levels[$position+1]/*/@name"/>
          <xsl:for-each select="*[not(@if) or contains(@if,$spec) or $spec='all']">
            <a href="#prod-{$name}">
              <xsl:call-template name="color-coding-attrs"/>
              <xsl:value-of select="$nextProd"/>
            </a>
            <xsl:text>&nbsp;&nbsp;</xsl:text>
            <xsl:call-template name="g:group">
              <xsl:with-param name="conn-cur" select="$conn-seq"/>
            </xsl:call-template>
            <xsl:text>&nbsp;&nbsp;</xsl:text>
            <a href="#prod-{$name}">
              <xsl:call-template name="color-coding-attrs"/>
              <xsl:value-of select="$nextProd"/>
            </a>
          </xsl:for-each>
        </xsl:if>
      </xsl:for-each>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="g:prefix">
    <xsl:if test="not(@if) or contains(@if,$spec) or $spec='all'">
      <xsl:variable name="name" select="../../@name"/>
      <xsl:call-template name="g:group">
        <xsl:with-param name="conn-cur" select="$conn-seq"/>
      </xsl:call-template>
      <xsl:text>&nbsp;&nbsp;</xsl:text>
      <a href="#prod-{$name}">
        <xsl:call-template name="color-coding-attrs"/>
        <xsl:value-of select="$name"/>
      </a>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="g:postfix">
    <xsl:if test="not(@if) or contains(@if,$spec) or $spec='all'">
      <xsl:variable name="name" select="../../@name"/>
      <a href="#prod-{$name}">
        <xsl:call-template name="color-coding-attrs"/>
        <xsl:value-of select="$name"/>
      </a>
      <xsl:text>&nbsp;&nbsp;</xsl:text>
      <xsl:call-template name="g:group">
        <xsl:with-param name="conn-cur" select="$conn-seq"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="g:optional">
    <xsl:if test="not(@if) or contains(@if,$spec) or $spec='all'">
      <xsl:call-template name="g:group"/>
      <xsl:text>?</xsl:text>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="g:zeroOrMore">
    <xsl:if test="not(@if) or contains(@if,$spec) or $spec='all'">
      <xsl:call-template name="g:group"/>
      <xsl:text>*</xsl:text>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="g:oneOrMore">
    <xsl:if test="not(@if) or contains(@if,$spec) or $spec='all'">
      <xsl:call-template name="g:group"/>
      <xsl:text>+</xsl:text>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="g:sequence">
    <xsl:param name="conn-cur" select="$conn-none"/>
    <xsl:param name="conn-new" select="$conn-seq"/>
    <xsl:if test="not(@if) or contains(@if,$spec) or $spec='all'">
      <xsl:call-template name="g:group">
        <xsl:with-param name="conn-new" select="$conn-seq"/>
        <xsl:with-param name="conn-cur" select="$conn-cur"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="g:choice">
    <xsl:param name="conn-cur" select="$conn-none"/>
    <xsl:param name="conn-new" select="$conn-seq"/>
    <xsl:if test="not(@if) or contains(@if,$spec) or $spec='all'">
      <xsl:call-template name="g:group">
        <xsl:with-param name="conn-new" select="$conn-or"/>
        <xsl:with-param name="conn-cur" select="$conn-cur"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="g:ref">
    <xsl:param name="conn-cur" select="$conn-none"/>
    <xsl:param name="conn-new" select="$conn-seq"/>
    <xsl:if test="not(@if) or contains(@if,$spec) or $spec='all'">
      <xsl:variable name="name" select="@name"/>
      <xsl:variable name="target" select="key('ref',$name)
                                          [self::g:token
                                          and (not(@if) or contains(@if,$spec) or $spec='all')
                                          and not(@inline='false')]"/>
      <xsl:choose>
        <xsl:when test="not($target)">
          <a href="#prod-{$name}">
            <xsl:call-template name="color-coding-attrs"/>
            <xsl:value-of select="$name"/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:for-each select="$target[not(@if) or contains(@if,$spec) or $spec='all']">
            <xsl:call-template name="g:group">
              <xsl:with-param name="conn-new" select="$conn-seq"/>
              <xsl:with-param name="conn-cur" select="$conn-cur"/>
            </xsl:call-template>
          </xsl:for-each>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>

  <xsl:template match="g:next">
    <!-- The assumption is this we're in a exprProduction, 
         in a prefix, primary, etc., and want to call the next level. -->  
    <xsl:variable name="name" select="ancestor::g:primary/@name | ancestor::g:prefix/@name"/>

    <a href="#prod-{$name}">
        <xsl:call-template name="color-coding-attrs"/>
        <xsl:value-of select="$name"/>
    </a>
  </xsl:template>
  
  <xsl:variable name="conn-none" select="0"/>
  <xsl:variable name="conn-or" select="1"/>
  <xsl:variable name="conn-seq" select="2"/>
  <xsl:variable name="conn-top" select="3"/>
  
  <xsl:template name="g:group">
    <xsl:param name="conn-cur" select="$conn-none"/>
    <xsl:param name="conn-new" select="$conn-seq"/>
    <xsl:if test="not(@if) or contains(@if,$spec) or $spec='all'">
      <xsl:choose>
        <xsl:when test="count(*[not(@if) or contains(@if,$spec) or $spec='all'])>1
          and $conn-new != $conn-cur
          and $conn-cur != $conn-top">
          <xsl:text>(</xsl:text>
          <xsl:call-template name="g:group">
            <xsl:with-param name="conn-new" select="$conn-new"/>
            <xsl:with-param name="conn-cur" select="$conn-new"/>
          </xsl:call-template>
          <xsl:text>)</xsl:text>
        </xsl:when>
        <xsl:when test="count(*[not(@if) or contains(@if,$spec) or $spec='all'])>1">
          <xsl:for-each select="*[not(self::g:optionalSkip|self::g:requiredSkip)][not(@if) or contains(@if,$spec) or $spec='all']">
            <xsl:if test="position() != 1">
              <xsl:choose>
                <xsl:when test="$conn-new=$conn-seq">&nbsp;&nbsp;</xsl:when>
                <xsl:when test="../@break[.='true']">
                  <br/>|&nbsp;&nbsp;</xsl:when>
                  <xsl:otherwise>&nbsp;&nbsp;|&nbsp;&nbsp;</xsl:otherwise>
                </xsl:choose>
              </xsl:if>
              <xsl:apply-templates select=".">
                <xsl:with-param name="conn-new" select="$conn-new"/>
                <xsl:with-param name="conn-cur" select="$conn-new"/>
              </xsl:apply-templates>
            </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="*[not(@if) or contains(@if,$spec) or $spec='all']">
              <xsl:with-param name="conn-new" select="$conn-new"/>
              <xsl:with-param name="conn-cur" select="$conn-cur"/>
            </xsl:apply-templates>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>
    </xsl:template>
    
  </xsl:stylesheet>
