<?xml version="1.0" encoding="utf-8"?>

<!--
 * Copyright (c) 2002 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:param name="spec" select="'xquery'"/>
  <xsl:output method="html"/>

  <xsl:template match="@*|node()">
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
  </xsl:template>

  <xsl:template name="which-spec">
    <xsl:choose>
      <xsl:when test="$spec='xquery'">
        <xsl:text>XQuery 1.0</xsl:text>
      </xsl:when>
      <xsl:when test="$spec='xpath'">
        <xsl:text>XPath 2.0</xsl:text>
      </xsl:when>
      <xsl:when test="$spec='pathx1'">
        <xsl:text>XPath 1.0</xsl:text>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="body">
    <xsl:copy>
      <h1>
        <a>
          <xsl:attribute name="href">
            <xsl:choose>
              <xsl:when test="$spec='xquery'">
                <xsl:text>http://www.w3.org/TR/xquery/#nt-bnf</xsl:text>
              </xsl:when>
              <xsl:when test="$spec='xpath'">
                <xsl:text>http://www.w3.org/TR/xpath20/#nt-bnf</xsl:text>
              </xsl:when>
              <xsl:when test="$spec='pathx1'">
                <xsl:text>http://www.w3.org/TR/xpath.html#location-paths</xsl:text>
              </xsl:when>
            </xsl:choose>
          </xsl:attribute>
          
          <xsl:call-template name="which-spec"/>
        </a>
        <xsl:text> Grammar Test Page</xsl:text>
      </h1>
      <xsl:variable name="spec-uri-part">
        <xsl:choose>
          <xsl:when test="$spec='xquery'">
            <xsl:text>xquery</xsl:text>
          </xsl:when>
          <xsl:when test="$spec='xpath'">
            <xsl:text>xpath20</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>##ERROR##</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <p>This page is meant to be a tool for readers and parser implementers of 
      <a href="http://www.w3.org/TR/2002/WD-{$spec-uri-part}-20020816/"><xsl:call-template name="which-spec"/></a>. 
      It allows them to type in an expression, and then view the parse tree, or else obtain an error if it is syntactically incorrect.  
      The results should not be used as an absolute reference, and may flag legal syntax or errors not intended by the drafts.  
      However, the parser used was generated by processing the <a>
        <xsl:attribute name="href">
          <xsl:text>xpath-grammar.xml</xsl:text>
        </xsl:attribute>
        <xsl:text>XML representation of the grammar</xsl:text>
      </a>, which is also used to produce the EBNF productions in the XPath and XQuery drafts.  This parser is also used by the 
          working groups to validate the integrity of the grammar.  Implementers may wish to 
      <a>
        <xsl:attribute name="href">
          <xsl:text>xgrammar.zip</xsl:text>
        </xsl:attribute>
        <xsl:text>download the XPath 2.0/XQuery 1.0 Parser Build</xsl:text>
      </a> if they are interested in the parser production, and more details of this process.
      </p>
      
      <xsl:text>&#160;&#160; </xsl:text>
      
      <xsl:text>&#160;&#160; </xsl:text>
      <a>
        <xsl:attribute name="href">
          <xsl:value-of select="$spec"/>
          <xsl:text>-bnf.html</xsl:text>
        </xsl:attribute>
        <xsl:text>View </xsl:text>
        <xsl:value-of select="$spec"/>
        <xsl:text> BNF</xsl:text>
      </a>
      <xsl:text>&#160;&#160; </xsl:text>
      <a>
        <xsl:attribute name="href">
          <xsl:value-of select="$spec"/>
          <xsl:text>-jjdoc.html</xsl:text>
        </xsl:attribute>
        <xsl:text>View </xsl:text>
        <xsl:value-of select="$spec"/>
        <xsl:text> JJDOC BNF</xsl:text>
      </a>
      <xsl:if test="$spec='xquery'">
        <xsl:text>&#160;&#160; </xsl:text>
        <a>
          <xsl:attribute name="href">
            <xsl:value-of select="$spec"/>
            <xsl:text>-usecases.txt</xsl:text>
          </xsl:attribute>
          <xsl:text>View </xsl:text>
          <xsl:value-of select="$spec"/>
          <xsl:text> use cases</xsl:text>
        </a>      
      </xsl:if>
      <xsl:text>&#160;&#160; </xsl:text>
      <br/>

      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="applet[@code='XPathApplet.class']">
    <xsl:copy>
      <xsl:attribute name="archive">
        <xsl:value-of select="$spec"/>
        <xsl:text>.zip</xsl:text>
      </xsl:attribute>
      
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="spec">
    <xsl:call-template name="which-spec"/>
  </xsl:template>

  <xsl:template match="title">
    <xsl:copy>
      <xsl:call-template name="which-spec"/>
      <xsl:text> Grammar Test Page</xsl:text>
    </xsl:copy>
  </xsl:template>
  
</xsl:stylesheet>
