/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPool;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.AttributeInfo;

public class AttributeInfoList {
    protected AttributeInfo[] attributes;
    protected ConstantPool constantPool;

    public AttributeInfoList(ConstantPool pool) {
        this.constantPool = pool;
    }

    public void read(DataInputStream dis) throws IOException {
        int attributes_count = dis.readUnsignedShort();
        this.attributes = new AttributeInfo[attributes_count];
        int i = 0;
        while (i < attributes_count) {
            short attr_id = dis.readShort();
            this.attributes[i] = AttributeInfo.newAttribute(attr_id, dis, this.constantPool);
            ++i;
        }
    }

    public AttributeInfo[] getAttributes() {
        return this.attributes;
    }

    public AttributeInfo getAttribute(String name) {
        int i = 0;
        while (i < this.attributes.length) {
            if (name.equals(this.attributes[i].getName())) {
                return this.attributes[i];
            }
            ++i;
        }
        return null;
    }

    public int size() {
        return this.attributes.length;
    }
}

