/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPool;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.FieldInfo;

public class FieldInfoList {
    protected ConstantPool constantPool;
    protected FieldInfo[] fields;

    public FieldInfoList(ConstantPool pool) {
        this.constantPool = pool;
    }

    public void read(DataInputStream dis) throws IOException {
        short numFields = dis.readShort();
        this.fields = new FieldInfo[numFields];
        int i = 0;
        while (i < this.fields.length) {
            this.fields[i] = new FieldInfo(this.constantPool);
            this.fields[i].read(dis);
            ++i;
        }
    }

    public String getFieldName(int index) {
        return this.getField(index).getName();
    }

    public FieldInfo getField(int index) {
        return this.fields[index];
    }

    public int length() {
        return this.fields.length;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Fields: ").append(this.fields.length).append("\n");
        int i = 0;
        while (i < this.fields.length) {
            sb.append("\t");
            sb.append(this.getField(i).toString());
            ++i;
        }
        return sb.toString();
    }
}

