/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.depend;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFile;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFileUtils;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Depend
extends MatchingTask {
    private Path srcPath;
    private Path destPath;
    private File cache;
    private Hashtable affectedClassMap;
    private Hashtable classFileInfoMap;
    private Hashtable classpathDependencies;
    private Hashtable outOfDateClasses;
    private boolean closure = false;
    private boolean dump = false;
    private Path dependClasspath;
    private static final String CACHE_FILE_NAME = "dependencies.txt";
    private static final String CLASSNAME_PREPEND = "||:";

    public void setClasspath(Path classpath) {
        if (this.dependClasspath == null) {
            this.dependClasspath = classpath;
        } else {
            this.dependClasspath.append(classpath);
        }
    }

    public Path getClasspath() {
        return this.dependClasspath;
    }

    public Path createClasspath() {
        if (this.dependClasspath == null) {
            this.dependClasspath = new Path(((ProjectComponent)this).project);
        }
        return this.dependClasspath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Hashtable readCachedDependencies() throws IOException {
        Hashtable dependencyMap = new Hashtable();
        if (this.cache == null) return dependencyMap;
        File depFile = new File(this.cache, CACHE_FILE_NAME);
        BufferedReader in = null;
        if (!depFile.exists()) return dependencyMap;
        try {
            in = new BufferedReader(new FileReader(depFile));
            String line = null;
            Vector<String> dependencyList = null;
            String className = null;
            int prependLength = CLASSNAME_PREPEND.length();
            while ((line = in.readLine()) != null) {
                if (line.startsWith(CLASSNAME_PREPEND)) {
                    dependencyList = new Vector<String>();
                    className = line.substring(prependLength);
                    dependencyMap.put(className, dependencyList);
                    continue;
                }
                dependencyList.addElement(line);
            }
            Object var9_8 = null;
            if (in == null) return dependencyMap;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        in.close();
        return dependencyMap;
    }

    private void writeCachedDependencies(Hashtable dependencyMap) throws IOException {
        if (this.cache != null) {
            PrintWriter pw = null;
            try {
                this.cache.mkdirs();
                File depFile = new File(this.cache, CACHE_FILE_NAME);
                pw = new PrintWriter(new FileWriter(depFile));
                Enumeration deps = dependencyMap.keys();
                while (deps.hasMoreElements()) {
                    String className = (String)deps.nextElement();
                    pw.println(CLASSNAME_PREPEND + className);
                    Vector dependencyList = (Vector)dependencyMap.get(className);
                    int size = dependencyList.size();
                    int x = 0;
                    while (x < size) {
                        pw.println(dependencyList.elementAt(x));
                        ++x;
                    }
                }
                Object var10_9 = null;
                if (pw != null) {
                    pw.close();
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (pw != null) {
                    pw.close();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void determineDependencies() throws IOException {
        Hashtable dependencyMap;
        boolean cacheDirty;
        block21: {
            Enumeration e;
            Object nullFileMarker;
            Hashtable<String, void> classpathFileCache;
            AntClassLoader loader;
            this.affectedClassMap = new Hashtable();
            this.classFileInfoMap = new Hashtable();
            cacheDirty = false;
            dependencyMap = null;
            File depCacheFile = null;
            boolean depCacheFileExists = true;
            long depCacheFileLastModified = Long.MAX_VALUE;
            if (this.cache != null) {
                dependencyMap = this.readCachedDependencies();
                depCacheFile = new File(this.cache, CACHE_FILE_NAME);
                depCacheFileExists = depCacheFile.exists();
                depCacheFileLastModified = depCacheFile.lastModified();
            }
            Enumeration e2 = this.getClassFiles(this.destPath).elements();
            block2: while (true) {
                Vector dependencyList;
                ClassFileInfo info;
                block22: {
                    if (!e2.hasMoreElements()) {
                        this.classpathDependencies = null;
                        if (this.dependClasspath != null) {
                            this.classpathDependencies = new Hashtable();
                            loader = new AntClassLoader(this.getProject(), this.dependClasspath);
                            classpathFileCache = new Hashtable<String, void>();
                            nullFileMarker = new Object();
                            e = dependencyMap.keys();
                            break;
                        }
                        break block21;
                    }
                    info = (ClassFileInfo)e2.nextElement();
                    this.log("Adding class info for " + info.className, 4);
                    this.classFileInfoMap.put(info.className, info);
                    dependencyList = null;
                    if (this.cache != null && depCacheFileExists && depCacheFileLastModified > info.absoluteFile.lastModified()) {
                        dependencyList = (Vector)dependencyMap.get(info.className);
                    }
                    if (dependencyList == null) {
                        Object var13_13;
                        FileInputStream inFileStream = null;
                        try {
                            inFileStream = new FileInputStream(info.absoluteFile);
                            ClassFile classFile = new ClassFile();
                            classFile.read(inFileStream);
                            dependencyList = classFile.getClassRefs();
                            if (dependencyList != null) {
                                cacheDirty = true;
                                dependencyMap.put(info.className, dependencyList);
                            }
                            var13_13 = null;
                            if (inFileStream == null) break block22;
                        }
                        catch (Throwable throwable) {
                            var13_13 = null;
                            if (inFileStream != null) {
                                inFileStream.close();
                            }
                            throw throwable;
                        }
                        inFileStream.close();
                    }
                }
                Enumeration depEnum = dependencyList.elements();
                while (true) {
                    if (!depEnum.hasMoreElements()) continue block2;
                    String dependentClass = (String)depEnum.nextElement();
                    Hashtable<String, ClassFileInfo> affectedClasses = (Hashtable<String, ClassFileInfo>)this.affectedClassMap.get(dependentClass);
                    if (affectedClasses == null) {
                        affectedClasses = new Hashtable<String, ClassFileInfo>();
                        this.affectedClassMap.put(dependentClass, affectedClasses);
                    }
                    affectedClasses.put(info.className, info);
                }
                break;
            }
            while (e.hasMoreElements()) {
                String className = (String)e.nextElement();
                Vector dependencyList = (Vector)dependencyMap.get(className);
                Hashtable<File, File> dependencies = new Hashtable<File, File>();
                this.classpathDependencies.put(className, dependencies);
                Enumeration e22 = dependencyList.elements();
                while (e22.hasMoreElements()) {
                    void var17_17;
                    String dependency = (String)e22.nextElement();
                    Object v = classpathFileCache.get(dependency);
                    if (v == null) {
                        void var17_22;
                        URL classURL;
                        Object object = nullFileMarker;
                        if (!dependency.startsWith("java.") && !dependency.startsWith("javax.") && (classURL = loader.getResource(dependency.replace('.', '/') + ".class")) != null) {
                            if (classURL.getProtocol().equals("jar")) {
                                String jarFilePath = classURL.getFile();
                                if (jarFilePath.startsWith("file:")) {
                                    int classMarker = jarFilePath.indexOf(33);
                                    jarFilePath = jarFilePath.substring(5, classMarker);
                                }
                                File file = new File(jarFilePath);
                            } else if (classURL.getProtocol().equals("file")) {
                                String classFilePath = classURL.getFile();
                                File file = new File(classFilePath);
                            }
                            this.log("Class " + className + " depends on " + var17_22 + " due to " + dependency, 4);
                        }
                        classpathFileCache.put(dependency, var17_22);
                    }
                    if (var17_17 == null || var17_17 == nullFileMarker) continue;
                    File jarFile = (File)var17_17;
                    dependencies.put(jarFile, jarFile);
                }
            }
        }
        if (this.cache != null && cacheDirty) {
            this.writeCachedDependencies(dependencyMap);
        }
    }

    private int deleteAllAffectedFiles() {
        int count = 0;
        Enumeration e = this.outOfDateClasses.elements();
        while (e.hasMoreElements()) {
            String className = (String)e.nextElement();
            count += this.deleteAffectedFiles(className);
            ClassFileInfo classInfo = (ClassFileInfo)this.classFileInfoMap.get(className);
            if (classInfo == null || !classInfo.absoluteFile.exists()) continue;
            classInfo.absoluteFile.delete();
            ++count;
        }
        return count;
    }

    private int deleteAffectedFiles(String className) {
        int count = 0;
        Hashtable affectedClasses = (Hashtable)this.affectedClassMap.get(className);
        if (affectedClasses != null) {
            Enumeration e = affectedClasses.keys();
            while (e.hasMoreElements()) {
                String affectedClassName = (String)e.nextElement();
                ClassFileInfo affectedClassInfo = (ClassFileInfo)affectedClasses.get(affectedClassName);
                if (!affectedClassInfo.absoluteFile.exists()) continue;
                this.log("Deleting file " + affectedClassInfo.absoluteFile.getPath() + " since " + className + " out of date", 3);
                affectedClassInfo.absoluteFile.delete();
                ++count;
                if (this.closure) {
                    count += this.deleteAffectedFiles(affectedClassName);
                    continue;
                }
                if (affectedClassName.indexOf("$") == -1) continue;
                String topLevelClassName = affectedClassName.substring(0, affectedClassName.indexOf("$"));
                this.log("Top level class = " + topLevelClassName, 3);
                ClassFileInfo topLevelClassInfo = (ClassFileInfo)this.classFileInfoMap.get(topLevelClassName);
                if (topLevelClassInfo == null || !topLevelClassInfo.absoluteFile.exists()) continue;
                this.log("Deleting file " + topLevelClassInfo.absoluteFile.getPath() + " since " + "one of its inner classes was removed", 3);
                topLevelClassInfo.absoluteFile.delete();
                ++count;
                if (!this.closure) continue;
                count += this.deleteAffectedFiles(topLevelClassName);
            }
        }
        return count;
    }

    public void execute() throws BuildException {
        try {
            String className;
            Enumeration e;
            long start = System.currentTimeMillis();
            String[] srcPathList = this.srcPath.list();
            if (srcPathList.length == 0) {
                throw new BuildException("srcdir attribute must be set!", ((Task)this).location);
            }
            if (this.destPath == null) {
                this.destPath = this.srcPath;
            }
            if (this.cache != null && this.cache.exists() && !this.cache.isDirectory()) {
                throw new BuildException("The cache, if specified, must point to a directory");
            }
            if (this.cache != null && !this.cache.exists()) {
                this.cache.mkdirs();
            }
            this.determineDependencies();
            if (this.dump) {
                this.log("Reverse Dependency Dump for " + this.affectedClassMap.size() + " classes:", 4);
                Enumeration e2 = this.affectedClassMap.keys();
                while (e2.hasMoreElements()) {
                    String className2 = (String)e2.nextElement();
                    this.log(" Class " + className2 + " affects:", 4);
                    Hashtable affectedClasses = (Hashtable)this.affectedClassMap.get(className2);
                    Enumeration e22 = affectedClasses.keys();
                    while (e22.hasMoreElements()) {
                        String affectedClass = (String)e22.nextElement();
                        ClassFileInfo info = (ClassFileInfo)affectedClasses.get(affectedClass);
                        this.log("    " + affectedClass + " in " + info.absoluteFile.getPath(), 4);
                    }
                }
                if (this.classpathDependencies != null) {
                    this.log("Classpath file dependencies (Forward):", 4);
                    e = this.classpathDependencies.keys();
                    while (e.hasMoreElements()) {
                        className = (String)e.nextElement();
                        this.log(" Class " + className + " depends on:", 4);
                        Hashtable dependencies = (Hashtable)this.classpathDependencies.get(className);
                        Enumeration e23 = dependencies.elements();
                        while (e23.hasMoreElements()) {
                            File classpathFile = (File)e23.nextElement();
                            this.log("    " + classpathFile.getPath(), 4);
                        }
                    }
                }
            }
            this.outOfDateClasses = new Hashtable();
            int i = 0;
            while (i < srcPathList.length) {
                File srcDir = ((ProjectComponent)this).project.resolveFile(srcPathList[i]);
                if (srcDir.exists()) {
                    DirectoryScanner ds = this.getDirectoryScanner(srcDir);
                    String[] files = ds.getIncludedFiles();
                    this.scanDir(srcDir, files);
                }
                ++i;
            }
            if (this.classpathDependencies != null) {
                e = this.classpathDependencies.keys();
                block7: while (e.hasMoreElements()) {
                    className = (String)e.nextElement();
                    if (this.outOfDateClasses.containsKey(className)) continue;
                    ClassFileInfo info = (ClassFileInfo)this.classFileInfoMap.get(className);
                    Hashtable dependencies = (Hashtable)this.classpathDependencies.get(className);
                    Enumeration e2 = dependencies.elements();
                    while (e2.hasMoreElements()) {
                        File classpathFile = (File)e2.nextElement();
                        if (classpathFile.lastModified() <= info.absoluteFile.lastModified()) continue;
                        this.log("Class " + className + " is out of date with respect to " + classpathFile, 4);
                        this.outOfDateClasses.put(className, className);
                        continue block7;
                    }
                }
            }
            int count = this.deleteAllAffectedFiles();
            long duration = (System.currentTimeMillis() - start) / 1000L;
            this.log("Deleted " + count + " out of date files in " + duration + " seconds");
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected void scanDir(File srcDir, String[] files) {
        long now = System.currentTimeMillis();
        int i = 0;
        while (i < files.length) {
            File srcFile = new File(srcDir, files[i]);
            if (files[i].endsWith(".java")) {
                String filePath = srcFile.getPath();
                String className = filePath.substring(srcDir.getPath().length() + 1, filePath.length() - ".java".length());
                ClassFileInfo info = (ClassFileInfo)this.classFileInfoMap.get(className = ClassFileUtils.convertSlashName(className));
                if (info == null) {
                    this.outOfDateClasses.put(className, className);
                } else if (srcFile.lastModified() > info.absoluteFile.lastModified()) {
                    this.outOfDateClasses.put(className, className);
                }
            }
            ++i;
        }
    }

    private Vector getClassFiles(Path classLocations) {
        String[] classLocationsList = classLocations.list();
        Vector classFileList = new Vector();
        int i = 0;
        while (i < classLocationsList.length) {
            File dir = new File(classLocationsList[i]);
            if (dir.isDirectory()) {
                this.addClassFiles(classFileList, dir, dir);
            }
            ++i;
        }
        return classFileList;
    }

    private void addClassFiles(Vector classFileList, File dir, File root) {
        String[] filesInDir = dir.list();
        if (filesInDir != null) {
            int length = filesInDir.length;
            int i = 0;
            while (i < length) {
                File file = new File(dir, filesInDir[i]);
                if (file.isDirectory()) {
                    this.addClassFiles(classFileList, file, root);
                } else if (file.getName().endsWith(".class")) {
                    ClassFileInfo info = new ClassFileInfo();
                    info.absoluteFile = file;
                    info.relativeName = file.getPath().substring(root.getPath().length() + 1, file.getPath().length() - 6);
                    info.className = ClassFileUtils.convertSlashName(info.relativeName);
                    classFileList.addElement(info);
                }
                ++i;
            }
        }
    }

    public void setSrcdir(Path srcPath) {
        this.srcPath = srcPath;
    }

    public void setDestDir(Path destPath) {
        this.destPath = destPath;
    }

    public void setCache(File cache) {
        this.cache = cache;
    }

    public void setClosure(boolean closure) {
        this.closure = closure;
    }

    public void setDump(boolean dump) {
        this.dump = dump;
    }

    private static class ClassFileInfo {
        public File absoluteFile;
        public String relativeName;
        public String className;

        private ClassFileInfo() {
        }
    }
}

