/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.PrintStream;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildLogger;

public class DefaultLogger
implements BuildLogger {
    private static int LEFT_COLUMN_SIZE = 12;
    protected PrintStream out;
    protected PrintStream err;
    protected int msgOutputLevel = 0;
    private long startTime = System.currentTimeMillis();
    protected static String lSep = System.getProperty("line.separator");
    protected boolean emacsMode = false;

    public void setMessageOutputLevel(int n) {
        this.msgOutputLevel = n;
    }

    public void setOutputPrintStream(PrintStream printStream) {
        this.out = printStream;
    }

    public void setErrorPrintStream(PrintStream printStream) {
        this.err = printStream;
    }

    public void setEmacsMode(boolean bl) {
        this.emacsMode = bl;
    }

    public void buildStarted(BuildEvent buildEvent) {
        this.startTime = System.currentTimeMillis();
    }

    public void buildFinished(BuildEvent buildEvent) {
        Throwable throwable = buildEvent.getException();
        if (throwable == null) {
            this.out.println(lSep + "BUILD SUCCESSFUL");
        } else {
            this.err.println(lSep + "BUILD FAILED" + lSep);
            if (3 <= this.msgOutputLevel || !(throwable instanceof BuildException)) {
                throwable.printStackTrace(this.err);
            } else if (throwable instanceof BuildException) {
                this.err.println(throwable.toString());
            } else {
                this.err.println(throwable.getMessage());
            }
        }
        this.out.println(lSep + "Total time: " + DefaultLogger.formatTime(System.currentTimeMillis() - this.startTime));
    }

    public void targetStarted(BuildEvent buildEvent) {
        if (2 <= this.msgOutputLevel) {
            this.out.println(lSep + buildEvent.getTarget().getName() + ":");
        }
    }

    public void targetFinished(BuildEvent buildEvent) {
    }

    public void taskStarted(BuildEvent buildEvent) {
    }

    public void taskFinished(BuildEvent buildEvent) {
    }

    public void messageLogged(BuildEvent buildEvent) {
        PrintStream printStream;
        PrintStream printStream2 = printStream = buildEvent.getPriority() == 0 ? this.err : this.out;
        if (buildEvent.getPriority() <= this.msgOutputLevel) {
            if (buildEvent.getTask() != null) {
                String string = buildEvent.getTask().getTaskName();
                if (!this.emacsMode) {
                    String string2 = "[" + string + "] ";
                    int n = 0;
                    while (n < LEFT_COLUMN_SIZE - string2.length()) {
                        printStream.print(" ");
                        ++n;
                    }
                    printStream.print(string2);
                }
            }
            printStream.println(buildEvent.getMessage());
        }
    }

    protected static String formatTime(long l) {
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        if (l3 > 0L) {
            return Long.toString(l3) + " minute" + (l3 == 1L ? " " : "s ") + Long.toString(l2 % 60L) + " second" + (l2 % 60L == 1L ? "" : "s");
        }
        return Long.toString(l2) + " second" + (l2 % 60L == 1L ? "" : "s");
    }
}

