/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.Writer;
import java.util.Stack;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class DOMBuilder
implements ContentHandler,
LexicalHandler {
    public Document m_doc;
    protected Node m_currentNode = null;
    public DocumentFragment m_docFrag = null;
    protected Stack m_elemStack = new Stack();
    protected boolean m_inCData = false;

    public DOMBuilder(Document doc) {
        this.m_doc = doc;
    }

    public DOMBuilder(Document doc, DocumentFragment docFrag) {
        this.m_doc = doc;
        this.m_docFrag = docFrag;
    }

    public DOMBuilder(Document doc, Node node) {
        this.m_doc = doc;
        this.m_currentNode = node;
    }

    protected void append(Node newNode) throws SAXException {
        Node currentNode = this.m_currentNode;
        if (currentNode != null) {
            currentNode.appendChild(newNode);
        } else if (this.m_docFrag != null) {
            this.m_docFrag.appendChild(newNode);
        } else {
            boolean ok = true;
            short type = newNode.getNodeType();
            if (type == 3) {
                String data = newNode.getNodeValue();
                if (data != null && data.trim().length() > 0) {
                    throw new SAXException(XSLMessages.createXPATHMessage(63, null));
                }
                ok = false;
            } else if (type == 1 && this.m_doc.getDocumentElement() != null) {
                throw new SAXException(XSLMessages.createXPATHMessage(64, null));
            }
            if (ok) {
                this.m_doc.appendChild(newNode);
            }
        }
    }

    public void cdata(char[] ch, int start, int length) throws SAXException {
        if (this.isOutsideDocElem() && XMLCharacterRecognizer.isWhiteSpace(ch, start, length)) {
            return;
        }
        String s = new String(ch, start, length);
        this.append(this.m_doc.createCDATASection(s));
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isOutsideDocElem() && XMLCharacterRecognizer.isWhiteSpace(ch, start, length)) {
            return;
        }
        if (this.m_inCData) {
            this.cdata(ch, start, length);
            return;
        }
        String s = new String(ch, start, length);
        Text text = this.m_doc.createTextNode(s);
        this.append(text);
    }

    public void charactersRaw(char[] ch, int start, int length) throws SAXException {
        if (this.isOutsideDocElem() && XMLCharacterRecognizer.isWhiteSpace(ch, start, length)) {
            return;
        }
        String s = new String(ch, start, length);
        this.append(this.m_doc.createProcessingInstruction("xslt-next-is-raw", "formatter-to-dom"));
        this.append(this.m_doc.createTextNode(s));
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.append(this.m_doc.createComment(new String(ch, start, length)));
    }

    public void endCDATA() throws SAXException {
        this.m_inCData = false;
    }

    public void endDTD() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String ns, String localName, String name) throws SAXException {
        this.m_elemStack.pop();
        this.m_currentNode = this.m_elemStack.isEmpty() ? null : (Node)this.m_elemStack.peek();
    }

    public void endEntity(String name) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void entityReference(String name) throws SAXException {
        this.append(this.m_doc.createEntityReference(name));
    }

    public Node getCurrentNode() {
        return this.m_currentNode;
    }

    public Node getRootNode() {
        return this.m_docFrag != null ? this.m_docFrag : this.m_doc;
    }

    public Writer getWriter() {
        return null;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.isOutsideDocElem()) {
            return;
        }
        String s = new String(ch, start, length);
        this.append(this.m_doc.createTextNode(s));
    }

    private boolean isOutsideDocElem() {
        return this.m_docFrag == null && this.m_elemStack.size() == 0 && (this.m_currentNode == null || this.m_currentNode.getNodeType() == 9);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.append(this.m_doc.createProcessingInstruction(target, data));
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void setIDAttribute(String id, Element elem) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.m_inCData = true;
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String ns, String localName, String name, Attributes atts) throws SAXException {
        Element elem = ns == null || ns.length() == 0 ? this.m_doc.createElement(name) : this.m_doc.createElementNS(ns, name);
        this.append(elem);
        try {
            int nAtts = atts.getLength();
            if (nAtts != 0) {
                int i = 0;
                while (i < nAtts) {
                    String attrNS;
                    if (atts.getType(i).equalsIgnoreCase("ID")) {
                        this.setIDAttribute(atts.getValue(i), elem);
                    }
                    if ((attrNS = atts.getURI(i)) == null) {
                        attrNS = "";
                    }
                    String attrQName = atts.getQName(i);
                    if (attrNS.length() == 0) {
                        elem.setAttribute(attrQName, atts.getValue(i));
                    } else {
                        elem.setAttributeNS(attrNS, attrQName, atts.getValue(i));
                    }
                    ++i;
                }
            }
            this.m_elemStack.push(elem);
            this.m_currentNode = elem;
        }
        catch (Exception de) {
            throw new SAXException(de);
        }
    }

    public void startEntity(String name) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

