/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMAxisIterator;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMManagerDefault;
import org.apache.xml.dtm.ref.DTMNodeProxy;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.SuballocatedIntVector;
import org.apache.xml.utils.XMLString;
import org.apache.xml.utils.XMLStringFactory;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public abstract class DTMDefaultBase
implements DTM {
    protected int m_size = 0;
    protected SuballocatedIntVector m_exptype;
    protected SuballocatedIntVector m_firstch;
    protected SuballocatedIntVector m_nextsib;
    protected SuballocatedIntVector m_prevsib;
    protected SuballocatedIntVector m_parent;
    protected Vector m_namespaceDeclSets = null;
    protected SuballocatedIntVector m_namespaceDeclSetElements = null;
    protected int[][][] m_elemIndexes;
    protected int m_initialblocksize = 512;
    protected int m_blocksize = 2048;
    protected static final int NOTPROCESSED = -2;
    protected DTMManager m_mgr;
    protected int m_dtmIdent;
    protected static final int m_mask = 0x3FFFFF;
    protected String m_documentBaseURI;
    protected DTMWSFilter m_wsfilter;
    protected boolean m_shouldStripWS = false;
    protected BoolStack m_shouldStripWhitespaceStack;
    protected XMLStringFactory m_xstrf;
    public static final int ROOTNODE = 0;
    protected ExpandedNameTable m_expandedNameTable;
    protected boolean m_indexing;
    protected DTMAxisTraverser[] m_traversers;
    private Vector m_namespaceLists = null;

    public DTMDefaultBase(DTMManager mgr, Source source, int dtmIdentity, DTMWSFilter whiteSpaceFilter, XMLStringFactory xstringfactory, boolean doIndexing) {
        if (!doIndexing) {
            this.m_initialblocksize = 8;
            this.m_blocksize = 16;
        }
        this.m_exptype = new SuballocatedIntVector(this.m_initialblocksize);
        this.m_firstch = new SuballocatedIntVector(this.m_initialblocksize);
        this.m_nextsib = new SuballocatedIntVector(this.m_initialblocksize);
        this.m_prevsib = new SuballocatedIntVector(this.m_initialblocksize);
        this.m_parent = new SuballocatedIntVector(this.m_initialblocksize);
        this.m_mgr = mgr;
        this.m_documentBaseURI = source != null ? source.getSystemId() : null;
        this.m_dtmIdent = dtmIdentity;
        this.m_wsfilter = whiteSpaceFilter;
        this.m_xstrf = xstringfactory;
        this.m_indexing = doIndexing;
        if (doIndexing) {
            this.m_expandedNameTable = new ExpandedNameTable();
        } else {
            DTMManagerDefault dmd = (DTMManagerDefault)this.m_mgr;
            this.m_expandedNameTable = dmd.getExpandedNameTable(this);
        }
        if (whiteSpaceFilter != null) {
            this.m_shouldStripWhitespaceStack = new BoolStack();
            this.pushShouldStripWhitespace(false);
        }
    }

    protected int _exptype(int identity) {
        while (identity >= this.m_size) {
            if (this.nextNode() || identity < this.m_size) continue;
            return -1;
        }
        return this.m_exptype.elementAt(identity);
    }

    protected int _firstch(int identity) {
        int info = identity >= this.m_size ? -2 : this.m_firstch.elementAt(identity);
        while (info == -2) {
            boolean isMore = this.nextNode();
            if (identity >= this.m_size && !isMore) {
                return -1;
            }
            info = this.m_firstch.elementAt(identity);
            if (info != -2 || isMore) continue;
            return -1;
        }
        return info;
    }

    protected int _level(int identity) {
        while (identity >= this.m_size) {
            boolean isMore = this.nextNode();
            if (isMore || identity < this.m_size) continue;
            return -1;
        }
        int i = 0;
        while ((identity = this._parent(identity)) != -1) {
            ++i;
        }
        return i;
    }

    protected int _nextsib(int identity) {
        int info = identity >= this.m_size ? -2 : this.m_nextsib.elementAt(identity);
        while (info == -2) {
            boolean isMore = this.nextNode();
            if (identity >= this.m_size && !isMore) {
                return -1;
            }
            info = this.m_nextsib.elementAt(identity);
            if (info != -2 || isMore) continue;
            return -1;
        }
        return info;
    }

    protected int _parent(int identity) {
        if (identity < this.m_size) {
            return this.m_parent.elementAt(identity);
        }
        do {
            boolean isMore = this.nextNode();
            if (identity < this.m_size || isMore) continue;
            return -1;
        } while (identity >= this.m_size);
        return this.m_parent.elementAt(identity);
    }

    protected int _prevsib(int identity) {
        if (identity < this.m_size) {
            return this.m_prevsib.elementAt(identity);
        }
        do {
            boolean isMore = this.nextNode();
            if (identity < this.m_size || isMore) continue;
            return -1;
        } while (identity >= this.m_size);
        return this.m_prevsib.elementAt(identity);
    }

    protected short _type(int identity) {
        int info = this.getExpandedTypeID(identity);
        if (info != -1) {
            return ExpandedNameTable.getType(info);
        }
        return -1;
    }

    public void appendChild(int newChild, boolean clone, boolean cloneDepth) {
        this.error(XSLMessages.createMessage(210, null));
    }

    public void appendTextChild(String str) {
        this.error(XSLMessages.createMessage(210, null));
    }

    protected void declareNamespaceInContext(int elementNodeIndex, int namespaceNodeIndex) {
        SuballocatedIntVector nsList = null;
        if (this.m_namespaceDeclSets == null) {
            this.m_namespaceDeclSetElements = new SuballocatedIntVector();
            this.m_namespaceDeclSetElements.addElement(elementNodeIndex);
            this.m_namespaceDeclSets = new Vector();
            nsList = new SuballocatedIntVector();
            this.m_namespaceDeclSets.addElement(nsList);
        } else {
            int last = this.m_namespaceDeclSetElements.size() - 1;
            if (elementNodeIndex == this.m_namespaceDeclSetElements.elementAt(last)) {
                nsList = (SuballocatedIntVector)this.m_namespaceDeclSets.elementAt(last);
            }
        }
        if (nsList == null) {
            this.m_namespaceDeclSetElements.addElement(elementNodeIndex);
            nsList = new SuballocatedIntVector();
            this.m_namespaceDeclSets.addElement(nsList);
            SuballocatedIntVector inherited = this.findNamespaceContext(this._parent(elementNodeIndex));
            if (inherited != null) {
                int isize = inherited.size();
                int i = 0;
                while (i < isize) {
                    nsList.addElement(inherited.elementAt(i));
                    ++i;
                }
            }
        }
        int newEType = this.getExpandedTypeID(namespaceNodeIndex);
        int i = nsList.size() - 1;
        while (i >= 0) {
            if (newEType == this.getExpandedTypeID(nsList.elementAt(i))) {
                nsList.setElementAt(namespaceNodeIndex | this.m_dtmIdent, i);
                return;
            }
            --i;
        }
        nsList.addElement(namespaceNodeIndex | this.m_dtmIdent);
    }

    public abstract void dispatchCharactersEvents(int var1, ContentHandler var2, boolean var3) throws SAXException;

    public abstract void dispatchToEvents(int var1, ContentHandler var2) throws SAXException;

    public void documentRegistration() {
    }

    public void documentRelease() {
    }

    public void dumpDTM() {
        try {
            File f = new File("DTMDump" + this.hashCode() + ".txt");
            System.err.println("Dumping... " + f.getAbsolutePath());
            PrintStream ps = new PrintStream(new FileOutputStream(f));
            while (this.nextNode()) {
            }
            int nRecords = this.m_size;
            ps.println("Total nodes: " + nRecords);
            int i = 0;
            while (i < nRecords) {
                String typestring;
                ps.println("=========== " + i + " ===========");
                ps.println("NodeName: " + this.getNodeName(i));
                ps.println("NodeNameX: " + this.getNodeNameX(i));
                ps.println("LocalName: " + this.getLocalName(i));
                ps.println("NamespaceURI: " + this.getNamespaceURI(i));
                ps.println("Prefix: " + this.getPrefix(i));
                int exTypeID = this.getExpandedTypeID(i);
                ps.println("Expanded Type ID: " + Integer.toHexString(exTypeID));
                short type = this.getNodeType(i);
                switch (type) {
                    case 2: {
                        typestring = "ATTRIBUTE_NODE";
                        break;
                    }
                    case 4: {
                        typestring = "CDATA_SECTION_NODE";
                        break;
                    }
                    case 8: {
                        typestring = "COMMENT_NODE";
                        break;
                    }
                    case 11: {
                        typestring = "DOCUMENT_FRAGMENT_NODE";
                        break;
                    }
                    case 9: {
                        typestring = "DOCUMENT_NODE";
                        break;
                    }
                    case 10: {
                        typestring = "DOCUMENT_NODE";
                        break;
                    }
                    case 1: {
                        typestring = "ELEMENT_NODE";
                        break;
                    }
                    case 6: {
                        typestring = "ENTITY_NODE";
                        break;
                    }
                    case 5: {
                        typestring = "ENTITY_REFERENCE_NODE";
                        break;
                    }
                    case 13: {
                        typestring = "NAMESPACE_NODE";
                        break;
                    }
                    case 12: {
                        typestring = "NOTATION_NODE";
                        break;
                    }
                    case -1: {
                        typestring = "NULL";
                        break;
                    }
                    case 7: {
                        typestring = "PROCESSING_INSTRUCTION_NODE";
                        break;
                    }
                    case 3: {
                        typestring = "TEXT_NODE";
                        break;
                    }
                    default: {
                        typestring = "Unknown!";
                    }
                }
                ps.println("Type: " + typestring);
                int firstChild = this._firstch(i);
                if (firstChild == -1) {
                    ps.println("First child: DTM.NULL");
                } else if (firstChild == -2) {
                    ps.println("First child: NOTPROCESSED");
                } else {
                    ps.println("First child: " + firstChild);
                }
                int prevSibling = this._prevsib(i);
                if (prevSibling == -1) {
                    ps.println("Prev sibling: DTM.NULL");
                } else if (prevSibling == -2) {
                    ps.println("Prev sibling: NOTPROCESSED");
                } else {
                    ps.println("Prev sibling: " + prevSibling);
                }
                int nextSibling = this._nextsib(i);
                if (nextSibling == -1) {
                    ps.println("Next sibling: DTM.NULL");
                } else if (nextSibling == -2) {
                    ps.println("Next sibling: NOTPROCESSED");
                } else {
                    ps.println("Next sibling: " + nextSibling);
                }
                int parent = this._parent(i);
                if (parent == -1) {
                    ps.println("Parent: DTM.NULL");
                } else if (parent == -2) {
                    ps.println("Parent: NOTPROCESSED");
                } else {
                    ps.println("Parent: " + parent);
                }
                int level = this._level(i);
                ps.println("Level: " + level);
                ps.println("Node Value: " + this.getNodeValue(i));
                ps.println("String Value: " + this.getStringValue(i));
                ++i;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    public String dumpNode(int nodeHandle) {
        String typestring;
        if (nodeHandle == -1) {
            return "[null]";
        }
        switch (this.getNodeType(nodeHandle)) {
            case 2: {
                typestring = "ATTR";
                break;
            }
            case 4: {
                typestring = "CDATA";
                break;
            }
            case 8: {
                typestring = "COMMENT";
                break;
            }
            case 11: {
                typestring = "DOC_FRAG";
                break;
            }
            case 9: {
                typestring = "DOC";
                break;
            }
            case 10: {
                typestring = "DOC_TYPE";
                break;
            }
            case 1: {
                typestring = "ELEMENT";
                break;
            }
            case 6: {
                typestring = "ENTITY";
                break;
            }
            case 5: {
                typestring = "ENT_REF";
                break;
            }
            case 13: {
                typestring = "NAMESPACE";
                break;
            }
            case 12: {
                typestring = "NOTATION";
                break;
            }
            case -1: {
                typestring = "null";
                break;
            }
            case 7: {
                typestring = "PI";
                break;
            }
            case 3: {
                typestring = "TEXT";
                break;
            }
            default: {
                typestring = "Unknown!";
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[" + nodeHandle + ": " + typestring + "(0x" + Integer.toHexString(this.getExpandedTypeID(nodeHandle)) + ") " + this.getNodeNameX(nodeHandle) + " {" + this.getNamespaceURI(nodeHandle) + "}" + "=\"" + this.getNodeValue(nodeHandle) + "\"]");
        return sb.toString();
    }

    protected void ensureSizeOfIndex(int namespaceID, int LocalNameID) {
        if (this.m_elemIndexes == null) {
            this.m_elemIndexes = new int[namespaceID + 20][][];
        } else if (this.m_elemIndexes.length <= namespaceID) {
            int[][][] indexes = this.m_elemIndexes;
            this.m_elemIndexes = new int[namespaceID + 20][][];
            System.arraycopy(indexes, 0, this.m_elemIndexes, 0, indexes.length);
        }
        int[][] localNameIndex = this.m_elemIndexes[namespaceID];
        if (localNameIndex == null) {
            localNameIndex = new int[LocalNameID + 100][];
            this.m_elemIndexes[namespaceID] = localNameIndex;
        } else if (localNameIndex.length <= LocalNameID) {
            int[][] indexes = localNameIndex;
            localNameIndex = new int[LocalNameID + 100][];
            System.arraycopy(indexes, 0, localNameIndex, 0, indexes.length);
            this.m_elemIndexes[namespaceID] = localNameIndex;
        }
        int[] elemHandles = localNameIndex[LocalNameID];
        if (elemHandles == null) {
            elemHandles = new int[128];
            localNameIndex[LocalNameID] = elemHandles;
            elemHandles[0] = 1;
        } else if (elemHandles.length <= elemHandles[0] + 1) {
            int[] indexes = elemHandles;
            elemHandles = new int[elemHandles[0] + 1024];
            System.arraycopy(indexes, 0, elemHandles, 0, indexes.length);
            localNameIndex[LocalNameID] = elemHandles;
        }
    }

    protected void error(String msg) {
        throw new DTMException(msg);
    }

    int findElementFromIndex(int nsIndex, int lnIndex, int firstPotential) {
        int pos;
        int[] elems;
        int[][] lnIndexs;
        int[][][] indexes = this.m_elemIndexes;
        if (indexes != null && nsIndex < indexes.length && (lnIndexs = indexes[nsIndex]) != null && lnIndex < lnIndexs.length && (elems = lnIndexs[lnIndex]) != null && (pos = this.findGTE(elems, 1, elems[0], firstPotential)) > -1) {
            return elems[pos];
        }
        return -2;
    }

    protected int findGTE(int[] list, int start, int len, int value) {
        int high;
        int low = start;
        int end = high = start + (len - 1);
        while (low <= high) {
            int mid = (low + high) / 2;
            int c = list[mid];
            if (c > value) {
                high = mid - 1;
                continue;
            }
            if (c < value) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return low <= end && list[low] > value ? low : -1;
    }

    protected int findInSortedSuballocatedIntVector(SuballocatedIntVector vector, int lookfor) {
        int i = 0;
        if (vector != null) {
            int first = 0;
            int last = vector.size() - 1;
            while (first <= last) {
                i = (first + last) / 2;
                int test = lookfor - vector.elementAt(i);
                if (test == 0) {
                    return i;
                }
                if (test < 0) {
                    last = i - 1;
                    continue;
                }
                first = i + 1;
            }
            if (first > i) {
                i = first;
            }
        }
        return -1 - i;
    }

    protected SuballocatedIntVector findNamespaceContext(int elementNodeIndex) {
        if (this.m_namespaceDeclSetElements != null) {
            int wouldBeAt = this.findInSortedSuballocatedIntVector(this.m_namespaceDeclSetElements, elementNodeIndex);
            if (wouldBeAt >= 0) {
                return (SuballocatedIntVector)this.m_namespaceDeclSets.elementAt(wouldBeAt);
            }
            if (wouldBeAt == -1) {
                return null;
            }
            wouldBeAt = -1 - wouldBeAt;
            int candidate = this.m_namespaceDeclSetElements.elementAt(--wouldBeAt);
            int ancestor = this._parent(elementNodeIndex);
            while (wouldBeAt >= 0 && ancestor > 0) {
                candidate = this.m_namespaceDeclSetElements.elementAt(wouldBeAt);
                if (candidate == ancestor) {
                    return (SuballocatedIntVector)this.m_namespaceDeclSets.elementAt(wouldBeAt);
                }
                if (candidate < ancestor) {
                    ancestor = this._parent(ancestor);
                    continue;
                }
                --wouldBeAt;
            }
        }
        return null;
    }

    public abstract int getAttributeNode(int var1, String var2, String var3);

    public abstract DTMAxisIterator getAxisIterator(int var1);

    public abstract DTMAxisTraverser getAxisTraverser(int var1);

    public abstract ContentHandler getContentHandler();

    public abstract DTDHandler getDTDHandler();

    public abstract DeclHandler getDeclHandler();

    public int getDocument() {
        return this.m_dtmIdent;
    }

    public boolean getDocumentAllDeclarationsProcessed() {
        return true;
    }

    public String getDocumentBaseURI() {
        return this.m_documentBaseURI;
    }

    public String getDocumentEncoding(int nodeHandle) {
        return "UTF-8";
    }

    public String getDocumentStandalone(int nodeHandle) {
        return null;
    }

    public String getDocumentSystemIdentifier(int nodeHandle) {
        return this.m_documentBaseURI;
    }

    public abstract String getDocumentTypeDeclarationPublicIdentifier();

    public abstract String getDocumentTypeDeclarationSystemIdentifier();

    public String getDocumentVersion(int documentHandle) {
        return null;
    }

    public abstract int getElementById(String var1);

    public abstract EntityResolver getEntityResolver();

    public abstract ErrorHandler getErrorHandler();

    public int getExpandedTypeID(int nodeHandle) {
        return this._exptype(nodeHandle & 0x3FFFFF);
    }

    public int getExpandedTypeID(String namespace, String localName, int type) {
        ExpandedNameTable ent = this.m_expandedNameTable;
        return ent.getExpandedTypeID(namespace, localName, type);
    }

    public int getFirstAttribute(int nodeHandle) {
        short type = this.getNodeType(nodeHandle);
        if (type == 1) {
            int identity = nodeHandle & 0x3FFFFF;
            while ((identity = this.getNextNodeIdentity(identity)) != -1) {
                type = this.getNodeType(identity);
                if (type == 2) {
                    return identity | this.m_dtmIdent;
                }
                if (type != 13) break;
            }
        }
        return -1;
    }

    public int getFirstChild(int nodeHandle) {
        int identity = nodeHandle & 0x3FFFFF;
        int firstChild = this._firstch(identity);
        return firstChild | this.m_dtmIdent;
    }

    public int getFirstNamespaceNode(int nodeHandle, boolean inScope) {
        if (inScope) {
            SuballocatedIntVector nsContext = this.findNamespaceContext(nodeHandle & 0x3FFFFF);
            if (nsContext == null || nsContext.size() < 1) {
                return -1;
            }
            return nsContext.elementAt(0) | this.m_dtmIdent;
        }
        int identity = nodeHandle & 0x3FFFFF;
        while ((identity = this.getNextNodeIdentity(identity)) != -1) {
            short type = this.getNodeType(identity);
            if (type == 13) {
                return identity | this.m_dtmIdent;
            }
            if (type != 2) break;
        }
        return -1;
    }

    public int getLastChild(int nodeHandle) {
        int identity = nodeHandle & 0x3FFFFF;
        int child = this._firstch(identity);
        int lastChild = -1;
        while (child != -1) {
            lastChild = child;
            child = this._nextsib(child);
        }
        return lastChild | this.m_dtmIdent;
    }

    public short getLevel(int nodeHandle) {
        int identity = nodeHandle & 0x3FFFFF;
        return (short)(this._level(identity) + 1);
    }

    public abstract LexicalHandler getLexicalHandler();

    public abstract String getLocalName(int var1);

    public String getLocalNameFromExpandedNameID(int expandedNameID) {
        return this.m_expandedNameTable.getLocalName(expandedNameID);
    }

    public String getNamespaceFromExpandedNameID(int expandedNameID) {
        return this.m_expandedNameTable.getNamespace(expandedNameID);
    }

    public int getNamespaceType(int nodeHandle) {
        int identity = nodeHandle & 0x3FFFFF;
        int expandedNameID = this._exptype(identity);
        return ExpandedNameTable.getNamespaceID(expandedNameID);
    }

    public abstract String getNamespaceURI(int var1);

    public int getNextAttribute(int nodeHandle) {
        short type = this.getNodeType(nodeHandle);
        if (type == 2) {
            int identity = nodeHandle & 0x3FFFFF;
            while ((identity = this.getNextNodeIdentity(identity)) != -1) {
                type = this.getNodeType(identity);
                if (type == 2) {
                    return identity | this.m_dtmIdent;
                }
                if (type != 13) break;
            }
        }
        return -1;
    }

    public int getNextNamespaceNode(int baseHandle, int nodeHandle, boolean inScope) {
        if (inScope) {
            SuballocatedIntVector nsContext = this.findNamespaceContext(baseHandle & 0x3FFFFF);
            if (nsContext == null) {
                return -1;
            }
            int i = 1 + nsContext.indexOf(nodeHandle);
            if (i <= 0 || i == nsContext.size()) {
                return -1;
            }
            return nsContext.elementAt(i) | this.m_dtmIdent;
        }
        int identity = nodeHandle & 0x3FFFFF;
        while ((identity = this.getNextNodeIdentity(identity)) != -1) {
            short type = this.getNodeType(identity);
            if (type == 13) {
                return identity | this.m_dtmIdent;
            }
            if (type != 2) break;
        }
        return -1;
    }

    protected abstract int getNextNodeIdentity(int var1);

    public int getNextSibling(int nodeHandle) {
        return this._nextsib(nodeHandle & 0x3FFFFF) | this.m_dtmIdent;
    }

    public Node getNode(int nodeHandle) {
        return new DTMNodeProxy(this, nodeHandle);
    }

    public abstract String getNodeName(int var1);

    public String getNodeNameX(int nodeHandle) {
        this.error(XSLMessages.createMessage(210, null));
        return null;
    }

    public short getNodeType(int nodeHandle) {
        return (short)(this._exptype(nodeHandle & 0x3FFFFF) >> ExpandedNameTable.ROTAMOUNT_TYPE);
    }

    public abstract String getNodeValue(int var1);

    protected abstract int getNumberOfNodes();

    public int getOwnerDocument(int nodeHandle) {
        short type = this.getNodeType(nodeHandle);
        if (type == 9) {
            return -1;
        }
        return this.getDocument();
    }

    public int getParent(int nodeHandle) {
        int identity = nodeHandle & 0x3FFFFF;
        if (identity > 0) {
            return this._parent(identity) | this.m_dtmIdent;
        }
        return -1;
    }

    public abstract String getPrefix(int var1);

    public int getPreviousSibling(int nodeHandle) {
        return this._prevsib(nodeHandle & 0x3FFFFF) | this.m_dtmIdent;
    }

    protected boolean getShouldStripWhitespace() {
        return this.m_shouldStripWS;
    }

    public abstract SourceLocator getSourceLocatorFor(int var1);

    public abstract XMLString getStringValue(int var1);

    public char[] getStringValueChunk(int nodeHandle, int chunkIndex, int[] startAndLen) {
        this.error(XSLMessages.createMessage(210, null));
        return null;
    }

    public int getStringValueChunkCount(int nodeHandle) {
        this.error(XSLMessages.createMessage(210, null));
        return 0;
    }

    public abstract DTMAxisIterator getTypedAxisIterator(int var1, int var2);

    public abstract String getUnparsedEntityURI(String var1);

    public boolean hasChildNodes(int nodeHandle) {
        int identity = nodeHandle & 0x3FFFFF;
        int firstChild = this._firstch(identity);
        return firstChild != -1;
    }

    protected void indexNode(int expandedTypeID, int identity) {
        ExpandedNameTable ent = this.m_expandedNameTable;
        short type = ExpandedNameTable.getType(expandedTypeID);
        if (type == 1) {
            int namespaceID = ExpandedNameTable.getNamespaceID(expandedTypeID);
            int localNameID = ExpandedNameTable.getLocalNameID(expandedTypeID);
            this.ensureSizeOfIndex(namespaceID, localNameID);
            int[] index = this.m_elemIndexes[namespaceID][localNameID];
            index[index[0]] = identity;
            index[0] = index[0] + 1;
        }
    }

    public abstract boolean isAttributeSpecified(int var1);

    public boolean isCharacterElementContentWhitespace(int nodeHandle) {
        return false;
    }

    public boolean isDocumentAllDeclarationsProcessed(int documentHandle) {
        return true;
    }

    public boolean isNodeAfter(int nodeHandle1, int nodeHandle2) {
        if ((nodeHandle1 & 0xFFC00000) != (nodeHandle2 & 0xFFC00000)) {
            return false;
        }
        int index1 = nodeHandle1 & 0x3FFFFF;
        int index2 = nodeHandle2 & 0x3FFFFF;
        return index1 <= index2;
    }

    public boolean isSupported(String feature, String version) {
        return false;
    }

    public abstract boolean needsTwoThreads();

    protected abstract boolean nextNode();

    protected void popShouldStripWhitespace() {
        if (this.m_shouldStripWhitespaceStack != null) {
            this.m_shouldStripWS = this.m_shouldStripWhitespaceStack.popAndTop();
        }
    }

    protected void pushShouldStripWhitespace(boolean shouldStrip) {
        this.m_shouldStripWS = shouldStrip;
        if (this.m_shouldStripWhitespaceStack != null) {
            this.m_shouldStripWhitespaceStack.push(shouldStrip);
        }
    }

    public void setDocumentBaseURI(String baseURI) {
        this.m_documentBaseURI = baseURI;
    }

    public void setFeature(String featureId, boolean state) {
    }

    public abstract void setProperty(String var1, Object var2);

    protected void setShouldStripWhitespace(boolean shouldStrip) {
        this.m_shouldStripWS = shouldStrip;
        if (this.m_shouldStripWhitespaceStack != null) {
            this.m_shouldStripWhitespaceStack.setTop(shouldStrip);
        }
    }

    public boolean supportsPreStripping() {
        return true;
    }
}

