/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.impl;

import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.RDFSyntax;
import com.hp.hpl.jena.xmloutput.impl.BaseXMLWriter;
import com.hp.hpl.jena.xmloutput.impl.Unparser;
import java.io.FileInputStream;
import java.io.PrintWriter;

public class Abbreviated
extends BaseXMLWriter
implements RDFErrorHandler {
    private Resource[] types = new Resource[]{DAML_OIL.Ontology, OWL.Ontology, DAML_OIL.Datatype, OWL.Datatype, RDFS.Datatype, DAML_OIL.Class, RDFS.Class, OWL.Class, DAML_OIL.Property, OWL.ObjectProperty, RDF.Property, DAML_OIL.ObjectProperty, OWL.DatatypeProperty, DAML_OIL.DatatypeProperty, OWL.TransitiveProperty, OWL.SymmetricProperty, OWL.FunctionalProperty, OWL.InverseFunctionalProperty, DAML_OIL.TransitiveProperty, DAML_OIL.UnambiguousProperty, DAML_OIL.UniqueProperty};
    boolean sReification;
    boolean sIdAttr;
    boolean sDamlCollection;
    boolean sParseTypeCollectionPropertyElt;
    boolean sListExpand;
    boolean sParseTypeLiteralPropertyElt;
    boolean sParseTypeResourcePropertyElt;
    boolean sPropertyAttr;
    boolean sResourcePropertyElt;

    public Abbreviated() {
        this.unblockAll();
    }

    void unblockAll() {
        this.sDamlCollection = false;
        this.sReification = false;
        this.sResourcePropertyElt = false;
        this.sParseTypeLiteralPropertyElt = false;
        this.sParseTypeResourcePropertyElt = false;
        this.sParseTypeCollectionPropertyElt = false;
        this.sIdAttr = false;
        this.sPropertyAttr = false;
        this.sListExpand = false;
    }

    void blockRule(Resource resource) {
        if (((Object)resource).equals(RDFSyntax.sectionReification)) {
            this.sReification = true;
        } else if (((Object)resource).equals(RDFSyntax.sectionListExpand)) {
            this.sListExpand = true;
        } else if (((Object)resource).equals(RDFSyntax.parseTypeLiteralPropertyElt)) {
            this.sParseTypeLiteralPropertyElt = true;
        } else if (((Object)resource).equals(RDFSyntax.parseTypeResourcePropertyElt)) {
            this.sParseTypeResourcePropertyElt = true;
        } else if (((Object)resource).equals(RDFSyntax.parseTypeCollectionPropertyElt)) {
            this.sParseTypeCollectionPropertyElt = true;
        } else if (((Object)resource).equals(RDFSyntax.idAttr)) {
            this.sIdAttr = true;
            this.sReification = true;
        } else if (((Object)resource).equals(RDFSyntax.propertyAttr)) {
            this.sPropertyAttr = true;
        } else if (((Object)resource).equals(DAML_OIL.collection)) {
            this.sDamlCollection = true;
        } else {
            logger.warn((Object)("Cannot block rule <" + resource.getURI() + ">"));
        }
    }

    Resource[] setTypes(Resource[] resourceArray) {
        Resource[] resourceArray2 = this.types;
        this.types = resourceArray;
        return resourceArray2;
    }

    void writeBody(Model model, PrintWriter printWriter, String string, boolean bl) {
        Unparser unparser = new Unparser(this, string, model, printWriter);
        unparser.setTopLevelTypes(this.types);
        if (bl) {
            unparser.setXMLBase(string);
        }
        unparser.write();
    }

    public void error(Exception exception) {
        this.errorHandler.error(exception);
    }

    public void warning(Exception exception) {
        this.errorHandler.warning(exception);
    }

    public void fatalError(Exception exception) {
        this.errorHandler.fatalError(exception);
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("Test code for bug 77");
        ModelMem modelMem = new ModelMem();
        modelMem.read(new FileInputStream("modules/rdf/regression/arp/bug51_0.rdf"), "http://example.org/file");
        RDFWriter rDFWriter = modelMem.getWriter("RDF/XML-ABBREV");
        modelMem.setNsPrefix("eg", "http://example.org/");
        modelMem.setNsPrefix("eg2", "http://example.org/foo#");
        rDFWriter.write((Model)modelMem, System.out, "http://example.org/file");
    }
}

