/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.iterator;

import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.ResIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ConcatenatedIterator
implements Iterator {
    private Iterator m_iter0 = null;
    private Iterator m_iter1 = null;
    protected Object m_defaultValue = null;
    protected boolean m_defaultValueSeen = false;

    public ConcatenatedIterator(Object object, Object object2) {
        if (object instanceof Iterator) {
            this.m_iter0 = (Iterator)object;
        } else if (object instanceof NodeIterator) {
            this.m_iter0 = (NodeIterator)object;
        } else if (object instanceof ResIterator) {
            this.m_iter0 = (ResIterator)object;
        } else {
            throw new IllegalArgumentException("Found a non-iterator when constructing ConcatenatedIterator: " + object);
        }
        if (object2 instanceof Iterator) {
            this.m_iter1 = (Iterator)object2;
        } else if (object2 instanceof NodeIterator) {
            this.m_iter1 = (NodeIterator)object2;
        } else if (object2 instanceof ResIterator) {
            this.m_iter1 = (ResIterator)object2;
        } else {
            throw new IllegalArgumentException("Found a non-iterator when constructing ConcatenatedIterator: " + object2);
        }
    }

    public boolean hasNext() {
        return this.m_iter0.hasNext() || this.m_iter1.hasNext() || this.hasDefaultValue() && !this.m_defaultValueSeen;
    }

    public Object next() {
        boolean bl = this.m_iter0.hasNext();
        boolean bl2 = this.m_iter1.hasNext();
        if (bl || bl2) {
            Object e;
            Object e2 = e = bl ? this.m_iter0.next() : this.m_iter1.next();
            if (this.hasDefaultValue() && this.m_defaultValue.equals(e)) {
                this.m_defaultValueSeen = true;
            }
            return e;
        }
        if (this.hasDefaultValue() && !this.m_defaultValueSeen) {
            this.m_defaultValueSeen = true;
            return this.m_defaultValue;
        }
        throw new NoSuchElementException("Tried to access next() element from empty concatenated iterator");
    }

    public void remove() {
        throw new UnsupportedOperationException("Cannot remove elements from concatenated iterator");
    }

    public void setDefaultValue(Object object) {
        this.m_defaultValue = object;
    }

    public boolean hasDefaultValue() {
        return this.m_defaultValue != null;
    }
}

