/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared;

import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.RSS;
import com.hp.hpl.jena.vocabulary.VCARD;
import java.util.Map;

public interface PrefixMapping {
    public static final PrefixMapping Standard = Factory.create().setNsPrefix("rdfs", RDFS.getURI()).setNsPrefix("rdf", RDF.getURI()).setNsPrefix("dc", DC.getURI()).setNsPrefix("rss", RSS.getURI()).setNsPrefix("daml", "http://www.daml.org/2000/12/daml+oil#").setNsPrefix("vcard", VCARD.getURI()).setNsPrefix("owl", "http://www.w3.org/2002/07/owl#").lock();

    public PrefixMapping setNsPrefix(String var1, String var2);

    public PrefixMapping setNsPrefixes(PrefixMapping var1);

    public PrefixMapping setNsPrefixes(Map var1);

    public String getNsPrefixURI(String var1);

    public String getNsURIPrefix(String var1);

    public Map getNsPrefixMap();

    public String expandPrefix(String var1);

    public String usePrefix(String var1);

    public PrefixMapping lock();

    public static class Factory {
        public static PrefixMapping create() {
            return new PrefixMappingImpl();
        }
    }

    public static class JenaLockedException
    extends JenaException {
        public JenaLockedException(PrefixMapping prefixMapping) {
            super(prefixMapping.toString());
        }
    }

    public static class IllegalPrefixException
    extends JenaException {
        public IllegalPrefixException(String string) {
            super(string);
        }
    }
}

