/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.test.ReasonerTester;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasonerFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestReasoners
extends TestCase {
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$test$TestReasoners;

    public TestReasoners(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$reasoner$test$TestReasoners == null ? (class$com$hp$hpl$jena$reasoner$test$TestReasoners = TestReasoners.class$("com.hp.hpl.jena.reasoner.test.TestReasoners")) : class$com$hp$hpl$jena$reasoner$test$TestReasoners);
    }

    public void testTransitiveReasoner() throws IOException {
        ReasonerTester reasonerTester = new ReasonerTester("transitive/manifest.rdf");
        ReasonerFactory reasonerFactory = TransitiveReasonerFactory.theInstance();
        TestReasoners.assertTrue((String)"transitive reasoner tests", (boolean)reasonerTester.runTests(reasonerFactory, this, null));
    }

    public void testTransitiveRebind() {
        GraphMem graphMem = new GraphMem();
        Node node = Node.createURI("C1");
        Node node2 = Node.createURI("C2");
        Node node3 = Node.createURI("C3");
        Node node4 = Node.createURI("C4");
        graphMem.add(new Triple(node, RDFS.subClassOf.asNode(), node2));
        graphMem.add(new Triple(node2, RDFS.subClassOf.asNode(), node3));
        Reasoner reasoner = TransitiveReasonerFactory.theInstance().create(null);
        TestReasoners.assertTrue((boolean)reasoner.supportsProperty(RDFS.subClassOf));
        TestReasoners.assertTrue((!reasoner.supportsProperty(RDFS.domain) ? 1 : 0) != 0);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(node, null, null), new Object[]{new Triple(node, RDFS.subClassOf.asNode(), node), new Triple(node, RDFS.subClassOf.asNode(), node2), new Triple(node, RDFS.subClassOf.asNode(), node3)});
        GraphMem graphMem2 = new GraphMem();
        graphMem2.add(new Triple(node, RDFS.subClassOf.asNode(), node2));
        graphMem2.add(new Triple(node2, RDFS.subClassOf.asNode(), node4));
        infGraph.rebind(graphMem2);
        Node node5 = Node.createURI("a");
        Node node6 = Node.createURI("b");
        Node node7 = Node.createURI("c");
        infGraph.add(new Triple(node5, RDFS.subClassOf.asNode(), node6));
        infGraph.add(new Triple(node6, RDFS.subClassOf.asNode(), node7));
        TestUtil.assertIteratorValues(this, infGraph.find(node6, RDFS.subClassOf.asNode(), null), new Object[]{new Triple(node6, RDFS.subClassOf.asNode(), node7), new Triple(node6, RDFS.subClassOf.asNode(), node6)});
        TestUtil.assertIteratorValues(this, infGraph.find(node5, RDFS.subClassOf.asNode(), null), new Object[]{new Triple(node5, RDFS.subClassOf.asNode(), node5), new Triple(node5, RDFS.subClassOf.asNode(), node6), new Triple(node5, RDFS.subClassOf.asNode(), node7)});
        Node node8 = Node.createURI("p");
        Node node9 = Node.createURI("q");
        Node node10 = Node.createURI("r");
        infGraph.add(new Triple(node8, RDFS.subPropertyOf.asNode(), node9));
        infGraph.add(new Triple(node9, RDFS.subPropertyOf.asNode(), node10));
        TestUtil.assertIteratorValues(this, infGraph.find(node9, RDFS.subPropertyOf.asNode(), null), new Object[]{new Triple(node9, RDFS.subPropertyOf.asNode(), node9), new Triple(node9, RDFS.subPropertyOf.asNode(), node10)});
        TestUtil.assertIteratorValues(this, infGraph.find(node8, RDFS.subPropertyOf.asNode(), null), new Object[]{new Triple(node8, RDFS.subPropertyOf.asNode(), node8), new Triple(node8, RDFS.subPropertyOf.asNode(), node9), new Triple(node8, RDFS.subPropertyOf.asNode(), node10)});
    }

    public void testTransitiveRemove() {
        GraphMem graphMem = new GraphMem();
        Node node = Node.createURI("a");
        Node node2 = Node.createURI("b");
        Node node3 = Node.createURI("c");
        Node node4 = Node.createURI("d");
        Node node5 = Node.createURI("e");
        Node node6 = RDFS.subClassOf.asNode();
        graphMem.add(new Triple(node, RDFS.subClassOf.asNode(), node2));
        graphMem.add(new Triple(node, RDFS.subClassOf.asNode(), node3));
        graphMem.add(new Triple(node2, RDFS.subClassOf.asNode(), node4));
        graphMem.add(new Triple(node3, RDFS.subClassOf.asNode(), node4));
        graphMem.add(new Triple(node4, RDFS.subClassOf.asNode(), node5));
        Reasoner reasoner = TransitiveReasonerFactory.theInstance().create(null);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(node, RDFS.subClassOf.asNode(), null), new Object[]{new Triple(node, node6, node), new Triple(node, node6, node2), new Triple(node, node6, node2), new Triple(node, node6, node3), new Triple(node, node6, node4), new Triple(node, node6, node5)});
        TestUtil.assertIteratorValues(this, infGraph.find(node2, RDFS.subClassOf.asNode(), null), new Object[]{new Triple(node2, node6, node2), new Triple(node2, node6, node4), new Triple(node2, node6, node5)});
        infGraph.delete(new Triple(node2, node6, node4));
        TestUtil.assertIteratorValues(this, infGraph.find(node, RDFS.subClassOf.asNode(), null), new Object[]{new Triple(node, node6, node), new Triple(node, node6, node2), new Triple(node, node6, node2), new Triple(node, node6, node3), new Triple(node, node6, node4), new Triple(node, node6, node5)});
        TestUtil.assertIteratorValues(this, infGraph.find(node2, RDFS.subClassOf.asNode(), null), new Object[]{new Triple(node2, node6, node2)});
        infGraph.delete(new Triple(node, node6, node3));
        TestUtil.assertIteratorValues(this, infGraph.find(node, RDFS.subClassOf.asNode(), null), new Object[]{new Triple(node, node6, node), new Triple(node, node6, node2)});
        TestUtil.assertIteratorValues(this, infGraph.find(node2, RDFS.subClassOf.asNode(), null), new Object[]{new Triple(node2, node6, node2)});
        TestUtil.assertIteratorValues(this, graphMem.find(null, RDFS.subClassOf.asNode(), null), new Object[]{new Triple(node, node6, node2), new Triple(node3, node6, node4), new Triple(node4, node6, node5)});
    }

    public void testTransitiveMetaLevel() {
        this.doTestMetaLevel(TransitiveReasonerFactory.theInstance());
    }

    public void testRDFSMetaLevel() {
        this.doTestMetaLevel(RDFSRuleReasonerFactory.theInstance());
    }

    public void doTestMetaLevel(ReasonerFactory reasonerFactory) {
        GraphMem graphMem = new GraphMem();
        Node node = Node.createURI("C1");
        Node node2 = Node.createURI("C2");
        Node node3 = Node.createURI("C3");
        Node node4 = Node.createURI("p");
        Node node5 = Node.createURI("q");
        Node node6 = RDFS.subClassOf.asNode();
        Node node7 = RDFS.subPropertyOf.asNode();
        Node node8 = RDF.type.asNode();
        graphMem.add(new Triple(node2, node6, node3));
        graphMem.add(new Triple(node, node4, node2));
        Reasoner reasoner = reasonerFactory.create(null);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(node, node6, null), new Object[0]);
        infGraph.add(new Triple(node4, node5, node6));
        TestUtil.assertIteratorValues(this, infGraph.find(node, node6, null), new Object[0]);
        infGraph.add(new Triple(node5, node7, node7));
        TestUtil.assertIteratorValues(this, infGraph.find(node, node6, null), new Object[]{new Triple(node, node6, node), new Triple(node, node6, node2), new Triple(node, node6, node3)});
        infGraph.delete(new Triple(node4, node5, node6));
        TestUtil.assertIteratorValues(this, infGraph.find(node, node6, null), new Object[0]);
    }

    public void testRDFSRebind() {
        GraphMem graphMem = new GraphMem();
        Node node = Node.createURI("C1");
        Node node2 = Node.createURI("C2");
        Node node3 = Node.createURI("C3");
        Node node4 = Node.createURI("C4");
        graphMem.add(new Triple(node, RDFS.subClassOf.asNode(), node2));
        graphMem.add(new Triple(node2, RDFS.subClassOf.asNode(), node3));
        Reasoner reasoner = RDFSReasonerFactory.theInstance().create(null);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(node, RDFS.subClassOf.asNode(), null), new Object[]{new Triple(node, RDFS.subClassOf.asNode(), node), new Triple(node, RDFS.subClassOf.asNode(), node2), new Triple(node, RDFS.subClassOf.asNode(), node3)});
        GraphMem graphMem2 = new GraphMem();
        graphMem2.add(new Triple(node, RDFS.subClassOf.asNode(), node2));
        graphMem2.add(new Triple(node2, RDFS.subClassOf.asNode(), node4));
        infGraph.rebind(graphMem2);
        TestUtil.assertIteratorValues(this, infGraph.find(node, RDFS.subClassOf.asNode(), null), new Object[]{new Triple(node, RDFS.subClassOf.asNode(), node), new Triple(node, RDFS.subClassOf.asNode(), node2), new Triple(node, RDFS.subClassOf.asNode(), node4)});
    }

    public void testModelFactoryRDFS() {
        Model model = ModelFactory.createDefaultModel();
        Property property = model.createProperty("urn:x-hp:ex/p");
        Resource resource = model.createResource("urn:x-hp:ex/a");
        Resource resource2 = model.createResource("urn:x-hp:ex/b");
        Resource resource3 = model.createResource("urn:x-hp:ex/c");
        model.add((Resource)property, RDFS.range, resource3).add(resource, property, resource2);
        InfModel infModel = ModelFactory.createRDFSModel(model);
        StmtIterator stmtIterator = infModel.listStatements(resource2, RDF.type, (RDFNode)null);
        TestUtil.assertIteratorValues(this, stmtIterator, new Object[]{new StatementImpl(resource2, RDF.type, RDFS.Resource), new StatementImpl(resource2, RDF.type, resource3)});
    }

    public void testTransitiveFindWithPremises() {
        this.doTestFindWithPremises(TransitiveReasonerFactory.theInstance());
    }

    public void testRDFSFindWithPremises() {
        this.doTestFindWithPremises(RDFSRuleReasonerFactory.theInstance());
    }

    public void doTestFindWithPremises(ReasonerFactory reasonerFactory) {
        Node node = Node.createURI("C1");
        Node node2 = Node.createURI("C2");
        Node node3 = Node.createURI("C3");
        Node node4 = RDFS.subClassOf.asNode();
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(node2, node4, node3));
        GraphMem graphMem2 = new GraphMem();
        graphMem2.add(new Triple(node, node4, node2));
        Reasoner reasoner = reasonerFactory.create(null);
        InfGraph infGraph = reasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(node, node4, null), new Object[0]);
        TestUtil.assertIteratorValues(this, infGraph.find(node, node4, null, graphMem2), new Object[]{new Triple(node, node4, node2), new Triple(node, node4, node3), new Triple(node, node4, node)});
        TestUtil.assertIteratorValues(this, infGraph.find(node, node4, null), new Object[0]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

