/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleDerivation;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;

public class TestGenericRules
extends TestCase {
    protected static Logger logger = Logger.getLogger((Class)(class$com$hp$hpl$jena$reasoner$rulesys$test$TestFBRules == null ? (class$com$hp$hpl$jena$reasoner$rulesys$test$TestFBRules = TestGenericRules.class$("com.hp.hpl.jena.reasoner.rulesys.test.TestFBRules")) : class$com$hp$hpl$jena$reasoner$rulesys$test$TestFBRules));
    Node p = Node.createURI("p");
    Node q = Node.createURI("q");
    Node r = Node.createURI("r");
    Node s = Node.createURI("s");
    Node t = Node.createURI("t");
    Node a = Node.createURI("a");
    Node b = Node.createURI("b");
    Node c = Node.createURI("c");
    Node d = Node.createURI("d");
    Node C1 = Node.createURI("C1");
    Node C2 = Node.createURI("C2");
    Node C3 = Node.createURI("C3");
    Node ty = RDF.type.getNode();
    Node sC = RDFS.subClassOf.getNode();
    List ruleList = Rule.parseRules("[r1: (?a p ?b), (?b p ?c) -> (?a p ?c)][r2: (?a q ?b) -> (?a p ?c)]");
    Triple[] ans = new Triple[]{new Triple(this.a, this.p, this.b), new Triple(this.b, this.p, this.c), new Triple(this.a, this.p, this.c)};
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$rulesys$test$TestFBRules;
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$rulesys$test$TestGenericRules;

    public TestGenericRules(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$reasoner$rulesys$test$TestGenericRules == null ? (class$com$hp$hpl$jena$reasoner$rulesys$test$TestGenericRules = TestGenericRules.class$("com.hp.hpl.jena.reasoner.rulesys.test.TestGenericRules")) : class$com$hp$hpl$jena$reasoner$rulesys$test$TestGenericRules);
    }

    public void testForward() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.p, this.b));
        graphMem.add(new Triple(this.b, this.p, this.c));
        GenericRuleReasoner genericRuleReasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(null);
        genericRuleReasoner.setRules(this.ruleList);
        genericRuleReasoner.setMode(GenericRuleReasoner.FORWARD);
        InfGraph infGraph = genericRuleReasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.p, null), this.ans);
        infGraph = genericRuleReasoner.bindSchema(graphMem).bind(new GraphMem());
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.p, null), this.ans);
    }

    public void testBackward() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.p, this.b));
        graphMem.add(new Triple(this.b, this.p, this.c));
        GenericRuleReasoner genericRuleReasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(null);
        genericRuleReasoner.setRules(this.ruleList);
        genericRuleReasoner.setMode(GenericRuleReasoner.BACKWARD);
        InfGraph infGraph = genericRuleReasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.p, null), this.ans);
        infGraph = genericRuleReasoner.bindSchema(graphMem).bind(new GraphMem());
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.p, null), this.ans);
    }

    public void testHybrid() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.r, this.b));
        graphMem.add(new Triple(this.p, this.ty, this.s));
        List list = Rule.parseRules("[a1: -> (a rdf:type t)][r0: (?x r ?y) -> (?x p ?y)][r1: (?p rdf:type s) -> [r1b: (?x ?p ?y) <- (?y ?p ?x)]][r2: (?p rdf:type s) -> [r2b: (?x ?p ?x) <- (?x rdf:type t)]]");
        GenericRuleReasoner genericRuleReasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(null);
        genericRuleReasoner.setRules(list);
        genericRuleReasoner.setMode(GenericRuleReasoner.HYBRID);
        InfGraph infGraph = genericRuleReasoner.bind(graphMem);
        infGraph.setDerivationLogging(true);
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.p, null), new Object[]{new Triple(this.a, this.p, this.a), new Triple(this.a, this.p, this.b), new Triple(this.b, this.p, this.a)});
        Iterator iterator = infGraph.getDerivation(new Triple(this.b, this.p, this.a));
        TestGenericRules.assertTrue((boolean)iterator.hasNext());
        RuleDerivation ruleDerivation = (RuleDerivation)iterator.next();
        TestGenericRules.assertTrue((boolean)ruleDerivation.getRule().getName().equals("r1b"));
        TestUtil.assertIteratorValues(this, ruleDerivation.getMatches().iterator(), new Object[]{new Triple(this.a, this.p, this.b)});
        TestGenericRules.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
    }

    public void testParameters() {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.r, this.b));
        graphMem.add(new Triple(this.p, this.ty, this.s));
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("http://www.hpl.hp.com/semweb/2003/GenericRuleReasoner");
        resource.addProperty(ReasonerVocabulary.PROPderivationLogging, "true");
        resource.addProperty(ReasonerVocabulary.PROPruleMode, "hybrid");
        resource.addProperty(ReasonerVocabulary.PROPruleSet, "testing/reasoners/genericRuleTest.rules");
        GenericRuleReasoner genericRuleReasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(resource);
        InfGraph infGraph = genericRuleReasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(null, this.p, null), new Object[]{new Triple(this.a, this.p, this.a), new Triple(this.a, this.p, this.b), new Triple(this.b, this.p, this.a)});
        Iterator iterator = infGraph.getDerivation(new Triple(this.b, this.p, this.a));
        TestGenericRules.assertTrue((boolean)iterator.hasNext());
        RuleDerivation ruleDerivation = (RuleDerivation)iterator.next();
        TestGenericRules.assertTrue((boolean)ruleDerivation.getRule().getName().equals("r1b"));
        TestUtil.assertIteratorValues(this, ruleDerivation.getMatches().iterator(), new Object[]{new Triple(this.a, this.p, this.b)});
        TestGenericRules.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
    }

    public void testAddRemove() {
        this.doTestAddRemove(false);
        this.doTestAddRemove(true);
    }

    public void doTestAddRemove(boolean bl) {
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(this.a, this.p, this.C1));
        graphMem.add(new Triple(this.C1, this.sC, this.C2));
        graphMem.add(new Triple(this.C2, this.sC, this.C3));
        List list = Rule.parseRules("[r1: (?x p ?c) -> (?x rdf:type ?c)] [rdfs9:  (?x rdfs:subClassOf ?y) -> [ (?a rdf:type ?y) <- (?a rdf:type ?x)] ]");
        if (!bl) {
            list.add(Rule.parseRule("[rdfs8:  (?a rdfs:subClassOf ?b), (?b rdfs:subClassOf ?c) -> (?a rdfs:subClassOf ?c)] "));
        }
        GenericRuleReasoner genericRuleReasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(null);
        genericRuleReasoner.setRules(list);
        genericRuleReasoner.setMode(GenericRuleReasoner.HYBRID);
        genericRuleReasoner.setTransitiveClosureCaching(bl);
        InfGraph infGraph = genericRuleReasoner.bind(graphMem);
        TestUtil.assertIteratorValues(this, infGraph.find(this.a, this.ty, null), new Object[]{new Triple(this.a, this.ty, this.C1), new Triple(this.a, this.ty, this.C2), new Triple(this.a, this.ty, this.C3)});
        logger.debug((Object)"Checkpoint 1");
        infGraph.delete(new Triple(this.C1, this.sC, this.C2));
        TestUtil.assertIteratorValues(this, infGraph.find(this.a, this.ty, null), new Object[]{new Triple(this.a, this.ty, this.C1)});
        logger.debug((Object)"Checkpoint 2");
        infGraph.add(new Triple(this.C1, this.sC, this.C3));
        infGraph.add(new Triple(this.b, this.p, this.C2));
        TestUtil.assertIteratorValues(this, infGraph.find(this.a, this.ty, null), new Object[]{new Triple(this.a, this.ty, this.C1), new Triple(this.a, this.ty, this.C3)});
        TestUtil.assertIteratorValues(this, infGraph.find(this.b, this.ty, null), new Object[]{new Triple(this.b, this.ty, this.C2), new Triple(this.b, this.ty, this.C3)});
        TestUtil.assertIteratorValues(this, graphMem.find(null, null, null), new Object[]{new Triple(this.a, this.p, this.C1), new Triple(this.b, this.p, this.C2), new Triple(this.C2, this.sC, this.C3), new Triple(this.C1, this.sC, this.C3)});
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

