/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import java.util.ArrayList;
import java.util.Iterator;

public class Trail
implements BindingEnvironment {
    protected ArrayList trail = new ArrayList();

    public void unwindBindings() {
        for (int i = this.trail.size() - 1; i >= 0; --i) {
            TrailEntry trailEntry = (TrailEntry)this.trail.get(i);
            trailEntry.var.unbind();
        }
    }

    public void unwindAndClear() {
        for (int i = this.trail.size() - 1; i >= 0; --i) {
            TrailEntry trailEntry = (TrailEntry)this.trail.get(i);
            trailEntry.var.unbind();
        }
        this.trail.clear();
    }

    public void activate() {
        Iterator iterator = this.trail.iterator();
        while (iterator.hasNext()) {
            TrailEntry trailEntry = (TrailEntry)iterator.next();
            trailEntry.var.simpleBind(trailEntry.value);
        }
    }

    public boolean unify(TriplePattern triplePattern, TriplePattern triplePattern2) {
        boolean bl;
        int n = this.trail.size();
        boolean bl2 = bl = this.unify(triplePattern.getSubject(), triplePattern2.getSubject()) && this.unify(triplePattern.getPredicate(), triplePattern2.getPredicate()) && this.unifyObj(triplePattern.getObject(), triplePattern2.getObject());
        if (!bl) {
            for (int i = this.trail.size() - 1; i >= n; --i) {
                TrailEntry trailEntry = (TrailEntry)this.trail.get(i);
                trailEntry.var.unbind();
                this.trail.remove(i);
            }
        }
        return bl;
    }

    public boolean unify(Triple triple, TriplePattern triplePattern) {
        boolean bl;
        int n = this.trail.size();
        boolean bl2 = bl = this.unify(triple.getSubject(), triplePattern.getSubject()) && this.unify(triple.getPredicate(), triplePattern.getPredicate()) && this.unifyObj(triple.getObject(), triplePattern.getObject());
        if (!bl) {
            for (int i = this.trail.size() - 1; i >= n; --i) {
                TrailEntry trailEntry = (TrailEntry)this.trail.get(i);
                trailEntry.var.unbind();
                this.trail.remove(i);
            }
        }
        return bl;
    }

    public boolean unify(Node node, Node node2) {
        Node node3 = this.getGroundVersion(node);
        Node node4 = this.getGroundVersion(node2);
        if (node3 instanceof Node_RuleVariable) {
            this.bind(node3, node4);
            return true;
        }
        if (node4 instanceof Node_RuleVariable) {
            this.bind(node4, node3);
            return true;
        }
        return node3.sameValueAs(node4);
    }

    public boolean unifyObj(Node node, Node node2) {
        Node node3 = this.getGroundVersion(node);
        Node node4 = this.getGroundVersion(node2);
        if (node3 instanceof Node_RuleVariable) {
            this.bind(node3, node4);
            return true;
        }
        if (node4 instanceof Node_RuleVariable) {
            this.bind(node4, node3);
            return true;
        }
        if (Functor.isFunctor(node3)) {
            if (Functor.isFunctor(node4)) {
                Node[] nodeArray;
                Functor functor = (Functor)node3.getLiteral().getValue();
                Functor functor2 = (Functor)node4.getLiteral().getValue();
                if (!functor.getName().equals(functor2.getName())) {
                    return false;
                }
                Node[] nodeArray2 = functor.getArgs();
                if (nodeArray2.length != (nodeArray = functor2.getArgs()).length) {
                    return false;
                }
                for (int i = 0; i < nodeArray2.length; ++i) {
                    if (this.unify(nodeArray2[i], nodeArray[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return node3.sameValueAs(node4);
    }

    public Node getGroundVersion(Node node) {
        if (node instanceof Node_RuleVariable) {
            return ((Node_RuleVariable)node).deref();
        }
        return node;
    }

    public Node getMostGroundVersion(Node node) {
        if (node instanceof Node_RuleVariable) {
            node = ((Node_RuleVariable)node).deref();
        }
        if (Functor.isFunctor(node)) {
            Functor functor = (Functor)node.getLiteral().getValue();
            Node[] nodeArray = functor.getArgs();
            Node[] nodeArray2 = new Node[nodeArray.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                nodeArray2[i] = this.getGroundVersion(nodeArray[i]);
            }
            return Functor.makeFunctorNode(functor.getName(), nodeArray2);
        }
        return node;
    }

    public Functor getMostGroundVersion(Functor functor) {
        Node[] nodeArray = functor.getArgs();
        Node[] nodeArray2 = new Node[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray2[i] = this.getGroundVersion(nodeArray[i]);
        }
        return new Functor(functor.getName(), nodeArray2);
    }

    public boolean bind(Node node, Node node2) {
        if (node == Node_RuleVariable.WILD || node2 == Node_RuleVariable.WILD) {
            return true;
        }
        Node node3 = this.getGroundVersion(node);
        if (node3 instanceof Node_RuleVariable) {
            this.trail.add(new TrailEntry((Node_RuleVariable)node3, node2));
            ((Node_RuleVariable)node3).simpleBind(node2);
            return true;
        }
        return node3.sameValueAs(node2);
    }

    public TriplePattern partInstantiate(TriplePattern triplePattern) {
        return new TriplePattern(this.getMostGroundVersion(triplePattern.getSubject()), this.getMostGroundVersion(triplePattern.getPredicate()), this.getMostGroundVersion(triplePattern.getObject()));
    }

    public Triple instantiate(TriplePattern triplePattern) {
        return new Triple(this.getMostGroundVersion(triplePattern.getSubject()), this.getMostGroundVersion(triplePattern.getPredicate()), this.getMostGroundVersion(triplePattern.getObject()));
    }

    static class TrailEntry {
        protected Node_RuleVariable var;
        protected Node value;

        TrailEntry(Node_RuleVariable node_RuleVariable, Node node) {
            this.var = node_RuleVariable;
            this.value = node;
        }
    }
}

