/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.impl.BRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.GoalResults;
import com.hp.hpl.jena.reasoner.rulesys.impl.GoalState;
import com.hp.hpl.jena.reasoner.rulesys.impl.RuleState;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class GoalTable {
    protected Map table = new HashMap();
    protected BRuleEngine ruleEngine;
    static Logger logger = Logger.getLogger((Class)(class$com$hp$hpl$jena$reasoner$rulesys$impl$GoalTable == null ? (class$com$hp$hpl$jena$reasoner$rulesys$impl$GoalTable = GoalTable.class$("com.hp.hpl.jena.reasoner.rulesys.impl.GoalTable")) : class$com$hp$hpl$jena$reasoner$rulesys$impl$GoalTable));
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$rulesys$impl$GoalTable;

    public GoalTable(BRuleEngine bRuleEngine) {
        this.ruleEngine = bRuleEngine;
    }

    public GoalState findGoal(TriplePattern triplePattern) {
        GoalResults goalResults = (GoalResults)this.table.get(triplePattern);
        if (goalResults == null || !triplePattern.variantOf(goalResults.goal)) {
            goalResults = new GoalResults(triplePattern, this.ruleEngine);
            this.table.put(triplePattern, goalResults);
        }
        return new GoalState(this.ruleEngine.getInfGraph().findDataMatches(triplePattern), goalResults);
    }

    public void reset() {
        this.table = new HashMap();
    }

    public void removePartialGoals() {
        Iterator iterator = this.table.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TriplePattern triplePattern = (TriplePattern)entry.getKey();
            GoalResults goalResults = (GoalResults)entry.getValue();
            if (goalResults.isComplete()) continue;
            Iterator iterator2 = goalResults.dependents.iterator();
            while (iterator2.hasNext()) {
                RuleState ruleState = (RuleState)iterator2.next();
                if (ruleState.goalState == null) continue;
                ruleState.goalState.close();
            }
            iterator.remove();
        }
    }

    public void setAllComplete() {
        Iterator iterator = this.table.values().iterator();
        while (iterator.hasNext()) {
            ((GoalResults)iterator.next()).setAllComplete();
        }
    }

    public void dump() {
        System.out.println("Final goal table");
        Iterator iterator = this.table.values().iterator();
        while (iterator.hasNext()) {
            GoalResults goalResults = (GoalResults)iterator.next();
            System.out.println(goalResults.toString());
            for (int i = 0; i < goalResults.numResults(); ++i) {
                System.out.println(" - " + goalResults.getResult(i));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

