/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.IllegalParameterException;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.List;

public class FBRuleReasoner
implements Reasoner {
    protected ReasonerFactory factory;
    protected List rules;
    protected Graph schemaGraph;
    protected boolean recordDerivations = false;
    boolean traceOn = false;
    protected static final boolean cachePreload = true;
    protected InfGraph preload;

    public FBRuleReasoner(List list) {
        this.rules = list;
    }

    public FBRuleReasoner(ReasonerFactory reasonerFactory) {
        this(null, reasonerFactory);
    }

    public FBRuleReasoner(List list, ReasonerFactory reasonerFactory) {
        this(list);
        this.factory = reasonerFactory;
    }

    protected FBRuleReasoner(List list, Graph graph, ReasonerFactory reasonerFactory) {
        this(list, reasonerFactory);
        this.schemaGraph = graph;
    }

    public Model getCapabilities() {
        if (this.factory != null) {
            return this.factory.getCapabilities();
        }
        return null;
    }

    public boolean supportsProperty(Property property) {
        if (this.factory == null) {
            return false;
        }
        Model model = this.factory.getCapabilities();
        Resource resource = model.getResource(this.factory.getURI());
        return model.contains(resource, ReasonerVocabulary.supportsP, property);
    }

    public Reasoner bindSchema(Graph graph) throws ReasonerException {
        if (this.schemaGraph != null) {
            throw new ReasonerException("Can only bind one schema at a time to an OWLRuleReasoner");
        }
        FBRuleInfGraph fBRuleInfGraph = new FBRuleInfGraph(this, this.rules, this.getPreload(), graph);
        fBRuleInfGraph.prepare();
        FBRuleReasoner fBRuleReasoner = new FBRuleReasoner(this.rules, fBRuleInfGraph, this.factory);
        fBRuleReasoner.setDerivationLogging(this.recordDerivations);
        fBRuleReasoner.setTraceOn(this.traceOn);
        return fBRuleReasoner;
    }

    public Reasoner bindSchema(Model model) throws ReasonerException {
        return this.bindSchema(model.getGraph());
    }

    public InfGraph bind(Graph graph) throws ReasonerException {
        InfGraph infGraph = this.schemaGraph == null ? this.getPreload() : (FBRuleInfGraph)this.schemaGraph;
        FBRuleInfGraph fBRuleInfGraph = new FBRuleInfGraph(this, this.rules, infGraph);
        fBRuleInfGraph.setDerivationLogging(this.recordDerivations);
        fBRuleInfGraph.setTraceOn(this.traceOn);
        fBRuleInfGraph.rebind(graph);
        return fBRuleInfGraph;
    }

    public void setRules(List list) {
        this.rules = list;
        this.preload = null;
    }

    public List getRules() {
        return this.rules;
    }

    protected synchronized InfGraph getPreload() {
        if (this.preload == null) {
            this.preload = new FBRuleInfGraph(this, this.rules, null);
            this.preload.prepare();
        }
        return this.preload;
    }

    public void setDerivationLogging(boolean bl) {
        this.recordDerivations = bl;
    }

    public void setTraceOn(boolean bl) {
        this.traceOn = bl;
    }

    public void setParameter(String string, Object object) {
        if (string.equals(ReasonerVocabulary.PROPderivationLogging.getURI())) {
            this.recordDerivations = Util.convertBooleanPredicateArg(string, object);
        } else if (string.equals(ReasonerVocabulary.PROPtraceOn.getURI())) {
            this.traceOn = Util.convertBooleanPredicateArg(string, object);
        } else {
            throw new IllegalParameterException("Don't recognize configuration parameter " + string + " for rule-based reasoner");
        }
    }
}

