/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.reasoner.rulesys.Builtin;
import com.hp.hpl.jena.reasoner.rulesys.builtins.AddOne;
import com.hp.hpl.jena.reasoner.rulesys.builtins.AssertDisjointPairs;
import com.hp.hpl.jena.reasoner.rulesys.builtins.Bound;
import com.hp.hpl.jena.reasoner.rulesys.builtins.IsFunctor;
import com.hp.hpl.jena.reasoner.rulesys.builtins.IsLiteral;
import com.hp.hpl.jena.reasoner.rulesys.builtins.LessThan;
import com.hp.hpl.jena.reasoner.rulesys.builtins.MakeInstance;
import com.hp.hpl.jena.reasoner.rulesys.builtins.MakeTemp;
import com.hp.hpl.jena.reasoner.rulesys.builtins.NoValue;
import com.hp.hpl.jena.reasoner.rulesys.builtins.NotEqual;
import com.hp.hpl.jena.reasoner.rulesys.builtins.NotFunctor;
import com.hp.hpl.jena.reasoner.rulesys.builtins.NotLiteral;
import com.hp.hpl.jena.reasoner.rulesys.builtins.Print;
import com.hp.hpl.jena.reasoner.rulesys.builtins.Remove;
import com.hp.hpl.jena.reasoner.rulesys.builtins.Sum;
import com.hp.hpl.jena.reasoner.rulesys.builtins.Unbound;
import java.util.HashMap;
import java.util.Map;

public class BuiltinRegistry {
    public static BuiltinRegistry theRegistry = new BuiltinRegistry();
    protected Map builtins = new HashMap();
    protected Map builtinsByURI = new HashMap();

    public void register(String string, Builtin builtin) {
        this.builtins.put(string, builtin);
        this.builtinsByURI.put(builtin.getURI(), builtin);
    }

    public void register(Builtin builtin) {
        this.builtins.put(builtin.getName(), builtin);
        this.builtinsByURI.put(builtin.getURI(), builtin);
    }

    public Builtin getImplementation(String string) {
        return (Builtin)this.builtins.get(string);
    }

    public Builtin getImplementationByURI(String string) {
        return (Builtin)this.builtinsByURI.get(string);
    }

    static {
        theRegistry.register(new Print());
        theRegistry.register(new AddOne());
        theRegistry.register(new LessThan());
        theRegistry.register(new NotFunctor());
        theRegistry.register(new IsFunctor());
        theRegistry.register(new NotEqual());
        theRegistry.register(new MakeTemp());
        theRegistry.register(new NoValue());
        theRegistry.register(new Remove());
        theRegistry.register(new Sum());
        theRegistry.register(new Bound());
        theRegistry.register(new Unbound());
        theRegistry.register(new IsLiteral());
        theRegistry.register(new NotLiteral());
        theRegistry.register(new AssertDisjointPairs());
        theRegistry.register(new MakeInstance());
    }
}

