/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rdfsReasoner1;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.IllegalParameterException;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSInfGraph;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveEngine;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveGraphCache;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasoner;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;

public class RDFSReasoner
extends TransitiveReasoner
implements Reasoner {
    public static Node domainP = RDFS.domain.getNode();
    public static Node rangeP = RDFS.range.getNode();
    protected boolean scanProperties = true;

    public RDFSReasoner() {
    }

    public RDFSReasoner(Resource resource) {
        Boolean bl;
        if (resource != null && (bl = this.checkBinaryPredicate(RDFSReasonerFactory.scanProperties, resource)) != null) {
            this.scanProperties = bl;
        }
    }

    protected RDFSReasoner(Finder finder, TransitiveGraphCache transitiveGraphCache, TransitiveGraphCache transitiveGraphCache2, boolean bl) {
        super(finder, transitiveGraphCache, transitiveGraphCache2);
        this.scanProperties = bl;
    }

    public boolean supportsProperty(Property property) {
        ReasonerFactory reasonerFactory = RDFSReasonerFactory.theInstance();
        Model model = reasonerFactory.getCapabilities();
        Resource resource = model.getResource(reasonerFactory.getURI());
        return model.contains(resource, ReasonerVocabulary.supportsP, property);
    }

    private Boolean checkBinaryPredicate(Property property, Resource resource) {
        StmtIterator stmtIterator = resource.listProperties(property);
        if (stmtIterator.hasNext()) {
            return new Boolean(((Object)stmtIterator.nextStatement().getObject()).toString().equalsIgnoreCase("true"));
        }
        return null;
    }

    public Reasoner bindSchema(Graph graph) throws ReasonerException {
        if (this.tbox != null) {
            throw new ReasonerException("Attempt to bind multiple rulesets - disallowed for now");
        }
        FGraph fGraph = new FGraph(graph);
        TransitiveGraphCache transitiveGraphCache = new TransitiveGraphCache(directSubClassOf, subClassOf);
        TransitiveGraphCache transitiveGraphCache2 = new TransitiveGraphCache(directSubPropertyOf, subPropertyOf);
        TransitiveEngine.cacheSubPropUtility(fGraph, transitiveGraphCache2);
        TransitiveEngine.cacheSubClassUtility(fGraph, transitiveGraphCache2, transitiveGraphCache);
        transitiveGraphCache2.setCaching(true);
        return new RDFSReasoner(fGraph, transitiveGraphCache, transitiveGraphCache2, this.scanProperties);
    }

    public InfGraph bind(Graph graph) throws ReasonerException {
        return new RDFSInfGraph(this, graph);
    }

    public void setDerivationLogging(boolean bl) {
    }

    public void setParameter(String string, Object object) {
        if (!string.equals(RDFSReasonerFactory.scanProperties.getURI())) {
            throw new IllegalParameterException(string);
        }
        this.scanProperties = Util.convertBooleanPredicateArg(string, object);
    }
}

