/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasonerFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.HashMap;
import java.util.Map;

public class ReasonerRegistry {
    protected static ReasonerRegistry theRegistry;
    protected Map reasonerFactories = new HashMap();
    protected Model allDescriptions = new ModelMem();
    protected static Reasoner theRDFSReasoner;
    protected static Reasoner theRDFSSimpleReasoner;
    protected static Reasoner theTRANSITIVEReasoner;
    protected static Reasoner theOWLReasoner;

    private ReasonerRegistry() {
        this.register(TransitiveReasonerFactory.theInstance());
        this.register(RDFSRuleReasonerFactory.theInstance());
        this.register(RDFSFBRuleReasonerFactory.theInstance());
        this.register(OWLFBRuleReasonerFactory.theInstance());
        this.register(GenericRuleReasonerFactory.theInstance());
    }

    public static ReasonerRegistry theRegistry() {
        if (theRegistry == null) {
            theRegistry = new ReasonerRegistry();
        }
        return theRegistry;
    }

    public void register(ReasonerFactory reasonerFactory) {
        this.reasonerFactories.put(reasonerFactory.getURI(), reasonerFactory);
        Model model = reasonerFactory.getCapabilities();
        if (model != null) {
            this.allDescriptions.add(model);
        }
        this.allDescriptions.createResource(reasonerFactory.getURI()).addProperty(RDF.type, ReasonerVocabulary.ReasonerClass);
    }

    public void register(String string, ReasonerFactory reasonerFactory) {
        this.reasonerFactories.put(string, reasonerFactory);
        this.allDescriptions.createResource(string).addProperty(RDF.type, ReasonerVocabulary.ReasonerClass);
    }

    public Model getAllDescriptions() {
        return this.allDescriptions;
    }

    public Resource getDescription(String string) {
        Resource resource = this.allDescriptions.getResource(string);
        if (this.allDescriptions.contains(resource, RDF.type, ReasonerVocabulary.ReasonerClass)) {
            return resource;
        }
        return null;
    }

    public ReasonerFactory getFactory(String string) {
        return (ReasonerFactory)this.reasonerFactories.get(string);
    }

    public Reasoner create(String string, Resource resource) throws ReasonerException {
        ReasonerFactory reasonerFactory = this.getFactory(string);
        if (reasonerFactory != null) {
            return reasonerFactory.create(resource);
        }
        throw new ReasonerException("Attempted to instantiate an unknown reasoner: " + string);
    }

    public static Node makeDirect(Node node) {
        String string = "urn:x-hp-direct-predicate:" + node.getURI().replace(':', '_');
        return Node.createURI(string);
    }

    public static Reasoner getRDFSReasoner() {
        if (theRDFSReasoner == null) {
            theRDFSReasoner = RDFSRuleReasonerFactory.theInstance().create(null);
        }
        return theRDFSReasoner;
    }

    public static Reasoner getRDFSSimpleReasoner() {
        if (theRDFSSimpleReasoner == null) {
            theRDFSSimpleReasoner = RDFSRuleReasonerFactory.theInstance().create(null);
            theRDFSSimpleReasoner.setParameter(ReasonerVocabulary.PROPsetRDFSLevel.getURI(), ReasonerVocabulary.RDFS_SIMPLE);
        }
        return theRDFSSimpleReasoner;
    }

    public static Reasoner getTransitiveReasoner() {
        if (theTRANSITIVEReasoner == null) {
            theTRANSITIVEReasoner = TransitiveReasonerFactory.theInstance().create(null);
        }
        return theTRANSITIVEReasoner;
    }

    public static Reasoner getOWLReasoner() {
        if (theOWLReasoner == null) {
            theOWLReasoner = OWLFBRuleReasonerFactory.theInstance().create(null);
        }
        return theOWLReasoner;
    }

    static {
        theRDFSReasoner = null;
        theRDFSSimpleReasoner = null;
    }
}

