/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.test;

import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.QueryResultsFormatter;
import com.hp.hpl.jena.rdql.QueryResultsMem;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.ModelLoader;
import com.hp.hpl.jena.util.TestManifestList;
import com.hp.hpl.jena.vocabulary.TestQuery;
import java.io.IOException;
import java.io.PrintWriter;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;

public class QueryTestScripts
extends TestSuite {
    static final String testSetName = "RDQL - Query - Scripts";
    public static final String defaultControlFilename = "rdql-tests.n3";
    public static final String defaultTestDirectory = "testing/RDQL";
    public String basename = null;
    public static boolean printDetails = false;
    public static boolean displayTime = false;
    protected static Logger logger = Logger.getLogger((Class)(class$com$hp$hpl$jena$rdql$test$QueryTestScripts == null ? (class$com$hp$hpl$jena$rdql$test$QueryTestScripts = QueryTestScripts.class$("com.hp.hpl.jena.rdql.test.QueryTestScripts")) : class$com$hp$hpl$jena$rdql$test$QueryTestScripts));
    String controlFilename = null;
    String testDirectory = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdql$test$QueryTestScripts;

    public static TestSuite suite() {
        return QueryTestScripts.suite(testSetName, null);
    }

    public static TestSuite suite(String string, Model model) {
        return QueryTestScripts.suite(string, model, defaultTestDirectory, defaultControlFilename);
    }

    public static TestSuite suite(String string, Model model, String string2, String string3) {
        return new QueryTestScripts(string, model, string2, string3);
    }

    private QueryTestScripts(String string, Model model, String string2, String string3) {
        super(string);
        this.testDirectory = string2;
        this.controlFilename = string3;
        String string4 = this.testDirectory == null ? this.controlFilename : this.testDirectory + "/" + this.controlFilename;
        this.addTests(model, string4);
    }

    public static void doTests(String string, boolean bl, boolean bl2) {
        displayTime = bl2;
        printDetails = bl || bl2;
        QueryTestScripts.init();
        TestSuite testSuite = QueryTestScripts.suite("RDQL-Scripts", null, null, string);
        TestRunner.run((Test)testSuite);
    }

    public void addTests(Model model, String string) {
        PrintWriter printWriter = new PrintWriter(System.out);
        Model model2 = ModelLoader.loadModel(string, "N3");
        TestManifestList testManifestList = new TestManifestList(model2);
        TestManifestList.TestIterator testIterator = testManifestList.iterator();
        while (testIterator.hasNext()) {
            Object object;
            TestManifestList.TestItem testItem = testIterator.nextItem();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (testItem.getAction() instanceof Literal) {
                string2 = ((Literal)testItem.getAction()).getString();
            } else if (!((Resource)testItem.getAction()).isAnon()) {
                string2 = ((Resource)testItem.getAction()).getURI();
            } else {
                object = (Resource)testItem.getAction();
                string2 = object.getProperty(TestQuery.query).getResource().getURI();
                if (object.hasProperty(TestQuery.data)) {
                    string3 = object.getProperty(TestQuery.data).getResource().getURI();
                }
            }
            if (testItem.getResult() != null) {
                string4 = testItem.getResult() instanceof Resource ? ((Resource)testItem.getResult()).getURI() : ((Literal)testItem.getResult()).getString();
            }
            object = new RDQLTest(model, printWriter, testItem.getName(), this.testDirectory, string2, string3, string4);
            this.addTest((Test)object);
        }
    }

    private static void emptyModel(Model model) {
        if (model == null) {
            return;
        }
        try {
            StmtIterator stmtIterator = model.listStatements();
            while (stmtIterator.hasNext()) {
                stmtIterator.nextStatement();
                stmtIterator.remove();
            }
            stmtIterator.close();
        }
        catch (JenaException jenaException) {
            logger.error((Object)"Failed to empty model (com.hp.hpl.jena.rdf.query.Test.QueryTest.emptyModel)", (Throwable)jenaException);
        }
    }

    static String convertFilename(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("file:")) {
            string = string.substring("file:".length());
        }
        if (string2 != null && !string.startsWith("/")) {
            string = string2 + "/" + string;
        }
        return string;
    }

    private static void init() {
        String string = "SELECT * WHERE (?x, ?y, ?z)";
        Query query = new Query(string);
        query.setSource(new ModelMem());
        QueryEngine queryEngine = new QueryEngine(query);
        QueryResults queryResults = queryEngine.exec();
        QueryResultsFormatter queryResultsFormatter = new QueryResultsFormatter(queryResults);
        queryResultsFormatter.consume();
    }

    static String formatlong(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Long.toString(l));
        for (int i = stringBuffer.length(); i < 4; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class RDQLTest
    extends TestCase {
        static int testCounter = 1;
        Model model;
        PrintWriter pw;
        int testNumber = testCounter++;
        String queryFile;
        String dataFile;
        String resultsFile;
        String directory;

        RDQLTest(PrintWriter printWriter, String string, String string2, String string3, String string4, String string5) {
            this(null, printWriter, string, string2, string3, string4, string5);
        }

        RDQLTest(Model model, PrintWriter printWriter, String string, String string2, String string3, String string4, String string5) {
            super(string);
            this.model = model;
            this.pw = printWriter;
            this.queryFile = string3;
            this.dataFile = string4;
            this.resultsFile = string5;
            this.directory = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runTest() throws Throwable {
            block23: {
                Query query = null;
                try {
                    try {
                        Object object;
                        boolean bl;
                        if (printDetails) {
                            if (this.testNumber != 1) {
                                this.pw.println();
                                this.pw.println("------------------------------------------------------------------------");
                                this.pw.println();
                            }
                            this.pw.println("Test " + this.testNumber + " :: QueryFile=" + this.queryFile + ", DataFile=" + this.dataFile + ", ResultsFile=" + this.resultsFile);
                        }
                        String string = QueryTestScripts.convertFilename(this.queryFile, this.directory);
                        String string2 = FileUtils.readWholeFile(string);
                        if (printDetails) {
                            this.pw.println("Query:");
                            this.pw.println(string2);
                            if (!string2.endsWith("\n")) {
                                this.pw.println();
                            }
                            this.pw.flush();
                        }
                        long l = System.currentTimeMillis();
                        query = new Query(string2);
                        if (printDetails) {
                            this.pw.println("Parsed query:");
                            this.pw.println(query.toString());
                            this.pw.flush();
                        }
                        if (this.model == null) {
                            if (this.dataFile != null && !this.dataFile.equals("")) {
                                long l2 = System.currentTimeMillis();
                                String string3 = QueryTestScripts.convertFilename(this.dataFile, this.directory);
                                query.setSource(ModelLoader.loadModel(string3, null));
                                query.loadTime = System.currentTimeMillis() - l2;
                            }
                        } else {
                            QueryTestScripts.emptyModel(this.model);
                            String string4 = QueryTestScripts.convertFilename(this.dataFile, this.directory);
                            if (string4 == null) {
                                string4 = query.getSourceURL();
                            }
                            long l3 = System.currentTimeMillis();
                            query.setSource(ModelLoader.loadModel(this.model, string4, null));
                            query.loadTime = System.currentTimeMillis() - l3;
                        }
                        QueryEngine queryEngine = new QueryEngine(query);
                        ModelLoader.setFileBase(this.directory);
                        queryEngine.init();
                        ModelLoader.setFileBase(null);
                        QueryResults queryResults = queryEngine.exec();
                        long l4 = System.currentTimeMillis();
                        long l5 = l4 - l;
                        QueryResultsMem queryResultsMem = new QueryResultsMem(queryResults);
                        queryResults.close();
                        queryResults = null;
                        boolean bl2 = bl = this.resultsFile != null && !this.resultsFile.equals("");
                        if (printDetails) {
                            object = new QueryResultsFormatter(queryResultsMem);
                            ((QueryResultsFormatter)object).printAll(this.pw, " | ");
                            this.pw.println();
                            int n = ((QueryResultsFormatter)object).numRows();
                            this.pw.println("Results: " + (n < 0 ? "unknown (one pass format)" : n + ""));
                            ((QueryResultsFormatter)object).close();
                            queryResultsMem.rewind();
                        }
                        if (printDetails && displayTime) {
                            this.pw.println();
                            this.pw.println("Query parse:     " + QueryTestScripts.formatlong(query.parseTime) + " ms");
                            this.pw.println("Query build:     " + QueryTestScripts.formatlong(query.buildTime) + " ms");
                            this.pw.println("Data load time:  " + QueryTestScripts.formatlong(query.loadTime) + " ms");
                            this.pw.println("Query execute:   " + QueryTestScripts.formatlong(query.executeTime) + " ms");
                            this.pw.println("Query misc:      " + QueryTestScripts.formatlong(l5 - query.parseTime - query.buildTime - query.loadTime - query.executeTime) + " ms");
                            this.pw.println("Query total:     " + QueryTestScripts.formatlong(l5) + " ms");
                            this.pw.flush();
                        }
                        if (bl) {
                            QueryResultsMem queryResultsMem2 = new QueryResultsMem((QueryResults)queryResultsMem);
                            object = QueryTestScripts.convertFilename(this.resultsFile, this.directory);
                            QueryResultsMem queryResultsMem3 = new QueryResultsMem((String)object);
                            if (!QueryResultsMem.equivalent(queryResultsMem2, queryResultsMem3)) {
                                this.pw.println();
                                this.pw.println("=======================================");
                                this.pw.println("Failure: " + this.queryFile);
                                this.pw.println("Got: ----------------------------------");
                                queryResultsMem2.rewind();
                                queryResultsMem2.list(this.pw);
                                queryResultsMem2.rewind();
                                this.pw.println("---------------------------------------");
                                queryResultsMem2.toModel().write(this.pw, "N3");
                                this.pw.flush();
                                queryResultsMem2.close();
                                this.pw.println("Expected: -----------------------------");
                                queryResultsMem3.rewind();
                                queryResultsMem3.list(this.pw);
                                queryResultsMem3.rewind();
                                this.pw.println("---------------------------------------");
                                queryResultsMem3.toModel().write(this.pw, "N3");
                                queryResultsMem3.close();
                                this.pw.flush();
                                Assert.assertTrue((String)("Rsults do not match: " + this.queryFile), (boolean)false);
                            }
                            queryResultsMem2.close();
                            queryResultsMem3.close();
                        }
                        queryResultsMem.close();
                    }
                    catch (QueryException queryException) {
                        this.pw.flush();
                        Assert.fail((String)this.queryFile);
                        throw queryException;
                    }
                    catch (IOException iOException) {
                        this.pw.println("IOException: " + iOException);
                        iOException.printStackTrace(this.pw);
                        this.pw.flush();
                        Object var18_23 = null;
                        if (this.model == null && query.getSource() != null) {
                            query.getSource().close();
                        }
                        this.pw.flush();
                        break block23;
                    }
                    catch (Exception exception) {
                        this.pw.println("Exception: " + exception);
                        exception.printStackTrace(this.pw);
                        this.pw.flush();
                        Assert.assertTrue((String)("Exception: " + this.queryFile), (boolean)false);
                        Object var18_24 = null;
                        if (this.model == null && query.getSource() != null) {
                            query.getSource().close();
                        }
                        this.pw.flush();
                    }
                    Object var18_22 = null;
                    if (this.model == null && query.getSource() != null) {
                        query.getSource().close();
                    }
                    this.pw.flush();
                }
                catch (Throwable throwable) {
                    Object var18_25 = null;
                    if (this.model == null && query.getSource() != null) {
                        query.getSource().close();
                    }
                    this.pw.flush();
                    throw throwable;
                }
            }
        }
    }
}

