/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Variable;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.rdql.Constraint;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.QueryExecution;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.QueryResultsStream;
import com.hp.hpl.jena.rdql.ResultBinding;
import com.hp.hpl.jena.rdql.Value;
import com.hp.hpl.jena.util.ModelLoader;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.ListIterator;

public class QueryEngine
implements QueryExecution {
    Query query;
    static int queryCount = 0;
    boolean queryInitialised = false;
    int idQueryExecution;
    ResultsIterator resultsIter;
    long queryStartTime = -1L;

    public QueryEngine(Query query) {
        this.query = query;
        this.idQueryExecution = ++queryCount;
    }

    public void init() {
        if (this.queryInitialised) {
            return;
        }
        if (this.query.getSource() == null) {
            if (this.query.sourceURL == null) {
                Query.logger.warn((Object)"No data for query (no URL, no model)");
                throw new QueryException("No model for query");
            }
            long l = System.currentTimeMillis();
            this.query.setSource(ModelLoader.loadModel(this.query.sourceURL, null));
            this.query.loadTime = System.currentTimeMillis() - l;
        }
        this.queryInitialised = true;
    }

    public QueryResults exec() {
        return this.exec(null);
    }

    public QueryResults exec(ResultBinding resultBinding) {
        this.init();
        this.resultsIter = new ResultsIterator(this.query, resultBinding);
        return new QueryResultsStream(this.query, this, this.resultsIter);
    }

    public void abort() {
        this.resultsIter.close();
    }

    public void close() {
        this.resultsIter.close();
    }

    static Node convertValueToNode(Value value) {
        if (value.isRDFLiteral()) {
            return Node.createLiteral(value.getRDFLiteral().getLexicalForm(), value.getRDFLiteral().getLanguage(), value.getRDFLiteral().getDatatype());
        }
        if (value.isRDFResource()) {
            if (value.getRDFResource().isAnon()) {
                return Node.createAnon(value.getRDFResource().getId());
            }
            return Node.createURI(value.getRDFResource().getURI());
        }
        if (value.isURI()) {
            return Node.createURI(value.getURI());
        }
        return Node.createLiteral(value.asUnquotedString(), null, null);
    }

    static RDFNode convertNodeToRDFNode(Node node, Model model) {
        if (node.isLiteral()) {
            return new LiteralImpl(node, model);
        }
        if (node.isURI() || node.isBlank()) {
            return new ResourceImpl(node, model);
        }
        if (node.isVariable()) {
            System.err.println("Variable unbound: " + node);
            return null;
        }
        System.err.println("Unknown node type for node: " + node);
        return null;
    }

    static Triple substituteIntoTriple(Triple triple, ResultBinding resultBinding) {
        if (resultBinding == null) {
            return triple;
        }
        boolean bl = true;
        Node node = QueryEngine.substituteNode(triple.getSubject(), resultBinding);
        Node node2 = QueryEngine.substituteNode(triple.getPredicate(), resultBinding);
        Node node3 = QueryEngine.substituteNode(triple.getObject(), resultBinding);
        if (node == triple.getSubject() && node2 == triple.getPredicate() && node3 == triple.getObject()) {
            return triple;
        }
        return new Triple(node, node2, node3);
    }

    static Node substituteNode(Node node, ResultBinding resultBinding) {
        if (!node.isVariable()) {
            return node;
        }
        String string = ((Node_Variable)node).getName();
        Object object = resultBinding.get(string);
        if (object == null) {
            return node;
        }
        if (object instanceof RDFNode) {
            return ((RDFNode)object).asNode();
        }
        if (object instanceof Value) {
            return QueryEngine.convertValueToNode((Value)object);
        }
        System.err.println("Unknown object in binding: ignored: " + object.getClass().getName());
        return node;
    }

    static class ResultsIterator
    implements ClosableIterator {
        Node[] projectionVars;
        Query query;
        ResultBinding nextBinding = null;
        boolean finished = false;
        ClosableIterator planIter;
        ResultBinding initialBindings;

        ResultsIterator(Query query, ResultBinding resultBinding) {
            this.query = query;
            this.initialBindings = resultBinding;
            Graph graph = this.query.getSource().getGraph();
            QueryHandler queryHandler = graph.queryHandler();
            com.hp.hpl.jena.graph.query.Query query2 = new com.hp.hpl.jena.graph.query.Query();
            ListIterator listIterator = this.query.getTriplePatterns().listIterator();
            while (listIterator.hasNext()) {
                Triple triple = (Triple)listIterator.next();
                triple = QueryEngine.substituteIntoTriple(triple, resultBinding);
                query2.addMatch(triple);
            }
            this.projectionVars = new Node[this.query.getBoundVars().size()];
            for (int i = 0; i < this.projectionVars.length; ++i) {
                this.projectionVars[i] = Node.createVariable((String)this.query.getBoundVars().get(i));
            }
            BindingQueryPlan bindingQueryPlan = queryHandler.prepareBindings(query2, this.projectionVars);
            this.planIter = bindingQueryPlan.executeBindings();
        }

        public boolean hasNext() {
            if (this.finished) {
                return false;
            }
            while (this.nextBinding == null && this.planIter.hasNext()) {
                Object object;
                Object object2;
                int n;
                Domain domain = (Domain)this.planIter.next();
                this.nextBinding = new ResultBinding(this.initialBindings);
                this.nextBinding.setQuery(this.query);
                for (n = 0; n < this.projectionVars.length; ++n) {
                    object2 = this.projectionVars[n].toString().substring(1);
                    object = (Node)domain.get(n);
                    if (object == null) continue;
                    RDFNode rDFNode = QueryEngine.convertNodeToRDFNode((Node)object, this.query.getSource());
                    this.nextBinding.add((String)object2, rDFNode);
                }
                n = 1;
                object2 = this.query.constraints.iterator();
                while (object2.hasNext()) {
                    object = (Constraint)object2.next();
                    if (object.isSatisfied(this.query, this.nextBinding)) continue;
                    n = 0;
                    break;
                }
                if (n != 0) continue;
                this.nextBinding = null;
            }
            if (this.nextBinding == null) {
                this.close();
                return false;
            }
            return true;
        }

        public Object next() {
            ResultBinding resultBinding = this.nextBinding;
            this.nextBinding = null;
            return resultBinding;
        }

        public void remove() {
            throw new UnsupportedOperationException("QueryEngine.ResultsIterator.remove");
        }

        public void close() {
            if (!this.finished) {
                this.planIter.close();
                this.finished = true;
            }
        }
    }
}

