/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.impl.ModelMakerImpl;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestSuite;

public class TestModelMakerImpl
extends ModelTestBase {
    private ModelMaker maker;
    private Graph graph;
    private GraphMaker graphMaker;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$test$TestModelMakerImpl;

    public TestModelMakerImpl(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$rdf$model$test$TestModelMakerImpl == null ? (class$com$hp$hpl$jena$rdf$model$test$TestModelMakerImpl = TestModelMakerImpl.class$("com.hp.hpl.jena.rdf.model.test.TestModelMakerImpl")) : class$com$hp$hpl$jena$rdf$model$test$TestModelMakerImpl);
    }

    public void setUp() {
        this.graph = GraphTestBase.graphWith("");
        this.graphMaker = new MockGraphMaker(this.graph);
        this.maker = new ModelMakerImpl(this.graphMaker);
    }

    public void testClose() {
        this.maker.close();
        TestModelMakerImpl.assertEquals((Object)this.history(), (Object)this.one("close()"));
    }

    public void testRemove() {
        this.maker.removeModel("London");
        TestModelMakerImpl.assertEquals((Object)this.history(), (Object)this.one("remove(London)"));
    }

    public void testCreate() {
        Model model = this.maker.createModel("petal");
        TestModelMakerImpl.assertEquals((Object)this.history(), (Object)this.one("create(petal,false)"));
        TestModelMakerImpl.assertTrue((model.getGraph() == this.graph ? 1 : 0) != 0);
    }

    public void testCreateTrue() {
        Model model = this.maker.createModel("stem", true);
        TestModelMakerImpl.assertEquals((Object)this.history(), (Object)this.one("create(stem,true)"));
        TestModelMakerImpl.assertTrue((model.getGraph() == this.graph ? 1 : 0) != 0);
    }

    public void testCreateFalse() {
        Model model = this.maker.createModel("leaf", false);
        TestModelMakerImpl.assertEquals((Object)this.history(), (Object)this.one("create(leaf,false)"));
        TestModelMakerImpl.assertTrue((model.getGraph() == this.graph ? 1 : 0) != 0);
    }

    public void testOpen() {
        Model model = this.maker.openModel("trunk");
        TestModelMakerImpl.assertEquals((Object)this.history(), (Object)this.one("open(trunk,false)"));
        TestModelMakerImpl.assertTrue((model.getGraph() == this.graph ? 1 : 0) != 0);
    }

    public void testOpenFalse() {
        Model model = this.maker.openModel("branch", false);
        TestModelMakerImpl.assertEquals((Object)this.history(), (Object)this.one("open(branch,false)"));
        TestModelMakerImpl.assertTrue((model.getGraph() == this.graph ? 1 : 0) != 0);
    }

    public void testOpenTrue() {
        Model model = this.maker.openModel("bark", true);
        TestModelMakerImpl.assertEquals((Object)this.history(), (Object)this.one("open(bark,true)"));
        TestModelMakerImpl.assertTrue((model.getGraph() == this.graph ? 1 : 0) != 0);
    }

    public void testGetGraphMaker() {
        TestModelMakerImpl.assertTrue((this.maker.getGraphMaker() == this.graphMaker ? 1 : 0) != 0);
    }

    private List history() {
        return ((MockGraphMaker)this.maker.getGraphMaker()).history;
    }

    private List one(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class MockGraphMaker
    implements GraphMaker {
        List history = new ArrayList();
        Graph graph;

        public MockGraphMaker(Graph graph) {
            this.graph = graph;
        }

        public Graph getGraph() {
            this.history.add("get()");
            return this.graph;
        }

        public Graph createGraph(String string, boolean bl) {
            this.history.add("create(" + string + "," + bl + ")");
            return this.graph;
        }

        public Graph createGraph(String string) {
            this.history.add("create(" + string + ")");
            return this.graph;
        }

        public Graph openGraph(String string, boolean bl) {
            this.history.add("open(" + string + "," + bl + ")");
            return this.graph;
        }

        public Graph openGraph(String string) {
            this.history.add("open(" + string + ")");
            return this.graph;
        }

        public void removeGraph(String string) {
            this.history.add("remove(" + string + ")");
        }

        public boolean hasGraph(String string) {
            this.history.add("has(" + string + ")");
            return false;
        }

        public void close() {
            this.history.add("close()");
        }
    }
}

