/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.IteratorFactory;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.RSIteratorImpl;
import com.hp.hpl.jena.rdf.model.impl.ReifiedStatementImpl;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.Map1;

public class ModelReifier {
    private ModelCom model;
    private Reifier reifier;
    private static boolean copyingReifications = false;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$ReifiedStatement;

    public ModelReifier(ModelCom modelCom) {
        this.model = modelCom;
        this.reifier = modelCom.asGraph().getReifier();
    }

    public static Model withHiddenStatements(Model model) {
        Graph graph = model.getGraph();
        Graph graph2 = graph.getReifier().getHiddenTriples();
        return new ModelCom(new Union(graph, graph2));
    }

    public Model getHiddenStatements() {
        return new ModelCom(this.reifier.getHiddenTriples());
    }

    public ReifiedStatement createReifiedStatement(Statement statement) {
        return this.createReifiedStatement(null, statement);
    }

    public ReifiedStatement createReifiedStatement(String string, Statement statement) {
        return ReifiedStatementImpl.create(this.model, string, statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getAnyReifiedStatement(Statement statement) {
        RSIterator rSIterator = this.listReifiedStatements(statement);
        if (rSIterator.hasNext()) {
            try {
                ReifiedStatement reifiedStatement = rSIterator.nextRS();
                return reifiedStatement;
            }
            finally {
                rSIterator.close();
            }
        }
        return this.createReifiedStatement(statement);
    }

    public boolean isReified(Statement statement) {
        return this.reifier.hasTriple(statement.asTriple());
    }

    public void removeAllReifications(Statement statement) {
        this.reifier.remove(statement.asTriple());
    }

    public void removeReification(ReifiedStatement reifiedStatement) {
        this.reifier.remove(reifiedStatement.asNode(), reifiedStatement.getStatement().asTriple());
    }

    public RSIterator listReifiedStatements() {
        return this.listReifiedStatements(Filter.any);
    }

    public RSIterator listReifiedStatements(Statement statement) {
        return this.listReifiedStatements(this.matching(statement));
    }

    public RSIterator listReifiedStatements(Filter filter) {
        return new RSIteratorImpl(this.findReifiedStatements().filterKeep(filter));
    }

    public void noteIfReified(RDFNode rDFNode, RDFNode rDFNode2, RDFNode rDFNode3) {
        if (copyingReifications) {
            this.noteIfReified(rDFNode);
            this.noteIfReified(rDFNode2);
            this.noteIfReified(rDFNode3);
        }
    }

    private void noteIfReified(RDFNode rDFNode) {
        if (rDFNode.canAs(class$com$hp$hpl$jena$rdf$model$ReifiedStatement == null ? (class$com$hp$hpl$jena$rdf$model$ReifiedStatement = ModelReifier.class$("com.hp.hpl.jena.rdf.model.ReifiedStatement")) : class$com$hp$hpl$jena$rdf$model$ReifiedStatement)) {
            ReifiedStatement reifiedStatement = (ReifiedStatement)rDFNode.as(class$com$hp$hpl$jena$rdf$model$ReifiedStatement == null ? (class$com$hp$hpl$jena$rdf$model$ReifiedStatement = ModelReifier.class$("com.hp.hpl.jena.rdf.model.ReifiedStatement")) : class$com$hp$hpl$jena$rdf$model$ReifiedStatement);
            this.createReifiedStatement(reifiedStatement.getURI(), reifiedStatement.getStatement());
        }
    }

    private Filter matching(final Statement statement) {
        return new Filter(){

            public boolean accept(Object object) {
                ReifiedStatement reifiedStatement = (ReifiedStatement)((RDFNode)object).as(class$com$hp$hpl$jena$rdf$model$ReifiedStatement == null ? (class$com$hp$hpl$jena$rdf$model$ReifiedStatement = ModelReifier.class$("com.hp.hpl.jena.rdf.model.ReifiedStatement")) : class$com$hp$hpl$jena$rdf$model$ReifiedStatement);
                return ((Object)reifiedStatement.getStatement()).equals(statement);
            }
        };
    }

    private ExtendedIterator findReifiedStatements() {
        Map1 map1 = new Map1(){

            public Object map1(Object object) {
                return ModelReifier.this.getRS((Node)object);
            }
        };
        return this.reifier.allNodes().mapWith(map1);
    }

    private ReifiedStatement getRS(Node node) {
        Triple triple = this.reifier.getTriple(node);
        Statement statement = IteratorFactory.asStatement(triple, this.model);
        return ReifiedStatementImpl.create(this.model, node, statement);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

