/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.enhanced.BuiltinPersonalities;
import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.Personality;
import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Container;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.ModelLock;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.NsIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.RDFReaderF;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.RDFWriterF;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceF;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.IteratorFactory;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelI;
import com.hp.hpl.jena.rdf.model.impl.ModelListenerAdapter;
import com.hp.hpl.jena.rdf.model.impl.ModelLockImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelReifier;
import com.hp.hpl.jena.rdf.model.impl.NodeIteratorFactory;
import com.hp.hpl.jena.rdf.model.impl.NsIteratorImpl;
import com.hp.hpl.jena.rdf.model.impl.QueryMapper;
import com.hp.hpl.jena.rdf.model.impl.RDFReaderFImpl;
import com.hp.hpl.jena.rdf.model.impl.RDFWriterFImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;
import com.hp.hpl.jena.rdf.model.impl.StmtIteratorImpl;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.shared.Command;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.JenaInvalidPropertyURIException;
import com.hp.hpl.jena.shared.JenaPropertyNotFoundException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.Map1Iterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ModelCom
extends EnhGraph
implements Model,
ModelI,
PrefixMapping,
ModelLock {
    private RDFReaderF readerFactory = new RDFReaderFImpl();
    private RDFWriterF writerFactory = new RDFWriterFImpl();
    private ModelLock modelLock = null;
    protected ModelReifier modelReifier = new ModelReifier(this);
    private Map1 mapAsTriple = new Map1(){

        public Object map1(Object object) {
            return ((Statement)object).asTriple();
        }
    };
    protected Map1 mapAsStatement = new Map1(){

        public Object map1(Object object) {
            return ModelCom.this.asStatement((Triple)object);
        }
    };
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$RDFList;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Seq;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Bag;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Alt;

    public ModelCom(Graph graph) {
        this(graph, BuiltinPersonalities.model);
    }

    public QueryHandler queryHandler() {
        return this.getGraph().queryHandler();
    }

    public ModelCom(Graph graph, Personality personality) {
        super(graph, personality);
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Resource getResource(String string, ResourceF resourceF) {
        try {
            return resourceF.createResource(this.getResource(string));
        }
        catch (Exception exception) {
            throw new JenaException(exception);
        }
    }

    public Model add(Resource resource, Property property, boolean bl) {
        return this.add(resource, property, String.valueOf(bl));
    }

    public Model add(Resource resource, Property property, long l) {
        return this.add(resource, property, String.valueOf(l));
    }

    public Model add(Resource resource, Property property, char c) {
        return this.add(resource, property, String.valueOf(c));
    }

    public Model add(Resource resource, Property property, float f) {
        return this.add(resource, property, String.valueOf(f));
    }

    public Model add(Resource resource, Property property, double d) {
        return this.add(resource, property, String.valueOf(d));
    }

    public Model add(Resource resource, Property property, String string) {
        return this.add(resource, property, string, "", false);
    }

    public Model add(Resource resource, Property property, String string, boolean bl) {
        return this.add(resource, property, string, "", bl);
    }

    public Model add(Resource resource, Property property, String string, String string2, boolean bl) {
        this.add(resource, property, this.literal(string, string2, bl));
        return this;
    }

    private Literal literal(String string, String string2, boolean bl) {
        return new LiteralImpl(Node.createLiteral(string, string2, bl), this);
    }

    public Model add(Resource resource, Property property, String string, String string2) {
        return this.add(resource, property, string, string2, false);
    }

    private RDFNode ensureRDFNode(Object object) {
        return object instanceof RDFNode ? (RDFNode)object : this.literal(object.toString(), null, false);
    }

    public Model add(Resource resource, Property property, Object object) {
        return this.add(resource, property, this.ensureRDFNode(object));
    }

    public Model add(StmtIterator stmtIterator) {
        this.getBulkUpdateHandler().add(this.asTriples(stmtIterator));
        return this;
    }

    public Model add(Model model) {
        this.getBulkUpdateHandler().add(model.getGraph());
        return this;
    }

    public RDFReader getReader() {
        return this.readerFactory.getReader();
    }

    public RDFReader getReader(String string) {
        return this.readerFactory.getReader(string);
    }

    public String setReaderClassName(String string, String string2) {
        return this.readerFactory.setReaderClassName(string, string2);
    }

    public Model read(String string) {
        this.readerFactory.getReader().read(this, string);
        return this;
    }

    public Model read(Reader reader, String string) {
        this.readerFactory.getReader().read((Model)this, reader, string);
        return this;
    }

    public Model read(InputStream inputStream, String string) {
        this.readerFactory.getReader().read((Model)this, inputStream, string);
        return this;
    }

    public Model read(String string, String string2) {
        this.readerFactory.getReader(string2).read(this, string);
        return this;
    }

    public Model read(Reader reader, String string, String string2) {
        this.readerFactory.getReader(string2).read((Model)this, reader, string);
        return this;
    }

    public Model read(InputStream inputStream, String string, String string2) {
        this.readerFactory.getReader(string2).read((Model)this, inputStream, string);
        return this;
    }

    public RDFWriter getWriter() {
        return this.writerFactory.getWriter();
    }

    public RDFWriter getWriter(String string) {
        return this.writerFactory.getWriter(string);
    }

    public String setWriterClassName(String string, String string2) {
        return this.writerFactory.setWriterClassName(string, string2);
    }

    public Model write(Writer writer) {
        this.getWriter().write((Model)this, writer, "");
        return this;
    }

    public Model write(Writer writer, String string) {
        this.getWriter(string).write((Model)this, writer, "");
        return this;
    }

    public Model write(Writer writer, String string, String string2) {
        this.getWriter(string).write((Model)this, writer, string2);
        return this;
    }

    public Model write(OutputStream outputStream) {
        this.getWriter().write((Model)this, outputStream, "");
        return this;
    }

    public Model write(OutputStream outputStream, String string) {
        this.getWriter(string).write((Model)this, outputStream, "");
        return this;
    }

    public Model write(OutputStream outputStream, String string, String string2) {
        this.getWriter(string).write((Model)this, outputStream, string2);
        return this;
    }

    public static Model withHiddenStatements(Model model) {
        return ModelReifier.withHiddenStatements(model);
    }

    public Model remove(Statement statement) {
        this.graph.delete(statement.asTriple());
        return this;
    }

    public Model remove(StmtIterator stmtIterator) {
        this.getBulkUpdateHandler().delete(this.asTriples(stmtIterator));
        return this;
    }

    public Model remove(Model model) {
        this.getBulkUpdateHandler().delete(model.getGraph());
        return this;
    }

    public boolean contains(Resource resource, Property property, boolean bl) {
        return this.contains(resource, property, String.valueOf(bl));
    }

    public boolean contains(Resource resource, Property property, long l) {
        return this.contains(resource, property, String.valueOf(l));
    }

    public boolean contains(Resource resource, Property property, char c) {
        return this.contains(resource, property, String.valueOf(c));
    }

    public boolean contains(Resource resource, Property property, float f) {
        return this.contains(resource, property, String.valueOf(f));
    }

    public boolean contains(Resource resource, Property property, double d) {
        return this.contains(resource, property, String.valueOf(d));
    }

    public boolean contains(Resource resource, Property property, String string) {
        return this.contains(resource, property, string, "");
    }

    public boolean contains(Resource resource, Property property, String string, String string2) {
        return this.contains(resource, property, this.literal(string, string2, false));
    }

    public boolean contains(Resource resource, Property property, Object object) {
        return this.contains(resource, property, this.ensureRDFNode(object));
    }

    public boolean containsAny(StmtIterator stmtIterator) {
        while (stmtIterator.hasNext()) {
            if (!this.contains(stmtIterator.nextStatement())) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(StmtIterator stmtIterator) {
        while (stmtIterator.hasNext()) {
            if (this.contains(stmtIterator.nextStatement())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAny(Model model) {
        StmtIterator stmtIterator = model.listStatements();
        try {
            boolean bl = this.containsAny(stmtIterator);
            return bl;
        }
        finally {
            stmtIterator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Model model) {
        StmtIterator stmtIterator = model.listStatements();
        try {
            boolean bl = this.containsAll(stmtIterator);
            return bl;
        }
        finally {
            stmtIterator.close();
        }
    }

    public StmtIterator listStatements(Resource resource, Property property, RDFNode rDFNode) {
        return this.listStatements(new SimpleSelector(resource, property, rDFNode));
    }

    public StmtIterator listStatements(Resource resource, Property property, boolean bl) {
        return this.listStatements(new SimpleSelector(resource, property, bl));
    }

    public StmtIterator listStatements(Resource resource, Property property, long l) {
        return this.listStatements(new SimpleSelector(resource, property, l));
    }

    public StmtIterator listStatements(Resource resource, Property property, char c) {
        return this.listStatements(new SimpleSelector(resource, property, c));
    }

    public StmtIterator listStatements(Resource resource, Property property, float f) {
        return this.listStatements(new SimpleSelector(resource, property, f));
    }

    public StmtIterator listStatements(Resource resource, Property property, double d) {
        return this.listStatements(new SimpleSelector(resource, property, d));
    }

    public StmtIterator listStatements(Resource resource, Property property, String string) {
        return this.listStatements(new SimpleSelector(resource, property, string));
    }

    public StmtIterator listStatements(Resource resource, Property property, String string, String string2) {
        return this.listStatements(new SimpleSelector(resource, property, string, string2));
    }

    public ResIterator listSubjectsWithProperty(Property property, boolean bl) {
        return this.listSubjectsWithProperty(property, String.valueOf(bl));
    }

    public ResIterator listSubjectsWithProperty(Property property, long l) {
        return this.listSubjectsWithProperty(property, String.valueOf(l));
    }

    public ResIterator listSubjectsWithProperty(Property property, char c) {
        return this.listSubjectsWithProperty(property, String.valueOf(c));
    }

    public ResIterator listSubjectsWithProperty(Property property, float f) {
        return this.listSubjectsWithProperty(property, String.valueOf(f));
    }

    public ResIterator listSubjectsWithProperty(Property property, double d) {
        return this.listSubjectsWithProperty(property, String.valueOf(d));
    }

    public ResIterator listSubjectsWithProperty(Property property, String string) {
        return this.listSubjectsWithProperty(property, string, "");
    }

    public ResIterator listSubjectsWithProperty(Property property, String string, String string2) {
        return this.listSubjectsWithProperty(property, this.literal(string, string2, false));
    }

    public ResIterator listSubjectsWithProperty(Property property, Object object) {
        return this.listSubjectsWithProperty(property, this.ensureRDFNode(object));
    }

    public Resource createResource(Resource resource) {
        return this.createResource().addProperty(RDF.type, resource);
    }

    public Resource createResource(String string, Resource resource) {
        return this.getResource(string).addProperty(RDF.type, resource);
    }

    public Resource createResource(ResourceF resourceF) {
        return this.createResource(null, resourceF);
    }

    public Resource createResource(AnonId anonId) {
        return new ResourceImpl(anonId, (Model)this);
    }

    public Resource createResource(String string, ResourceF resourceF) {
        return resourceF.createResource(this.createResource(string));
    }

    public Literal createTypedLiteral(boolean bl) {
        return this.createTypedLiteral(new Boolean(bl));
    }

    public Literal createTypedLiteral(int n) {
        return this.createTypedLiteral(new Integer(n));
    }

    public Literal createTypedLiteral(long l) {
        return this.createTypedLiteral(new Long(l));
    }

    public Literal createTypedLiteral(char c) {
        return this.createTypedLiteral(new Character(c));
    }

    public Literal createTypedLiteral(float f) {
        return this.createTypedLiteral(new Float(f));
    }

    public Literal createTypedLiteral(double d) {
        return this.createTypedLiteral(new Double(d));
    }

    public Literal createTypedLiteral(String string) {
        LiteralLabel literalLabel = new LiteralLabel(string);
        return new LiteralImpl(Node.createLiteral(literalLabel), this);
    }

    public Literal createTypedLiteral(String string, String string2, RDFDatatype rDFDatatype) throws DatatypeFormatException {
        LiteralLabel literalLabel = new LiteralLabel(string, string2, rDFDatatype);
        return new LiteralImpl(Node.createLiteral(literalLabel), this);
    }

    public Literal createTypedLiteral(Object object, String string, RDFDatatype rDFDatatype) {
        LiteralLabel literalLabel = new LiteralLabel(object, string, rDFDatatype);
        return new LiteralImpl(Node.createLiteral(literalLabel), this);
    }

    public Literal createTypedLiteral(String string, String string2, String string3) {
        RDFDatatype rDFDatatype = TypeMapper.getInstance().getSafeTypeByName(string3);
        LiteralLabel literalLabel = new LiteralLabel(string, string2, rDFDatatype);
        return new LiteralImpl(Node.createLiteral(literalLabel), this);
    }

    public Literal createTypedLiteral(Object object, String string, String string2) {
        RDFDatatype rDFDatatype = TypeMapper.getInstance().getSafeTypeByName(string2);
        LiteralLabel literalLabel = new LiteralLabel(object, string, rDFDatatype);
        return new LiteralImpl(Node.createLiteral(literalLabel), this);
    }

    public Literal createTypedLiteral(Object object) {
        LiteralLabel literalLabel = new LiteralLabel(object);
        return new LiteralImpl(Node.createLiteral(literalLabel), this);
    }

    public Literal createLiteral(boolean bl) {
        return this.createLiteral(String.valueOf(bl), "");
    }

    public Literal createLiteral(int n) {
        return this.createLiteral(String.valueOf(n), "");
    }

    public Literal createLiteral(long l) {
        return this.createLiteral(String.valueOf(l), "");
    }

    public Literal createLiteral(char c) {
        return this.createLiteral(String.valueOf(c), "");
    }

    public Literal createLiteral(float f) {
        return this.createLiteral(String.valueOf(f), "");
    }

    public Literal createLiteral(double d) {
        return this.createLiteral(String.valueOf(d), "");
    }

    public Literal createLiteral(String string) {
        return this.createLiteral(string, "");
    }

    public Literal createLiteral(String string, String string2) {
        return this.createLiteral(string, string2, false);
    }

    public Literal createLiteral(String string, String string2, boolean bl) {
        return this.literal(string, string2, bl);
    }

    public Literal createLiteral(Object object) {
        return this.createLiteral(object.toString(), "");
    }

    public Statement createStatement(Resource resource, Property property, boolean bl) {
        return this.createStatement(resource, property, this.createLiteral(bl));
    }

    public Statement createStatement(Resource resource, Property property, long l) {
        return this.createStatement(resource, property, this.createLiteral(l));
    }

    public Statement createStatement(Resource resource, Property property, char c) {
        return this.createStatement(resource, property, this.createLiteral(c));
    }

    public Statement createStatement(Resource resource, Property property, float f) {
        return this.createStatement(resource, property, this.createLiteral(f));
    }

    public Statement createStatement(Resource resource, Property property, double d) {
        return this.createStatement(resource, property, this.createLiteral(d));
    }

    public Statement createStatement(Resource resource, Property property, String string) {
        return this.createStatement(resource, property, this.createLiteral(string));
    }

    public Statement createStatement(Resource resource, Property property, Object object) {
        return this.createStatement(resource, property, this.ensureRDFNode(object));
    }

    public Statement createStatement(Resource resource, Property property, String string, boolean bl) {
        return this.createStatement(resource, property, string, "", bl);
    }

    public Statement createStatement(Resource resource, Property property, String string, String string2) {
        return this.createStatement(resource, property, string, string2, false);
    }

    public Statement createStatement(Resource resource, Property property, String string, String string2, boolean bl) {
        return this.createStatement(resource, property, this.literal(string, string2, bl));
    }

    public Bag createBag() {
        return this.createBag(null);
    }

    public Alt createAlt() {
        return this.createAlt(null);
    }

    public Seq createSeq() {
        return this.createSeq(null);
    }

    public RDFList createList() {
        Resource resource = this.getResource(RDF.nil.getURI());
        resource.addProperty(RDF.type, RDF.List);
        return (RDFList)resource.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = ModelCom.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList);
    }

    public RDFList createList(Iterator iterator) {
        RDFList rDFList = this.createList();
        while (iterator != null && iterator.hasNext()) {
            rDFList = rDFList.with((RDFNode)iterator.next());
        }
        return rDFList;
    }

    public RDFList createList(RDFNode[] rDFNodeArray) {
        return this.createList(Arrays.asList(rDFNodeArray).iterator());
    }

    public RDFNode getRDFNode(Node node) {
        return node.isURI() || node.isBlank() ? new ResourceImpl(node, (Model)this) : new LiteralImpl(node, this);
    }

    public Resource getResource(String string) {
        return IteratorFactory.asResource(ModelCom.makeURI(string), this);
    }

    public Property getProperty(String string) {
        if (string == null) {
            throw new JenaInvalidPropertyURIException(null);
        }
        return IteratorFactory.asProperty(ModelCom.makeURI(string), this);
    }

    public Property getProperty(String string, String string2) {
        return this.getProperty(string + string2);
    }

    public Seq getSeq(String string) {
        return (Seq)IteratorFactory.asResource(ModelCom.makeURI(string), class$com$hp$hpl$jena$rdf$model$Seq == null ? (class$com$hp$hpl$jena$rdf$model$Seq = ModelCom.class$("com.hp.hpl.jena.rdf.model.Seq")) : class$com$hp$hpl$jena$rdf$model$Seq, this);
    }

    public Seq getSeq(Resource resource) {
        return (Seq)resource.as(class$com$hp$hpl$jena$rdf$model$Seq == null ? (class$com$hp$hpl$jena$rdf$model$Seq = ModelCom.class$("com.hp.hpl.jena.rdf.model.Seq")) : class$com$hp$hpl$jena$rdf$model$Seq);
    }

    public Bag getBag(String string) {
        return (Bag)IteratorFactory.asResource(ModelCom.makeURI(string), class$com$hp$hpl$jena$rdf$model$Bag == null ? (class$com$hp$hpl$jena$rdf$model$Bag = ModelCom.class$("com.hp.hpl.jena.rdf.model.Bag")) : class$com$hp$hpl$jena$rdf$model$Bag, this);
    }

    public Bag getBag(Resource resource) {
        return (Bag)resource.as(class$com$hp$hpl$jena$rdf$model$Bag == null ? (class$com$hp$hpl$jena$rdf$model$Bag = ModelCom.class$("com.hp.hpl.jena.rdf.model.Bag")) : class$com$hp$hpl$jena$rdf$model$Bag);
    }

    private static Node makeURI(String string) {
        if (string == null) {
            return Node.createAnon(new AnonId());
        }
        return Node.createURI(string);
    }

    public Alt getAlt(String string) {
        return (Alt)IteratorFactory.asResource(ModelCom.makeURI(string), class$com$hp$hpl$jena$rdf$model$Alt == null ? (class$com$hp$hpl$jena$rdf$model$Alt = ModelCom.class$("com.hp.hpl.jena.rdf.model.Alt")) : class$com$hp$hpl$jena$rdf$model$Alt, this);
    }

    public Alt getAlt(Resource resource) {
        return (Alt)resource.as(class$com$hp$hpl$jena$rdf$model$Alt == null ? (class$com$hp$hpl$jena$rdf$model$Alt = ModelCom.class$("com.hp.hpl.jena.rdf.model.Alt")) : class$com$hp$hpl$jena$rdf$model$Alt);
    }

    public long size() {
        return this.graph.size();
    }

    public boolean isEmpty() {
        return this.graph.queryHandler().isEmpty();
    }

    private void updateNamespace(HashSet hashSet, Iterator iterator) {
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!node.isURI()) continue;
            String string = node.getURI();
            String string2 = string.substring(0, Util.splitNamespace(string));
            hashSet.add(string2);
        }
    }

    private Iterator listPredicates() {
        HashSet<Node> hashSet = new HashSet<Node>();
        ExtendedIterator extendedIterator = this.graph.find(null, null, null);
        while (extendedIterator.hasNext()) {
            hashSet.add(((Triple)extendedIterator.next()).getPredicate());
        }
        return hashSet.iterator();
    }

    private Iterator listTypes() {
        HashSet<Node> hashSet = new HashSet<Node>();
        ExtendedIterator extendedIterator = this.graph.find(null, RDF.type.asNode(), null);
        while (extendedIterator.hasNext()) {
            hashSet.add(((Triple)extendedIterator.next()).getObject());
        }
        return hashSet.iterator();
    }

    public NsIterator listNameSpaces() {
        HashSet hashSet = new HashSet();
        this.updateNamespace(hashSet, this.listPredicates());
        this.updateNamespace(hashSet, this.listTypes());
        return new NsIteratorImpl(hashSet.iterator(), hashSet);
    }

    private PrefixMapping getPrefixMapping() {
        return this.getGraph().getPrefixMapping();
    }

    public PrefixMapping lock() {
        this.getPrefixMapping().lock();
        return this;
    }

    public PrefixMapping setNsPrefix(String string, String string2) {
        this.getPrefixMapping().setNsPrefix(string, string2);
        return this;
    }

    public PrefixMapping setNsPrefixes(PrefixMapping prefixMapping) {
        this.getPrefixMapping().setNsPrefixes(prefixMapping);
        return this;
    }

    public PrefixMapping setNsPrefixes(Map map) {
        this.getPrefixMapping().setNsPrefixes(map);
        return this;
    }

    public String getNsPrefixURI(String string) {
        return this.getPrefixMapping().getNsPrefixURI(string);
    }

    public String getNsURIPrefix(String string) {
        return this.getPrefixMapping().getNsURIPrefix(string);
    }

    public Map getNsPrefixMap() {
        return this.getPrefixMapping().getNsPrefixMap();
    }

    public String expandPrefix(String string) {
        return this.getPrefixMapping().expandPrefix(string);
    }

    public String usePrefix(String string) {
        return this.getPrefixMapping().usePrefix(string);
    }

    public static void addNamespaces(Model model, Map map) {
        Model model2 = model;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Set set = (Set)entry.getValue();
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if (!PrefixMappingImpl.isNiceURI(string2)) continue;
                hashSet.add(string2);
            }
            if (hashSet.size() != 1) continue;
            model2.setNsPrefix(string, (String)hashSet.iterator().next());
        }
    }

    public ExtendedIterator queryBindingsWith(Model model, Resource[] resourceArray) {
        Map1 map1 = new Map1(){

            public Object map1(Object object) {
                return ModelCom.this.mappy(object);
            }
        };
        QueryMapper queryMapper = new QueryMapper(model, resourceArray);
        return queryMapper.getQuery().executeBindings(this.getGraph(), queryMapper.getVariables()).mapWith(map1);
    }

    public List mappy(Object object) {
        List list = (List)object;
        ArrayList<RDFNode> arrayList = new ArrayList<RDFNode>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(this.asRDF((Node)list.get(i)));
        }
        return arrayList;
    }

    private RDFNode asRDF(Node node) {
        return IteratorFactory.asRDFNode(node, this);
    }

    public StmtIterator listStatements() {
        return IteratorFactory.asStmtIterator(this.graph.find(null, null, null), this);
    }

    public Model add(Statement statement) {
        this.add(statement.getSubject(), statement.getPredicate(), statement.getObject());
        return this;
    }

    public Model add(Statement[] statementArray) {
        this.getBulkUpdateHandler().add(StatementImpl.asTriples(statementArray));
        return this;
    }

    protected BulkUpdateHandler getBulkUpdateHandler() {
        return this.getGraph().getBulkUpdateHandler();
    }

    public Model add(List list) {
        this.getBulkUpdateHandler().add(this.asTriples(list));
        return this;
    }

    private List asTriples(List list) {
        ArrayList<Triple> arrayList = new ArrayList<Triple>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(((Statement)list.get(i)).asTriple());
        }
        return arrayList;
    }

    private Iterator asTriples(StmtIterator stmtIterator) {
        return new Map1Iterator(this.mapAsTriple, stmtIterator);
    }

    public Model remove(Statement[] statementArray) {
        this.getBulkUpdateHandler().delete(StatementImpl.asTriples(statementArray));
        return this;
    }

    public Model remove(List list) {
        this.getBulkUpdateHandler().delete(this.asTriples(list));
        return this;
    }

    public Model add(Resource resource, Property property, RDFNode rDFNode) {
        this.modelReifier.noteIfReified(resource, property, rDFNode);
        this.graph.add(new Triple(resource.asNode(), property.asNode(), rDFNode.asNode()));
        return this;
    }

    public RSIterator listReifiedStatements() {
        return this.modelReifier.listReifiedStatements();
    }

    public RSIterator listReifiedStatements(Statement statement) {
        return this.modelReifier.listReifiedStatements(statement);
    }

    public boolean isReified(Statement statement) {
        return this.modelReifier.isReified(statement);
    }

    public Resource getAnyReifiedStatement(Statement statement) {
        return this.modelReifier.getAnyReifiedStatement(statement);
    }

    public void removeAllReifications(Statement statement) {
        this.modelReifier.removeAllReifications(statement);
    }

    public void removeReification(ReifiedStatement reifiedStatement) {
        this.modelReifier.removeReification(reifiedStatement);
    }

    public ReifiedStatement createReifiedStatement(Statement statement) {
        return this.modelReifier.createReifiedStatement(statement);
    }

    public ReifiedStatement createReifiedStatement(String string, Statement statement) {
        return this.modelReifier.createReifiedStatement(string, statement);
    }

    public boolean contains(Statement statement) {
        return this.graph.contains(statement.asTriple());
    }

    public boolean containsResource(RDFNode rDFNode) {
        return this.graph.queryHandler().containsNode(rDFNode.asNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Resource resource, Property property) {
        ExtendedIterator extendedIterator = this.graph.find(resource.asNode(), property.asNode(), null);
        try {
            boolean bl = extendedIterator.hasNext();
            return bl;
        }
        finally {
            extendedIterator.close();
        }
    }

    public boolean contains(Resource resource, Property property, RDFNode rDFNode) {
        return this.graph.contains(resource.asNode(), property.asNode(), rDFNode.asNode());
    }

    public Statement getProperty(Resource resource, Property property) {
        StmtIterator stmtIterator = this.listStatements(resource, property, (RDFNode)null);
        try {
            if (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                return statement;
            }
            throw new JenaPropertyNotFoundException(property);
        }
        finally {
            stmtIterator.close();
        }
    }

    public static Node asNode(RDFNode rDFNode) {
        return rDFNode == null ? null : rDFNode.asNode();
    }

    private NodeIterator listObjectsFor(RDFNode rDFNode, RDFNode rDFNode2) {
        ExtendedIterator extendedIterator = this.graph.queryHandler().objectsFor(ModelCom.asNode(rDFNode), ModelCom.asNode(rDFNode2));
        return IteratorFactory.asRDFNodeIterator(extendedIterator, this);
    }

    private ResIterator listSubjectsFor(RDFNode rDFNode, RDFNode rDFNode2) {
        ExtendedIterator extendedIterator = this.graph.queryHandler().subjectsFor(ModelCom.asNode(rDFNode), ModelCom.asNode(rDFNode2));
        return IteratorFactory.asResIterator(extendedIterator, this);
    }

    public ResIterator listSubjects() {
        return this.listSubjectsFor(null, null);
    }

    public ResIterator listSubjectsWithProperty(Property property) {
        return this.listSubjectsFor(property, null);
    }

    public ResIterator listSubjectsWithProperty(Property property, RDFNode rDFNode) {
        return this.listSubjectsFor(property, rDFNode);
    }

    public NodeIterator listObjects() {
        return this.listObjectsFor(null, null);
    }

    public NodeIterator listObjectsOfProperty(Property property) {
        return this.listObjectsFor(null, property);
    }

    public NodeIterator listObjectsOfProperty(Resource resource, Property property) {
        return this.listObjectsFor(resource, property);
    }

    public StmtIterator listStatements(Selector selector) {
        StmtIterator stmtIterator = IteratorFactory.asStmtIterator(this.findTriplesFrom(selector), this);
        return selector.isSimple() ? stmtIterator : new StmtIteratorImpl(stmtIterator.filterKeep(this.asFilter(selector)));
    }

    public Filter asFilter(final Selector selector) {
        return new Filter(){

            public boolean accept(Object object) {
                return selector.test((Statement)object);
            }
        };
    }

    public ExtendedIterator findTriplesFrom(Selector selector) {
        return this.graph.find(ModelCom.asNode(selector.getSubject()), ModelCom.asNode(selector.getPredicate()), ModelCom.asNode(selector.getObject()));
    }

    public boolean supportsTransactions() {
        return this.getTransactionHandler().transactionsSupported();
    }

    public Model begin() {
        this.getTransactionHandler().begin();
        return this;
    }

    public Model abort() {
        this.getTransactionHandler().abort();
        return this;
    }

    public Model commit() {
        this.getTransactionHandler().commit();
        return this;
    }

    public Object executeInTransaction(Command command) {
        return this.getTransactionHandler().executeInTransaction(command);
    }

    private TransactionHandler getTransactionHandler() {
        return this.getGraph().getTransactionHandler();
    }

    public boolean independent() {
        return true;
    }

    public Resource createResource() {
        return IteratorFactory.asResource(Node.createAnon(new AnonId()), this);
    }

    public Resource createResource(String string) {
        return this.getResource(string);
    }

    public Property createProperty(String string) {
        return this.getProperty(string);
    }

    public Property createProperty(String string, String string2) {
        return this.getProperty(string, string2);
    }

    public Statement createStatement(Resource resource, Property property, RDFNode rDFNode) {
        return new StatementImpl(resource, property, rDFNode, this);
    }

    public Bag createBag(String string) {
        return (Bag)this.getBag(string).addProperty(RDF.type, RDF.Bag);
    }

    public Alt createAlt(String string) {
        return (Alt)this.getAlt(string).addProperty(RDF.type, RDF.Alt);
    }

    public Seq createSeq(String string) {
        return (Seq)this.getSeq(string).addProperty(RDF.type, RDF.Seq);
    }

    public NodeIterator listContainerMembers(Container container, NodeIteratorFactory nodeIteratorFactory) {
        Iterator iterator = this.listBySubject(container);
        Vector<Statement> vector = new Vector<Statement>();
        int n = 0;
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            int n2 = statement.getPredicate().getOrdinal();
            if (!((Object)statement.getSubject()).equals(container) || n2 == 0) continue;
            if (n2 > n) {
                n = n2;
                vector.setSize(n2);
            }
            vector.setElementAt(statement, n2 - 1);
        }
        WrappedIterator.close(iterator);
        try {
            return nodeIteratorFactory.createIterator(vector.iterator(), vector, container);
        }
        catch (Exception exception) {
            throw new JenaException(exception);
        }
    }

    public int containerSize(Container container) {
        int n = 0;
        Iterator iterator = this.listBySubject(container);
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            Property property = statement.getPredicate();
            if (!((Object)statement.getSubject()).equals(container) || property.getOrdinal() == 0) continue;
            ++n;
        }
        WrappedIterator.close(iterator);
        return n;
    }

    public Statement asStatement(Triple triple) {
        return StatementImpl.toStatement(triple, this);
    }

    public Statement[] asStatements(Triple[] tripleArray) {
        Statement[] statementArray = new Statement[tripleArray.length];
        for (int i = 0; i < tripleArray.length; ++i) {
            statementArray[i] = this.asStatement(tripleArray[i]);
        }
        return statementArray;
    }

    public List asStatements(List list) {
        ArrayList<Statement> arrayList = new ArrayList<Statement>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(this.asStatement((Triple)list.get(i)));
        }
        return arrayList;
    }

    public Model asModel(Graph graph) {
        return new ModelCom(graph);
    }

    public StmtIterator asStatements(Iterator iterator) {
        return new StmtIteratorImpl(new Map1Iterator(this.mapAsStatement, iterator));
    }

    private Iterator listBySubject(Container container) {
        return this.asStatements(this.graph.find(container.asNode(), null, null));
    }

    public int containerIndexOf(Container container, RDFNode rDFNode) {
        int n = 0;
        Iterator iterator = this.listBySubject(container);
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            Property property = statement.getPredicate();
            if (!((Object)statement.getSubject()).equals(container) || property.getOrdinal() == 0 || !rDFNode.equals(statement.getObject())) continue;
            n = property.getOrdinal();
            break;
        }
        WrappedIterator.close(iterator);
        return n;
    }

    public boolean containerContains(Container container, RDFNode rDFNode) {
        return this.containerIndexOf(container, rDFNode) != 0;
    }

    public void close() {
        this.graph.close();
    }

    public boolean supportsSetOperations() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model query(Selector selector) {
        ModelMem modelMem = new ModelMem();
        StmtIterator stmtIterator = null;
        try {
            stmtIterator = this.listStatements(selector);
            while (stmtIterator.hasNext()) {
                modelMem.add(stmtIterator.nextStatement());
            }
            ModelMem modelMem2 = modelMem;
            return modelMem2;
        }
        finally {
            if (stmtIterator != null) {
                stmtIterator.close();
            }
        }
    }

    public Model union(Model model) {
        return new ModelMem().add(this).add(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model intersection(Model model) {
        Model model2 = this;
        Model model3 = model;
        ModelMem modelMem = new ModelMem();
        StmtIterator stmtIterator = null;
        if (model.size() > this.size()) {
            model2 = model;
            model3 = this;
        }
        try {
            stmtIterator = model3.listStatements();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                if (!model2.contains(statement)) continue;
                modelMem.add(statement);
            }
            ModelMem modelMem2 = modelMem;
            return modelMem2;
        }
        finally {
            stmtIterator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model difference(Model model) {
        ModelMem modelMem = new ModelMem();
        StmtIterator stmtIterator = null;
        try {
            stmtIterator = this.listStatements();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                if (model.contains(statement)) continue;
                modelMem.add(statement);
            }
            ModelMem modelMem2 = modelMem;
            return modelMem2;
        }
        finally {
            stmtIterator.close();
        }
    }

    public String toString() {
        return "<ModelCom  " + this.getGraph() + ">";
    }

    public Model getHiddenStatements() {
        return this.modelReifier.getHiddenStatements();
    }

    public boolean isIsomorphicWith(Model model) {
        ModelCom modelCom = (ModelCom)ModelCom.withHiddenStatements(this);
        EnhGraph enhGraph = (EnhGraph)((Object)ModelCom.withHiddenStatements(model));
        return modelCom.isIsomorphicWith(enhGraph);
    }

    public synchronized ModelLock getModelLock() {
        if (this.modelLock == null) {
            this.modelLock = new ModelLockImpl();
        }
        return this.modelLock;
    }

    public void enterCriticalSection(boolean bl) {
        this.getModelLock().enterCriticalSection(bl);
    }

    public void leaveCriticalSection() {
        this.getModelLock().leaveCriticalSection();
    }

    public Model register(ModelChangedListener modelChangedListener) {
        this.getGraph().getEventManager().register(this.adapt(modelChangedListener));
        return this;
    }

    public Model unregister(ModelChangedListener modelChangedListener) {
        this.getGraph().getEventManager().unregister(this.adapt(modelChangedListener));
        return this;
    }

    public GraphListener adapt(ModelChangedListener modelChangedListener) {
        return new ModelListenerAdapter(this, modelChangedListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

