/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.log4j.Logger;

public class TestOntReasoning
extends TestCase {
    public static final String BASE = "http://jena.hpl.hp.com/testing/ontology";
    public static final String NS = "http://jena.hpl.hp.com/testing/ontology#";

    public TestOntReasoning(String string) {
        super(string);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testSubClassDirectTransInf1a() {
        OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/TR/owl-features/#term_OWLLite");
        OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
        OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
        OntClass ontClass3 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
        OntClass ontClass4 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#D");
        ontClass.addSubClass(ontClass2);
        ontClass.addSubClass(ontClass3);
        ontClass3.addSubClass(ontClass4);
        this.iteratorTest(ontClass.listSubClasses(), new Object[]{ontClass, ontClass2, ontClass3, ontClass4});
        this.iteratorTest(ontClass.listSubClasses(true), new Object[]{ontClass2, ontClass3, ontClass});
    }

    public void testSubClassDirectTransInf1b() {
        OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/TR/owl-features/#term_OWLLite");
        OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
        OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
        OntClass ontClass3 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
        OntClass ontClass4 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#D");
        ontClass.addSubClass(ontClass2);
        ontClass.addSubClass(ontClass3);
        ontClass3.addSubClass(ontClass4);
        ontClass.addSubClass(ontClass4);
        this.iteratorTest(ontClass.listSubClasses(), new Object[]{ontClass, ontClass2, ontClass3, ontClass4});
        this.iteratorTest(ontClass.listSubClasses(true), new Object[]{ontClass2, ontClass3, ontClass});
    }

    public void testSubClassDirectTransInf2a() {
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_LITE_MEM);
        ontModelSpec.setReasonerFactory(null);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
        OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
        OntClass ontClass3 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
        OntClass ontClass4 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#D");
        ontClass.addSubClass(ontClass2);
        ontClass.addSubClass(ontClass3);
        ontClass3.addSubClass(ontClass4);
        this.iteratorTest(ontClass.listSubClasses(), new Object[]{ontClass2, ontClass3});
        this.iteratorTest(ontClass.listSubClasses(true), new Object[]{ontClass2, ontClass3});
    }

    public void testSubClassDirectTransInf2b() {
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_LITE_MEM);
        ontModelSpec.setReasonerFactory(null);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#A");
        OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#B");
        OntClass ontClass3 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
        OntClass ontClass4 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#D");
        ontClass.addSubClass(ontClass2);
        ontClass.addSubClass(ontClass3);
        ontClass3.addSubClass(ontClass4);
        ontClass.addSubClass(ontClass4);
        this.iteratorTest(ontClass.listSubClasses(), new Object[]{ontClass2, ontClass3, ontClass4});
        this.iteratorTest(ontClass.listSubClasses(true), new Object[]{ontClass2, ontClass3});
    }

    public void testSubPropertyDirectTransInf1a() {
        OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/TR/owl-features/#term_OWLLite");
        ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
        ObjectProperty objectProperty2 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
        ObjectProperty objectProperty3 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
        ObjectProperty objectProperty4 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#s");
        objectProperty.addSubProperty(objectProperty2);
        objectProperty.addSubProperty(objectProperty3);
        objectProperty3.addSubProperty(objectProperty4);
        this.iteratorTest(objectProperty.listSubProperties(), new Object[]{objectProperty, objectProperty2, objectProperty3, objectProperty4});
        this.iteratorTest(objectProperty.listSubProperties(true), new Object[]{objectProperty, objectProperty2, objectProperty3});
    }

    public void testSubPropertyDirectTransInf1b() {
        OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/TR/owl-features/#term_OWLLite");
        ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
        ObjectProperty objectProperty2 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
        ObjectProperty objectProperty3 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
        ObjectProperty objectProperty4 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#s");
        objectProperty.addSubProperty(objectProperty2);
        objectProperty.addSubProperty(objectProperty3);
        objectProperty3.addSubProperty(objectProperty4);
        objectProperty.addSubProperty(objectProperty4);
        this.iteratorTest(objectProperty.listSubProperties(), new Object[]{objectProperty, objectProperty2, objectProperty3, objectProperty4});
        this.iteratorTest(objectProperty.listSubProperties(true), new Object[]{objectProperty, objectProperty2, objectProperty3});
    }

    public void testSubPropertyDirectTransInf2a() {
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_LITE_MEM);
        ontModelSpec.setReasonerFactory(null);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
        ObjectProperty objectProperty2 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
        ObjectProperty objectProperty3 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
        ObjectProperty objectProperty4 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#s");
        objectProperty.addSubProperty(objectProperty2);
        objectProperty.addSubProperty(objectProperty3);
        objectProperty3.addSubProperty(objectProperty4);
        this.iteratorTest(objectProperty.listSubProperties(), new Object[]{objectProperty2, objectProperty3});
        this.iteratorTest(objectProperty.listSubProperties(true), new Object[]{objectProperty2, objectProperty3});
    }

    public void testSubPropertyDirectTransInf2b() {
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_LITE_MEM);
        ontModelSpec.setReasonerFactory(null);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ObjectProperty objectProperty = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
        ObjectProperty objectProperty2 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
        ObjectProperty objectProperty3 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
        ObjectProperty objectProperty4 = ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#s");
        objectProperty.addSubProperty(objectProperty2);
        objectProperty.addSubProperty(objectProperty3);
        objectProperty3.addSubProperty(objectProperty4);
        objectProperty.addSubProperty(objectProperty4);
        this.iteratorTest(objectProperty.listSubProperties(), new Object[]{objectProperty2, objectProperty3, objectProperty4});
        this.iteratorTest(objectProperty.listSubProperties(true), new Object[]{objectProperty2, objectProperty3});
    }

    public void testListDefinedProperties() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RULE_INF, null);
        OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#Organism");
        OntClass ontClass2 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#Vertebrate");
        OntClass ontClass3 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#Mammal");
        OntClass ontClass4 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#Dog");
        ontClass.addSubClass(ontClass2);
        ontClass2.addSubClass(ontClass3);
        ontClass3.addSubClass(ontClass4);
        OntClass ontClass5 = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#Covering");
        Individual individual = ontModel.createIndividual("http://jena.hpl.hp.com/testing/ontology#hair", ontClass5);
        DatatypeProperty datatypeProperty = ontModel.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#limbsCount");
        DatatypeProperty datatypeProperty2 = ontModel.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#hasCovering");
        DatatypeProperty datatypeProperty3 = ontModel.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#numYoung");
        datatypeProperty.addDomain(ontClass2);
        datatypeProperty3.addDomain(ontClass3);
        Restriction restriction = ontModel.createRestriction(datatypeProperty2);
        restriction.convertToHasValueRestriction(individual);
        ontClass3.addSuperClass(restriction);
        this.iteratorTest(ontClass.listDeclaredProperties(), new Object[0]);
        this.iteratorTest(ontClass2.listDeclaredProperties(), new Object[]{datatypeProperty});
        this.iteratorTest(ontClass3.listDeclaredProperties(), new Object[]{datatypeProperty, datatypeProperty2, datatypeProperty3});
        this.iteratorTest(ontClass4.listDeclaredProperties(), new Object[]{datatypeProperty, datatypeProperty2, datatypeProperty3});
        this.iteratorTest(restriction.listDeclaredProperties(), new Object[]{datatypeProperty2});
        this.iteratorTest(ontClass.listDeclaredProperties(true), new Object[0]);
        this.iteratorTest(ontClass2.listDeclaredProperties(true), new Object[]{datatypeProperty});
        this.iteratorTest(ontClass3.listDeclaredProperties(true), new Object[]{datatypeProperty, datatypeProperty2, datatypeProperty3});
        this.iteratorTest(ontClass4.listDeclaredProperties(true), new Object[]{datatypeProperty, datatypeProperty2, datatypeProperty3});
        this.iteratorTest(restriction.listDeclaredProperties(true), new Object[]{datatypeProperty2});
        this.iteratorTest(ontClass.listDeclaredProperties(false), new Object[0]);
        this.iteratorTest(ontClass2.listDeclaredProperties(false), new Object[]{datatypeProperty});
        this.iteratorTest(ontClass3.listDeclaredProperties(false), new Object[]{datatypeProperty3});
        this.iteratorTest(ontClass4.listDeclaredProperties(false), new Object[0]);
        this.iteratorTest(restriction.listDeclaredProperties(false), new Object[]{datatypeProperty2});
    }

    protected void iteratorTest(Iterator iterator, Object[] objectArray) {
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!arrayList.contains(e)) {
                logger.debug((Object)(this.getName() + " - Unexpected iterator result: " + e));
            }
            TestOntReasoning.assertTrue((String)("Value " + e + " was not expected as a result from this iterator "), (boolean)arrayList.contains(e));
            TestOntReasoning.assertTrue((String)("Value " + e + " was not removed from the list "), (boolean)arrayList.remove(e));
        }
        if (arrayList.size() != 0) {
            logger.debug((Object)(this.getName() + " Expected iterator results not found"));
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                logger.debug((Object)(this.getName() + " - missing: " + iterator2.next()));
            }
        }
        TestOntReasoning.assertEquals((String)"There were expected elements from the iterator that were not found", (int)0, (int)arrayList.size());
    }
}

