/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.BuiltinPersonalities;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.compose.MultiUnion;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.Axiom;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.LanguageConsistencyException;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.ProfileException;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class OntModelImpl
extends ModelCom
implements OntModel {
    protected OntModelSpec m_spec;
    protected Set m_imported = new HashSet();
    protected BindingQueryPlan m_individualsQuery;
    protected boolean m_strictMode = true;
    protected MultiUnion m_union = new MultiUnion();
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Ontology;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$ObjectProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$DatatypeProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Individual;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntClass;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$EnumeratedClass;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$UnionClass;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$ComplementClass;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$IntersectionClass;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Restriction;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$AllDifferent;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$AnnotationProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$TransitiveProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$SymmetricProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$InverseFunctionalProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$HasValueRestriction;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$SomeValuesFromRestriction;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$AllValuesFromRestriction;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$CardinalityRestriction;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$MinCardinalityRestriction;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$MaxCardinalityRestriction;

    public OntModelImpl(OntModelSpec ontModelSpec, Model model) {
        super(OntModelImpl.generateGraph(ontModelSpec), BuiltinPersonalities.model);
        this.m_spec = ontModelSpec;
        this.m_union = this.getGraph() instanceof MultiUnion ? (MultiUnion)this.getGraph() : (MultiUnion)((InfGraph)this.getGraph()).getRawGraph();
        this.m_union.addGraph(model != null ? model.getGraph() : ModelFactory.createDefaultModel().getGraph());
        Profile profile = this.getProfile();
        this.m_individualsQuery = this.queryXTypeOfType(profile.CLASS());
        if (this.getDocumentManager().useDeclaredPrefixes()) {
            this.setNsPrefixes(this.getDocumentManager().getDeclaredPrefixMapping());
        }
        this.getDocumentManager().loadImports(this);
        this.rebind();
    }

    public OntDocumentManager getDocumentManager() {
        return this.m_spec.getDocumentManager();
    }

    public ExtendedIterator listOntologies() {
        this.checkProfileEntry(this.getProfile().ONTOLOGY(), "ONTOLOGY");
        return this.findByTypeAs(this.getProfile().ONTOLOGY(), class$com$hp$hpl$jena$ontology$Ontology == null ? (class$com$hp$hpl$jena$ontology$Ontology = OntModelImpl.class$("com.hp.hpl.jena.ontology.Ontology")) : class$com$hp$hpl$jena$ontology$Ontology);
    }

    public ExtendedIterator listOntProperties() {
        return this.findByTypeAs(RDF.Property, class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
    }

    public ExtendedIterator listObjectProperties() {
        this.checkProfileEntry(this.getProfile().OBJECT_PROPERTY(), "OBJECT_PROPERTY");
        return this.findByTypeAs(this.getProfile().OBJECT_PROPERTY(), class$com$hp$hpl$jena$ontology$ObjectProperty == null ? (class$com$hp$hpl$jena$ontology$ObjectProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.ObjectProperty")) : class$com$hp$hpl$jena$ontology$ObjectProperty);
    }

    public ExtendedIterator listDatatypeProperties() {
        this.checkProfileEntry(this.getProfile().DATATYPE_PROPERTY(), "DATATYPE_PROPERTY");
        return this.findByTypeAs(this.getProfile().DATATYPE_PROPERTY(), class$com$hp$hpl$jena$ontology$DatatypeProperty == null ? (class$com$hp$hpl$jena$ontology$DatatypeProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.DatatypeProperty")) : class$com$hp$hpl$jena$ontology$DatatypeProperty);
    }

    public ExtendedIterator listIndividuals() {
        return this.queryFor(this.m_individualsQuery, null, class$com$hp$hpl$jena$ontology$Individual == null ? (class$com$hp$hpl$jena$ontology$Individual = OntModelImpl.class$("com.hp.hpl.jena.ontology.Individual")) : class$com$hp$hpl$jena$ontology$Individual);
    }

    public ExtendedIterator listClasses() {
        return this.findByTypeAs(this.getProfile().getClassDescriptionTypes(), class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntModelImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
    }

    public ExtendedIterator listEnumeratedClasses() {
        this.checkProfileEntry(this.getProfile().ONE_OF(), "ONE_OF");
        return this.findByDefiningPropertyAs(this.getProfile().ONE_OF(), class$com$hp$hpl$jena$ontology$EnumeratedClass == null ? (class$com$hp$hpl$jena$ontology$EnumeratedClass = OntModelImpl.class$("com.hp.hpl.jena.ontology.EnumeratedClass")) : class$com$hp$hpl$jena$ontology$EnumeratedClass);
    }

    public ExtendedIterator listUnionClasses() {
        this.checkProfileEntry(this.getProfile().UNION_OF(), "UNION_OF");
        return this.findByDefiningPropertyAs(this.getProfile().UNION_OF(), class$com$hp$hpl$jena$ontology$UnionClass == null ? (class$com$hp$hpl$jena$ontology$UnionClass = OntModelImpl.class$("com.hp.hpl.jena.ontology.UnionClass")) : class$com$hp$hpl$jena$ontology$UnionClass);
    }

    public ExtendedIterator listComplementClasses() {
        this.checkProfileEntry(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF");
        return this.findByDefiningPropertyAs(this.getProfile().COMPLEMENT_OF(), class$com$hp$hpl$jena$ontology$ComplementClass == null ? (class$com$hp$hpl$jena$ontology$ComplementClass = OntModelImpl.class$("com.hp.hpl.jena.ontology.ComplementClass")) : class$com$hp$hpl$jena$ontology$ComplementClass);
    }

    public ExtendedIterator listIntersectionClasses() {
        this.checkProfileEntry(this.getProfile().INTERSECTION_OF(), "INTERSECTION_OF");
        return this.findByDefiningPropertyAs(this.getProfile().INTERSECTION_OF(), class$com$hp$hpl$jena$ontology$IntersectionClass == null ? (class$com$hp$hpl$jena$ontology$IntersectionClass = OntModelImpl.class$("com.hp.hpl.jena.ontology.IntersectionClass")) : class$com$hp$hpl$jena$ontology$IntersectionClass);
    }

    public ExtendedIterator listNamedClasses() {
        return this.listClasses().filterDrop(new Filter(){

            public boolean accept(Object object) {
                return ((Resource)object).isAnon();
            }
        });
    }

    public ExtendedIterator listRestrictions() {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        return this.findByTypeAs(this.getProfile().RESTRICTION(), class$com$hp$hpl$jena$ontology$Restriction == null ? (class$com$hp$hpl$jena$ontology$Restriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.Restriction")) : class$com$hp$hpl$jena$ontology$Restriction);
    }

    public ExtendedIterator listAllDifferent() {
        this.checkProfileEntry(this.getProfile().ALL_DIFFERENT(), "ALL_DIFFERENT");
        return this.findByTypeAs(this.getProfile().ALL_DIFFERENT(), class$com$hp$hpl$jena$ontology$AllDifferent == null ? (class$com$hp$hpl$jena$ontology$AllDifferent = OntModelImpl.class$("com.hp.hpl.jena.ontology.AllDifferent")) : class$com$hp$hpl$jena$ontology$AllDifferent);
    }

    public ExtendedIterator listAnnotationProperties() {
        this.checkProfileEntry(this.getProfile().ANNOTATION_PROPERTY(), "ANNOTATION_PROPERTY");
        Resource resource = this.getProfile().ANNOTATION_PROPERTY();
        if (resource == null) {
            return WrappedIterator.create(new ArrayList().iterator());
        }
        return this.findByType(resource).andThen(WrappedIterator.create(this.getProfile().getAnnotationProperties())).mapWith(new SubjectNodeAs(class$com$hp$hpl$jena$ontology$AnnotationProperty == null ? (class$com$hp$hpl$jena$ontology$AnnotationProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.AnnotationProperty")) : class$com$hp$hpl$jena$ontology$AnnotationProperty));
    }

    public Ontology getOntology(String string) {
        return (Ontology)this.findByURIAs(string, class$com$hp$hpl$jena$ontology$Ontology == null ? (class$com$hp$hpl$jena$ontology$Ontology = OntModelImpl.class$("com.hp.hpl.jena.ontology.Ontology")) : class$com$hp$hpl$jena$ontology$Ontology);
    }

    public Individual getIndividual(String string) {
        return (Individual)this.findByURIAs(string, class$com$hp$hpl$jena$ontology$Individual == null ? (class$com$hp$hpl$jena$ontology$Individual = OntModelImpl.class$("com.hp.hpl.jena.ontology.Individual")) : class$com$hp$hpl$jena$ontology$Individual);
    }

    public OntProperty getOntProperty(String string) {
        return (OntProperty)this.findByURIAs(string, class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
    }

    public ObjectProperty getObjectProperty(String string) {
        return (ObjectProperty)this.findByURIAs(string, class$com$hp$hpl$jena$ontology$ObjectProperty == null ? (class$com$hp$hpl$jena$ontology$ObjectProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.ObjectProperty")) : class$com$hp$hpl$jena$ontology$ObjectProperty);
    }

    public TransitiveProperty getTransitiveProperty(String string) {
        return (TransitiveProperty)this.findByURIAs(string, class$com$hp$hpl$jena$ontology$TransitiveProperty == null ? (class$com$hp$hpl$jena$ontology$TransitiveProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.TransitiveProperty")) : class$com$hp$hpl$jena$ontology$TransitiveProperty);
    }

    public SymmetricProperty getSymmetricProperty(String string) {
        return (SymmetricProperty)this.findByURIAs(string, class$com$hp$hpl$jena$ontology$SymmetricProperty == null ? (class$com$hp$hpl$jena$ontology$SymmetricProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.SymmetricProperty")) : class$com$hp$hpl$jena$ontology$SymmetricProperty);
    }

    public InverseFunctionalProperty getInverseFunctionalProperty(String string) {
        return (InverseFunctionalProperty)this.findByURIAs(string, class$com$hp$hpl$jena$ontology$InverseFunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$InverseFunctionalProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.InverseFunctionalProperty")) : class$com$hp$hpl$jena$ontology$InverseFunctionalProperty);
    }

    public DatatypeProperty getDatatypeProperty(String string) {
        return (DatatypeProperty)this.findByURIAs(string, class$com$hp$hpl$jena$ontology$DatatypeProperty == null ? (class$com$hp$hpl$jena$ontology$DatatypeProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.DatatypeProperty")) : class$com$hp$hpl$jena$ontology$DatatypeProperty);
    }

    public AnnotationProperty getAnnotationProperty(String string) {
        return (AnnotationProperty)this.findByURIAs(string, class$com$hp$hpl$jena$ontology$AnnotationProperty == null ? (class$com$hp$hpl$jena$ontology$AnnotationProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.AnnotationProperty")) : class$com$hp$hpl$jena$ontology$AnnotationProperty);
    }

    public OntClass getOntClass(String string) {
        return (OntClass)this.findByURIAs(string, class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntModelImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
    }

    public ComplementClass getComplementClass(String string) {
        return (ComplementClass)this.findByURIAs(string, class$com$hp$hpl$jena$ontology$ComplementClass == null ? (class$com$hp$hpl$jena$ontology$ComplementClass = OntModelImpl.class$("com.hp.hpl.jena.ontology.ComplementClass")) : class$com$hp$hpl$jena$ontology$ComplementClass);
    }

    public EnumeratedClass getEnumeratedClass(String string) {
        return (EnumeratedClass)this.findByURIAs(string, class$com$hp$hpl$jena$ontology$EnumeratedClass == null ? (class$com$hp$hpl$jena$ontology$EnumeratedClass = OntModelImpl.class$("com.hp.hpl.jena.ontology.EnumeratedClass")) : class$com$hp$hpl$jena$ontology$EnumeratedClass);
    }

    public UnionClass getUnionClass(String string) {
        return (UnionClass)this.findByURIAs(string, class$com$hp$hpl$jena$ontology$UnionClass == null ? (class$com$hp$hpl$jena$ontology$UnionClass = OntModelImpl.class$("com.hp.hpl.jena.ontology.UnionClass")) : class$com$hp$hpl$jena$ontology$UnionClass);
    }

    public IntersectionClass getIntersectionClass(String string) {
        return (IntersectionClass)this.findByURIAs(string, class$com$hp$hpl$jena$ontology$IntersectionClass == null ? (class$com$hp$hpl$jena$ontology$IntersectionClass = OntModelImpl.class$("com.hp.hpl.jena.ontology.IntersectionClass")) : class$com$hp$hpl$jena$ontology$IntersectionClass);
    }

    public Restriction getRestriction(String string) {
        return (Restriction)this.findByURIAs(string, class$com$hp$hpl$jena$ontology$Restriction == null ? (class$com$hp$hpl$jena$ontology$Restriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.Restriction")) : class$com$hp$hpl$jena$ontology$Restriction);
    }

    public HasValueRestriction getHasValueRestriction(String string) {
        return (HasValueRestriction)this.findByURIAs(string, class$com$hp$hpl$jena$ontology$HasValueRestriction == null ? (class$com$hp$hpl$jena$ontology$HasValueRestriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.HasValueRestriction")) : class$com$hp$hpl$jena$ontology$HasValueRestriction);
    }

    public SomeValuesFromRestriction getSomeValuesFromRestriction(String string) {
        return (SomeValuesFromRestriction)this.findByURIAs(string, class$com$hp$hpl$jena$ontology$SomeValuesFromRestriction == null ? (class$com$hp$hpl$jena$ontology$SomeValuesFromRestriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.SomeValuesFromRestriction")) : class$com$hp$hpl$jena$ontology$SomeValuesFromRestriction);
    }

    public AllValuesFromRestriction getAllValuesFromRestriction(String string) {
        return (AllValuesFromRestriction)this.findByURIAs(string, class$com$hp$hpl$jena$ontology$AllValuesFromRestriction == null ? (class$com$hp$hpl$jena$ontology$AllValuesFromRestriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.AllValuesFromRestriction")) : class$com$hp$hpl$jena$ontology$AllValuesFromRestriction);
    }

    public CardinalityRestriction getCardinalityRestriction(String string) {
        return (CardinalityRestriction)this.findByURIAs(string, class$com$hp$hpl$jena$ontology$CardinalityRestriction == null ? (class$com$hp$hpl$jena$ontology$CardinalityRestriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.CardinalityRestriction")) : class$com$hp$hpl$jena$ontology$CardinalityRestriction);
    }

    public MinCardinalityRestriction getMinCardinalityRestriction(String string) {
        return (MinCardinalityRestriction)this.findByURIAs(string, class$com$hp$hpl$jena$ontology$MinCardinalityRestriction == null ? (class$com$hp$hpl$jena$ontology$MinCardinalityRestriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.MinCardinalityRestriction")) : class$com$hp$hpl$jena$ontology$MinCardinalityRestriction);
    }

    public MaxCardinalityRestriction getMaxCardinalityRestriction(String string) {
        return (MaxCardinalityRestriction)this.findByURIAs(string, class$com$hp$hpl$jena$ontology$MaxCardinalityRestriction == null ? (class$com$hp$hpl$jena$ontology$MaxCardinalityRestriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.MaxCardinalityRestriction")) : class$com$hp$hpl$jena$ontology$MaxCardinalityRestriction);
    }

    public Ontology createOntology(String string) {
        this.checkProfileEntry(this.getProfile().ONTOLOGY(), "ONTOLOGY");
        return (Ontology)this.createOntResource(class$com$hp$hpl$jena$ontology$Ontology == null ? (class$com$hp$hpl$jena$ontology$Ontology = OntModelImpl.class$("com.hp.hpl.jena.ontology.Ontology")) : class$com$hp$hpl$jena$ontology$Ontology, this.getProfile().ONTOLOGY(), string);
    }

    public Individual createIndividual(Resource resource) {
        return (Individual)this.createOntResource(class$com$hp$hpl$jena$ontology$Individual == null ? (class$com$hp$hpl$jena$ontology$Individual = OntModelImpl.class$("com.hp.hpl.jena.ontology.Individual")) : class$com$hp$hpl$jena$ontology$Individual, resource, null);
    }

    public Individual createIndividual(String string, Resource resource) {
        return (Individual)this.createOntResource(class$com$hp$hpl$jena$ontology$Individual == null ? (class$com$hp$hpl$jena$ontology$Individual = OntModelImpl.class$("com.hp.hpl.jena.ontology.Individual")) : class$com$hp$hpl$jena$ontology$Individual, resource, string);
    }

    public OntProperty createOntProperty(String string) {
        Property property = this.createProperty(string);
        property.addProperty(RDF.type, this.getProfile().PROPERTY());
        return (OntProperty)property.as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
    }

    public ObjectProperty createObjectProperty(String string) {
        return this.createObjectProperty(string, false);
    }

    public ObjectProperty createObjectProperty(String string, boolean bl) {
        this.checkProfileEntry(this.getProfile().OBJECT_PROPERTY(), "OBJECT_PROPERTY");
        ObjectProperty objectProperty = (ObjectProperty)this.createOntResource(class$com$hp$hpl$jena$ontology$ObjectProperty == null ? (class$com$hp$hpl$jena$ontology$ObjectProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.ObjectProperty")) : class$com$hp$hpl$jena$ontology$ObjectProperty, this.getProfile().OBJECT_PROPERTY(), string);
        if (bl) {
            this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
            objectProperty.addProperty(RDF.type, this.getProfile().FUNCTIONAL_PROPERTY());
        }
        return objectProperty;
    }

    public TransitiveProperty createTransitiveProperty(String string) {
        return this.createTransitiveProperty(string, false);
    }

    public TransitiveProperty createTransitiveProperty(String string, boolean bl) {
        this.checkProfileEntry(this.getProfile().TRANSITIVE_PROPERTY(), "TRANSITIVE_PROPERTY");
        TransitiveProperty transitiveProperty = (TransitiveProperty)this.createOntResource(class$com$hp$hpl$jena$ontology$TransitiveProperty == null ? (class$com$hp$hpl$jena$ontology$TransitiveProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.TransitiveProperty")) : class$com$hp$hpl$jena$ontology$TransitiveProperty, this.getProfile().TRANSITIVE_PROPERTY(), string);
        if (bl) {
            this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
            transitiveProperty.addProperty(RDF.type, this.getProfile().FUNCTIONAL_PROPERTY());
        }
        return transitiveProperty;
    }

    public SymmetricProperty createSymmetricProperty(String string) {
        return this.createSymmetricProperty(string, false);
    }

    public SymmetricProperty createSymmetricProperty(String string, boolean bl) {
        this.checkProfileEntry(this.getProfile().SYMMETRIC_PROPERTY(), "SYMMETRIC_PROPERTY");
        SymmetricProperty symmetricProperty = (SymmetricProperty)this.createOntResource(class$com$hp$hpl$jena$ontology$SymmetricProperty == null ? (class$com$hp$hpl$jena$ontology$SymmetricProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.SymmetricProperty")) : class$com$hp$hpl$jena$ontology$SymmetricProperty, this.getProfile().SYMMETRIC_PROPERTY(), string);
        if (bl) {
            this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
            symmetricProperty.addProperty(RDF.type, this.getProfile().FUNCTIONAL_PROPERTY());
        }
        return symmetricProperty;
    }

    public InverseFunctionalProperty createInverseFunctionalProperty(String string) {
        return this.createInverseFunctionalProperty(string, false);
    }

    public InverseFunctionalProperty createInverseFunctionalProperty(String string, boolean bl) {
        this.checkProfileEntry(this.getProfile().INVERSE_FUNCTIONAL_PROPERTY(), "INVERSE_FUNCTIONAL_PROPERTY");
        InverseFunctionalProperty inverseFunctionalProperty = (InverseFunctionalProperty)this.createOntResource(class$com$hp$hpl$jena$ontology$InverseFunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$InverseFunctionalProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.InverseFunctionalProperty")) : class$com$hp$hpl$jena$ontology$InverseFunctionalProperty, this.getProfile().INVERSE_FUNCTIONAL_PROPERTY(), string);
        if (bl) {
            this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
            inverseFunctionalProperty.addProperty(RDF.type, this.getProfile().FUNCTIONAL_PROPERTY());
        }
        return inverseFunctionalProperty;
    }

    public DatatypeProperty createDatatypeProperty(String string) {
        return this.createDatatypeProperty(string, false);
    }

    public DatatypeProperty createDatatypeProperty(String string, boolean bl) {
        this.checkProfileEntry(this.getProfile().DATATYPE_PROPERTY(), "DATATYPE_PROPERTY");
        DatatypeProperty datatypeProperty = (DatatypeProperty)this.createOntResource(class$com$hp$hpl$jena$ontology$DatatypeProperty == null ? (class$com$hp$hpl$jena$ontology$DatatypeProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.DatatypeProperty")) : class$com$hp$hpl$jena$ontology$DatatypeProperty, this.getProfile().DATATYPE_PROPERTY(), string);
        if (bl) {
            this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
            datatypeProperty.addProperty(RDF.type, this.getProfile().FUNCTIONAL_PROPERTY());
        }
        return datatypeProperty;
    }

    public AnnotationProperty createAnnotationProperty(String string) {
        this.checkProfileEntry(this.getProfile().ANNOTATION_PROPERTY(), "ANNOTATION_PROPERTY");
        return (AnnotationProperty)this.createOntResource(class$com$hp$hpl$jena$ontology$AnnotationProperty == null ? (class$com$hp$hpl$jena$ontology$AnnotationProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.AnnotationProperty")) : class$com$hp$hpl$jena$ontology$AnnotationProperty, this.getProfile().ANNOTATION_PROPERTY(), string);
    }

    public Axiom createAxiom(Resource resource, String string) {
        return null;
    }

    public OntClass createClass() {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        return (OntClass)this.createOntResource(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntModelImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass, this.getProfile().CLASS(), null);
    }

    public OntClass createClass(String string) {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        return (OntClass)this.createOntResource(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntModelImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass, this.getProfile().CLASS(), string);
    }

    public ComplementClass createComplementClass(String string, Resource resource) {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        OntClass ontClass = (OntClass)this.createOntResource(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntModelImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass, this.getProfile().CLASS(), string);
        this.checkProfileEntry(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF");
        ontClass.addProperty(this.getProfile().COMPLEMENT_OF(), resource == null ? this.getProfile().NOTHING() : resource);
        return (ComplementClass)ontClass.as(class$com$hp$hpl$jena$ontology$ComplementClass == null ? (class$com$hp$hpl$jena$ontology$ComplementClass = OntModelImpl.class$("com.hp.hpl.jena.ontology.ComplementClass")) : class$com$hp$hpl$jena$ontology$ComplementClass);
    }

    public EnumeratedClass createEnumeratedClass(String string, RDFList rDFList) {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        OntClass ontClass = (OntClass)this.createOntResource(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntModelImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass, this.getProfile().CLASS(), string);
        this.checkProfileEntry(this.getProfile().ONE_OF(), "ONE_OF");
        ontClass.addProperty(this.getProfile().ONE_OF(), rDFList == null ? this.createList() : rDFList);
        return (EnumeratedClass)ontClass.as(class$com$hp$hpl$jena$ontology$EnumeratedClass == null ? (class$com$hp$hpl$jena$ontology$EnumeratedClass = OntModelImpl.class$("com.hp.hpl.jena.ontology.EnumeratedClass")) : class$com$hp$hpl$jena$ontology$EnumeratedClass);
    }

    public UnionClass createUnionClass(String string, RDFList rDFList) {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        OntClass ontClass = (OntClass)this.createOntResource(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntModelImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass, this.getProfile().CLASS(), string);
        this.checkProfileEntry(this.getProfile().UNION_OF(), "UNION_OF");
        ontClass.addProperty(this.getProfile().UNION_OF(), rDFList == null ? this.createList() : rDFList);
        return (UnionClass)ontClass.as(class$com$hp$hpl$jena$ontology$UnionClass == null ? (class$com$hp$hpl$jena$ontology$UnionClass = OntModelImpl.class$("com.hp.hpl.jena.ontology.UnionClass")) : class$com$hp$hpl$jena$ontology$UnionClass);
    }

    public IntersectionClass createIntersectionClass(String string, RDFList rDFList) {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        OntClass ontClass = (OntClass)this.createOntResource(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntModelImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass, this.getProfile().CLASS(), string);
        this.checkProfileEntry(this.getProfile().INTERSECTION_OF(), "INTERSECTION_OF");
        ontClass.addProperty(this.getProfile().INTERSECTION_OF(), rDFList == null ? this.createList() : rDFList);
        return (IntersectionClass)ontClass.as(class$com$hp$hpl$jena$ontology$IntersectionClass == null ? (class$com$hp$hpl$jena$ontology$IntersectionClass = OntModelImpl.class$("com.hp.hpl.jena.ontology.IntersectionClass")) : class$com$hp$hpl$jena$ontology$IntersectionClass);
    }

    public Restriction createRestriction(Property property) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction restriction = (Restriction)this.createOntResource(class$com$hp$hpl$jena$ontology$Restriction == null ? (class$com$hp$hpl$jena$ontology$Restriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.Restriction")) : class$com$hp$hpl$jena$ontology$Restriction, this.getProfile().RESTRICTION(), null);
        if (property != null) {
            restriction.setOnProperty(property);
        }
        return restriction;
    }

    public Restriction createRestriction(String string, Property property) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction restriction = (Restriction)this.createOntResource(class$com$hp$hpl$jena$ontology$Restriction == null ? (class$com$hp$hpl$jena$ontology$Restriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.Restriction")) : class$com$hp$hpl$jena$ontology$Restriction, this.getProfile().RESTRICTION(), string);
        if (property != null) {
            restriction.setOnProperty(property);
        }
        return restriction;
    }

    public HasValueRestriction createHasValueRestriction(String string, Property property, RDFNode rDFNode) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction restriction = (Restriction)this.createOntResource(class$com$hp$hpl$jena$ontology$Restriction == null ? (class$com$hp$hpl$jena$ontology$Restriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.Restriction")) : class$com$hp$hpl$jena$ontology$Restriction, this.getProfile().RESTRICTION(), string);
        if (property == null || rDFNode == null) {
            throw new IllegalArgumentException("Cannot create hasValueRestriction with a null property or value");
        }
        this.checkProfileEntry(this.getProfile().HAS_VALUE(), "HAS_VALUE");
        restriction.addProperty(this.getProfile().ON_PROPERTY(), property);
        restriction.addProperty(this.getProfile().HAS_VALUE(), rDFNode);
        return (HasValueRestriction)restriction.as(class$com$hp$hpl$jena$ontology$HasValueRestriction == null ? (class$com$hp$hpl$jena$ontology$HasValueRestriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.HasValueRestriction")) : class$com$hp$hpl$jena$ontology$HasValueRestriction);
    }

    public SomeValuesFromRestriction createSomeValuesFromRestriction(String string, Property property, Resource resource) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction restriction = (Restriction)this.createOntResource(class$com$hp$hpl$jena$ontology$Restriction == null ? (class$com$hp$hpl$jena$ontology$Restriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.Restriction")) : class$com$hp$hpl$jena$ontology$Restriction, this.getProfile().RESTRICTION(), string);
        if (property == null || resource == null) {
            throw new IllegalArgumentException("Cannot create someValuesFromRestriction with a null property or class");
        }
        this.checkProfileEntry(this.getProfile().SOME_VALUES_FROM(), "SOME_VALUES_FROM");
        restriction.addProperty(this.getProfile().ON_PROPERTY(), property);
        restriction.addProperty(this.getProfile().SOME_VALUES_FROM(), resource);
        return (SomeValuesFromRestriction)restriction.as(class$com$hp$hpl$jena$ontology$SomeValuesFromRestriction == null ? (class$com$hp$hpl$jena$ontology$SomeValuesFromRestriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.SomeValuesFromRestriction")) : class$com$hp$hpl$jena$ontology$SomeValuesFromRestriction);
    }

    public AllValuesFromRestriction createAllValuesFromRestriction(String string, Property property, Resource resource) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction restriction = (Restriction)this.createOntResource(class$com$hp$hpl$jena$ontology$Restriction == null ? (class$com$hp$hpl$jena$ontology$Restriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.Restriction")) : class$com$hp$hpl$jena$ontology$Restriction, this.getProfile().RESTRICTION(), string);
        if (property == null || resource == null) {
            throw new IllegalArgumentException("Cannot create allValuesFromRestriction with a null property or class");
        }
        this.checkProfileEntry(this.getProfile().ALL_VALUES_FROM(), "ALL_VALUES_FROM");
        restriction.addProperty(this.getProfile().ON_PROPERTY(), property);
        restriction.addProperty(this.getProfile().ALL_VALUES_FROM(), resource);
        return (AllValuesFromRestriction)restriction.as(class$com$hp$hpl$jena$ontology$AllValuesFromRestriction == null ? (class$com$hp$hpl$jena$ontology$AllValuesFromRestriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.AllValuesFromRestriction")) : class$com$hp$hpl$jena$ontology$AllValuesFromRestriction);
    }

    public CardinalityRestriction createCardinalityRestriction(String string, Property property, int n) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction restriction = (Restriction)this.createOntResource(class$com$hp$hpl$jena$ontology$Restriction == null ? (class$com$hp$hpl$jena$ontology$Restriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.Restriction")) : class$com$hp$hpl$jena$ontology$Restriction, this.getProfile().RESTRICTION(), string);
        if (property == null) {
            throw new IllegalArgumentException("Cannot create cardinalityRestriction with a null property");
        }
        this.checkProfileEntry(this.getProfile().CARDINALITY(), "CARDINALITY");
        restriction.addProperty(this.getProfile().ON_PROPERTY(), property);
        restriction.addProperty(this.getProfile().CARDINALITY(), this.createTypedLiteral(n));
        return (CardinalityRestriction)restriction.as(class$com$hp$hpl$jena$ontology$CardinalityRestriction == null ? (class$com$hp$hpl$jena$ontology$CardinalityRestriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.CardinalityRestriction")) : class$com$hp$hpl$jena$ontology$CardinalityRestriction);
    }

    public MinCardinalityRestriction createMinCardinalityRestriction(String string, Property property, int n) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction restriction = (Restriction)this.createOntResource(class$com$hp$hpl$jena$ontology$Restriction == null ? (class$com$hp$hpl$jena$ontology$Restriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.Restriction")) : class$com$hp$hpl$jena$ontology$Restriction, this.getProfile().RESTRICTION(), string);
        if (property == null) {
            throw new IllegalArgumentException("Cannot create minCardinalityRestriction with a null property");
        }
        this.checkProfileEntry(this.getProfile().MIN_CARDINALITY(), "MIN_CARDINALITY");
        restriction.addProperty(this.getProfile().ON_PROPERTY(), property);
        restriction.addProperty(this.getProfile().MIN_CARDINALITY(), this.createTypedLiteral(n));
        return (MinCardinalityRestriction)restriction.as(class$com$hp$hpl$jena$ontology$MinCardinalityRestriction == null ? (class$com$hp$hpl$jena$ontology$MinCardinalityRestriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.MinCardinalityRestriction")) : class$com$hp$hpl$jena$ontology$MinCardinalityRestriction);
    }

    public MaxCardinalityRestriction createMaxCardinalityRestriction(String string, Property property, int n) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction restriction = (Restriction)this.createOntResource(class$com$hp$hpl$jena$ontology$Restriction == null ? (class$com$hp$hpl$jena$ontology$Restriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.Restriction")) : class$com$hp$hpl$jena$ontology$Restriction, this.getProfile().RESTRICTION(), string);
        if (property == null) {
            throw new IllegalArgumentException("Cannot create maxCardinalityRestriction with a null property");
        }
        this.checkProfileEntry(this.getProfile().MAX_CARDINALITY(), "MAX_CARDINALITY");
        restriction.addProperty(this.getProfile().ON_PROPERTY(), property);
        restriction.addProperty(this.getProfile().MAX_CARDINALITY(), this.createTypedLiteral(n));
        return (MaxCardinalityRestriction)restriction.as(class$com$hp$hpl$jena$ontology$MaxCardinalityRestriction == null ? (class$com$hp$hpl$jena$ontology$MaxCardinalityRestriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.MaxCardinalityRestriction")) : class$com$hp$hpl$jena$ontology$MaxCardinalityRestriction);
    }

    public AllDifferent createAllDifferent() {
        return this.createAllDifferent(null);
    }

    public AllDifferent createAllDifferent(RDFList rDFList) {
        this.checkProfileEntry(this.getProfile().ALL_DIFFERENT(), "ALL_DIFFERENT");
        AllDifferent allDifferent = (AllDifferent)this.createOntResource(class$com$hp$hpl$jena$ontology$AllDifferent == null ? (class$com$hp$hpl$jena$ontology$AllDifferent = OntModelImpl.class$("com.hp.hpl.jena.ontology.AllDifferent")) : class$com$hp$hpl$jena$ontology$AllDifferent, this.getProfile().ALL_DIFFERENT(), null);
        if (rDFList != null) {
            allDifferent.setDistinct(rDFList);
        }
        return allDifferent;
    }

    public OntResource createOntResource(Class clazz, Resource resource, String string) {
        return (OntResource)this.getResourceWithType(string, resource).as(clazz);
    }

    public Profile getProfile() {
        return this.m_spec.getProfile();
    }

    public boolean hasLoadedImport(String string) {
        return this.m_imported.contains(string);
    }

    public void addLoadedImport(String string) {
        this.m_imported.add(string);
    }

    public List listImportedOntologyURIs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getProfile().ONTOLOGY() != null && this.getProfile().IMPORTS() != null) {
            StmtIterator stmtIterator = this.getBaseModel().listStatements(null, RDF.type, this.getProfile().ONTOLOGY());
            while (stmtIterator.hasNext()) {
                Resource resource = stmtIterator.nextStatement().getSubject();
                StmtIterator stmtIterator2 = resource.listProperties(this.getProfile().IMPORTS());
                while (stmtIterator2.hasNext()) {
                    arrayList.add(stmtIterator2.nextStatement().getResource().getURI());
                }
            }
        }
        return arrayList;
    }

    public ModelMaker getModelMaker() {
        return this.m_spec.getModelMaker();
    }

    public Model read(String string) {
        super.read(this.getDocumentManager().doAltURLMapping(string));
        this.getDocumentManager().loadImports(this);
        this.rebind();
        return this;
    }

    public Model read(Reader reader, String string) {
        super.read(reader, string);
        this.getDocumentManager().loadImports(this);
        this.rebind();
        return this;
    }

    public Model read(InputStream inputStream, String string) {
        super.read(inputStream, string);
        this.getDocumentManager().loadImports(this);
        this.rebind();
        return this;
    }

    public Model read(String string, String string2) {
        super.read(this.getDocumentManager().doAltURLMapping(string), string2);
        this.getDocumentManager().addModel(string, this);
        this.getDocumentManager().loadImports(this);
        this.rebind();
        return this;
    }

    public Model read(Reader reader, String string, String string2) {
        super.read(reader, string, string2);
        this.getDocumentManager().loadImports(this);
        this.rebind();
        return this;
    }

    public Model read(InputStream inputStream, String string, String string2) {
        super.read(inputStream, string, string2);
        this.getDocumentManager().loadImports(this);
        this.rebind();
        return this;
    }

    public List getSubGraphs() {
        return this.getUnionGraph().getSubGraphs();
    }

    public Graph getBaseGraph() {
        return this.getUnionGraph().getBaseGraph();
    }

    public Model getBaseModel() {
        return ModelFactory.createModelForGraph(this.getBaseGraph());
    }

    public void addSubModel(Model model) {
        this.addSubModel(model, true);
    }

    public void addSubModel(Model model, boolean bl) {
        this.getUnionGraph().addGraph(model.getGraph());
        if (bl) {
            this.rebind();
        }
    }

    public boolean strictMode() {
        return this.m_strictMode;
    }

    public void setStrictMode(boolean bl) {
        this.m_strictMode = bl;
    }

    public OntModelSpec getSpecification() {
        return this.m_spec;
    }

    public ExtendedIterator queryFor(BindingQueryPlan bindingQueryPlan, List list, Class clazz) {
        GetBinding getBinding = new GetBinding(0);
        ExtendedIterator extendedIterator = bindingQueryPlan.executeBindings().mapWith(getBinding);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ExtendedIterator extendedIterator2 = ((BindingQueryPlan)iterator.next()).executeBindings().mapWith(getBinding);
                extendedIterator = extendedIterator.andThen(extendedIterator2);
            }
        }
        return extendedIterator.mapWith(new SubjectNodeAs(clazz));
    }

    public Model write(Writer writer) {
        return this.getBaseModel().write(writer);
    }

    public Model write(Writer writer, String string) {
        return this.getBaseModel().write(writer, string);
    }

    public Model write(Writer writer, String string, String string2) {
        return this.getBaseModel().write(writer, string, string2);
    }

    public Model write(OutputStream outputStream) {
        return this.getBaseModel().write(outputStream);
    }

    public Model write(OutputStream outputStream, String string) {
        return this.getBaseModel().write(outputStream, string);
    }

    public Model write(OutputStream outputStream, String string, String string2) {
        return this.getBaseModel().write(outputStream, string, string2);
    }

    public Model writeAll(Writer writer, String string, String string2) {
        return super.write(writer, string, string2);
    }

    public Model writeAll(OutputStream outputStream, String string, String string2) {
        return super.write(outputStream, string, string2);
    }

    private static Graph generateGraph(OntModelSpec ontModelSpec) {
        MultiUnion multiUnion = new MultiUnion();
        return ontModelSpec.getReasoner() == null ? multiUnion : ontModelSpec.getReasoner().bind(multiUnion);
    }

    protected MultiUnion getUnionGraph() {
        return this.m_union;
    }

    protected void rebind() {
        if (this.getGraph() instanceof InfGraph) {
            ((InfGraph)this.getGraph()).rebind();
        }
    }

    protected Resource findByURIAs(String string, Class clazz) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot get() ontology value with a null URI");
        }
        Node node = Node.createURI(string);
        if (this.getGraph().contains(node, Node.ANY, Node.ANY)) {
            try {
                return (Resource)((Object)this.getNodeAs(node, clazz));
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
        }
        return null;
    }

    protected ExtendedIterator findByType(Resource resource) {
        return this.getGraph().find(null, RDF.type.asNode(), resource.asNode());
    }

    protected ExtendedIterator findByType(Resource resource, Iterator iterator) {
        ExtendedIterator extendedIterator = this.findByType(resource);
        if (iterator != null) {
            while (iterator.hasNext()) {
                extendedIterator = extendedIterator.andThen(this.findByType((Resource)iterator.next()));
            }
        }
        return extendedIterator;
    }

    protected ExtendedIterator findByTypeAs(Resource resource, Iterator iterator, Class clazz) {
        return this.findByType(resource, iterator).mapWith(new SubjectNodeAs(clazz));
    }

    protected ExtendedIterator findByTypeAs(Iterator iterator, Class clazz) {
        return this.findByTypeAs((Resource)iterator.next(), iterator, clazz);
    }

    protected ExtendedIterator findByTypeAs(Resource resource, Class clazz) {
        return this.findByType(resource).mapWith(new SubjectNodeAs(clazz));
    }

    protected BindingQueryPlan queryXTypeOfType(Resource resource) {
        Query query = new Query();
        query.addMatch(Query.X, RDF.type.asNode(), Query.Y);
        query.addMatch(Query.Y, RDF.type.asNode(), resource.asNode());
        return this.queryHandler().prepareBindings(query, new Node[]{Query.X});
    }

    protected ExtendedIterator findByDefiningProperty(Property property) {
        return this.getGraph().find(null, property.getNode(), null);
    }

    protected ExtendedIterator findByDefiningPropertyAs(Property property, Class clazz) {
        return this.findByDefiningProperty(property).mapWith(new SubjectNodeAs(clazz));
    }

    protected Resource getResourceWithType(String string, Resource resource) {
        return this.getResource(string).addProperty(RDF.type, resource);
    }

    protected void checkProfileEntry(Object object, String string) {
        if (object == null) {
            throw new ProfileException(string, this.getProfile());
        }
    }

    protected void checkListMembersRdfType(RDFList rDFList, Resource resource) {
        if (this.strictMode() && !((Boolean)rDFList.reduce(new RdfTypeTestFn(resource), Boolean.TRUE)).booleanValue()) {
            throw new LanguageConsistencyException("The members of the given list are expected to be of rdf:type " + ((Object)resource).toString());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class RdfTypeTestFn
    implements RDFList.ReduceFn {
        protected Resource m_type;

        protected RdfTypeTestFn(Resource resource) {
            this.m_type = resource;
        }

        public Object reduce(RDFNode rDFNode, Object object) {
            Boolean bl = (Boolean)object;
            if (bl.booleanValue()) {
                Resource resource = (Resource)rDFNode;
                return new Boolean(resource.hasProperty(RDF.type, this.m_type));
            }
            return bl;
        }
    }

    protected class GetBinding
    implements Map1 {
        protected int m_index;

        protected GetBinding(int n) {
            this.m_index = n;
        }

        public Object map1(Object object) {
            return ((List)object).get(this.m_index);
        }
    }

    protected class SubjectNodeAs
    implements Map1 {
        protected Class m_asKey;

        protected SubjectNodeAs(Class clazz) {
            this.m_asKey = clazz;
        }

        public Object map1(Object object) {
            Node node = object instanceof Triple ? ((Triple)object).getSubject() : (object instanceof EnhNode ? ((EnhNode)object).asNode() : (Node)object);
            return OntModelImpl.this.getNodeAs(node, this.m_asKey);
        }
    }
}

