/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.util.ResourceUtils;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.HashSet;
import java.util.Set;

public class OntClassImpl
extends OntResourceImpl
implements OntClass {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            if (this.canWrap(node, enhGraph)) {
                return new OntClassImpl(node, enhGraph);
            }
            throw new ConversionException("Cannot convert node " + node.toString() + " to OntClass");
        }

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            Profile profile;
            Profile profile2 = profile = enhGraph instanceof OntModel ? ((OntModel)((Object)enhGraph)).getProfile() : null;
            return profile != null && profile.isSupported(node, enhGraph, class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
        }
    };
    protected BindingQueryPlan m_domainQuery;
    protected BindingQueryPlan m_restrictionPropQuery = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntClass;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Restriction;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Property;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$EnumeratedClass;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$UnionClass;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$IntersectionClass;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$ComplementClass;

    public OntClassImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
        Query query = new Query();
        query.addMatch(Query.X, this.getProfile().DOMAIN().asNode(), this.asNode());
        this.m_domainQuery = this.getModel().queryHandler().prepareBindings(query, new Node[]{Query.X});
        if (this.getProfile().ON_PROPERTY() != null) {
            query = new Query();
            query.addMatch(this.asNode(), this.getProfile().SUB_CLASS_OF().asNode(), Query.X);
            query.addMatch(Query.X, this.getProfile().ON_PROPERTY().asNode(), Query.Y);
            this.m_restrictionPropQuery = this.getModel().queryHandler().prepareBindings(query, new Node[]{Query.Y});
        }
    }

    public void setSuperClass(Resource resource) {
        this.setPropertyValue(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", resource);
    }

    public void addSuperClass(Resource resource) {
        this.addPropertyValue(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", resource);
    }

    public OntClass getSuperClass() {
        return (OntClass)this.objectAs(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
    }

    public ExtendedIterator listSuperClasses() {
        return this.listSuperClasses(false);
    }

    public ExtendedIterator listSuperClasses(boolean bl) {
        return this.listDirectPropertyValues(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass, this.getProfile().SUB_CLASS_OF(), bl, false);
    }

    public boolean hasSuperClass(Resource resource) {
        return this.hasSuperClass(resource, false);
    }

    public boolean hasSuperClass(Resource resource, boolean bl) {
        InfGraph infGraph;
        if (!bl) {
            return this.hasPropertyValue(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", resource);
        }
        if (this.getGraph() instanceof InfGraph && (infGraph = (InfGraph)((Object)this.getGraph())).getReasoner().supportsProperty(ReasonerVocabulary.directSubClassOf)) {
            return this.hasPropertyValue(ReasonerVocabulary.directSubClassOf, "direct sub-class", resource);
        }
        return ResourceUtils.maximalLowerElements(this.listSuperClasses(), this.getProfile().SUB_CLASS_OF(), false).contains(resource);
    }

    public void removeSuperClass(Resource resource) {
        this.removePropertyValue(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", resource);
    }

    public void setSubClass(Resource resource) {
        this.checkProfile(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF");
        StmtIterator stmtIterator = this.getModel().listStatements(null, this.getProfile().SUB_CLASS_OF(), this);
        while (stmtIterator.hasNext()) {
            stmtIterator.nextStatement().remove();
        }
        ((OntClass)resource.as(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass)).addSuperClass(this);
    }

    public void addSubClass(Resource resource) {
        ((OntClass)resource.as(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass)).addSuperClass(this);
    }

    public OntClass getSubClass() {
        this.checkProfile(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF");
        return (OntClass)this.getModel().listStatements(null, this.getProfile().SUB_CLASS_OF(), this).nextStatement().getSubject().as(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
    }

    public ExtendedIterator listSubClasses() {
        return this.listSubClasses(false);
    }

    public ExtendedIterator listSubClasses(boolean bl) {
        return this.listDirectPropertyValues(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass, this.getProfile().SUB_CLASS_OF(), bl, true);
    }

    public boolean hasSubClass(Resource resource) {
        return this.hasSubClass(resource, false);
    }

    public boolean hasSubClass(Resource resource, boolean bl) {
        return ((OntClass)resource.as(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass)).hasSuperClass(this, bl);
    }

    public void removeSubClass(Resource resource) {
        ((OntClass)resource.as(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass)).removeSuperClass(this);
    }

    public void setEquivalentClass(Resource resource) {
        this.setPropertyValue(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", resource);
    }

    public void addEquivalentClass(Resource resource) {
        this.addPropertyValue(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", resource);
    }

    public OntClass getEquivalentClass() {
        return (OntClass)this.objectAs(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
    }

    public ExtendedIterator listEquivalentClasses() {
        return this.listAs(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
    }

    public boolean hasEquivalentClass(Resource resource) {
        return this.hasPropertyValue(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", resource);
    }

    public void removeEquivalentClass(Resource resource) {
        this.removePropertyValue(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", resource);
    }

    public void setDisjointWith(Resource resource) {
        this.setPropertyValue(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", resource);
    }

    public void addDisjointWith(Resource resource) {
        this.addPropertyValue(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", resource);
    }

    public OntClass getDisjointWith() {
        return (OntClass)this.objectAs(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
    }

    public ExtendedIterator listDisjointWith() {
        return this.listAs(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
    }

    public boolean isDisjointWith(Resource resource) {
        return this.hasPropertyValue(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", resource);
    }

    public void removeDisjointWith(Resource resource) {
        this.removePropertyValue(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", resource);
    }

    public ExtendedIterator listDeclaredProperties() {
        return this.listDeclaredProperties(true);
    }

    public ExtendedIterator listDeclaredProperties(boolean bl) {
        OntModel ontModel = (OntModel)this.getModel();
        Model model = bl ? ontModel : ontModel.getBaseModel();
        HashSet<RDFNode> hashSet = new HashSet<RDFNode>();
        HashSet hashSet2 = new HashSet();
        hashSet.add(this);
        ExtendedIterator extendedIterator = model.listStatements((Resource)this, this.getProfile().SUB_CLASS_OF(), (RDFNode)null);
        while (extendedIterator.hasNext()) {
            hashSet.add(extendedIterator.nextStatement().getObject());
        }
        ExtendedIterator extendedIterator2 = extendedIterator = bl ? hashSet.iterator() : new SingletonIterator(this);
        while (extendedIterator.hasNext()) {
            Resource resource;
            Object object;
            Resource resource2 = (Resource)extendedIterator.next();
            if (resource2.canAs(class$com$hp$hpl$jena$ontology$Restriction == null ? OntClassImpl.class$("com.hp.hpl.jena.ontology.Restriction") : class$com$hp$hpl$jena$ontology$Restriction)) {
                object = (Restriction)resource2.as(class$com$hp$hpl$jena$ontology$Restriction == null ? OntClassImpl.class$("com.hp.hpl.jena.ontology.Restriction") : class$com$hp$hpl$jena$ontology$Restriction);
                resource = object.getOnProperty();
                if (hashSet2.contains(resource) || object.hasProperty(this.getProfile().MAX_CARDINALITY(), 0L) || object.hasProperty(this.getProfile().CARDINALITY(), 0L)) continue;
                this.collectProperty((Property)resource, hashSet2, ontModel);
                continue;
            }
            object = model.listStatements(null, this.getProfile().DOMAIN(), resource2);
            while (object.hasNext()) {
                resource = object.nextStatement().getSubject();
                if (hashSet2.contains(resource)) continue;
                StmtIterator stmtIterator = null;
                boolean bl2 = true;
                stmtIterator = model.listStatements(resource, this.getProfile().DOMAIN(), (RDFNode)null);
                while (bl2 && stmtIterator.hasNext()) {
                    bl2 = hashSet.contains(stmtIterator.nextStatement().getObject());
                }
                if (bl2) {
                    this.collectProperty((Property)resource.as(class$com$hp$hpl$jena$rdf$model$Property == null ? OntClassImpl.class$("com.hp.hpl.jena.rdf.model.Property") : class$com$hp$hpl$jena$rdf$model$Property), hashSet2, ontModel);
                }
                stmtIterator.close();
            }
        }
        return WrappedIterator.create(hashSet2.iterator()).mapWith(new OntResourceImpl.AsMapper(this, class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = OntClassImpl.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty));
    }

    public ExtendedIterator listInstances() {
        return this.getModel().listStatements(null, RDF.type, this).mapWith(new OntResourceImpl.SubjectAsMapper(this, null));
    }

    public EnumeratedClass asEnumeratedClass() {
        return (EnumeratedClass)this.as(class$com$hp$hpl$jena$ontology$EnumeratedClass == null ? (class$com$hp$hpl$jena$ontology$EnumeratedClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.EnumeratedClass")) : class$com$hp$hpl$jena$ontology$EnumeratedClass);
    }

    public UnionClass asUnionClass() {
        return (UnionClass)this.as(class$com$hp$hpl$jena$ontology$UnionClass == null ? (class$com$hp$hpl$jena$ontology$UnionClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.UnionClass")) : class$com$hp$hpl$jena$ontology$UnionClass);
    }

    public IntersectionClass asIntersectionClass() {
        return (IntersectionClass)this.as(class$com$hp$hpl$jena$ontology$IntersectionClass == null ? (class$com$hp$hpl$jena$ontology$IntersectionClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.IntersectionClass")) : class$com$hp$hpl$jena$ontology$IntersectionClass);
    }

    public ComplementClass asComplementClass() {
        return (ComplementClass)this.as(class$com$hp$hpl$jena$ontology$ComplementClass == null ? (class$com$hp$hpl$jena$ontology$ComplementClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.ComplementClass")) : class$com$hp$hpl$jena$ontology$ComplementClass);
    }

    public Restriction asRestriction() {
        return (Restriction)this.as(class$com$hp$hpl$jena$ontology$Restriction == null ? (class$com$hp$hpl$jena$ontology$Restriction = OntClassImpl.class$("com.hp.hpl.jena.ontology.Restriction")) : class$com$hp$hpl$jena$ontology$Restriction);
    }

    public boolean isEnumeratedClass() {
        this.checkProfile(this.getProfile().ONE_OF(), "ONE_OF");
        return this.canAs(class$com$hp$hpl$jena$ontology$EnumeratedClass == null ? (class$com$hp$hpl$jena$ontology$EnumeratedClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.EnumeratedClass")) : class$com$hp$hpl$jena$ontology$EnumeratedClass);
    }

    public boolean isUnionClass() {
        this.checkProfile(this.getProfile().UNION_OF(), "UNION_OF");
        return this.canAs(class$com$hp$hpl$jena$ontology$UnionClass == null ? (class$com$hp$hpl$jena$ontology$UnionClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.UnionClass")) : class$com$hp$hpl$jena$ontology$UnionClass);
    }

    public boolean isIntersectionClass() {
        this.checkProfile(this.getProfile().INTERSECTION_OF(), "INTERSECTION_OF");
        return this.canAs(class$com$hp$hpl$jena$ontology$IntersectionClass == null ? (class$com$hp$hpl$jena$ontology$IntersectionClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.IntersectionClass")) : class$com$hp$hpl$jena$ontology$IntersectionClass);
    }

    public boolean isComplementClass() {
        this.checkProfile(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF");
        return this.canAs(class$com$hp$hpl$jena$ontology$ComplementClass == null ? (class$com$hp$hpl$jena$ontology$ComplementClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.ComplementClass")) : class$com$hp$hpl$jena$ontology$ComplementClass);
    }

    public boolean isRestriction() {
        this.checkProfile(this.getProfile().RESTRICTION(), "RESTRICTION");
        return this.canAs(class$com$hp$hpl$jena$ontology$Restriction == null ? (class$com$hp$hpl$jena$ontology$Restriction = OntClassImpl.class$("com.hp.hpl.jena.ontology.Restriction")) : class$com$hp$hpl$jena$ontology$Restriction);
    }

    public EnumeratedClass convertToEnumeratedClass(RDFList rDFList) {
        this.setPropertyValue(this.getProfile().ONE_OF(), "ONE_OF", rDFList);
        return (EnumeratedClass)this.as(class$com$hp$hpl$jena$ontology$EnumeratedClass == null ? (class$com$hp$hpl$jena$ontology$EnumeratedClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.EnumeratedClass")) : class$com$hp$hpl$jena$ontology$EnumeratedClass);
    }

    public IntersectionClass convertToIntersectionClass(RDFList rDFList) {
        this.setPropertyValue(this.getProfile().INTERSECTION_OF(), "INTERSECTION_OF", rDFList);
        return (IntersectionClass)this.as(class$com$hp$hpl$jena$ontology$IntersectionClass == null ? (class$com$hp$hpl$jena$ontology$IntersectionClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.IntersectionClass")) : class$com$hp$hpl$jena$ontology$IntersectionClass);
    }

    public UnionClass convertToUnionClass(RDFList rDFList) {
        this.setPropertyValue(this.getProfile().UNION_OF(), "UNION_OF", rDFList);
        return (UnionClass)this.as(class$com$hp$hpl$jena$ontology$UnionClass == null ? (class$com$hp$hpl$jena$ontology$UnionClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.UnionClass")) : class$com$hp$hpl$jena$ontology$UnionClass);
    }

    public ComplementClass convertToComplementClass(Resource resource) {
        this.setPropertyValue(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF", resource);
        return (ComplementClass)this.as(class$com$hp$hpl$jena$ontology$ComplementClass == null ? (class$com$hp$hpl$jena$ontology$ComplementClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.ComplementClass")) : class$com$hp$hpl$jena$ontology$ComplementClass);
    }

    public Restriction convertToRestriction(Property property) {
        if (!this.hasRDFType(this.getProfile().RESTRICTION(), "RESTRICTION", false)) {
            this.setRDFType(this.getProfile().RESTRICTION());
        }
        this.setPropertyValue(this.getProfile().ON_PROPERTY(), "ON_PROPERTY", property);
        return (Restriction)this.as(class$com$hp$hpl$jena$ontology$Restriction == null ? (class$com$hp$hpl$jena$ontology$Restriction = OntClassImpl.class$("com.hp.hpl.jena.ontology.Restriction")) : class$com$hp$hpl$jena$ontology$Restriction);
    }

    private void collectProperty(Property property, Set set, OntModel ontModel) {
        set.add(ontModel.getProperty(property.getURI()));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

