/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.daml.DAMLDataInstance;
import com.hp.hpl.jena.ontology.daml.impl.DAMLInstanceImpl;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;

public class DAMLDataInstanceImpl
extends DAMLInstanceImpl
implements DAMLDataInstance {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            if (this.canWrap(node, enhGraph)) {
                return new DAMLDataInstanceImpl(node, enhGraph);
            }
            throw new ConversionException("Cannot convert node " + node.toString() + " to DAMLDataInstance");
        }

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), Node.ANY);
        }
    };

    public DAMLDataInstanceImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
    }

    public RDFDatatype getDatatype() {
        ExtendedIterator extendedIterator = this.listRDFTypes(true);
        while (extendedIterator.hasNext()) {
            RDFDatatype rDFDatatype = TypeMapper.getInstance().getTypeByName(((Resource)extendedIterator.next()).getURI());
            if (rDFDatatype == null) continue;
            if (extendedIterator instanceof ClosableIterator) {
                ((ClosableIterator)extendedIterator).close();
            }
            return rDFDatatype;
        }
        return null;
    }

    public Object getValue() {
        return this.hasProperty(RDF.value) ? this.getDatatype().parse(this.getProperty(RDF.value).getString()) : null;
    }

    public void setValue(Object object) {
        this.setPropertyValue(RDF.value, "", this.getModel().createTypedLiteral(object, null, this.getDatatype()));
    }
}

