/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import com.hp.hpl.jena.n3.N3JenaWriterCommon;
import com.hp.hpl.jena.n3.N3JenaWriterPP;
import com.hp.hpl.jena.n3.N3JenaWriterTriples;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import java.io.OutputStream;
import java.io.Writer;

public class N3JenaWriter
implements RDFWriter {
    public static boolean DEBUG = false;
    public static final String propWriteSimple = "com.hp.hpl.jena.n3.N3JenaWriter.writeSimple";
    public static final String propWriterName = "com.hp.hpl.jena.n3.N3JenaWriter.writer";
    public static final String n3Writer = "N3";
    public static final String n3WriterPrettyPrinter = "N3-PP";
    public static final String n3WriterPlain = "N3-PLAIN";
    public static final String n3WriterTriples = "N3-TRIPLES";
    public static final String n3WriterTriplesAlt = "N3-TRIPLE";
    RDFWriter writer = this.chooseWriter();

    RDFWriter chooseWriter() {
        if (System.getProperty(propWriteSimple, "false").equals("true")) {
            return new N3JenaWriterCommon();
        }
        String string = System.getProperty(propWriterName);
        if (string == null || string.equals(n3Writer) || string.equals(n3WriterPrettyPrinter)) {
            return new N3JenaWriterPP();
        }
        if (string.equalsIgnoreCase(n3WriterPlain)) {
            return new N3JenaWriterCommon();
        }
        if (string.equalsIgnoreCase(n3WriterTriples) || string.equalsIgnoreCase(n3WriterTriplesAlt)) {
            return new N3JenaWriterTriples();
        }
        return new N3JenaWriterPP();
    }

    public void write(Model model, Writer writer, String string) {
        this.writer.write(model, writer, string);
    }

    public void write(Model model, OutputStream outputStream, String string) {
        this.writer.write(model, outputStream, string);
    }

    public Object setProperty(String string, Object object) {
        return this.writer.setProperty(string, object);
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler rDFErrorHandler) {
        return this.writer.setErrorHandler(rDFErrorHandler);
    }
}

