/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class TestStoreSpeed
extends GraphTestBase {
    private long began;
    static final int COUNT = 100000;

    public TestStoreSpeed(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        new TestStoreSpeed("vladimir taltos").gonzales("subject StoreMem", new GraphMem());
        new TestStoreSpeed("vladimir taltos").gonzales("normal StoreMem", new GraphMem());
        new TestStoreSpeed("vladimir taltos").gonzales("GraphMem", new GraphMem());
        new TestStoreSpeed("vladimir taltos").gonzales("subject StoreMem", new GraphMem());
        new TestStoreSpeed("vladimir taltos").gonzales("normal StoreMem", new GraphMem());
        new TestStoreSpeed("vladimir taltos").gonzales("GraphMem", new GraphMem());
        new TestStoreSpeed("vladimir taltos").gonzales("subject StoreMem", new GraphMem());
        new TestStoreSpeed("vladimir taltos").gonzales("normal StoreMem", new GraphMem());
        new TestStoreSpeed("vladimir taltos").gonzales("GraphMem", new GraphMem());
    }

    private void mark() {
        this.began = System.currentTimeMillis();
    }

    private Triple newt(int n) {
        return new Triple(TestStoreSpeed.node("s" + n % 1000), TestStoreSpeed.node("p" + (n + 11) % 20), TestStoreSpeed.node("s" + (n + 131) % 1001));
    }

    private void makeTriples() {
        for (int i = 0; i < 100000; ++i) {
            this.newt(i);
        }
    }

    private void fillGraph(Graph graph) {
        for (int i = 0; i < 100000; ++i) {
            graph.add(this.newt(i));
        }
    }

    private long ticktock(String string) {
        long l = System.currentTimeMillis() - this.began;
        System.err.println("+ " + string + " took: " + l + "ms.");
        this.mark();
        return l;
    }

    private void consumeAll(Graph graph) {
        int n = 0;
        ExtendedIterator extendedIterator = graph.find(TestStoreSpeed.node("s500"), null, null);
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            ++n;
        }
    }

    private void gonzales(String string, Graph graph) {
        System.err.println("");
        System.err.println("| gonzales: " + string);
        this.mark();
        this.makeTriples();
        this.ticktock("generating triples");
        this.makeTriples();
        this.ticktock("generating triples again");
        this.makeTriples();
        long l = this.ticktock("generating triples yet again");
        this.fillGraph(graph);
        long l2 = this.ticktock("filling graph");
        System.err.println("> insertion time: " + (l2 - l));
        this.fillGraph(graph);
        this.ticktock("adding the same triples again");
        this.consumeAll(graph);
        this.ticktock("counting s500 triples");
        this.consumeAll(graph);
        this.ticktock("counting s500 triples again");
        this.consumeAll(graph);
        this.ticktock("counting s500 triples yet again");
    }
}

