/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;

class RecordingListener
implements GraphListener {
    List history = new ArrayList();

    RecordingListener() {
    }

    public void notifyAddTriple(Triple triple) {
        this.record("add", triple);
    }

    public void notifyAddArray(Triple[] tripleArray) {
        this.record("add[]", tripleArray);
    }

    public void notifyAddList(List list) {
        this.record("addList", list);
    }

    public void notifyAddIterator(Iterator iterator) {
        this.record("addIterator", GraphTestBase.iteratorToList(iterator));
    }

    public void notifyAddGraph(Graph graph) {
        this.record("addGraph", graph);
    }

    public void notifyDeleteTriple(Triple triple) {
        this.record("delete", triple);
    }

    public void notifyDeleteArray(Triple[] tripleArray) {
        this.record("delete[]", tripleArray);
    }

    public void notifyDeleteList(List list) {
        this.record("deleteList", list);
    }

    public void notifyDeleteIterator(Iterator iterator) {
        this.record("deleteIterator", GraphTestBase.iteratorToList(iterator));
    }

    public void notifyDeleteGraph(Graph graph) {
        this.record("deleteGraph", graph);
    }

    protected void record(String string, Object object) {
        this.history.add(string);
        this.history.add(object);
    }

    public void clear() {
        this.history.clear();
    }

    public boolean has(Object[] objectArray) {
        return ((Object)this.history).equals(Arrays.asList(objectArray));
    }

    void assertHas(Object[] objectArray) {
        if (!this.has(objectArray)) {
            Assert.fail((String)("expected " + Arrays.asList(objectArray) + " but got " + this.history));
        }
    }
}

