/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import junit.framework.TestSuite;

public class QueryTest
extends GraphTestBase {
    private Query Q;
    private Node X = QueryTest.node("?x");
    private Node Y = QueryTest.node("?y");
    private Node Z = QueryTest.node("?z");
    private Graph empty;
    private Graph single;
    private static final String[][] tests = new String[][]{{"", "pigs might fly", "", ""}, {"", "", "pigs might fly", ""}, {"", "a pings b; b pings c", "a pings _x; _x pings c", "a pings b; b pings c"}, {"", "a pings b; b pings c; a pings x; x pings c", "a pings _x; _x pings c", "a pings b; b pings c; a pings x; x pings c"}};
    static /* synthetic */ Class class$com$hp$hpl$jena$graph$query$test$QueryTest;

    public QueryTest(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$graph$query$test$QueryTest == null ? (class$com$hp$hpl$jena$graph$query$test$QueryTest = QueryTest.class$("com.hp.hpl.jena.graph.query.test.QueryTest")) : class$com$hp$hpl$jena$graph$query$test$QueryTest);
    }

    public void setUp() {
        this.Q = new Query();
        this.empty = QueryTest.graphWith("");
        this.single = QueryTest.graphWith("spindizzies drive cities");
    }

    private void testTreeQuery(String string, String string2, String string3, String string4) {
        Graph graph = QueryTest.graphWith(string2);
        Graph graph2 = QueryTest.graphWith(string3);
        Graph graph3 = graph.queryHandler().prepareTree(graph2).executeTree();
        if (string.equals("")) {
            string = "checking {" + string2 + "} against {" + string3 + "} should give {" + string4 + "}" + " not " + graph3;
        }
        QueryTest.assertEquals(string, QueryTest.graphWith(string4), graph3);
    }

    private void testTreeQuery(String string, String string2, String string3) {
        this.testTreeQuery("checking", string, string2, string3);
    }

    public void testManyThings() {
        for (int i = 0; i < tests.length; ++i) {
            this.testTreeQuery(tests[i][0], tests[i][1], tests[i][2], tests[i][3]);
        }
    }

    public void testAtomicTreeQuery() {
        this.testTreeQuery("pigs might fly; birds will joke; cats must watch", "birds will joke", "birds will joke");
    }

    public void testCompositeTreeQuery() {
        this.testTreeQuery("pigs might fly; birds will joke; cats must watch", "birds will joke; pigs might fly", "pigs might fly; birds will joke");
    }

    public void testChainedTreeQuery() {
        this.testTreeQuery("a pings b; b pings c; c pings d", "a pings b; b pings c", "a pings b; b pings c");
    }

    public void testBinding1() {
        Graph graph = QueryTest.graphWith("rice grows quickly");
        Query query = new Query();
        Node node = QueryTest.node("?v1");
        Node node2 = QueryTest.node("?v3");
        BindingQueryPlan bindingQueryPlan = graph.queryHandler().prepareBindings(query.addMatch(node, QueryTest.node("grows"), node2), new Node[]{node, node2});
        Domain domain = (Domain)bindingQueryPlan.executeBindings().next();
        QueryTest.assertEquals((String)"binding subject to rice", (Object)domain.get(0), (Object)QueryTest.node("rice"));
        QueryTest.assertEquals((String)"binding object to quickly", (Object)domain.get(1), (Object)QueryTest.node("quickly"));
    }

    public void testBinding2() {
        Graph graph = QueryTest.graphWith("rice grows quickly; time isan illusion");
        String[][] stringArrayArray = new String[][]{{"time", "isan", "illusion"}, {"rice", "grows", "quickly"}};
        Query query = new Query();
        Node node = QueryTest.node("?v1");
        Node node2 = QueryTest.node("?v2");
        Node node3 = QueryTest.node("?v3");
        BindingQueryPlan bindingQueryPlan = graph.queryHandler().prepareBindings(query.addMatch(node, node2, node3), new Node[]{node, node2, node3});
        ExtendedIterator extendedIterator = bindingQueryPlan.executeBindings();
        for (int i = 0; i < stringArrayArray.length; ++i) {
            if (!extendedIterator.hasNext()) {
                QueryTest.fail((String)"wanted some more results");
            }
            Domain domain = (Domain)extendedIterator.next();
            for (int j = 0; j < 3; ++j) {
                QueryTest.assertEquals((String)"binding failure", (Object)domain.get(j), (Object)QueryTest.node(stringArrayArray[i][j]));
            }
        }
        QueryTest.assertFalse((String)"iterator should be empty", (boolean)extendedIterator.hasNext());
    }

    public void testMultiplePatterns() {
        Graph graph = QueryTest.graphWith("ben wrote Clayface; Starfish ingenre SF; Clayface ingenre Geology; bill wrote Starfish");
        Query query = new Query();
        Node node = QueryTest.node("?X");
        Node node2 = QueryTest.node("?A");
        query.addMatch(node, QueryTest.node("wrote"), node2).addMatch(node2, QueryTest.node("ingenre"), QueryTest.node("SF"));
        BindingQueryPlan bindingQueryPlan = graph.queryHandler().prepareBindings(query, new Node[]{node});
        ExtendedIterator extendedIterator = bindingQueryPlan.executeBindings();
        if (extendedIterator.hasNext()) {
            Domain domain = (Domain)extendedIterator.next();
            if (domain.size() == 1) {
                if (domain.get(0).equals(QueryTest.node("bill"))) {
                    if (extendedIterator.hasNext()) {
                        System.out.println("! failed: more than one multiple pattern answer: " + (Domain)extendedIterator.next());
                    }
                } else {
                    System.out.println("! failed: multiple pattern answer should be 'bill'");
                }
            } else {
                System.out.println("! failed: multiple pattern answer should have one element");
            }
        } else {
            System.out.println("! failed: multiple pattern query should have an answer");
        }
    }

    public void testNodeVariablesA() {
        Graph graph = QueryTest.graphWith("storms hit England");
        Node node = QueryTest.node("?spoo");
        this.Q.addMatch(node, QueryTest.node("hit"), QueryTest.node("England"));
        ExtendedIterator extendedIterator = graph.queryHandler().prepareBindings(this.Q, new Node[]{node}).executeBindings();
        QueryTest.assertTrue((String)"tnv: it has a solution", (boolean)extendedIterator.hasNext());
        QueryTest.assertEquals((String)"", (Object)QueryTest.node("storms"), ((List)extendedIterator.next()).get(0));
        QueryTest.assertFalse((String)"tnv: just the one solution", (boolean)extendedIterator.hasNext());
    }

    public void testNodeVariablesB() {
        Graph graph = QueryTest.graphWith("storms hit England");
        Node node = QueryTest.node("?spoo");
        Node node2 = QueryTest.node("?flarn");
        this.Q.addMatch(node, QueryTest.node("hit"), node2);
        ExtendedIterator extendedIterator = graph.queryHandler().prepareBindings(this.Q, new Node[]{node2, node}).executeBindings();
        QueryTest.assertTrue((String)"tnv: it has a solution", (boolean)extendedIterator.hasNext());
        List list = (List)extendedIterator.next();
        QueryTest.assertEquals((String)"tnvB", (Object)QueryTest.node("storms"), list.get(1));
        QueryTest.assertEquals((String)"tnvB", (Object)QueryTest.node("England"), list.get(0));
        QueryTest.assertFalse((String)"tnv: just the one solution", (boolean)extendedIterator.hasNext());
    }

    public Set nodeSet(String string) {
        HashSet<Node> hashSet = new HashSet<Node>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(QueryTest.node(stringTokenizer.nextToken()));
        }
        return hashSet;
    }

    public void testGraphConstraints(String string, String string2, String string3) {
        Map1 map1 = new Map1(){

            public Object map1(Object object) {
                return ((List)object).get(0);
            }
        };
        Node node = QueryTest.node("?O");
        Query query = new Query();
        query.addMatch(Query.ANY, Query.ANY, node);
        Graph graph = QueryTest.graphWith("pigs fly south; dogs fly badly; plans fly flat");
        query.addConstraint(QueryTest.graphWith(string2));
        Set set = QueryTest.iteratorToSet(graph.queryHandler().prepareBindings(query, new Node[]{node}).executeBindings().mapWith(map1));
        QueryTest.assertEquals((String)"tgs", (Object)this.nodeSet(string3), (Object)set);
    }

    public void testGraphConstraints() {
        this.testGraphConstraints("tgs A", "", "south flat badly");
        this.testGraphConstraints("tgs B", "?O &ne badly", "south flat");
        this.testGraphConstraints("tgs C", "?O &ne badly; ?O &ne flat", "south");
    }

    public void testSeveralGraphConstraints() {
        Map1 map1 = new Map1(){

            public Object map1(Object object) {
                return ((List)object).get(0);
            }
        };
        Node node = QueryTest.node("?O");
        Query query = new Query();
        query.addMatch(Query.ANY, Query.ANY, node);
        Graph graph = QueryTest.graphWith("pigs fly south; dogs fly badly; plans fly flat");
        query.addConstraint(QueryTest.graphWith("?O &ne badly"));
        query.addConstraint(QueryTest.graphWith("?O &ne flat"));
        Set set = QueryTest.iteratorToSet(graph.queryHandler().prepareBindings(query, new Node[]{node}).executeBindings().mapWith(map1));
        QueryTest.assertEquals((String)"tsgs", (Object)this.nodeSet("south"), (Object)set);
    }

    public void testBindingQuery() {
        Graph graph = QueryTest.graphWith("");
        Graph graph2 = QueryTest.graphWith("pigs might fly; cats chase mice; dogs chase cars; cats might purr");
        Node[] nodeArray = new Node[]{};
        QueryTest.assertFalse((String)"empty graph, no bindings", (boolean)graph.queryHandler().prepareBindings(new Query().addMatch(Query.ANY, Query.ANY, Query.ANY), nodeArray).executeBindings().hasNext());
        QueryTest.assertTrue((String)"full graph, > 0 bindings", (boolean)graph2.queryHandler().prepareBindings(new Query(), nodeArray).executeBindings().hasNext());
    }

    public static List iteratorToList(ClosableIterator closableIterator) {
        ArrayList arrayList = new ArrayList();
        while (closableIterator.hasNext()) {
            arrayList.add(closableIterator.next());
        }
        return arrayList;
    }

    public void testEmpty() {
        List list = QueryTest.iteratorToList(this.Q.executeBindings(this.empty, new Node[0]));
        QueryTest.assertEquals((String)"testEmpty: select [] from {} => 1 empty binding [size]", (int)list.size(), (int)1);
        Domain domain = (Domain)list.get(0);
        QueryTest.assertEquals((String)"testEmpty: select [] from {} => 1 empty binding [width]", (int)domain.size(), (int)0);
    }

    public void testOneMatch() {
        this.Q.addMatch(this.X, Query.ANY, Query.ANY);
        List list = QueryTest.iteratorToList(this.Q.executeBindings(this.single, new Node[]{this.X}));
        QueryTest.assertEquals((String)"select X from {spindizzies drive cities} => 1 binding [size]", (int)list.size(), (int)1);
        Domain domain = (Domain)list.get(0);
        QueryTest.assertEquals((String)"select X from {spindizzies drive cities} => 1 binding [width]", (int)domain.size(), (int)1);
        QueryTest.assertTrue((String)"select X from {spindizzies drive cities} => 1 binding [value]", (boolean)domain.get(0).equals(QueryTest.node("spindizzies")));
    }

    public void testMismatch() {
        this.Q.addMatch(this.X, this.X, this.X);
        List list = QueryTest.iteratorToList(this.Q.executeBindings(this.single, new Node[]{this.X}));
        QueryTest.assertEquals((String)"bindings mismatch (X X X)", (int)list.size(), (int)0);
    }

    public void testXXXMatch1() {
        this.Q.addMatch(this.X, this.X, this.X);
        Graph graph = QueryTest.graphWith("ring ring ring");
        List list = QueryTest.iteratorToList(this.Q.executeBindings(graph, new Node[]{this.X}));
        QueryTest.assertEquals((String)"bindings match (X X X)", (int)list.size(), (int)1);
    }

    public HashSet setFrom(Node[] nodeArray) {
        HashSet<Node> hashSet = new HashSet<Node>(nodeArray.length);
        for (int i = 0; i < nodeArray.length; ++i) {
            hashSet.add(nodeArray[i]);
        }
        return hashSet;
    }

    public void testXXXMatch3() {
        this.Q.addMatch(this.X, this.X, this.X);
        Graph graph = QueryTest.graphWith("ring ring ring; ding ding ding; ping ping ping");
        List list = QueryTest.iteratorToList(this.Q.executeBindings(graph, new Node[]{this.X}));
        QueryTest.assertEquals((String)"bindings match (X X X)", (int)list.size(), (int)3);
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < list.size(); ++i) {
            Domain domain = (Domain)list.get(i);
            QueryTest.assertEquals((String)"one bound variable", (int)domain.size(), (int)1);
            hashSet.add(domain.get(0));
        }
        HashSet hashSet2 = this.setFrom(new Node[]{QueryTest.node("ring"), QueryTest.node("ding"), QueryTest.node("ping")});
        QueryTest.assertEquals((String)"testMatch getting {ring ding ping}", hashSet, (Object)hashSet2);
    }

    public void testTwoPatterns() {
        Node node = QueryTest.node("reads");
        Node node2 = QueryTest.node("inGenre");
        Graph graph = QueryTest.graphWith("chris reads blish; blish inGenre SF");
        this.Q.addMatch(this.X, node, this.Y);
        this.Q.addMatch(this.Y, node2, this.Z);
        List list = QueryTest.iteratorToList(this.Q.executeBindings(graph, new Node[]{this.X, this.Z}));
        QueryTest.assertTrue((String)"testTwoPatterns: one binding", (list.size() == 1 ? 1 : 0) != 0);
        Domain domain = (Domain)list.get(0);
        QueryTest.assertEquals((String)"testTwoPatterns: width 2", (int)domain.size(), (int)2);
        QueryTest.assertEquals((String)"testTwoPatterns: X = chris", (Object)domain.get(0), (Object)QueryTest.node("chris"));
        QueryTest.assertEquals((String)"testTwoPatterns: Y = SF", (Object)domain.get(1), (Object)QueryTest.node("SF"));
    }

    public void testGraphQuery() {
        Graph graph = QueryTest.graphWith("?X reads ?Y; ?Y inGenre ?Z");
        Graph graph2 = QueryTest.graphWith("chris reads blish; blish inGenre SF");
        Query query = new Query(graph);
        List list = QueryTest.iteratorToList(query.executeBindings(graph2, new Node[]{QueryTest.node("?X"), QueryTest.node("?Z")}));
        QueryTest.assertEquals((String)"testTwoPatterns: one binding", (int)1, (int)list.size());
        Domain domain = (Domain)list.get(0);
        QueryTest.assertEquals((String)"testTwoPatterns: width 2", (int)domain.size(), (int)2);
        QueryTest.assertEquals((String)"testTwoPatterns: X = chris", (Object)domain.get(0), (Object)QueryTest.node("chris"));
        QueryTest.assertEquals((String)"testTwoPatterns: Y = SF", (Object)domain.get(1), (Object)QueryTest.node("SF"));
    }

    public void testTwoGraphs() {
        Graph graph = QueryTest.graphWith("chris reads blish; chris reads norton; chris eats curry");
        Graph graph2 = QueryTest.graphWith("blish inGenre SF; curry inGenre food");
        Node node = QueryTest.node("reads");
        Node node2 = QueryTest.node("inGenre");
        this.Q.addMatch("a", this.X, node, this.Y).addMatch("b", this.Y, node2, this.Z);
        Query.ArgMap argMap = this.Q.args().put("a", graph).put("b", graph2);
        List list = QueryTest.iteratorToList(this.Q.executeBindings(argMap, new Node[]{this.X, this.Z}));
        QueryTest.assertEquals((String)"testTwoGraphs: one binding", (int)list.size(), (int)1);
        Domain domain = (Domain)list.get(0);
        QueryTest.assertEquals((String)"testTwoGraphs: width 2", (int)domain.size(), (int)2);
        QueryTest.assertEquals((String)"testTwoGraphs: X = chris", (Object)domain.get(0), (Object)QueryTest.node("chris"));
        QueryTest.assertEquals((String)"testTwoGraphs: Y = SF", (Object)domain.get(1), (Object)QueryTest.node("SF"));
    }

    private void helpConstraint(String string, Graph graph, int n) {
        Query query = new Query();
        Graph graph2 = QueryTest.graphWith("blish wrote CIF; blish wrote VOR; hambly wrote Darwath; feynman mechanicked quanta");
        query.addMatch(this.X, QueryTest.node("wrote"), Query.ANY);
        query.addConstraint(graph);
        List list = QueryTest.iteratorToList(query.executeBindings(graph2, new Node[]{this.X}));
        QueryTest.assertEquals((String)("testConstraint " + string + ": number of bindings"), (int)n, (int)list.size());
    }

    public void testConstraint() {
        this.helpConstraint("none", QueryTest.graphWith(""), 3);
        this.helpConstraint("X /= blish", QueryTest.graphWith("?x &ne blish"), 1);
        this.helpConstraint("X /= blish & X /= hambly", QueryTest.graphWith("?x &ne blish; ?x &ne hambly"), 0);
    }

    public void testConstraintTwo() {
        Graph graph = QueryTest.graphWith("blish wrote CIF; blish wrote VOR; hambly wrote Darwath; feynman mechanicked quanta");
        this.Q.addMatch(this.X, QueryTest.node("wrote"), this.Y);
        this.Q.addConstraint(QueryTest.graphWith("?x &ne ?y"));
        List list = QueryTest.iteratorToList(this.Q.executeBindings(graph, new Node[]{this.X}));
        QueryTest.assertEquals((String)"testConstraint Two: number of bindings", (int)list.size(), (int)3);
    }

    private void helpConstraintThree(String string, Graph graph, int n) {
        Query query = new Query();
        Graph graph2 = QueryTest.graphWith("brust wrote jhereg; hedgehog hacked code; angel age 230; brust wrote 230");
        query.addConstraint(graph);
        query.addMatch(this.X, this.Y, this.Z);
        List list = QueryTest.iteratorToList(query.executeBindings(graph2, new Node[]{this.X, this.Z}));
        QueryTest.assertEquals((String)("testConstraint " + string + ": number of bindings"), (int)n, (int)list.size());
    }

    public void testConstraintThree() {
        this.helpConstraintThree("testConstraintThree 1:", QueryTest.graphWith("?x &eq brust"), 2);
        this.helpConstraintThree("testConstraintThree 2:", QueryTest.graphWith("?y &eq hacked"), 1);
        this.helpConstraintThree("testConstraintThree 3:", QueryTest.graphWith("?z &eq 230"), 2);
        this.helpConstraintThree("testConstraintThree 4:", QueryTest.graphWith("?z &eq 230"), 2);
    }

    public void testConstraintFour() {
        Map1 map1 = new Map1(){

            public Object map1(Object object) {
                return ((List)object).get(0);
            }
        };
        Query query = new Query();
        Graph graph = QueryTest.graphWith("bill pinged ben; ben pinged weed; weed pinged weed; bill ignored bill");
        query.addMatch(this.X, QueryTest.node("pinged"), this.Y);
        query.addConstraint(this.X, Query.NE, this.Y);
        Set set = QueryTest.iteratorToSet(query.executeBindings(graph, new Node[]{this.X}).mapWith(map1));
        QueryTest.assertEquals((String)"", (Object)this.setFrom(new Node[]{QueryTest.node("bill"), QueryTest.node("ben")}), (Object)set);
    }

    public void testStringResults() {
        Graph graph = QueryTest.graphWith("ding dong dilly");
        Query query = new Query().addMatch(this.X, this.Y, Query.ANY);
        List list = QueryTest.iteratorToList(query.executeBindings(graph, new Node[]{this.X, this.Y}));
        QueryTest.assertEquals((String)"one result back by name", (int)list.size(), (int)1);
        QueryTest.assertEquals((String)"x = ding", (Object)((Domain)list.get(0)).get(0), (Object)QueryTest.node("ding"));
    }

    public void testMissingVariable() {
        Graph graph = QueryTest.graphWith("x y z");
        Query query = new Query();
        List list = QueryTest.iteratorToList(query.executeBindings(graph, new Node[]{this.X, this.Y}));
        List list2 = (List)query.executeBindings(graph, new Node[]{this.X, this.Y}).next();
        QueryTest.assertEquals((String)"undefined variables get null", null, list2.get(0));
    }

    public void testDisconnected() {
        Graph graph = QueryTest.graphWith("x pred1 foo; y pred2 bar");
        Query query = new Query(QueryTest.graphWith("?X ?? foo; ?Y ?? bar"));
        List list = QueryTest.iteratorToList(query.executeBindings(graph, QueryTest.nodes("?X ?Y")));
        QueryTest.assertEquals((int)1, (int)list.size());
        QueryTest.assertEquals((Object)QueryTest.node("x"), ((List)list.get(0)).get(0));
        QueryTest.assertEquals((Object)QueryTest.node("y"), ((List)list.get(0)).get(1));
    }

    public void testQueryTripleOrder() {
        Triple triple = Triple.create("A B C");
        Triple triple2 = Triple.create("D E F");
        List<Triple> list = Arrays.asList(triple, triple2);
        List list2 = this.getTriplesFromQuery(list);
        QueryTest.assertEquals(list, (Object)list2);
    }

    private List getTriplesFromQuery(List list) {
        Query query = new Query();
        final Triple[][] tripleArray = new Triple[1][];
        GraphBase graphBase = new GraphBase(){

            public ExtendedIterator find(TripleMatch tripleMatch) {
                return new NiceIterator();
            }

            public QueryHandler queryHandler() {
                return new SimpleQueryHandler(this, this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Stage patternStage(Mapping mapping, Graph graph, Triple[] tripleArray) {
                        if (tripleArray.length > 1) {
                            4.access$000(this.this$1)[0] = tripleArray;
                        }
                        return super.patternStage(mapping, graph, tripleArray);
                    }
                };
            }

            static /* synthetic */ Triple[][] access$000(4 var0) {
                return var0.tripleArray;
            }
        };
        for (int i = 0; i < list.size(); ++i) {
            query.addMatch((Triple)list.get(i));
        }
        query.executeBindings(graphBase, QueryTest.nodes(""));
        return Arrays.asList(tripleArray[0]);
    }

    public void testVariableCount() {
        this.assertCount(0, "");
        this.assertCount(0, "x R y");
        this.assertCount(1, "?x R y");
        this.assertCount(1, "?x R ?x");
        this.assertCount(2, "?x R ?y");
        this.assertCount(3, "?x ?R ?y");
        this.assertCount(6, "?x ?R ?y; ?a ?S ?c");
        this.assertCount(18, "?a ?b ?c; ?d ?e ?f; ?g ?h ?i; ?j ?k ?l; ?m ?n ?o; ?p ?q ?r");
    }

    public void assertCount(int n, String string) {
        Graph graph = QueryTest.graphWith("");
        Query query = new Query();
        Triple[] tripleArray = QueryTest.tripleArray(string);
        for (int i = 0; i < tripleArray.length; ++i) {
            query.addMatch(tripleArray[i]);
        }
        query.executeBindings(graph, new Node[0]);
        QueryTest.assertEquals((int)n, (int)query.getVariableCount());
        query.executeBindings(graph, QueryTest.nodes("?notPresentInQuery"));
        QueryTest.assertEquals((int)(n + 1), (int)query.getVariableCount());
    }

    public void testQueryConstraintNull() {
        Query query = new Query();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

